/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.opplugin.sscbillmanger;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class GenIscObjectValidatorPlugin
extends AbstractValidator {
    private static final String ISC_ENTITY_TYPE = "ENTITY";
    private static final String ISC_METADATA_SCHEMA = "isc_metadata_schema";

    public void initializeConfiguration() {
        super.initializeConfiguration();
    }

    public void validate() {
        StringBuilder errorMsg = new StringBuilder();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject sourceDatas = (DynamicObject)dataEntity.getValue("source_datas");
            String sourceNumber = (String)dataEntity.getValue("source_number");
            String sourceName = (String)dataEntity.getValue("source_name");
            Long sourceId = (Long)dataEntity.getValue("sourceid");
            Long targetId = (Long)dataEntity.getValue("targetid");
            if (sourceDatas == null) {
                errorMsg.append(ResManager.loadKDString((String)"\u201c\u6570\u636e\u6e90\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SynIscObjectValidatorPlugin_0", (String)"ssc-task-opplugin", (Object[])new Object[0]));
                errorMsg.append("\n\r");
            }
            if (StringUtils.isEmpty((String)sourceNumber)) {
                errorMsg.append(ResManager.loadKDString((String)"\u201c\u7f16\u7801\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GenIscObjectValidatorPlugin_0", (String)"ssc-task-opplugin", (Object[])new Object[0]));
                errorMsg.append("\n\r");
            }
            if (StringUtils.isEmpty((String)sourceName)) {
                errorMsg.append(ResManager.loadKDString((String)"\u201c\u540d\u79f0\u201d\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"GenIscObjectValidatorPlugin_1", (String)"ssc-task-opplugin", (Object[])new Object[0]));
                errorMsg.append("\n\r");
            }
            if (Long.valueOf("0").equals(targetId)) {
                errorMsg.append(ResManager.loadKDString((String)"\u5de5\u5355\u672a\u751f\u6210\u76ee\u6807\u5bf9\u8c61\uff0c\u8bf7\u5148\u8fdb\u884c\u540c\u6b65\u96c6\u6210\u5bf9\u8c61\u64cd\u4f5c\u3002", (String)"GenIscObjectValidatorPlugin_3", (String)"ssc-task-opplugin", (Object[])new Object[0]));
                errorMsg.append("\n\r");
            }
            if (errorMsg.length() > 0) {
                this.addMessage(dataEntity, errorMsg.substring(0, errorMsg.length() - 1), ErrorLevel.Error);
            } else {
                if (sourceDatas == null) continue;
                if (!this.checkNameUniqueness(sourceDatas.getPkValue(), sourceId, sourceNumber)) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u6570\u636e\u6e90\u5df2\u5b58\u5728\u96c6\u6210\u5bf9\u8c61\u201c%s\u201d\u3002", (String)"GenIscObjectValidatorPlugin_2", (String)"ssc-task-opplugin", (Object[])new Object[0]), sourceNumber));
                }
            }
            if (sourceId == 0L) continue;
            this.addWarningMessage(dataEntity, ResManager.loadKDString((String)"\u6e90\u5bf9\u8c61\u5df2\u7ecf\u751f\u6210\uff0c\u7ee7\u7eed\u5219\u8986\u76d6\u539f\u6709\u6e90\u5bf9\u8c61\u5185\u5bb9\u3002", (String)"GenIscObjectValidatorPlugin_4", (String)"ssc-task-opplugin", (Object[])new Object[0]));
        }
    }

    private boolean checkNameUniqueness(Object dataId, Long oldId, String name) {
        if (dataId == null) {
            return false;
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter groupFilter = new QFilter("group", "=", dataId);
        filters.add(groupFilter);
        QFilter typeFilter = new QFilter("type", "=", (Object)ISC_ENTITY_TYPE);
        filters.add(typeFilter);
        QFilter nameFilter = new QFilter("full_name", "=", (Object)name);
        filters.add(nameFilter);
        if (!oldId.equals(Long.valueOf("0"))) {
            filters.add(new QFilter("id", "!=", (Object)oldId));
        }
        return !QueryServiceHelper.exists((String)ISC_METADATA_SCHEMA, (QFilter[])filters.toArray(new QFilter[0]));
    }
}

