/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.opplugin.sscbillmanger;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.ssc.task.business.workbill.WorkBillCommonHelper;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class WorkBillDefineValidator
extends AbstractValidator {
    private static final HashSet<String> mustInput = new HashSet();

    public void validate() {
        String isvPrefix = WorkBillCommonHelper.getIsvPrefix();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            boolean updateObj;
            StringBuilder sb = new StringBuilder();
            DynamicObject workBill = dataEntity.getDataEntity();
            String number = workBill.getString("number");
            if (!WorkBillDefineValidator.checkEngLetter(number)) {
                sb.append(ResManager.loadKDString((String)"\u5de5\u5355\u7f16\u53f7\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u8bf7\u91c7\u7528\u82f1\u6587\u5b57\u6bcd\u3001\u6570\u5b57\u548c\u4e0b\u5212\u7ebf\u547d\u540d\u3002", (String)"WorkBillDefineValidator_7", (String)"ssc-task-opplugin", (Object[])new Object[0]));
                sb.append("\r\n");
            }
            if (!number.startsWith(isvPrefix)) {
                sb.append(ResManager.loadKDString((String)"\u5de5\u5355\u7f16\u53f7\u9700\u8981\u4ee5\u5f00\u53d1\u5546\u6807\u8bc6\u5f00\u5934\u3002", (String)"WorkBillDefineValidator_1", (String)"ssc-task-opplugin", (Object[])new Object[0]));
                sb.append("\r\n");
            }
            if (!(updateObj = workBill.getDataEntityState().getFromDatabase())) {
                boolean numberRepeat = MetadataDao.checkNumber((String)number);
                String tableName = "t_" + number;
                boolean tableRepeat = DB.exitsTable((DBRoute)DBRoute.of((String)"ssc"), (String)tableName);
                if (numberRepeat || tableRepeat) {
                    sb.append(ResManager.loadKDString((String)"\u7f16\u53f7\u6216\u5bf9\u5e94\u8868\u540d\u91cd\u590d\u3002", (String)"WorkBillDefineValidator_2", (String)"ssc-task-opplugin", (Object[])new Object[0]));
                    sb.append("\r\n");
                }
            }
            DynamicObjectCollection panelEntryCollection = workBill.getDynamicObjectCollection("entryentity");
            HashSet<String> numberSet = new HashSet<String>(16);
            for (DynamicObject entry : panelEntryCollection) {
                long realSize;
                DynamicObjectCollection fieldEntryCollection;
                String pNumber = entry.getString("pnumber");
                String pName = entry.getString("pname");
                String pCheckMeta = entry.getString("pcheckmeta");
                if (!WorkBillDefineValidator.checkEngLetter(pNumber)) {
                    sb.append(String.format(ResManager.loadKDString((String)"\u9762\u677f\u201c%s\u201d\u7684\u7f16\u53f7\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u8bf7\u91c7\u7528\u82f1\u6587\u5b57\u6bcd\u3001\u6570\u5b57\u548c\u4e0b\u5212\u7ebf\u547d\u540d\u3002", (String)"WorkBillDefineValidator_8", (String)"ssc-task-opplugin", (Object[])new Object[0]), pName));
                    sb.append("\r\n");
                }
                if (numberSet.contains(pNumber)) {
                    sb.append(String.format(ResManager.loadKDString((String)"\u9762\u677f\u201c%1$s\u201d\u7684\u7f16\u53f7%2$s\u5df2\u7ecf\u5b58\u5728\u3002", (String)"WorkBillDefineValidator_3", (String)"ssc-task-opplugin", (Object[])new Object[0]), pName, pNumber));
                    sb.append("\r\n");
                } else if (!"2".equals(pCheckMeta)) {
                    numberSet.add(pNumber);
                }
                String panelType = entry.getString("ptype");
                if (panelType.equals("0") && pNumber.length() > 25 || panelType.equals("1") && pNumber.length() > 20) {
                    sb.append(String.format(ResManager.loadKDString((String)"\u9762\u677f\u201c%s\u201d\u7684\u7f16\u53f7\u957f\u5ea6\u8d85\u51fa\u3002", (String)"WorkBillDefineValidator_4", (String)"ssc-task-opplugin", (Object[])new Object[0]), pNumber));
                    sb.append("\r\n");
                }
                if ("2".equals(pCheckMeta)) continue;
                if (panelType.equals("1") && pCheckMeta.equals("0")) {
                    String entryTableName = "t_" + pNumber + "_e";
                    boolean existTable = DB.exitsTable((DBRoute)DBRoute.of((String)"ssc"), (String)entryTableName);
                    if (existTable) {
                        sb.append(String.format(ResManager.loadKDString((String)"\u9762\u677f%s\u4e2d\u7684\u8868\u540d\u5df2\u5b58\u5728", (String)"WorkBillDefineValidator_12", (String)"ssc-task-opplugin", (Object[])new Object[0]), pName));
                        sb.append("\r\n");
                    }
                }
                if ((fieldEntryCollection = entry.getDynamicObjectCollection("subentryentity")).size() > 0 && (realSize = fieldEntryCollection.stream().filter(field -> {
                    String fCheckMeta = field.getString("fcheckmeta");
                    return !"2".equals(fCheckMeta);
                }).count()) <= 0L) {
                    sb.append(String.format(ResManager.loadKDString((String)"\u9762\u677f\u201c%s\u201d\u672a\u8bbe\u7f6e\u9762\u677f\u5b57\u6bb5", (String)"WorkBillDefineValidator_10", (String)"ssc-task-opplugin", (Object[])new Object[0]), pName));
                    sb.append("\r\n");
                }
                for (DynamicObject field2 : fieldEntryCollection) {
                    String fieldType;
                    String fNumber = field2.getString("fieldnumber");
                    String fieldName = field2.getString("fieldname");
                    String fCheckMeta = field2.getString("fcheckmeta");
                    if (!WorkBillDefineValidator.checkEngLetter(fNumber)) {
                        sb.append(String.format(ResManager.loadKDString((String)"\u9762\u677f\u201c%1$s\u201d\u4e2d\u7684\u5b57\u6bb5\u201c%2$s\u201d\u7684\u7f16\u53f7\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u8bf7\u91c7\u7528\u82f1\u6587\u5b57\u6bcd\u3001\u6570\u5b57\u548c\u4e0b\u5212\u7ebf\u547d\u540d\u3002", (String)"WorkBillDefineValidator_9", (String)"ssc-task-opplugin", (Object[])new Object[0]), pName, fieldName));
                        sb.append("\r\n");
                    }
                    if (numberSet.contains(fNumber)) {
                        sb.append(String.format(ResManager.loadKDString((String)"\u9762\u677f%1$s\u4e2d\u7684%2$s\u5b57\u6bb5\u7f16\u7801%3$s\u5df2\u5b58\u5728", (String)"WorkBillDefineValidator_15", (String)"ssc-task-opplugin", (Object[])new Object[0]), pName, fieldName, fNumber));
                        sb.append("\r\n");
                    } else if (!"2".equals(fCheckMeta)) {
                        numberSet.add(fNumber);
                    }
                    boolean isPresetField = field2.getBoolean("ispreset");
                    if (!isPresetField) {
                        if (!fNumber.startsWith(isvPrefix)) {
                            sb.append(ResManager.loadKDString((String)"\u5de5\u5355\u975e\u9884\u7f6e\u5b57\u6bb5\u9700\u8981\u4ee5\u5f00\u53d1\u5546\u6807\u8bc6\u5f00\u5934\u3002", (String)"WorkBillDefineValidator_5", (String)"ssc-task-opplugin", (Object[])new Object[0]));
                            sb.append("\r\n");
                        }
                        if (fNumber.length() > 22) {
                            sb.append(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5%s\u7684\u7f16\u53f7\u957f\u5ea6\u8d85\u51fa\u3002", (String)"WorkBillDefineValidator_6", (String)"ssc-task-opplugin", (Object[])new Object[0]), fieldName));
                            sb.append("\r\n");
                        }
                    }
                    if (!mustInput.contains(fieldType = field2.getString("fieldtype"))) continue;
                    String fp = field2.getString("fieldproperty");
                    String fpJson = field2.getString("fieldpropertyjson_tag");
                    if (fp != null && !fp.isEmpty() && fpJson != null && !fpJson.isEmpty()) continue;
                    sb.append(String.format(ResManager.loadKDString((String)"\u9762\u677f\u201c%1$s\u201d\u4e2d\u7684\u201c%2$s\u201d\u5b57\u6bb5\u9700\u8981\u5f55\u5165\u201c\u5b57\u6bb5\u5c5e\u6027\u201d\u3002", (String)"WorkBillDefineValidator_11", (String)"ssc-task-opplugin", (Object[])new Object[0]), pName, fieldName));
                    sb.append("\r\n");
                }
            }
            this.checkFieldProperties(dataEntity, workBill, panelEntryCollection);
            if (sb.length() <= 0) continue;
            String errMsg = sb.toString();
            this.addErrorMessage(dataEntity, errMsg.substring(0, errMsg.length() - 2));
        }
    }

    private void checkFieldProperties(ExtendedDataEntity dataEntity, DynamicObject workBill, DynamicObjectCollection panelEntryCollection) {
        HashMap fieldNewLengthMap = new HashMap();
        panelEntryCollection.stream().forEach(panelDynamicObject -> panelDynamicObject.getDynamicObjectCollection("subentryentity").stream().filter(dynamicObject -> String.valueOf(dynamicObject.getString("fieldtype")).startsWith("Text")).forEach(dynamicObject -> {
            String fieldpropertyjsonTag = dynamicObject.getString("fieldpropertyjson_tag");
            if (StringUtils.isNotEmpty((String)fieldpropertyjsonTag)) {
                fieldNewLengthMap.put(dynamicObject.getLong("id"), NumberUtils.toInt((String)JSON.parseObject((String)fieldpropertyjsonTag).getString("maxLength")));
            }
        }));
        HashMap<String, List> shortenMap = new HashMap<String, List>();
        HashMap<String, List> lengthenMap = new HashMap<String, List>();
        QFilter idFilter = new QFilter("id", "=", (Object)workBill.getLong("id"));
        QFilter typeFilter = new QFilter("entryentity.subentryentity.fieldtype", "in", (Object)new Object[]{"Text", "TextArea"});
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ".checkFieldProperties"), (String)"ssc_billmanger", (String)"id billid,entryentity.id,entryentity.pname, entryentity.subentryentity.id,entryentity.subentryentity.fieldnumber,entryentity.subentryentity.fieldname,entryentity.subentryentity.fieldpropertyjson_tag", (QFilter[])new QFilter[]{idFilter, typeFilter}, null);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            String pname = row.getString("entryentity.pname");
            Long detailid = row.getLong("entryentity.subentryentity.id");
            String fieldnumber = row.getString("entryentity.subentryentity.fieldnumber");
            String fieldname = row.getString("entryentity.subentryentity.fieldname");
            String fieldpropertyjsonTag = row.getString("entryentity.subentryentity.fieldpropertyjson_tag");
            Integer fieldNewLength = (Integer)fieldNewLengthMap.get(detailid);
            if (!StringUtils.isNotEmpty((String)fieldpropertyjsonTag) || !Objects.nonNull(fieldNewLength)) continue;
            int maxLength = NumberUtils.toInt((String)JSON.parseObject((String)fieldpropertyjsonTag).getString("maxLength"));
            if (fieldNewLength > maxLength) {
                lengthenMap.computeIfAbsent(pname, key -> new ArrayList()).add(String.format("%s\uff08%s\uff09", fieldname, fieldnumber));
                continue;
            }
            if (fieldNewLength >= maxLength) continue;
            shortenMap.computeIfAbsent(pname, key -> new ArrayList()).add(String.format("%s\uff08%s\uff09", fieldname, fieldnumber));
        }
        if (ObjectUtils.isNotEmpty(shortenMap)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b57\u6bb5\u957f\u5ea6\u4e0d\u5141\u8bb8\u7f29\u77ed\uff0c\u8bf7\u4fee\u6b63\uff1a", (String)"WorkBillDefineValidator_13", (String)"ssc-task-opplugin", (Object[])new Object[0]));
            shortenMap.forEach((k, v) -> this.addErrorMessage(dataEntity, String.format("%s\uff1a%s\uff1b", k, v.stream().collect(Collectors.joining("\u3001")))));
        }
        if (ObjectUtils.isNotEmpty(lengthenMap)) {
            String prefix = ObjectUtils.isEmpty(shortenMap) ? "" : "\r\n";
            this.addWarningMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%s\u201d\u6700\u5927\u957f\u5ea6\u53d8\u66f4\uff0c\u8bf7\u540c\u6b65\u4fee\u6539\u6570\u636e\u5e93\u7ed3\u6784\uff1a", (String)"WorkBillDefineValidator_14", (String)"ssc-task-opplugin", (Object[])new Object[0]), prefix));
            lengthenMap.forEach((k, v) -> this.addWarningMessage(dataEntity, String.format("%s\uff1a%s\uff1b", k, v.stream().collect(Collectors.joining("\u3001")))));
        }
    }

    private static boolean checkEngLetter(String passengerName) {
        if (passengerName == null || passengerName.isEmpty()) {
            return true;
        }
        String eng = "^[a-zA-Z][a-zA-Z0-9_]*$";
        Pattern pattern = Pattern.compile(eng);
        Matcher matcher = pattern.matcher(passengerName);
        return matcher.matches();
    }

    static {
        mustInput.add("Basedata");
        mustInput.add("Assistant");
        mustInput.add("Text");
        mustInput.add("TextArea");
    }
}

