/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.common;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.task.formplugin.util.UserGroupUtil;
import kd.ssc.task.util.DateUtil;

public class TaskIndexDataUtil {
    private static final Log log = LogFactory.getLog(TaskIndexDataUtil.class);

    public static Map<String, Long> getIndexData(Long sscid, String groupId, boolean isSysAdminAndAllRight) {
        HashMap<String, Long> dataMap = new HashMap<String, Long>();
        String entityName = "task_indexdata_update";
        QFilter shareCenterFilter = new QFilter("sscid.id", "=", (Object)sscid);
        if (groupId != null && !"-1".equals(groupId)) {
            shareCenterFilter.and("usergroup.id", "=", (Object)Long.parseLong(groupId));
        } else if (!isSysAdminAndAllRight) {
            QFilter leaderGroupFilter = new QFilter("usergroup.id", "!=", (Object)0L);
            String currUserId = String.valueOf(RequestContext.get().getCurrUserId());
            HashSet<Long> manageGroupSet = UserGroupUtil.getManageGroup(String.valueOf(sscid), currUserId);
            QFilter leaderGroupFilter2 = new QFilter("usergroup", "in", manageGroupSet);
            shareCenterFilter.and(leaderGroupFilter);
            shareCenterFilter.and(leaderGroupFilter2);
        }
        try {
            DataSet dSet = QueryServiceHelper.queryDataSet((String)"TaskIndexDataUtil.getIndexData()", (String)entityName, (String)"id,propname,propvalue,sscid,usergroup", (QFilter[])new QFilter[]{shareCenterFilter}, null);
            dSet = dSet.select(new String[]{"id", "propname", "propvalue"}).groupBy(new String[]{"propname"}).sum("propvalue").finish();
            dSet = dSet.select(new String[]{"propname", "propvalue"});
            for (Row row : dSet) {
                dataMap.put(row.getString("propname"), row.getLong("propvalue"));
            }
        }
        catch (Exception e) {
            log.info(e.getMessage());
        }
        return dataMap;
    }

    public static List<Integer[]> getIndexChartData(Long sscid, String usergroupId, boolean isSysAdminAndAllRight) {
        ArrayList<Integer[]> chartDataList = new ArrayList<Integer[]>();
        Map<String, Long> dataMap = TaskIndexDataUtil.getIndexData(sscid, usergroupId, isSysAdminAndAllRight);
        int x1 = 0;
        int x2 = 0;
        int x3 = 0;
        int x4 = 0;
        int x5 = 0;
        int x6 = 0;
        int x7 = 0;
        int x1_ood = 0;
        int x2_ood = 0;
        int x3_ood = 0;
        int x4_ood = 0;
        int x5_ood = 0;
        int x6_ood = 0;
        int x7_ood = 0;
        if (dataMap.get("chart_threedays") != null) {
            x1 = dataMap.get("chart_threedays").intValue();
        }
        if (dataMap.get("chart_sevendays") != null) {
            x2 = dataMap.get("chart_sevendays").intValue();
        }
        if (dataMap.get("chart_tenthdays") != null) {
            x3 = dataMap.get("chart_tenthdays").intValue();
        }
        if (dataMap.get("chart_fifthdays") != null) {
            x4 = dataMap.get("chart_fifthdays").intValue();
        }
        if (dataMap.get("chart_twentydays") != null) {
            x5 = dataMap.get("chart_twentydays").intValue();
        }
        if (dataMap.get("chart_monthdays") != null) {
            x6 = dataMap.get("chart_monthdays").intValue();
        }
        if (dataMap.get("chart_monthdaysup") != null) {
            x7 = dataMap.get("chart_monthdaysup").intValue();
        }
        if (dataMap.get("chart_threedays_ood") != null) {
            x1_ood = dataMap.get("chart_threedays_ood").intValue();
        }
        if (dataMap.get("chart_sevendays_ood") != null) {
            x2_ood = dataMap.get("chart_sevendays_ood").intValue();
        }
        if (dataMap.get("chart_tenthdays_ood") != null) {
            x3_ood = dataMap.get("chart_tenthdays_ood").intValue();
        }
        if (dataMap.get("chart_fifthdays_ood") != null) {
            x4_ood = dataMap.get("chart_fifthdays_ood").intValue();
        }
        if (dataMap.get("chart_twentydays_ood") != null) {
            x5_ood = dataMap.get("chart_twentydays_ood").intValue();
        }
        if (dataMap.get("chart_monthdays_ood") != null) {
            x6_ood = dataMap.get("chart_monthdays_ood").intValue();
        }
        if (dataMap.get("chart_monthdaysup_ood") != null) {
            x7_ood = dataMap.get("chart_monthdaysup_ood").intValue();
        }
        chartDataList.add(new Integer[]{x1 + x1_ood, x2 + x2_ood, x3 + x3_ood, x4 + x4_ood, x5 + x5_ood, x6 + x6_ood, x7 + x7_ood});
        chartDataList.add(new Integer[]{x1_ood, x2_ood, x3_ood, x4_ood, x5_ood, x6_ood, x7_ood});
        chartDataList.add(new Integer[]{x1, x2, x3, x4, x5, x6, x7});
        return chartDataList;
    }

    public static DataSet getTaskCountSet(Long sscid, String usergroupId, boolean isSysAdminAndAllRight) {
        String algoKey = "TaskIndexDataUtil.getTaskCountSet()";
        String entityName = "task_indexdata_update_ext";
        QFilter shareCenterFilter = new QFilter("sscid.id", "=", (Object)sscid);
        if (usergroupId != null && !"-1".equals(usergroupId)) {
            shareCenterFilter.and("usergroup.id", "=", (Object)Long.parseLong(usergroupId));
        } else if (!isSysAdminAndAllRight) {
            QFilter leaderGroupFilter = new QFilter("usergroup.id", "!=", (Object)0L);
            String currUserId = String.valueOf(RequestContext.get().getCurrUserId());
            HashSet<Long> manageGroupSet = UserGroupUtil.getManageGroup(String.valueOf(sscid), currUserId);
            QFilter leaderGroupFilter2 = new QFilter("usergroup", "in", manageGroupSet);
            shareCenterFilter.and(leaderGroupFilter);
            shareCenterFilter.and(leaderGroupFilter2);
        }
        DataSet ds = QueryServiceHelper.queryDataSet((String)algoKey, (String)entityName, (String)"user.id as personid,taskcount,taskamount,costwaittime,taskefficiency", (QFilter[])new QFilter[]{shareCenterFilter}, null).groupBy(new String[]{"personid"}).sum("taskcount").sum("taskamount").sum("costwaittime").finish();
        return ds.select(new String[]{"personid", "taskcount", "taskamount", "(taskamount/costwaittime) as taskefficiency"});
    }

    public static Map<String, Long> getSaleIndexData(Long userid, Long sscid) {
        HashMap<String, Long> dataMap = new HashMap<String, Long>();
        String entityName = "task_saleindexdata_update";
        QFilter shareCenterFilter = new QFilter("user.id", "=", (Object)userid);
        QFilter sscFilter = new QFilter("sscid", "=", (Object)sscid);
        try (DataSet dSet = QueryServiceHelper.queryDataSet((String)"TaskIndexDataUtil.getIndexData()", (String)entityName, (String)"id,propname,propvalue,user", (QFilter[])new QFilter[]{shareCenterFilter, sscFilter}, null);){
            for (Row row : dSet) {
                dataMap.put(row.getString("propname"), row.getLong("propvalue"));
            }
        }
        return dataMap;
    }

    public static DataSet getSaleIndexRankData(List<QFilter> filters, boolean isQuality) {
        String entityName = "task_saleindexdata_update";
        QFilter propNameFilter = new QFilter("propname", "=", (Object)(isQuality ? "sale_ranking_quality" : "sale_ranking"));
        filters.add(propNameFilter);
        DataSet dSet = null;
        dSet = QueryServiceHelper.queryDataSet((String)"TaskIndexDataUtil.getIndexData()", (String)entityName, (String)"propvalue as count,user personid", (QFilter[])filters.toArray(new QFilter[0]), null);
        filters.remove(propNameFilter);
        return dSet.orderBy(new String[]{"count desc"});
    }

    public static DataSet getTaskNumDaily(Map<String, Object> dateMap, Long userID, Long sscId, boolean isQuality) throws KDException {
        Date startDate = null;
        Date endDate = null;
        try {
            startDate = DateUtil.getCurDateForm((Date)((Date)dateMap.get("startDate")), (boolean)true);
            endDate = DateUtil.getCurDateForm((Date)((Date)dateMap.get("endDate")), (boolean)false);
        }
        catch (Exception e1) {
            throw new KDException(BosErrorCode.fulltextException, new Object[]{e1});
        }
        String algoKey = "TaskIndexDataUtil.getPersonTaskNumDaily()";
        String entityName = "task_saleindex_avgdaily";
        QFilter timeFilter = QFilter.of((String)"date >= ? and date <= ?", (Object[])new Object[]{startDate, endDate});
        QFilter sscFilter = new QFilter("sscid", "=", (Object)sscId);
        QFilter isQuaFilter = null;
        QFilter[] qFilters = null;
        isQuaFilter = isQuality ? new QFilter("isquality", "=", (Object)Character.valueOf('1')) : new QFilter("isquality", "=", (Object)Character.valueOf('0'));
        if (userID == null) {
            qFilters = new QFilter[]{timeFilter, isQuaFilter, sscFilter};
        } else {
            QFilter userFilter = new QFilter("user", "=", (Object)userID);
            qFilters = new QFilter[]{userFilter, timeFilter, isQuaFilter, sscFilter};
        }
        return QueryServiceHelper.queryDataSet((String)algoKey, (String)entityName, (String)"id,user,normalnum,expirenum,date", (QFilter[])qFilters, null);
    }
}

