/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.creditupdate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.config.TaskParamHelper;
import kd.ssc.enums.TaskPoolTypeEnum;
import kd.ssc.enums.TaskStateEnum;
import kd.ssc.exception.ExceptionPlatformUtil;
import kd.ssc.smartApproval.pojo.IDISchemaResult;
import kd.ssc.task.common.AutoProcessResultEnum;
import kd.ssc.task.common.OutSystemWorkLoadNodeChangeUtil;
import kd.ssc.task.common.TaskApprevalPluginUtil;
import kd.ssc.task.common.TaskApprevalUtil;
import kd.ssc.task.common.TaskFilterEnum;
import kd.ssc.task.creditupdate.TaskAutoApproveResultHelper;
import kd.ssc.task.dis.WorkerStatusPojo;
import kd.ssc.task.disRebuild.engine.Distribution;
import kd.ssc.task.dto.approve.DecisionResult;
import kd.ssc.task.helper.TaskBillChildQueryServiceHelper;
import kd.ssc.task.service.approve.IntelligentDecisionService;
import kd.ssc.task.service.approve.impl.IntelligentDecisionServiceImpl;
import kd.ssc.task.userworkload.TaskUserWorkLoadHelper;
import kd.ssc.task.util.TaskWorkFlowUtil;

public class TaskAutoAppreval
extends AbstractTask {
    private static final Log log = LogFactory.getLog(TaskAutoAppreval.class);
    private static final String KEY = "bar_pass";

    public void execute(RequestContext arg0, Map<String, Object> arg1) throws KDException {
        DynamicObjectCollection taskColl = this.getDataTasks();
        HashMap<Long, DecisionResult> taskDecisionResult = new HashMap<Long, DecisionResult>(8);
        HashMap<Long, DynamicObject> taskMap = new HashMap<Long, DynamicObject>(8);
        IntelligentDecisionServiceImpl intelligentService = new IntelligentDecisionServiceImpl();
        for (DynamicObject taskObj : taskColl) {
            try {
                this.taskAutoProcess(taskDecisionResult, taskMap, (IntelligentDecisionService)intelligentService, taskObj);
            }
            catch (Exception e) {
                ExceptionPlatformUtil.saveErrorInfo((String)((Object)((Object)this)).getClass().getName(), (String)"execute", (String)("taskId= " + taskObj.get("id")), (Throwable)e);
            }
        }
        this.afterAutoDoApprove(taskDecisionResult, taskMap);
    }

    public void taskAutoProcess(Map<Long, DecisionResult> taskDecisionResult, Map<Long, DynamicObject> taskMap, IntelligentDecisionService intelligentService, DynamicObject taskObj) {
        String tmpStr;
        Long sscId = taskObj.getLong("sscid");
        Long taskId = taskObj.getLong("id");
        String billid = taskObj.getString("billid");
        Long billTypeid = taskObj.getLong("billtype");
        Long tasktypeid = taskObj.getLong("tasktypeid");
        Object bizdata_tag = taskObj.get("bizdata_tag");
        String opinion = taskObj.getString("apprevalmessage");
        String innermsg = taskObj.getString("innermsg");
        String personid = taskObj.getString("personid");
        String state = taskObj.getString("state");
        List idiSchemaList = TaskBillChildQueryServiceHelper.listTaskBillChildIdiSchema((Long)billTypeid, (Long)tasktypeid);
        String bizdata = null;
        if (bizdata_tag != null && !kd.bos.util.StringUtils.isEmpty((String)(tmpStr = bizdata_tag.toString()))) {
            bizdata = tmpStr;
        }
        HashMap<String, String> map = new HashMap<String, String>(16);
        DynamicObject taskBill = this.getOperNumberAndtype(billTypeid);
        if (taskBill != null) {
            String billType = taskBill.getString("bindbill.number");
            String erpNumber = taskBill.getString("externalerp.number");
            DynamicObject dataEntity = null;
            if (bizdata == null) {
                dataEntity = BusinessDataServiceHelper.loadSingle((Object)billid, (String)billType, (String)"id");
            } else {
                DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder((DynamicObjectType)ORM.create().getDataEntityType(billType));
                DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
                dataEntity = (DynamicObject)jser.deserializeFromString(bizdata, null);
            }
            if (idiSchemaList != null && !idiSchemaList.isEmpty()) {
                DecisionResult result = intelligentService.decisionAnalysis(taskId, null, dataEntity, idiSchemaList);
                IDISchemaResult schemaResult = new IDISchemaResult(taskId.longValue());
                schemaResult.setBy(result);
                schemaResult.save();
                if (!result.isSucess()) {
                    taskDecisionResult.put(taskId, result);
                    taskMap.put(taskId, taskObj);
                    TaskAutoApproveResultHelper approveResultHelper = new TaskAutoApproveResultHelper();
                    approveResultHelper.saveAutoApproveResult(taskId, AutoProcessResultEnum.NO_PASS.getValue());
                    return;
                }
            } else {
                String infoStr = String.format("taskId = %s, billTypeid = %s, tasktypeid = %s, dataInsightSchemaList = %s", taskId, billTypeid, tasktypeid, idiSchemaList);
                log.info(infoStr);
            }
            opinion = TaskApprevalPluginUtil.processDefaultOpinion(taskId, true);
            map.put("sscId", String.valueOf(sscId));
            map.put("billtypeid", billTypeid + "");
            map.put("billTypeKey", billType);
            map.put("billid", billid + "");
            map.put("taskID", taskId + "");
            map.put("personID", billTypeid + "");
            map.put("innermsg", innermsg);
            map.put("opinion", opinion);
            map.put("autoappreval", "true");
            map.put("erpNumber", erpNumber);
            map.put("tasktypeid", tasktypeid + "");
            map.put("personid", personid);
            map.put("state", state);
            TaskApprevalUtil.autoDoApproveOperation(KEY, dataEntity, map);
        }
    }

    private DynamicObjectCollection getDataTasks() {
        String entityName = "task_task";
        String selectFields = "id,sscid,orgid,personid,billtype,oprt,billid,pooltype,state,subject,tasktypeid,bizdata_tag,qualitystate,apprevalmessage,imagenumber,billnumber,innermsg,receivetime,creator,qualitysamplelibrary";
        QFilter autoprocessFilter = new QFilter("autoprocess", "=", (Object)"1");
        QFilter pooltypeFil = new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.PROCESSING.getValue());
        QFilter stateFil = new QFilter("state", "in", Arrays.asList(TaskStateEnum.TO_BE_AUDIT.getValue(), TaskStateEnum.REUPLOAD_IMAGE.getValue()));
        QFilter notQuaCheckTask = new QFilter("qualitysamplelibrary", "=", (Object)TaskFilterEnum.NOTQUACHECKTASK);
        QFilter[] fitlerArr = new QFilter[]{autoprocessFilter, pooltypeFil, stateFil, notQuaCheckTask};
        return QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])fitlerArr, null, (int)1000);
    }

    private DynamicObject getOperNumberAndtype(Long billid) {
        String entityName = "task_taskbill";
        String selectFields = "id,bindbill.number,bindform.number,externalerp.number";
        QFilter filter = new QFilter("id", "=", (Object)billid);
        return QueryServiceHelper.queryOne((String)entityName, (String)selectFields, (QFilter[])new QFilter[]{filter});
    }

    private WorkerStatusPojo reDistribute(DynamicObject taskObj) {
        DynamicObject billType;
        if (taskObj == null) {
            return null;
        }
        ArrayList<String> tTypeBTypeList = new ArrayList<String>();
        ArrayList<String> orgIDList = new ArrayList<String>();
        ArrayList<String> sscList = new ArrayList<String>();
        ArrayList<Long> taskIds = new ArrayList<Long>();
        String tTypeBType = taskObj.getString("tasktypeid") + "," + taskObj.getString("billtype");
        tTypeBTypeList.add(tTypeBType);
        orgIDList.add(taskObj.getString("orgid"));
        sscList.add(taskObj.getString("sscid"));
        taskIds.add(taskObj.getLong("id"));
        Long applierOfCurTask = 0L;
        if (taskObj.getLong("qualitysamplelibrary") == 0L && !(billType = QueryServiceHelper.queryOne((String)"task_taskbill", (String)"allowanyapplier", (QFilter[])new QFilter("id", "=", (Object)taskObj.getLong("billtype")).toArray())).getBoolean("allowanyapplier")) {
            applierOfCurTask = taskObj.getLong("creator");
        }
        return TaskUserWorkLoadHelper.getMatchAndLeastPerson(orgIDList, sscList, taskIds, tTypeBTypeList, applierOfCurTask);
    }

    public void afterAutoDoApprove(Map<Long, DecisionResult> taskDecisionResult, Map<Long, DynamicObject> taskMap) {
        if ("true".equals(TaskParamHelper.getTaskParamByName((String)"enableDisRebuild"))) {
            this.taskRedistNew(taskDecisionResult);
        } else {
            this.taskRedistOld(taskDecisionResult, taskMap);
        }
    }

    private void taskRedistNew(Map<Long, DecisionResult> taskDecisionResult) {
        int reDisCount = taskDecisionResult.size();
        if (reDisCount == 0) {
            return;
        }
        Distribution.trans2Redist(taskDecisionResult);
    }

    private void taskRedistOld(Map<Long, DecisionResult> taskDecisionResult, Map<Long, DynamicObject> taskMap) {
        int reDisCount = taskDecisionResult.size();
        if (reDisCount == 0) {
            return;
        }
        HashMap<Long, WorkerStatusPojo> taskNewHandler = new HashMap<Long, WorkerStatusPojo>(reDisCount);
        for (long taskId : taskDecisionResult.keySet()) {
            WorkerStatusPojo workerStatusPojo = this.reDistribute(taskMap.get(taskId));
            if (workerStatusPojo == null) continue;
            taskNewHandler.put(taskId, workerStatusPojo);
        }
        QFilter idFil = new QFilter("id", "in", taskNewHandler.keySet());
        String selectProps = "id,sscid,billid,billtype,tasktypeid,pooltype,state,personid,usergroup,source,orgid,assignid,innermsg,autoprocess,receivetime,firstreceivetime,qualitysamplelibrary.id";
        Object[] taskDynObjs = BusinessDataServiceHelper.load((String)"task_task", (String)selectProps, (QFilter[])new QFilter[]{idFil});
        ArrayList<DynamicObject> stateChangeDyObjlist = new ArrayList<DynamicObject>();
        for (DynamicObject dynamicObject : taskDynObjs) {
            Long taskId = dynamicObject.getLong("id");
            Long prePersonId = dynamicObject.getLong("personid.id");
            dynamicObject.set("personid_id", (Object)((WorkerStatusPojo)taskNewHandler.get(taskId)).getUserId());
            dynamicObject.set("usergroup_id", (Object)((WorkerStatusPojo)taskNewHandler.get(taskId)).getUserGroupId());
            Date date = new Date();
            dynamicObject.set("receivetime", (Object)date);
            if (dynamicObject.getLong("qualitysamplelibrary.id") == 0L && dynamicObject.getDate("firstreceivetime") == null) {
                dynamicObject.set("firstreceivetime", (Object)date);
            }
            dynamicObject.set("autoprocess", (Object)Character.valueOf('0'));
            String innerMsg = taskDecisionResult.get(taskId).getErrorInfo();
            if (!StringUtils.isEmpty((Object)innerMsg) && innerMsg.length() > 2000) {
                innerMsg = innerMsg.substring(0, 2000);
            }
            dynamicObject.set("innermsg", (Object)innerMsg);
            this.addSateChange(stateChangeDyObjlist, dynamicObject, prePersonId);
        }
        if (taskDynObjs.length > 0) {
            BusinessDataServiceHelper.loadRefence((Object[])taskDynObjs, (IDataEntityType)taskDynObjs[0].getDataEntityType());
            SaveServiceHelper.save((DynamicObject[])taskDynObjs);
            SaveServiceHelper.save((DynamicObject[])stateChangeDyObjlist.toArray(new DynamicObject[0]));
            OutSystemWorkLoadNodeChangeUtil.changeWorkLoadNode((DynamicObject[])taskDynObjs, null);
            TaskWorkFlowUtil.updatePersonAndMsgDisTask((DynamicObject[])taskDynObjs, (String)ResManager.loadKDString((String)"\u4e00\u7ea7\u5ba1\u6279", (String)"TaskAutoDisTask_3", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
    }

    public void addSateChange(List<DynamicObject> stateChangeDyObjlist, DynamicObject disTask, Long prePersonId) {
        DynamicObject stateChangeDyObj = BusinessDataServiceHelper.newDynamicObject((String)"task_statechange");
        stateChangeDyObj.set("jobid", disTask.get("id"));
        stateChangeDyObj.set("newjobstate", disTask.get("state"));
        stateChangeDyObj.set("oldjobstate", disTask.get("state"));
        stateChangeDyObj.set("changetime", disTask.get("receivetime"));
        stateChangeDyObj.set("operatorid", (Object)prePersonId);
        stateChangeDyObj.set("allocatedpersonid", disTask.get("personid_id"));
        stateChangeDyObj.set("operation", (Object)7);
        stateChangeDyObj.set("tasktype", disTask.get("tasktypeid"));
        stateChangeDyObj.set("billtype", disTask.get("billtype"));
        stateChangeDyObj.set("innermsg", disTask.get("innermsg"));
        stateChangeDyObjlist.add(stateChangeDyObj);
    }
}

