/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.dis;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.ssc.task.dis.BillNumPersonPOJO;

public class HisTaskDisRule {
    private static final String TASK_USERGROUPMETA = "task_usergroup";
    private static final String TASK_TASHHISTORY = "task_taskhistory";
    private Map<Long, Set<Long>> sscUser = new HashMap<Long, Set<Long>>();
    private DynamicObject[] unDisTaskcol = null;
    private List<BillNumPersonPOJO> billNumPersonList = new ArrayList<BillNumPersonPOJO>();
    private long matchPerson = -1L;
    private long matchGroup = -1L;
    private static final Log log = LogFactory.getLog(HisTaskDisRule.class);
    private boolean printLog;

    public HisTaskDisRule(DynamicObject[] unDisTaskcol) {
        this.unDisTaskcol = unDisTaskcol;
    }

    public void prepareBaseData() {
        this.sscUser = this.buildSscUsersData();
        DynamicObject[] hisTask = this.queryRepulseTaskByBillId(this.unDisTaskcol);
        this.billNumPersonList = this.buildBillNumPersonList(this.sscUser, hisTask);
    }

    private List<BillNumPersonPOJO> buildBillNumPersonList(Map<Long, Set<Long>> sscUsersMap, DynamicObject[] hisObjs) {
        ArrayList<BillNumPersonPOJO> billNumPersonListToBuild = new ArrayList<BillNumPersonPOJO>();
        int hisSize = hisObjs.length;
        if (hisSize <= 0) {
            return billNumPersonListToBuild;
        }
        for (DynamicObject dyObj : hisObjs) {
            Set<Long> usersInSsc;
            String billNumber = dyObj.getString("billnumber");
            String billId = dyObj.getString("billid");
            long personID = dyObj.getLong("personid.id");
            long sscID = dyObj.getLong("sscid.id");
            Date finishTime = dyObj.getDate("completetime");
            long group = dyObj.getLong("usergroup.id");
            long taskTypeId = dyObj.getLong("tasktypeid.id");
            String autoProcessResult = dyObj.getString("autoprocessresult");
            int sameNumIndex = -1;
            int size = billNumPersonListToBuild.size();
            for (int i = 0; i < size; ++i) {
                BillNumPersonPOJO billNumPersonPojo = (BillNumPersonPOJO)billNumPersonListToBuild.get(i);
                if (!Objects.equals(billNumPersonPojo.getBillId(), billId) || Long.compare(taskTypeId, billNumPersonPojo.getTaskTypeId()) != 0) continue;
                sameNumIndex = i;
            }
            if (sameNumIndex > 0) {
                BillNumPersonPOJO billNumPersonPOJO = (BillNumPersonPOJO)billNumPersonListToBuild.get(sameNumIndex);
                if (dyObj.getDate("completetime") == null || !dyObj.getDate("completetime").after(billNumPersonPOJO.getFinishTime())) continue;
                billNumPersonListToBuild.remove(sameNumIndex);
            }
            if ((usersInSsc = sscUsersMap.get(sscID)) == null || !usersInSsc.contains(personID)) continue;
            billNumPersonListToBuild.add(new BillNumPersonPOJO(billNumber, billId, personID, finishTime, group, taskTypeId, autoProcessResult));
        }
        return billNumPersonListToBuild;
    }

    public boolean matched(DynamicObject task) {
        boolean result = false;
        if (task.getLong("qualitysamplelibrary.id") > 0L) {
            return false;
        }
        String billNumber = task.getString("billnumber");
        long taskTypeId = task.getLong("tasktypeid.id");
        String billId = task.getString("billid");
        if (!this.validate(task, billNumber) || taskTypeId == 0L || StringUtils.isEmpty((String)billId)) {
            return result;
        }
        this.removeMatchPerson();
        this.removeMatchGroup();
        this.logInfo("current waitDisTask billNo :" + billNumber + ";");
        Map<String, Long> personAndGroup = this.getSamebillIdPerson(billId, taskTypeId);
        Long person = personAndGroup.get("person");
        Long group = personAndGroup.get("group");
        if (person > -1L) {
            this.setMatchPerson(person);
            this.setMatchGroup(group);
            result = true;
            this.logInfo(billId + "find same hisTask ");
        } else {
            this.logInfo(billId + "no same hisTask");
        }
        this.logInfo("billnumber:" + billNumber + "billid:" + billId + ";personid:" + person + ";groupid:" + group);
        return result;
    }

    private boolean validate(DynamicObject task, String billNumber) {
        boolean result = true;
        if (task == null) {
            result = false;
            this.logInfo(billNumber + "task is null");
        }
        if (StringUtils.isEmpty((String)billNumber)) {
            result = false;
            this.logInfo(billNumber + "billNo is null");
        }
        return result;
    }

    private Map<String, Long> getSamebillNumPerson(String billNumber, Long taskTypeId) {
        long person = -1L;
        long group = -1L;
        HashMap<String, Long> result = new HashMap<String, Long>();
        result.put("person", person);
        result.put("group", group);
        for (BillNumPersonPOJO billNumPersonPOJO : this.billNumPersonList) {
            if (!billNumPersonPOJO.getBillNumber().equals(billNumber) || Long.compare(taskTypeId, billNumPersonPOJO.getTaskTypeId()) != 0) continue;
            person = billNumPersonPOJO.getPerson();
            group = billNumPersonPOJO.getUsergroup();
            result.put("person", person);
            result.put("group", group);
            return result;
        }
        return result;
    }

    private Map<String, Long> getSamebillIdPerson(String billId, Long taskTypeId) {
        long person = -1L;
        long group = -1L;
        HashMap<String, Long> result = new HashMap<String, Long>();
        result.put("person", person);
        result.put("group", group);
        for (BillNumPersonPOJO billNumPersonPOJO : this.billNumPersonList) {
            if (!Objects.equals(billNumPersonPOJO.getBillId(), billId) || Long.compare(taskTypeId, billNumPersonPOJO.getTaskTypeId()) != 0) continue;
            person = billNumPersonPOJO.getPerson();
            group = billNumPersonPOJO.getUsergroup();
            result.put("person", person);
            result.put("group", group);
            return result;
        }
        return result;
    }

    private Map<Long, Set<Long>> buildSscUsersData() {
        HashMap<Long, Set<Long>> sscUsersMap = new HashMap<Long, Set<Long>>();
        DynamicObjectCollection userGroupObjs = QueryServiceHelper.query((String)TASK_USERGROUPMETA, (String)"id,orgfield,entryentity.userfield", null);
        for (DynamicObject userGroupObj : userGroupObjs) {
            Long sscid = userGroupObj.getLong("orgfield");
            Set userSet = sscUsersMap.computeIfAbsent(sscid, k -> new HashSet(10));
            userSet.add(userGroupObj.getLong("entryentity.userfield"));
        }
        return sscUsersMap;
    }

    private DynamicObject[] queryRepulseTaskByBillId(DynamicObject[] unDisTaskcol) {
        ArrayList<String> taskBillIdList = new ArrayList<String>(10);
        for (DynamicObject dyObj : unDisTaskcol) {
            String taskBillId = dyObj.getString("billid");
            if (!StringUtils.isNotEmpty((String)taskBillId)) continue;
            taskBillIdList.add(taskBillId);
        }
        if (taskBillIdList.isEmpty()) {
            return new DynamicObject[0];
        }
        QFilter billIdFilter = new QFilter("billid", "in", taskBillIdList);
        DynamicObject[] hisObjs = BusinessDataServiceHelper.load((String)TASK_TASHHISTORY, (String)"completetime,billnumber,billid,personid,sscid,usergroup,tasktypeid,autoprocessresult", (QFilter[])new QFilter[]{billIdFilter}, (String)"completetime desc");
        return hisObjs;
    }

    private void removeMatchPerson() {
        this.matchPerson = -1L;
    }

    private void removeMatchGroup() {
        this.matchGroup = -1L;
    }

    private void setMatchPerson(long person) {
        this.matchPerson = person;
    }

    private void setMatchGroup(long matchGroup) {
        this.matchGroup = matchGroup;
    }

    public long getMatchPerson() {
        Long person = this.matchPerson;
        this.removeMatchPerson();
        return person;
    }

    public long getMatchGroup() {
        Long group = this.matchGroup;
        this.removeMatchGroup();
        return group;
    }

    private void logInfo(String msg) {
        if (this.printLog) {
            log.error(msg);
        }
    }

    public void setPrintLog(boolean printLog) {
        this.printLog = printLog;
    }

    public List<BillNumPersonPOJO> getBillNumPersonList() {
        return this.billNumPersonList;
    }

    public void setBillNumPersonList(List<BillNumPersonPOJO> billNumPersonList) {
        this.billNumPersonList = billNumPersonList;
    }
}

