/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.disRebuild.service.impl.before;

import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.sdk.annotation.SdkDeprecated;
import kd.sdk.fi.ssc.extpoint.disRebuild.IDataPrepareService;
import kd.sdk.fi.ssc.extpoint.disRebuild.disenum.DisTaskSourceEnum;
import kd.ssc.enums.TaskPoolTypeEnum;
import kd.ssc.enums.TaskStateEnum;

public class IDataPrepareServiceImpl
implements IDataPrepareService {
    private static final Log log = LogFactory.getLog(IDataPrepareServiceImpl.class);

    @SdkDeprecated
    public List<DynamicObject> prepareData(QFilter unDisFilter, DisTaskSourceEnum disTaskSource) {
        if (disTaskSource == null) {
            log.error("\u52a0\u8f7d\u5f85\u5206\u914d\u4efb\u52a1\u6570\u636e\u6269\u5c55\u63a5\u53e3\uff0c\u8c03\u7528\u6765\u6e90\u4e3a\u7a7a");
            return null;
        }
        DynamicObject[] taskDos = new DynamicObject[]{};
        switch (disTaskSource) {
            case AUTO_DIS_1: 
            case AUTO_DIS_2: 
            case AUTO_DIS_3: {
                taskDos = this.prepareDataByAutoDis(unDisFilter, disTaskSource);
                break;
            }
            case GET_DIS_1: {
                taskDos = this.prepareDataByGetDis(unDisFilter);
                break;
            }
            default: {
                log.error("\u65e0\u6548\u5206\u914d\u7c7b\u578b:" + disTaskSource);
            }
        }
        return Arrays.asList(taskDos);
    }

    private DynamicObject[] prepareDataByAutoDis(QFilter unDisFilter, DisTaskSourceEnum disTaskSource) {
        QFilter unDisTaskFilter = this.buildDisTaskFilter(unDisFilter, disTaskSource);
        int taskQueryNum = this.getAutoDisTaskQueryNum();
        DynamicObject[] taskDos = BusinessDataServiceHelper.load((String)"task_task", (String)"id,tasktypeid,oldtaskstate,state,billtype,receivetime,expirestate,personid,usergroup,sscid,pooltype,billid,source,orgid,bizdata_tag,assignid,subject,billnumber,creator.id,qualitystate,orignalperson,qualitysamplelibrary.id,autoprocess,hasallocated,sourcetaskid,tasklevelid.priority,billtype.externalerp.number", (QFilter[])new QFilter[]{unDisTaskFilter}, (String)"tasklevelid.priority,createtime", (int)taskQueryNum);
        return taskDos;
    }

    private DynamicObject[] prepareDataByGetDis(QFilter unDisFilter) {
        QFilter toDisfilter = new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.TO_BE_DIS.getValue());
        QFilter stateFilter = new QFilter("state", "in", (Object)new String[]{TaskStateEnum.TO_BE_DIS.getValue(), TaskStateEnum.DIS_EXCEPTION.getValue()});
        DynamicObject[] taskDos = BusinessDataServiceHelper.load((String)"task_task", (String)"id,state,tasklevelid,createtime,receivetime,expirestate,personid,pooltype,assignid,subject,source,billtype,billtype.id,tasktypeid,tasktypeid.id,creator.id,orgid,billid,sourcetaskid,qualitysamplelibrary.id,autoprocess,billnumber", (QFilter[])new QFilter[]{toDisfilter, stateFilter, unDisFilter}, (String)"tasklevelid.priority,createtime");
        return taskDos;
    }

    private QFilter buildDisTaskFilter(QFilter unDisFilter, DisTaskSourceEnum disTaskSource) {
        QFilter taskFilter;
        QFilter imageFilter = new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.TO_UPLOAD_IMAGE.getValue());
        QFilter poolTypeFil = new QFilter("pooltype", "=", (Object)TaskPoolTypeEnum.TO_BE_DIS.getValue()).or(imageFilter);
        QFilter recycleFil = new QFilter("state", "!=", (Object)TaskStateEnum.RECYCLE.getValue());
        if (disTaskSource.getValue() == DisTaskSourceEnum.AUTO_DIS_1.getValue()) {
            QFilter manualDisFil = new QFilter("state", "!=", (Object)TaskStateEnum.TO_BE_MANUAL_DIS.getValue());
            taskFilter = poolTypeFil.and(manualDisFil).and(recycleFil).and(unDisFilter);
        } else {
            taskFilter = poolTypeFil.and(recycleFil).and(unDisFilter);
        }
        return taskFilter;
    }

    private int getAutoDisTaskQueryNum() {
        int taskQueryNum = 10000;
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"task_paramcontrol", (String)"paramvalue", (QFilter[])new QFilter[]{new QFilter("paramname", "=", (Object)"autoDisTaskQueryNum")});
        if (dynamicObject == null) {
            return taskQueryNum;
        }
        try {
            int num = dynamicObject.getInt("paramvalue");
            if (num <= 0 || num > taskQueryNum) {
                return taskQueryNum;
            }
            return num;
        }
        catch (Exception e) {
            log.error("Error on parsing task_paramcontrol, autoDisTaskQueryNum = {}", dynamicObject.get("paramvalue"));
            return taskQueryNum;
        }
    }
}

