/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.disRebuild.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.sdk.fi.ssc.extpoint.disRebuild.disenum.DisTypeEnum;
import kd.ssc.enums.EnableStatusEnum;
import kd.ssc.exception.TaskErrorCodeEnum;
import kd.ssc.exception.TaskKDExcetptionUtil;
import kd.ssc.task.common.CommonFilterUtil;
import kd.ssc.task.dis.ApplyCreditLevel;
import kd.ssc.task.dis.BillCusFilter;
import kd.ssc.task.dis.BillNumPersonPOJO;
import kd.ssc.task.dis.CusDisRule;
import kd.ssc.task.dis.CusDisrulePojo;
import kd.ssc.task.dis.HisTaskDisRule;
import kd.ssc.task.dis.QulityJob;
import kd.ssc.task.dis.WorkLoad;
import kd.ssc.task.dis.WorkerStatusPojo;
import kd.ssc.task.disRebuild.disenum.DisExceptionEnum;
import kd.ssc.task.disRebuild.disenum.TaskAttributeEnum;
import kd.ssc.task.disRebuild.engine.Distribution;
import kd.ssc.task.disRebuild.pojo.DisRequestCtx;
import kd.ssc.task.disRebuild.pojo.ProxyPOJO;
import kd.ssc.task.disRebuild.service.MatchRuleService;
import kd.ssc.task.disRebuild.util.OtherUtil;
import kd.ssc.task.disRebuild.util.RobertUserGroupUtil;
import kd.ssc.task.service.distask.WorkLoadService;

public class DisRequestCtxConstructUtil {
    private static final Log log = LogFactory.getLog(DisRequestCtxConstructUtil.class);

    public static DisRequestCtx constructDisRequestCtx4AskTask(Long userId, Long sscId, List<DynamicObject> allTaskIds) {
        long begin = System.currentTimeMillis();
        DynamicObject[] unDisTaskcol = allTaskIds.toArray(new DynamicObject[0]);
        DisRequestCtx disRequestCtx = new DisRequestCtx();
        disRequestCtx.setSscid(sscId);
        disRequestCtx.setDisType(DisTypeEnum.MANUAL_GET);
        disRequestCtx.setUserId(userId);
        Set<Long> qualityTaskIdSet = Arrays.stream(unDisTaskcol).filter(p -> p.getLong("qualitysamplelibrary.id") > 0L).map(p -> p.getLong("id")).collect(Collectors.toSet());
        disRequestCtx.setQualityTaskIds(qualityTaskIdSet);
        HisTaskDisRule hisTaskDisRule = new HisTaskDisRule(unDisTaskcol);
        hisTaskDisRule.prepareBaseData();
        List<BillNumPersonPOJO> billNumPersonList = hisTaskDisRule.getBillNumPersonList();
        disRequestCtx.setReturnMatchRulePojos(billNumPersonList);
        ApplyCreditLevel applyCreditLevel = new ApplyCreditLevel(unDisTaskcol);
        applyCreditLevel.prepareData();
        disRequestCtx.setApplyCreditLevel(applyCreditLevel);
        BillCusFilter billCusFilter = new BillCusFilter();
        billCusFilter.prepareData();
        disRequestCtx.setSourceBillMatch(billCusFilter);
        WorkLoadService workLoad = DisRequestCtxConstructUtil.loadWorkLoadService();
        workLoad.setRobortRepulseRule(null);
        workLoad.prepareData();
        workLoad.prepareWorkflowPersons(unDisTaskcol);
        disRequestCtx.setWorkload(workLoad);
        QulityJob qulityJob = new QulityJob(unDisTaskcol);
        qulityJob.prepareData();
        disRequestCtx.setQualityJob(qulityJob);
        ArrayList<CusDisrulePojo> cusDisRuleList = DisRequestCtxConstructUtil.getDisRules(sscId, userId);
        if (cusDisRuleList == null || cusDisRuleList.isEmpty()) {
            throw new KDException(new ErrorCode(DisExceptionEnum.NOTMATCHED.getCode(), OtherUtil.getNotExistRuleError()), new Object[0]);
        }
        Map<Long, CusDisrulePojo> cusDisRulePojoMap = cusDisRuleList.stream().collect(Collectors.toMap(CusDisrulePojo::getId, v -> v, (p1, p2) -> p1));
        disRequestCtx.setRuleInfos(cusDisRulePojoMap);
        DynamicObject robertGroup = RobertUserGroupUtil.getRobertGroup(sscId);
        disRequestCtx.setRobertGroup(robertGroup);
        Map<Long, DynamicObject> robertGroupMap = RobertUserGroupUtil.getRobertGroupMap(sscId);
        disRequestCtx.setRobertGroupMap(robertGroupMap);
        ProxyPOJO proxy = new ProxyPOJO();
        disRequestCtx.setProxy(proxy);
        Map<String, List<MatchRuleService>> allAuditPluginMap = OtherUtil.loadMatchRuleService(disRequestCtx, TaskAttributeEnum.AUDIT);
        disRequestCtx.setAllAuditPlugins(allAuditPluginMap);
        Map<String, List<MatchRuleService>> allQualityPluginMap = OtherUtil.loadMatchRuleService(disRequestCtx, TaskAttributeEnum.QUALITY);
        disRequestCtx.setAllQualityPlugins(allQualityPluginMap);
        Map<Long, WorkerStatusPojo> group2WorkerStatusPojo = OtherUtil.getWordLoad4CurUserInPerGroup(userId);
        disRequestCtx.setGroup2WorkerStatusPojo(group2WorkerStatusPojo);
        AppParam param = new AppParam("83bfebc8000020ac", "12", Long.valueOf(0L), Long.valueOf(0L));
        Map appParameterMap = SystemParamServiceHelper.loadBatchAppParameterByOrgFromCache((AppParam)param, Collections.singletonList(sscId));
        disRequestCtx.setAppParameterMap((Map)appParameterMap.get(String.valueOf(sscId)));
        long end = System.currentTimeMillis();
        log.info("\u4e3b\u52a8\u83b7\u53d6\uff0c\u89c4\u5219\u51c6\u5907\u65f6\u95f4\uff1a" + (end - begin));
        return disRequestCtx;
    }

    public static DisRequestCtx constructDisRequestCtx4ManualDis(Long disTaskId, DynamicObject[] rules) {
        boolean isExisted = QueryServiceHelper.exists((String)"task_task", (Object)disTaskId);
        if (!isExisted) {
            throw new KDException(new ErrorCode(DisExceptionEnum.BIZERROR.getCode(), DisRequestCtxConstructUtil.getNotExistBizError(disTaskId)), new Object[0]);
        }
        long begin = System.currentTimeMillis();
        DynamicObject disTask = BusinessDataServiceHelper.loadSingle((Object)disTaskId, (String)"task_task", (String)"id,sscid.id,billid,qualitysamplelibrary.id,sourcetaskid,creator.id,billnumber,autoprocess");
        long sscId = disTask.getLong("sscid.id");
        DisRequestCtx disRequestCtx = new DisRequestCtx();
        disRequestCtx.setSscid(sscId);
        disRequestCtx.setDisType(DisTypeEnum.MANUAL_DIS);
        HisTaskDisRule hisTaskDisRule = new HisTaskDisRule(new DynamicObject[]{disTask});
        hisTaskDisRule.prepareBaseData();
        List<BillNumPersonPOJO> billNumPersonList = hisTaskDisRule.getBillNumPersonList();
        disRequestCtx.setReturnMatchRulePojos(billNumPersonList);
        HashSet<Long> qualityTaskIdSet = new HashSet<Long>();
        if (disTask.getLong("qualitysamplelibrary.id") > 0L) {
            qualityTaskIdSet.add(disTaskId);
        }
        disRequestCtx.setQualityTaskIds(qualityTaskIdSet);
        QulityJob qulityJob = new QulityJob(new DynamicObject[]{disTask});
        qulityJob.prepareData();
        disRequestCtx.setQualityJob(qulityJob);
        ArrayList<CusDisrulePojo> cusDisRuleList = CusDisrulePojo.buildDisRulePOJOListExcludeGroups(rules);
        if (cusDisRuleList == null || cusDisRuleList.isEmpty()) {
            throw new KDException(new ErrorCode(DisExceptionEnum.NOTMATCHED.getCode(), OtherUtil.getNotExistRuleError()), new Object[0]);
        }
        Map<Long, CusDisrulePojo> cusDisRulePojoMap = cusDisRuleList.stream().collect(Collectors.toMap(CusDisrulePojo::getId, v -> v, (p1, p2) -> p1));
        disRequestCtx.setRuleInfos(cusDisRulePojoMap);
        ApplyCreditLevel applyCreditLevel = new ApplyCreditLevel(new DynamicObject[]{disTask});
        applyCreditLevel.prepareData();
        disRequestCtx.setApplyCreditLevel(applyCreditLevel);
        BillCusFilter billCusFilter = new BillCusFilter();
        billCusFilter.prepareData();
        disRequestCtx.setSourceBillMatch(billCusFilter);
        Map<String, List<MatchRuleService>> allAuditPluginMap = OtherUtil.loadMatchRuleService(disRequestCtx, TaskAttributeEnum.AUDIT);
        disRequestCtx.setAllAuditPlugins(allAuditPluginMap);
        Map<String, List<MatchRuleService>> allQualityPluginMap = OtherUtil.loadMatchRuleService(disRequestCtx, TaskAttributeEnum.QUALITY);
        disRequestCtx.setAllQualityPlugins(allQualityPluginMap);
        AppParam param = new AppParam("83bfebc8000020ac", "12", Long.valueOf(0L), Long.valueOf(0L));
        Map appParameterMap = SystemParamServiceHelper.loadBatchAppParameterByOrgFromCache((AppParam)param, Collections.singletonList(sscId));
        disRequestCtx.setAppParameterMap((Map)appParameterMap.get(String.valueOf(sscId)));
        DynamicObject robertGroup = RobertUserGroupUtil.getRobertGroup(sscId);
        disRequestCtx.setRobertGroup(robertGroup);
        Map<Long, DynamicObject> robertGroupMap = RobertUserGroupUtil.getRobertGroupMap(sscId);
        disRequestCtx.setRobertGroupMap(robertGroupMap);
        long end = System.currentTimeMillis();
        log.info("\u624b\u5de5\u5206\u914d\uff0c\u89c4\u5219\u51c6\u5907\u65f6\u95f4\uff1a" + (end - begin));
        return disRequestCtx;
    }

    public static DisRequestCtx constructDisRequestCtx4AutoDis(Long sscId, List<DynamicObject> unDisTaskList) {
        DisRequestCtx disRequestCtx = DisRequestCtxConstructUtil.constructDisRequestCtx4AutoDisBase(unDisTaskList);
        disRequestCtx.setSscid(sscId);
        disRequestCtx.setDisType(DisTypeEnum.AUTO_DIS);
        Map<Long, CusDisrulePojo> cusDisRulePojoMap = disRequestCtx.getRuleInfos();
        if (cusDisRulePojoMap != null) {
            HashMap<Long, CusDisrulePojo> newCusDisRulePojoMap = new HashMap<Long, CusDisrulePojo>();
            for (Map.Entry<Long, CusDisrulePojo> entry : cusDisRulePojoMap.entrySet()) {
                if (!sscId.equals(entry.getValue().getSscId())) continue;
                newCusDisRulePojoMap.put(entry.getKey(), entry.getValue());
            }
            disRequestCtx.setRuleInfos(newCusDisRulePojoMap);
        }
        DynamicObject robertGroup = RobertUserGroupUtil.getRobertGroup(sscId);
        disRequestCtx.setRobertGroup(robertGroup);
        Map<Long, DynamicObject> robertGroupMap = RobertUserGroupUtil.getRobertGroupMap(sscId);
        disRequestCtx.setRobertGroupMap(robertGroupMap);
        ProxyPOJO proxy = new ProxyPOJO();
        disRequestCtx.setProxy(proxy);
        Map<String, List<MatchRuleService>> allAuditPluginMap = OtherUtil.loadMatchRuleService(disRequestCtx, TaskAttributeEnum.AUDIT);
        disRequestCtx.setAllAuditPlugins(allAuditPluginMap);
        Map<String, List<MatchRuleService>> allQualityPluginMap = OtherUtil.loadMatchRuleService(disRequestCtx, TaskAttributeEnum.QUALITY);
        disRequestCtx.setAllQualityPlugins(allQualityPluginMap);
        AppParam param = new AppParam("83bfebc8000020ac", "12", Long.valueOf(0L), Long.valueOf(0L));
        Map appParameterMap = SystemParamServiceHelper.loadBatchAppParameterByOrgFromCache((AppParam)param, Collections.singletonList(sscId));
        disRequestCtx.setAppParameterMap((Map)appParameterMap.get(String.valueOf(sscId)));
        return disRequestCtx;
    }

    public static DisRequestCtx constructDisRequestCtx4AutoDis(Long sscId, DisRequestCtx baseCtx) {
        DisRequestCtx disRequestCtx = new DisRequestCtx();
        disRequestCtx.setSscid(sscId);
        disRequestCtx.setDisType(DisTypeEnum.AUTO_DIS);
        disRequestCtx.setQualityTaskIds(baseCtx.getQualityTaskIds());
        disRequestCtx.setReturnMatchRulePojos(baseCtx.getReturnMatchRulePojos());
        disRequestCtx.setApplyCreditLevel(baseCtx.getApplyCreditLevel());
        disRequestCtx.setSourceBillMatch(baseCtx.getSourceBillMatch());
        disRequestCtx.setWorkload(baseCtx.getWorkload());
        disRequestCtx.setGroupInfos(baseCtx.getGroupInfos());
        disRequestCtx.setQualityJob(baseCtx.getQualityJob());
        Map<Long, CusDisrulePojo> cusDisRulePojoMap = baseCtx.getRuleInfos();
        if (cusDisRulePojoMap != null) {
            HashMap<Long, CusDisrulePojo> newCusDisRulePojoMap = new HashMap<Long, CusDisrulePojo>();
            for (Map.Entry<Long, CusDisrulePojo> entry : cusDisRulePojoMap.entrySet()) {
                if (!sscId.equals(entry.getValue().getSscId())) continue;
                newCusDisRulePojoMap.put(entry.getKey(), entry.getValue());
            }
            disRequestCtx.setRuleInfos(newCusDisRulePojoMap);
        }
        DynamicObject robertGroup = RobertUserGroupUtil.getRobertGroup(sscId);
        disRequestCtx.setRobertGroup(robertGroup);
        Map<Long, DynamicObject> robertGroupMap = RobertUserGroupUtil.getRobertGroupMap(sscId);
        disRequestCtx.setRobertGroupMap(robertGroupMap);
        disRequestCtx.setProxy(baseCtx.getProxy());
        Map<String, List<MatchRuleService>> allAuditPluginMap = OtherUtil.loadMatchRuleService(disRequestCtx, TaskAttributeEnum.AUDIT);
        disRequestCtx.setAllAuditPlugins(allAuditPluginMap);
        Map<String, List<MatchRuleService>> allQualityPluginMap = OtherUtil.loadMatchRuleService(disRequestCtx, TaskAttributeEnum.QUALITY);
        disRequestCtx.setAllQualityPlugins(allQualityPluginMap);
        AppParam param = new AppParam("83bfebc8000020ac", "12", Long.valueOf(0L), Long.valueOf(0L));
        Map appParameterMap = SystemParamServiceHelper.loadBatchAppParameterByOrgFromCache((AppParam)param, Collections.singletonList(sscId));
        disRequestCtx.setAppParameterMap((Map)appParameterMap.get(String.valueOf(sscId)));
        return disRequestCtx;
    }

    public static DisRequestCtx constructDisRequestCtx4AutoDisBase(List<DynamicObject> unDisTaskList) {
        long begin = System.currentTimeMillis();
        DynamicObject[] unDisTaskcol = unDisTaskList.toArray(new DynamicObject[0]);
        DisRequestCtx disRequestCtx = new DisRequestCtx();
        Set<Long> qualityTaskIdSet = Arrays.stream(unDisTaskcol).filter(p -> p.getLong("qualitysamplelibrary.id") > 0L).map(p -> p.getLong("id")).collect(Collectors.toSet());
        disRequestCtx.setQualityTaskIds(qualityTaskIdSet);
        HisTaskDisRule hisTaskDisRule = new HisTaskDisRule(unDisTaskcol);
        hisTaskDisRule.prepareBaseData();
        List<BillNumPersonPOJO> billNumPersonList = hisTaskDisRule.getBillNumPersonList();
        disRequestCtx.setReturnMatchRulePojos(billNumPersonList);
        ApplyCreditLevel applyCreditLevel = new ApplyCreditLevel(unDisTaskcol);
        applyCreditLevel.prepareData();
        disRequestCtx.setApplyCreditLevel(applyCreditLevel);
        BillCusFilter billCusFilter = new BillCusFilter();
        billCusFilter.prepareData();
        disRequestCtx.setSourceBillMatch(billCusFilter);
        WorkLoadService workLoad = DisRequestCtxConstructUtil.loadWorkLoadService();
        workLoad.setRobortRepulseRule(null);
        workLoad.prepareData();
        workLoad.prepareWorkflowPersons(unDisTaskcol);
        disRequestCtx.setWorkload(workLoad);
        Map<Long, Set<Long>> groupInfoMap = DisRequestCtxConstructUtil.loadAllGroupInfoMap(workLoad);
        disRequestCtx.setGroupInfos(groupInfoMap);
        QulityJob qulityJob = new QulityJob(unDisTaskcol);
        qulityJob.prepareData();
        disRequestCtx.setQualityJob(qulityJob);
        CusDisRule cusDisRule = new CusDisRule(applyCreditLevel, billCusFilter, workLoad, null, qulityJob);
        cusDisRule.prepareData();
        List<CusDisrulePojo> cusDisRuleList = cusDisRule.getCusDisRuleList();
        if (!CollectionUtils.isEmpty(cusDisRuleList)) {
            Map<Long, CusDisrulePojo> cusDisRulePojoMap = cusDisRuleList.stream().collect(Collectors.toMap(CusDisrulePojo::getId, v -> v, (p1, p2) -> p1));
            disRequestCtx.setRuleInfos(cusDisRulePojoMap);
        }
        ProxyPOJO proxy = new ProxyPOJO();
        disRequestCtx.setProxy(proxy);
        long end = System.currentTimeMillis();
        log.info("\u81ea\u52a8\u5206\u914d\uff0c\u89c4\u5219\u51c6\u5907\u65f6\u95f4\uff1a" + (end - begin));
        return disRequestCtx;
    }

    public static DisRequestCtx constructDisRequestCtx4TransRedist(long sscid, List<DynamicObject> taskList) {
        DisRequestCtx requestCtx = DisRequestCtxConstructUtil.constructDisRequestCtx4AutoDis((Long)sscid, taskList);
        requestCtx.setDisType(DisTypeEnum.NOPASS_DIS);
        return requestCtx;
    }

    public static DisRequestCtx constructPredisCtx(long sscId, List<DynamicObject> tasks) {
        long begin = System.currentTimeMillis();
        DisRequestCtx disRequestCtx = new DisRequestCtx();
        disRequestCtx.setSscid(sscId);
        disRequestCtx.setDisType(DisTypeEnum.PRE_DIS);
        disRequestCtx.setQualityTaskIds(new HashSet<Long>(0));
        ApplyCreditLevel applyCreditLevel = new ApplyCreditLevel(tasks.toArray(new DynamicObject[0]));
        applyCreditLevel.prepareData();
        disRequestCtx.setApplyCreditLevel(applyCreditLevel);
        List<CusDisrulePojo> cusDisRuleList = DisRequestCtxConstructUtil.getDisRule(sscId);
        if (cusDisRuleList.isEmpty()) {
            throw new KDException(new ErrorCode(DisExceptionEnum.NOTMATCHED.getCode(), OtherUtil.getNotExistRuleError()), new Object[0]);
        }
        Map<Long, CusDisrulePojo> cusDisRulePojoMap = cusDisRuleList.stream().collect(Collectors.toMap(CusDisrulePojo::getId, v -> v, (p1, p2) -> p1));
        disRequestCtx.setRuleInfos(cusDisRulePojoMap);
        BillCusFilter billCusFilter = new BillCusFilter();
        billCusFilter.prepareData4GivenSSC(sscId);
        disRequestCtx.setSourceBillMatch(billCusFilter);
        Map<String, List<MatchRuleService>> allAuditPluginMap = OtherUtil.loadMatchRuleService(disRequestCtx, TaskAttributeEnum.AUDIT);
        disRequestCtx.setAllAuditPlugins(allAuditPluginMap);
        AppParam param = new AppParam("83bfebc8000020ac", "12", Long.valueOf(0L), Long.valueOf(0L));
        Map appParameterMap = SystemParamServiceHelper.loadBatchAppParameterByOrgFromCache((AppParam)param, Collections.singletonList(sscId));
        disRequestCtx.setAppParameterMap((Map)appParameterMap.get(String.valueOf(sscId)));
        DynamicObject robertGroup = RobertUserGroupUtil.getRobertGroup(sscId);
        disRequestCtx.setRobertGroup(robertGroup);
        long end = System.currentTimeMillis();
        log.info("\u9884\u5206\u914d\uff0c\u89c4\u5219\u51c6\u5907\u65f6\u95f4\uff1a" + (end - begin));
        return disRequestCtx;
    }

    private static List<CusDisrulePojo> getDisRule(long sscId) {
        QFilter disruleEnbaleQFilter = CommonFilterUtil.getEnableDisRuleQFilter();
        QFilter sscFilter = new QFilter("ssccenter", "=", (Object)sscId);
        DynamicObject[] rules = BusinessDataServiceHelper.load((String)"task_disrule", (String)"id,number,entryentity.id,ssccenter,entryentity1.id,tasktype,priority,entryentity.billtype,entryentity.billtype.externalerp.number,entryentity.filterrulejson_tag,entryentity.filterrulejson,entryentity.applycreditleveljoson_tag,entryentity.applycreditleveljoson,entryentity1.orgrange,entryentity1.usergroup", (QFilter[])new QFilter[]{sscFilter, disruleEnbaleQFilter}, (String)"priority");
        return CusDisrulePojo.buildDisRulePOJOListExcludeGroups(rules);
    }

    private static WorkLoadService loadWorkLoadService() {
        DynamicObjectCollection workLoadServices = DisRequestCtxConstructUtil.getImplementClass("WorkLoadService");
        WorkLoadService workLoad = new WorkLoad();
        if (!CollectionUtils.isEmpty((Collection)workLoadServices)) {
            try {
                String value = (String)((DynamicObject)workLoadServices.get(0)).get("implementname");
                Class<?> aClass = Class.forName(value);
                workLoad = (WorkLoadService)aClass.newInstance();
            }
            catch (Exception e) {
                log.error("kd.ssc.task.disRebuild.engine.Distribution: \u53cd\u5c04WorkLoadService\u5b9e\u73b0\u7c7b\u5f02\u5e38", (Throwable)e);
                throw TaskKDExcetptionUtil.createKDException((Throwable)e, (String)TaskErrorCodeEnum.C_REFLECT_EXCEPTION.getCode(), (String)ResManager.loadKDString((String)"\u53cd\u5c04WorkLoadService\u5b9e\u73b0\u7c7b\u5f02\u5e38\uff01", (String)"ExceptionTaskReflect_2", (String)"ssc-task-common", (Object[])new Object[0]), (Object[])new Object[0]);
            }
        }
        return workLoad;
    }

    public static DynamicObjectCollection getImplementClass(String className) {
        QFilter qFilter1 = new QFilter("enable", "=", (Object)"1");
        QFilter qFilter2 = new QFilter("interfacename", "=", (Object)className);
        return QueryServiceHelper.query((String)"task_interfaceconfig", (String)"implementname", (QFilter[])new QFilter[]{qFilter1, qFilter2});
    }

    private static ArrayList<CusDisrulePojo> getDisRules(Long sscId, Long userId) {
        List<Long> groupIDs = DisRequestCtxConstructUtil.getGroupIncludeCurrentUser(userId);
        if (groupIDs.isEmpty()) {
            return null;
        }
        QFilter disruleEnbaleQFilter = CommonFilterUtil.getEnableDisRuleQFilter();
        QFilter userFilter = new QFilter("entryentity1.usergroup", "in", groupIDs).and(new QFilter("ssccenter", "=", (Object)sscId));
        DynamicObject[] taskDisRules = BusinessDataServiceHelper.load((String)"task_disrule", (String)"id,number,entryentity.id,ssccenter,entryentity1.id,tasktype,priority,entryentity.billtype,entryentity.billtype.externalerp.number,entryentity.filterrulejson_tag,entryentity.filterrulejson,entryentity.applycreditleveljoson_tag,entryentity.applycreditleveljoson,entryentity1.orgrange,entryentity1.usergroup", (QFilter[])new QFilter[]{userFilter, disruleEnbaleQFilter}, (String)"priority");
        return CusDisrulePojo.buildDisRulePOJOListIncludeGroups(taskDisRules, groupIDs);
    }

    private static List<Long> getGroupIncludeCurrentUser(long userId) {
        ORM orm = ORM.create();
        QFilter userFilter = new QFilter("entryentity.userfield", "=", (Object)userId);
        userFilter.and("enable", "=", (Object)EnableStatusEnum.Enable.getValue()).and("entryentity.usestatus", "=", (Object)EnableStatusEnum.Enable.getValue());
        ArrayList<Long> groupIDs = new ArrayList<Long>();
        try (DataSet groupDS = orm.queryDataSet(Distribution.class.getName() + ".query usergroup for ask Tasks", "task_usergroup", "id", new QFilter[]{userFilter});){
            for (Row row : groupDS) {
                groupIDs.add(row.getLong("id"));
            }
        }
        return groupIDs;
    }

    public static String getNotExistBizError(long taskId) {
        return String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5f85\u5206\u914d\u4efb\u52a1\uff0c\u4efb\u52a1ID\uff1a%s", (String)"Distribution_0", (String)"ssc-task-formplugin", (Object[])new Object[0]), taskId);
    }

    private static Map<Long, Set<Long>> loadAllGroupInfoMap(WorkLoadService workLoad) {
        HashMap<Long, Set<Long>> groupInfoMap = new HashMap<Long, Set<Long>>(8);
        Map<Long, List<WorkerStatusPojo>> groupPersonMap = workLoad.getGroupPersonMap();
        if (groupPersonMap != null && groupPersonMap.size() != 0) {
            for (Map.Entry<Long, List<WorkerStatusPojo>> entry : groupPersonMap.entrySet()) {
                Long userGroupId = entry.getKey();
                List<WorkerStatusPojo> workerStatusPojoList = entry.getValue();
                if (CollectionUtils.isEmpty(workerStatusPojoList)) continue;
                HashSet<Long> userIdSet = new HashSet<Long>(8);
                for (WorkerStatusPojo workerStatusPojo : workerStatusPojoList) {
                    userIdSet.add(workerStatusPojo.getUserId());
                }
                groupInfoMap.put(userGroupId, userIdSet);
            }
        }
        return groupInfoMap;
    }
}

