/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.events.SetFilterContainerFlatEvent;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.ssc.task.cache.CacheKey;
import kd.ssc.task.common.CommonFilterUtil;
import kd.ssc.task.common.QualityCheckSchemeUtil;
import kd.ssc.task.formplugin.util.SscUtil;
import kd.ssc.task.util.SscLicenseUtil;

public class QualityCheckSchemeListPlugin
extends AbstractListPlugin
implements ItemClickListener {
    private static final Log log = LogFactory.getLog(QualityCheckSchemeListPlugin.class);
    private int sum = 0;
    private static final String KEY_QUALITYCHECKSCHEME_FIRSTROAD = "qualityCheckSchemeFirstRoad";
    private List<FilterColumn> commonFilters;
    private static final String QUALITYCHECK_SCHEME_BATCH_TASK_CLASS = "kd.ssc.task.business.task.QualityCheckSchemeBatchTask";
    private static final String QUALITYCHECK_SCHEME_BATCH_TASK_CLICK_CLASS = "kd.ssc.task.business.task.QualityCheckSchemeBatchTaskClick";
    private static final String QUALITYCHECK_SCHEME_BATCH_TASK_CLOSE_BACK_ACTIONID = "qualityCheckSchemeBatchTaskCloseBack";

    public void filterContainerSetFlat(SetFilterContainerFlatEvent args) {
        args.setNewFilter(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if ("excutedonothing".equalsIgnoreCase(args.getVarMap().get("source.operateKey").toString())) {
            args.setCancel(true);
            ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
            if (selectedRows == null || selectedRows.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"QualityCheckSchemeListPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            if (selectedRows.size() > 100) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d28\u68c0\u65b9\u6848\u6279\u91cf\u6267\u884c\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7100\u3002", (String)"QualityCheckSchemeListPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            ConfirmCallBackListener confirmCallBacks1 = new ConfirmCallBackListener("btnimplement", (IFormPlugin)this);
            String strDeleteConfirmTip = ResManager.loadKDString((String)"\u201c\u7acb\u5373\u6267\u884c\u201d\u5c06\u4ea7\u751f\u8d28\u68c0\u4efb\u52a1\uff0c\u8bf7\u786e\u8ba4\u6267\u884c\uff1f", (String)"QualityCheckSchemeListPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(strDeleteConfirmTip, MessageBoxOptions.OKCancel, confirmCallBacks1);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if (e.getOperationResult() != null && e.getOperationResult().isSuccess() && "deletedonothing".equalsIgnoreCase(e.getOperateKey())) {
            ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
            if (selectedRows == null || selectedRows.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"QualityCheckSchemeListPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            ConfirmCallBackListener confirmCallBacks1 = new ConfirmCallBackListener("deletescheme", (IFormPlugin)this);
            String strDeleteConfirmTip = ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\u5f53\u524d\u8bb0\u5f55\uff1f\u5220\u9664\u540e\u65e0\u6cd5\u6062\u590d\u3002", (String)"QualityCheckSchemeListPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(strDeleteConfirmTip, MessageBoxOptions.OKCancel, confirmCallBacks1);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent arg0) {
        super.confirmCallBack(arg0);
        if ("deletescheme".equalsIgnoreCase(arg0.getCallBackId())) {
            if (MessageBoxResult.Yes.equals((Object)arg0.getResult())) {
                ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
                Object[] ids = selectedRows.getPrimaryKeyValues();
                QFilter filterId = new QFilter("id", "in", (Object)ids);
                DynamicObject[] schemes = BusinessDataServiceHelper.load((String)"task_qualitycheckscheme", (String)"id,name,status,enable", (QFilter[])new QFilter[]{filterId});
                if (schemes == null || schemes.length == 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u8d28\u68c0\u65b9\u6848\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u5220\u9664\u5931\u8d25\u3002", (String)"QualityCheckSchemeListPlugin_5", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    return;
                }
                Boolean enable = Boolean.FALSE;
                String shemeName = "";
                for (DynamicObject dynamicObject : schemes) {
                    enable = dynamicObject.getBoolean("enable");
                    shemeName = dynamicObject.getString("name");
                    if (enable.booleanValue()) continue;
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\uff1a\u6570\u636e\u4e3a\u7981\u7528\u72b6\u6001\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"QualityCheckSchemeListPlugin_11", (String)"ssc-task-formplugin", (Object[])new Object[0]), shemeName));
                    return;
                }
                DynamicObject[] libs = QualityCheckSchemeUtil.getSampleLibrarysBySchemeId(ids);
                List<String> processStateList = Arrays.asList("1", "5", "4");
                ArrayList<Long> libsId = new ArrayList<Long>();
                if (libs != null && libs.length > 0) {
                    for (DynamicObject item : libs) {
                        Long libId = item.getLong("id");
                        libsId.add(libId);
                        Object state = item.get("state");
                        String number = item.getString("number");
                        String schemeName = item.getString("checkscheme.name");
                        if (processStateList.contains(state)) {
                            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8d28\u68c0\u65b9\u6848\u540d\u79f0\u201c%1$s\u201d\u751f\u6210\u7684\u7f16\u53f7\u4e3a\u201c%2$s\u201d\u7684\u6837\u672c\u5e93\u6ca1\u6709\u201c\u5f85\u5206\u914d\u201d\u7684\u8d28\u68c0\u4efb\u52a1,\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"QualityCheckSchemeListPlugin_6", (String)"ssc-task-formplugin", (Object[])new Object[0]), schemeName, number));
                            return;
                        }
                        if (!"0".equals(state) || !QualityCheckSchemeUtil.isExistProcessQualityCheckTask(libId)) continue;
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8d28\u68c0\u65b9\u6848\u540d\u79f0\u201c%1$s\u201d\u751f\u6210\u7684\u7f16\u53f7\u4e3a\u201c%2$s\u201d\u7684\u6837\u672c\u5e93\u6ca1\u6709\u201c\u5f85\u5206\u914d\u201d\u7684\u8d28\u68c0\u4efb\u52a1,\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"QualityCheckSchemeListPlugin_7", (String)"ssc-task-formplugin", (Object[])new Object[0]), schemeName, number));
                        return;
                    }
                }
                try (TXHandle tXHandle = TX.required((String)(((Object)((Object)this)).getClass().getName() + "delete"));){
                    try {
                        DeleteServiceHelper.delete((String)"task_qualitycheckscheme", (QFilter[])new QFilter[]{filterId});
                        QFilter filterLibId = new QFilter("id", "in", libsId);
                        QFilter filterState = new QFilter("state", "=", (Object)"0");
                        DeleteServiceHelper.delete((String)"task_qualitysamplelibrary", (QFilter[])new QFilter[]{filterLibId, filterState});
                        QFilter filterTaskLibId = new QFilter("qualitysamplelibrary", "in", libsId);
                        QFilter filterUnassignedState = new QFilter("qualitystate", "=", (Object)"0");
                        DeleteServiceHelper.delete((String)"task_task", (QFilter[])new QFilter[]{filterTaskLibId, filterUnassignedState});
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8d28\u68c0\u65b9\u6848\u5220\u9664\u6210\u529f\u3002", (String)"QualityCheckSchemeListPlugin_8", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    }
                    catch (Throwable e) {
                        tXHandle.markRollback();
                        log.error("\u8d28\u68c0\u65b9\u6848\u5220\u9664\u5931\u8d25!", e);
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u8d28\u68c0\u65b9\u6848\u5220\u9664\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"QualityCheckSchemeListPlugin_9", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    }
                }
                this.getView().invokeOperation("refresh");
            }
        } else if ("btnimplement".equalsIgnoreCase(arg0.getCallBackId()) && MessageBoxResult.Yes.equals((Object)arg0.getResult())) {
            IListView view = (IListView)this.getView();
            view.setEnable(Boolean.FALSE, new String[]{"implement"});
            this.dispatchQualityCheckSchemeBatchTask();
            view.setEnable(Boolean.TRUE, new String[]{"implement"});
            this.getView().invokeOperation("refresh");
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        this.commonFilters = args.getFilterContainerInitEvent().getCommonFilterColumns();
        if (this.commonFilters == null || this.commonFilters.size() == 0) {
            return;
        }
        String sscid = "";
        Long sscidl = 0L;
        String cacheSscKey = CacheKey.getSSCKey((Object)KEY_QUALITYCHECKSCHEME_FIRSTROAD);
        if (this.getPageCache().get(cacheSscKey) == null) {
            for (FilterColumn filterColumn : this.commonFilters) {
                CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
                String fieldName = commonFilterColumn.getFieldName();
                if ("ssccenter.name".equals(fieldName)) {
                    List sscValueList;
                    Map sscidMap = commonFilterColumn.getDefaultFilter();
                    if (sscidMap == null || sscidMap.size() <= 0 || (sscValueList = (List)sscidMap.get("Value")) == null || sscValueList.size() <= 0) continue;
                    sscid = (String)sscValueList.get(0);
                    sscidl = Long.valueOf(sscid);
                    this.getPageCache().put(cacheSscKey, "true");
                    this.getPageCache().put("qualityCheckScheme_sscid", sscid);
                    continue;
                }
                if ("tasktype.name".equalsIgnoreCase(fieldName)) {
                    QFilter judgeFilter = new QFilter("qualityjudge", "=", (Object)"0");
                    QFilter idFilter = new QFilter("orgfield.id", "=", (Object)sscidl);
                    CommonFilterUtil.resetComboItems(this.getPageCache(), "qualityCheckScheme_taskType", commonFilterColumn, "task_tasktype", idFilter.and(judgeFilter), sscid, false);
                    continue;
                }
                if (!"taskbill.name".equalsIgnoreCase(fieldName)) continue;
                QFilter filter = new QFilter("ssccenter.id", "=", (Object)sscidl);
                CommonFilterUtil.resetComboItems(this.getPageCache(), "qualityCheckScheme_billType", commonFilterColumn, "task_taskbill", filter, sscid, false);
            }
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        List<String> nullFieldValues = Arrays.asList("tasktype.id", "taskbill.id");
        Object sscId = CommonFilterUtil.handleCommonFilterNullWhenClickSwitchSSC(args, "ssccenter.id", nullFieldValues);
        if (sscId != null) {
            this.getPageCache().put("qualityCheckScheme_sscid", sscId.toString());
        }
        if (this.commonFilters != null && this.commonFilters.size() > 0) {
            for (FilterColumn filterColumn : this.commonFilters) {
                Long sscidl;
                CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
                String fieldName = commonFilterColumn.getFieldName();
                if ("tasktype.name".equalsIgnoreCase(fieldName)) {
                    if (sscId == null) continue;
                    sscidl = Long.valueOf(sscId + "");
                    QFilter judgeFilter = new QFilter("qualityjudge", "=", (Object)"0");
                    QFilter idFilter = new QFilter("orgfield.id", "=", (Object)sscidl);
                    CommonFilterUtil.resetComboItems(this.getPageCache(), "qualityCheckScheme_taskType", commonFilterColumn, "task_tasktype", idFilter.and(judgeFilter), sscId, false);
                    continue;
                }
                if (!"taskbill.name".equalsIgnoreCase(fieldName) || sscId == null) continue;
                sscidl = Long.valueOf(sscId + "");
                QFilter filter = new QFilter("ssccenter.id", "=", (Object)sscidl);
                CommonFilterUtil.resetComboItems(this.getPageCache(), "qualityCheckScheme_billType", commonFilterColumn, "task_taskbill", filter, sscId, false);
            }
        }
    }

    public void setFilter(SetFilterEvent event) {
        super.setFilter(event);
        List filters = event.getQFilters();
        for (QFilter filter : filters) {
            if (!filter.getProperty().equals("taskbill.id")) continue;
            filter.or(new QFilter("taskbillentry.multaskbill.id", "=", filter.getValue()));
        }
        event.setOrderBy("createtime desc");
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection dynObjs = super.getData(start, limit);
                dynObjs.getDynamicObjectType().addProperty((DynamicProperty)new DynamicSimpleProperty("taskbillname", String.class, null));
                List ids = dynObjs.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
                DynamicObject[] schemes = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"task_qualitycheckscheme"));
                HashMap schemeMap = new HashMap(16);
                Arrays.stream(schemes).forEach(scheme -> schemeMap.put(scheme.getPkValue(), scheme));
                dynObjs.forEach(dyn -> {
                    DynamicObject scheme = (DynamicObject)schemeMap.get(dyn.getPkValue());
                    DynamicObjectCollection mulTaskBill = scheme.getDynamicObjectCollection("taskbillentry");
                    if (CollectionUtils.isEmpty((Collection)mulTaskBill)) {
                        Object taskBill2 = scheme.get("taskbill");
                        if (taskBill2 != null) {
                            dyn.set("taskbillname", ((DynamicObject)taskBill2).get("name"));
                        }
                    } else {
                        dyn.set("taskbillname", (Object)mulTaskBill.stream().map(taskBill -> taskBill.getString("multaskbill.name")).collect(Collectors.joining(";")));
                    }
                });
                return dynObjs;
            }
        });
    }

    public void billListHyperLinkClick(HyperLinkClickArgs hyperlinkclickargs) {
        super.billListHyperLinkClick(hyperlinkclickargs);
        HyperLinkClickEvent args = hyperlinkclickargs.getHyperLinkClickEvent();
        String fileldName = args.getFieldName();
        if ("operate".equals(fileldName)) {
            ListSelectedRow selectedRow = ((BillList)this.getView().getControl("billlistap")).getCurrentSelectedRowInfo();
            if (selectedRow == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"QualityCheckSchemeListPlugin_17", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            String checkschemeid = selectedRow.getPrimaryKeyValue().toString();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("checkschemeid", checkschemeid);
            params.put("source", "checkscheme");
            params.put("ssccenterid", QualityCheckSchemeUtil.getSSCIDByQualityScheme(selectedRow.getPrimaryKeyValue()));
            this.navigateOtherForm(hyperlinkclickargs, params);
        }
    }

    private void navigateOtherForm(HyperLinkClickArgs args, Map<String, Object> map) {
        args.setCancel(true);
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setCustomParams(map);
        listShowParameter.setBillFormId("task_qualitysamplelibrary");
        listShowParameter.setFormId("bos_list");
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listShowParameter.setCaption(ResManager.loadKDString((String)"\u8d28\u68c0\u6837\u672c\u5e93", (String)"QualityCheckSchemeListPlugin_18", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void packageData(PackageDataEvent e) {
        ColumnDesc columnDesc;
        if (e.getSource() instanceof ColumnDesc && "operate".equals((columnDesc = (ColumnDesc)e.getSource()).getKey())) {
            e.setFormatValue((Object)ResManager.loadKDString((String)"\u67e5\u770b\u8d28\u68c0\u6837\u672c\u5e93", (String)"QualityCheckSchemeListPlugin_19", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        List qfilters = args.getQfilters();
        String name = args.getFieldName();
        String sscId = this.getPageCache().get("qualityCheckScheme_sscid");
        if ("taskbill.id".equals(name)) {
            if (kd.bos.util.StringUtils.isNotEmpty((String)sscId)) {
                qfilters.add(new QFilter("ssccenter", "=", (Object)Long.valueOf(sscId)));
            }
            args.addCustomParam("showDisabledCheckbox", (Object)Boolean.FALSE);
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        String formId = "task_qualitycheckscheme";
        boolean hasLicense = SscLicenseUtil.checkGroupLicense5_0((PreOpenFormEventArgs)e, (String)formId);
        if (!hasLicense) {
            return;
        }
        List<Long> allPermSSC = SscUtil.getAllPermSSC(RequestContext.get().getCurrUserId(), formId, e.getFormShowParameter().getAppId());
        if (allPermSSC.size() == 0) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u5f53\u524d\u83dc\u5355\u65e0\u6743\u9650\u3002", (String)"QualityCheckSchemeListPlugin_21", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
    }

    private void dispatchQualityCheckSchemeBatchTask() {
        JobInfo jobInfo = this.buildQualityCheckSchemeBatchJobInfo();
        JobFormInfo jobFormInfo = this.buildQualityCheckSchemeBatchFormInfo(jobInfo);
        JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)this.getView());
    }

    private JobInfo buildQualityCheckSchemeBatchJobInfo() {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId(this.getView().getFormShowParameter().getServiceAppId());
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setName(ResManager.loadKDString((String)"\u8d28\u68c0\u65b9\u6848\u6279\u91cf\u6267\u884c", (String)"QualityCheckSchemeListPlugin_23", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        jobInfo.setRunByUserId(Long.parseLong(RequestContext.get().getUserId()));
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname(QUALITYCHECK_SCHEME_BATCH_TASK_CLASS);
        jobInfo.setRunByLang(Lang.get());
        ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
        Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
        HashMap<String, Object[]> params = new HashMap<String, Object[]>();
        params.put("selectedIds", primaryKeyValues);
        jobInfo.setParams(params);
        return jobInfo;
    }

    private JobFormInfo buildQualityCheckSchemeBatchFormInfo(JobInfo jobInfo) {
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, QUALITYCHECK_SCHEME_BATCH_TASK_CLOSE_BACK_ACTIONID);
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setCaption(ResManager.loadKDString((String)"\u8d28\u68c0\u65b9\u6848\u6279\u91cf\u6267\u884c\u8fdb\u5ea6", (String)"QualityCheckSchemeListPlugin_24", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        jobFormInfo.setCloseCallBack(closeCallBack);
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setCanStop(true);
        jobFormInfo.setClickClassName(QUALITYCHECK_SCHEME_BATCH_TASK_CLICK_CLASS);
        return jobFormInfo;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)QUALITYCHECK_SCHEME_BATCH_TASK_CLOSE_BACK_ACTIONID)) {
            this.taskCallBack(closedCallBackEvent.getReturnData());
        }
    }

    private void taskCallBack(Object returnData) {
        String data;
        TaskInfo taskInfo;
        String taskInfoStr;
        Map result;
        Object taskInfoObj;
        if (returnData == null) {
            return;
        }
        if (returnData instanceof Map && (taskInfoObj = (result = (Map)returnData).get("taskinfo")) != null && StringUtils.isNotBlank((CharSequence)(taskInfoStr = (String)taskInfoObj)) && (taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class)).isTaskEnd() && StringUtils.isNotEmpty((CharSequence)(data = taskInfo.getData()))) {
            JSONObject dataObj = (JSONObject)SerializationUtils.fromJsonString((String)data, JSONObject.class);
            int successCount = dataObj.getIntValue("successCount");
            int failureCount = dataObj.getIntValue("failureCount");
            String message = String.format(ResManager.loadKDString((String)"\u8d28\u68c0\u65b9\u6848\u6279\u91cf\u6267\u884c\u5b8c\u6210\uff0c\u6210\u529f%1$s\u6761\uff0c\u5931\u8d25%2$s\u6761\u3002", (String)"QualityCheckSchemeListPlugin_25", (String)"ssc-task-formplugin", (Object[])new Object[0]), successCount, failureCount);
            StringBuilder showMessage = new StringBuilder();
            showMessage.append(message);
            showMessage.append("\r\n");
            showMessage.append(dataObj.getString("showMessage"));
            this.getView().showMessage(showMessage.toString());
        }
    }
}

