/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin;

import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.enums.TaskStateEnum;
import kd.ssc.task.formplugin.TaskSalesIndexPlugin;

public class TaskPauseOrCancel {
    private static final Log log = LogFactory.getLog(TaskSalesIndexPlugin.class);

    public void changeImageTaskState(List<Long> selectedRowIds, Map<String, Object> extendMap) {
    }

    @Deprecated
    public void changeTaskState(List<Long> selectedRowIds, Map<String, Object> extendMap) {
        this.changeTaskState(selectedRowIds, extendMap, false);
    }

    public void changeTaskState(List<Long> selectedRowIds, Map<String, Object> extendMap, boolean isPending) {
        HashMap<String, Object> customParams = null;
        for (Long selectedRowId : selectedRowIds) {
            customParams = new HashMap<String, Object>();
            DynamicObject selectedRowData = this.getDataTasklist(selectedRowId);
            if (selectedRowData == null) continue;
            String state = (String)selectedRowData.get("state");
            if (isPending && TaskStateEnum.PAUSE.getValue().equals(state)) continue;
            Long billTypeId = Long.valueOf(selectedRowData.get("billtype") + "");
            Long taskTypeId = Long.valueOf(selectedRowData.get("tasktypeid") + "");
            customParams.put("selectedRowId", selectedRowId);
            customParams.put("billTypeId", billTypeId);
            customParams.put("taskTypeId", taskTypeId);
            String newTaskState = null;
            String operation = null;
            String oldJobState = null;
            if (isPending) {
                operation = "3";
                newTaskState = TaskStateEnum.PAUSE.getValue();
                oldJobState = state;
            } else {
                operation = "4";
                newTaskState = this.getOldJobState(selectedRowId);
                if (newTaskState == null) {
                    log.error("CancelPause newTaskState is null");
                }
                oldJobState = TaskStateEnum.PAUSE.getValue();
            }
            customParams.put("newJobState", newTaskState);
            customParams.put("operation", operation);
            customParams.put("oldJobState", oldJobState);
            if (extendMap != null && extendMap.size() > 0) {
                customParams.put("message", extendMap.getOrDefault("message", " "));
                customParams.put("innermsg", extendMap.getOrDefault("innermsg", " "));
            }
            this.updateTaskState(selectedRowId, newTaskState, customParams);
            this.updateStateChange(customParams);
        }
    }

    private void updateTaskState(Long id, String newTaskState, Map<String, Object> customParams) {
        QFilter idFilter = new QFilter("id", "=", (Object)id);
        DynamicObject[] colls = BusinessDataServiceHelper.load((String)"task_task", (String)"state,innermsg,apprevalmessage", (QFilter[])idFilter.toArray());
        DynamicObject taskInfo = colls[0];
        taskInfo.set("state", (Object)newTaskState);
        String innerMsg = (String)customParams.get("innermsg");
        if (StringUtils.isNotBlank((CharSequence)innerMsg)) {
            taskInfo.set("innermsg", customParams.get("innermsg"));
        }
        taskInfo.set("apprevalmessage", customParams.get("message"));
        SaveServiceHelper.update((DynamicObject)taskInfo);
    }

    private void updateStateChange(Map<String, Object> customParams) {
        DynamicObject stateChangeInfo = BusinessDataServiceHelper.newDynamicObject((String)"task_statechange");
        Long id = Long.valueOf(customParams.get("selectedRowId") + "");
        Long billTypeId = Long.valueOf(customParams.get("billTypeId") + "");
        Long taskTypeId = Long.valueOf(customParams.get("taskTypeId") + "");
        String operation = (String)customParams.get("operation");
        String newJobState = (String)customParams.get("newJobState");
        String oldJobState = (String)customParams.get("oldJobState");
        String message = (String)customParams.get("message");
        String innermsg = (String)customParams.get("innermsg");
        Long operatorid = this.getCurrentUserID();
        Timestamp changetime = new Timestamp(System.currentTimeMillis());
        stateChangeInfo.set("operatorid", (Object)operatorid);
        stateChangeInfo.set("operation", (Object)operation);
        stateChangeInfo.set("newjobstate", (Object)newJobState);
        stateChangeInfo.set("oldjobstate", (Object)oldJobState);
        stateChangeInfo.set("changetime", (Object)changetime);
        stateChangeInfo.set("innermsg", (Object)innermsg);
        stateChangeInfo.set("message", (Object)message);
        stateChangeInfo.set("jobid", (Object)id);
        stateChangeInfo.set("tasktype", (Object)taskTypeId);
        stateChangeInfo.set("billtype", (Object)billTypeId);
        int size = this.getOperationSize(id);
        stateChangeInfo.set("operationnum", (Object)(++size));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{stateChangeInfo});
    }

    private int getOperationSize(long id) {
        QFilter filter = new QFilter("jobid", "=", (Object)id);
        DynamicObjectCollection col = QueryServiceHelper.query((String)"task_statechange", (String)"id", (QFilter[])filter.toArray());
        return col.size();
    }

    private Long getCurrentUserID() {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        return userId;
    }

    private DynamicObject getDataTasklist(Long id) {
        QFilter filter = new QFilter("id", "=", (Object)id);
        return QueryServiceHelper.queryOne((String)"task_task", (String)"billtype,state,subject,tasktypeid,tasklevelid", (QFilter[])filter.toArray());
    }

    public String getOldJobState(Long Taskid) {
        int operationnum;
        QFilter jobIdFilter = new QFilter("jobid", "=", (Object)Taskid);
        QFilter opFil = new QFilter("operation", "!=", (Object)"26");
        DynamicObjectCollection stateCollection = QueryServiceHelper.query((String)"task_statechange", (String)"id,oldjobstate,operationnum", (QFilter[])new QFilter[]{jobIdFilter, opFil}, (String)"operationnum desc");
        String oldjobstate = (String)((DynamicObject)stateCollection.get(0)).get("oldjobstate");
        if (stateCollection.size() > 0 && (operationnum = ((Integer)((DynamicObject)stateCollection.get(0)).get("operationnum")).intValue()) == 0) {
            DynamicObjectCollection statebyChangeTime = QueryServiceHelper.query((String)"task_statechange", (String)"id,oldjobstate,operationnum", (QFilter[])jobIdFilter.toArray(), (String)"changetime desc");
            oldjobstate = (String)((DynamicObject)statebyChangeTime.get(0)).get("oldjobstate");
        }
        return oldjobstate;
    }
}

