/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeQuickAddNewEvent;
import kd.bos.form.field.events.BeforeQuickAddNewListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.ssc.enums.SSCTypeEnum;
import kd.ssc.function.SscFunctionTypes;
import kd.ssc.task.business.helper.DutyManageDataHelper;
import kd.ssc.task.business.helper.TaskMultiLangHelper;
import kd.ssc.task.common.OperationUtil;
import kd.ssc.task.common.TaskPropertyEnum;
import kd.ssc.task.util.SSCBosUtil;

public class TaskRuleChildEditPlugin
extends AbstractBillPlugIn
implements ClickListener,
BeforeF7SelectListener,
AfterF7SelectListener,
BeforeQuickAddNewListener {
    public static final Log log = LogFactory.getLog(TaskRuleChildEditPlugin.class);
    private static final String CACHEKEY_FIELD_NODES = "fieldnodes";
    private boolean neverShowSetPriorityTipsFlag = true;
    private static final String SSC_ID = "sscId";

    public void initialize() {
        super.initialize();
        TextEdit tasksubject = (TextEdit)this.getControl("tasksubject");
        tasksubject.addButtonClickListener((ClickListener)this);
        TextEdit billAttConf = (TextEdit)this.getControl("billattriconfig");
        billAttConf.addButtonClickListener((ClickListener)this);
        TextEdit billoprt = (TextEdit)this.getControl("taskoprt");
        billoprt.addButtonClickListener((ClickListener)this);
        TextEdit executeoprt = (TextEdit)this.getControl("executeoprt");
        executeoprt.addButtonClickListener((ClickListener)this);
        TextEdit reverseoprt = (TextEdit)this.getControl("reverseoprt");
        reverseoprt.addButtonClickListener((ClickListener)this);
        TextEdit priEdit = (TextEdit)this.getControl("priorityrule");
        priEdit.addButtonClickListener((ClickListener)this);
        TextEdit checkConditionEdit = (TextEdit)this.getControl("checkcondition");
        checkConditionEdit.addButtonClickListener((ClickListener)this);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        this.addItemClickListeners(new String[]{"advcontoolbarap3"});
        BasedataEdit tasktype = (BasedataEdit)this.getControl("tasktype");
        tasktype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit datainsightschema = (BasedataEdit)this.getControl("datainsightschema");
        datainsightschema.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit articheckpointconfig = (BasedataEdit)this.getControl("articheckpointconfig");
        articheckpointconfig.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit artiCheck = (BasedataEdit)this.getControl("articheck");
        artiCheck.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit priority = (BasedataEdit)this.getControl("priority");
        priority.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        priority.addAfterF7SelectListener((AfterF7SelectListener)this);
        priority.addBeforeQuickAddNewListener((BeforeQuickAddNewListener)this);
        BasedataEdit preTask = (BasedataEdit)this.getControl("pretasks");
        preTask.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit bindform = (BasedataEdit)this.getControl("bindform");
        bindform.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        TextEdit operationConfig = (TextEdit)this.getControl("srcoperation_desc");
        operationConfig.addButtonClickListener((ClickListener)this);
    }

    public void afterBindData(EventObject e) {
        String createTaskModel;
        boolean sscCreateTaskModel;
        FormShowParameter parameter;
        Object itemControl;
        IFormView thisView = this.getView();
        IDataModel model = this.getModel();
        IDataModel parentModel = thisView.getParentView().getModel();
        IPageCache iterC = (IPageCache)thisView.getParentView().getService(IPageCache.class);
        iterC.put("oldTaskoprt", (String)model.getValue("taskoprt"));
        DynamicObject bindbill = (DynamicObject)parentModel.getValue("bindbill");
        if (bindbill != null) {
            model.setValue("tasksubject", (Object)TaskMultiLangHelper.getTaskSubjectRemarkByMulLang((Long)((Long)model.getValue("tasksubjectid")), (String)bindbill.getString("number")));
        }
        if ((itemControl = (parameter = thisView.getFormShowParameter()).getCustomParams().get("itemControl")) instanceof Boolean) {
            Boolean control = (Boolean)itemControl;
            if (control.booleanValue()) {
                this.viewControl(thisView);
            } else {
                this.viewNotControl(thisView);
            }
        }
        if (!(sscCreateTaskModel = "0".equals(createTaskModel = (String)parentModel.getValue("createtaskmodel")))) {
            thisView.setVisible(Boolean.FALSE, new String[]{"nexttasks"});
        }
        this.setTaskOriCombo(sscCreateTaskModel);
        DynamicObject childssc = (DynamicObject)this.getModel().getValue("childssc");
        if (childssc != null) {
            this.getPageCache().put(SSC_ID, childssc.getString("id"));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        IDataModel model = this.getModel();
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        IDataModel parentModel = this.getView().getParentView().getModel();
        DynamicObject bindbill = (DynamicObject)parentModel.getValue("bindbill");
        String entityName = parentModel.getValue("name") + "";
        if (bindbill == null) {
            this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u6765\u6e90\u5355\u636e\u3002", (String)"TaskRuleChildEditPlugin_11", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            this.getView().sendFormAction(this.getView().getParentView());
            return;
        }
        if (StringUtils.isEmpty((String)entityName) || "null".equals(entityName)) {
            this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u540d\u79f0\u672a\u5f55\u5165\u3002", (String)"TaskRuleChildEditPlugin_12", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            this.getView().sendFormAction(this.getView().getParentView());
            return;
        }
        String entityNumber = bindbill.getString("number");
        if ("taskoprt".equals(key) || "executeoprt".equals(key) || "reverseoprt".equals(key) || "imagenumgenoprt".equals(key)) {
            this.getBilloperation(key, entityNumber);
        } else if ("tasksubject".equals(key)) {
            if (!" ".equals(entityNumber)) {
                this.getTaskSubject(entityNumber, entityName, model);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u7ed1\u5b9a\u5355\u636e\u6216\u4e1a\u52a1\u5355\u636e\u6ca1\u6709\u5f55\u5165\u540d\u79f0\u3002", (String)"TaskRuleChildEditPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            }
        } else if ("priorityrule".equals(key)) {
            if (!" ".equals(entityNumber)) {
                this.showConditionForm(entityNumber);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u7ed1\u5b9a\u5355\u636e\u6216\u4e1a\u52a1\u5355\u636e\u6ca1\u6709\u5f55\u5165\u540d\u79f0\u3002", (String)"TaskRuleChildEditPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            }
        } else if ("billattriconfig".equals(key)) {
            DynamicObject bindForm = (DynamicObject)this.getModel().getValue("bindform");
            String temp = bindForm == null ? entityNumber : bindForm.getString("number");
            this.showBillAttrConfig(temp);
        } else if ("srcoperation_desc".equals(key)) {
            DynamicObject bindForm = (DynamicObject)this.getModel().getValue("bindform");
            String temp = bindForm == null ? entityNumber : bindForm.getString("number");
            int index = this.getModel().getEntryCurrentRowIndex("entryentitybillop");
            this.getPageCache().put("billConfigRowIndex", String.valueOf(index));
            this.showBillOperationConfig(temp);
        } else if ("checkcondition".equals(key)) {
            if (StringUtils.isNotEmpty((String)entityNumber)) {
                int index = this.getModel().getEntryCurrentRowIndex("entryentityarticheck");
                this.getBillFilter(entityNumber, this.getModel().getValue("checkconditionjson_tag", index), "taskarticheck", "articheckrule", ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u4eba\u5de5\u68c0\u67e5\u9879\u6761\u4ef6", (String)"TaskRuleChildEditPlugin_20", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u7ed1\u5b9a\u5355\u636e\u6216\u4e1a\u52a1\u5355\u636e\u6ca1\u6709\u5f55\u5165\u540d\u79f0\u3002", (String)"TaskRuleChildEditPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        IDataModel model = this.getModel();
        if ("advconbaritemap13".equals(key)) {
            OperationUtil.deleteEntry("entryentitylevel", model, this.getView());
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        if (e.getActionId() != null) {
            IDataModel model = this.getModel();
            int currentRowfilter = this.getModel().getEntryCurrentRowIndex("entryentityfilter");
            int currentRowlevel = this.getModel().getEntryCurrentRowIndex("entryentitylevel");
            int currentArtiChecklevel = this.getModel().getEntryCurrentRowIndex("entryentityarticheck");
            Map ret = null;
            List retnumber = null;
            if ("propertyTree".equalsIgnoreCase(e.getActionId()) || "sourcefieldnametree".equalsIgnoreCase(e.getActionId()) || "articheckrule".equalsIgnoreCase(e.getActionId()) || "bar_save".equalsIgnoreCase(e.getActionId())) {
                ret = (Map)returnData;
            } else if ("billattriconfig".equals(e.getActionId())) {
                ret = (Map)returnData;
                model.setValue("billattriconfig", ret.get("showvalue"));
                model.setValue("billattriconfigjson_tag", ret.get("jsonvalue"));
            } else if ("billoperationconfig".equalsIgnoreCase(e.getActionId())) {
                Map opData = (Map)returnData;
                int rowIndex = Integer.parseInt(this.getPageCache().get("billConfigRowIndex"));
                this.getModel().setValue("srcoperation_key", opData.get("opKey"), rowIndex);
                this.getModel().setValue("srcoperation_desc", (Object)((String)opData.get("opKey") + "-" + (String)opData.get("opName")), rowIndex);
            } else if ("priorityrule".equalsIgnoreCase(e.getActionId())) {
                this.receiveFilter((String)returnData);
            } else {
                retnumber = (List)returnData;
            }
            if (ret != null && ret.size() > 0) {
                if ("propertyTree".equalsIgnoreCase(e.getActionId())) {
                    model.setValue("fieldname", ret.get("alias"), currentRowfilter);
                    model.setValue("fieldnumber", ret.get("key"), currentRowfilter);
                } else if ("bar_save".equalsIgnoreCase(e.getActionId())) {
                    model.setValue("tasksubject", ret.get("number"));
                    model.setValue("tasksubjectid", ret.get("id"));
                } else if ("articheckrule".equalsIgnoreCase(e.getActionId())) {
                    model.setValue("checkcondition", ret.get("filter"), currentArtiChecklevel);
                    model.setValue("checkconditionjson_tag", ret.get("filterCondition"), currentArtiChecklevel);
                }
            } else if (retnumber != null && retnumber.size() > 0) {
                if ("taskoprt".equalsIgnoreCase(e.getActionId())) {
                    model.setValue("taskoprt", ((Map)retnumber.get(0)).get("operationname"));
                    model.setValue("taskoprtnumber", ((Map)retnumber.get(0)).get("operationnumber"));
                } else if ("executeoprt".equalsIgnoreCase(e.getActionId())) {
                    model.setValue("executeoprt", ((Map)retnumber.get(0)).get("operationname"));
                    model.setValue("executeoprtnumber", ((Map)retnumber.get(0)).get("operationnumber"));
                } else if ("reverseoprt".equalsIgnoreCase(e.getActionId())) {
                    model.setValue("reverseoprt", ((Map)retnumber.get(0)).get("operationname"));
                    model.setValue("reverseoprtnumber", ((Map)retnumber.get(0)).get("operationnumber"));
                } else if ("imagenumgenoprt".equalsIgnoreCase(e.getActionId())) {
                    model.setValue("imagenumgenoprt", ((Map)retnumber.get(0)).get("operationname"));
                    model.setValue("imagenumgenoprtnumber", ((Map)retnumber.get(0)).get("operationnumber"));
                }
            }
        }
        this.getModel().updateCache();
    }

    private void receiveFilter(String filterJson) {
        int row = this.getModel().getEntryCurrentRowIndex("entryentitylevel");
        if (StringUtils.isBlank((String)filterJson)) {
            this.getModel().setValue("priorityrulejson", (Object)"", row);
            this.getModel().setValue("priorityrule", (Object)"", row);
        } else {
            CRCondition filterObj = (CRCondition)SerializationUtils.fromJsonString((String)filterJson, CRCondition.class);
            this.getModel().setValue("priorityrulejson", (Object)filterJson, row);
            String dsp = filterObj.getDescription().toString();
            if (StringUtils.isBlank((String)dsp)) {
                dsp = filterObj.getExprTran();
            }
            this.getModel().setValue("priorityrule", (Object)dsp, row);
        }
    }

    private void showConditionForm(String entityNumber) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("task_condition");
        int row = this.getModel().getEntryCurrentRowIndex("entryentitylevel");
        String conditionJson = (String)this.getModel().getValue("priorityrulejson", row);
        showParameter.getCustomParams().put("formula", conditionJson);
        showParameter.getCustomParams().put("entitynumber", entityNumber);
        String fieldNodes = this.getPageCache().get(CACHEKEY_FIELD_NODES);
        if (StringUtils.isEmpty((String)fieldNodes)) {
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            PropTreeBuildOption propTreeBuildOption = new PropTreeBuildOption();
            propTreeBuildOption.setOnlyPhysicsField(true);
            TreeNode rootNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)mainType, (PropTreeBuildOption)propTreeBuildOption);
            fieldNodes = SerializationUtils.toJsonString((Object)rootNode);
            this.getPageCache().put(CACHEKEY_FIELD_NODES, fieldNodes);
        }
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        String funcsXML = this.getPageCache().get("functiontypes");
        if (StringUtils.isEmpty((String)funcsXML)) {
            FunctionTypes functionTypes = SscFunctionTypes.get();
            funcsXML = FunctionTypes.serializeToXML((FunctionTypes)functionTypes);
            this.getPageCache().put("functiontypes", funcsXML);
        }
        showParameter.getCustomParams().put("functiontypes", funcsXML);
        showParameter.getCustomParams().put("fieldKey", "task_taskbill_taskPriority");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "priorityrule"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void getTaskSubject(String entryNumber, String entryName, IDataModel model) {
        Long tasksubjectid;
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("task_tasksubject");
        if (!model.getValue("tasksubjectid").equals(" ") && (tasksubjectid = (Long)model.getValue("tasksubjectid")) != 0L) {
            showParameter.setPkId((Object)tasksubjectid);
            showParameter.setStatus(OperationStatus.EDIT);
        }
        showParameter.setCustomParam("entryName", (Object)entryName);
        showParameter.setCustomParam("entryNumber", (Object)entryNumber);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "bar_save");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void getBillFilter(String taskBill, Object ruleJson, String fromWhere, String closeCallBackKey, String caption) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("task_taskbillfilter");
        showParameter.getOpenStyle().setShowType(ShowType.NonModal);
        if (StringUtils.isNotEmpty((String)caption)) {
            showParameter.setCaption(caption);
        }
        showParameter.setCustomParam("taskBill", (Object)taskBill);
        showParameter.setCustomParam("json", ruleJson);
        showParameter.setCustomParam("fromWhere", (Object)fromWhere);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, closeCallBackKey);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void getBilloperation(String operation, String entityKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("task_operationlist");
        showParameter.getOpenStyle().setShowType(ShowType.NonModal);
        if (entityKey.equalsIgnoreCase("null") || entityKey.equalsIgnoreCase(" ")) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6b64\u5355\u636e\u4e0d\u5b58\u5728\u5b9e\u4f53\uff0c\u8bf7\u624b\u5de5\u5f55\u5165\u3002", (String)"TaskRuleChildEditPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        } else {
            List alist = EntityMetadataCache.getDataEntityOperate((String)entityKey);
            if (alist.size() != 0) {
                showParameter.setCustomParam("entityKey", (Object)entityKey);
                CloseCallBack closeCallBack = null;
                if (operation.equals("taskoprt")) {
                    closeCallBack = new CloseCallBack((IFormPlugin)this, "taskoprt");
                } else if (operation.equals("executeoprt")) {
                    closeCallBack = new CloseCallBack((IFormPlugin)this, "executeoprt");
                } else if (operation.equals("reverseoprt")) {
                    closeCallBack = new CloseCallBack((IFormPlugin)this, "reverseoprt");
                } else if (operation.equals("imagenumgenoprt")) {
                    closeCallBack = new CloseCallBack((IFormPlugin)this, "imagenumgenoprt");
                }
                showParameter.setCloseCallBack(closeCallBack);
                this.getView().showForm(showParameter);
            } else {
                this.getView().showMessage(ResManager.loadKDString((String)"\u5355\u636e\u5143\u6570\u636e\u672a\u4fdd\u5b58\u3002", (String)"TaskRuleChildEditPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void showBillOperationConfig(String entityNumber) {
        FormShowParameter showParam = new FormShowParameter();
        showParam.setFormId("task_billoperationconfig");
        showParam.setCustomParam("entityNumber", (Object)entityNumber);
        showParam.setHasRight(true);
        showParam.getOpenStyle().setShowType(ShowType.Modal);
        showParam.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "billoperationconfig"));
        this.getView().showForm(showParam);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IFormView parentView = this.getView().getParentView();
        IDataModel parentModel = parentView.getModel();
        IDataModel model = this.getModel();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        int rowIdx = changeData.getRowIndex();
        String propName = e.getProperty().getName();
        if ("tasktype".equals(propName)) {
            this.taskTypeChanged(parentView, parentModel, newValue);
        } else if ("timeliness".equals(propName)) {
            this.timelineChanged(parentView, newValue, oldValue, rowIdx);
        } else if ("warningtime".equals(propName)) {
            this.warningTimeChanged(parentView, model, newValue, oldValue, rowIdx);
        } else if ("taskoprt".equals(propName)) {
            this.taskOprtChanged(newValue);
        } else if ("taskoprtnumber".equals(propName)) {
            this.taskOprtNumberChanged(newValue);
        } else if ("executeoprt".equals(propName)) {
            this.executeOprtChanged(newValue);
        } else if ("reverseoprt".equals(propName)) {
            this.reverseOprtChanged(newValue);
        } else if ("billattriconfig".equals(propName)) {
            this.billAttriConfigChanged(model, newValue);
        } else if ("taskoriginal".equals(propName)) {
            this.taskOriChanged(model, newValue);
        } else if ("tasksubject".equals(propName)) {
            this.taskSubjectChanged(newValue);
        } else if ("bindform".equals(propName)) {
            this.bindFormChanged(model, newValue);
        } else if ("priority".equals(propName)) {
            this.priorityChanged(newValue, rowIdx);
        } else if ("priorityrule".equalsIgnoreCase(propName)) {
            this.priorityRuleChanged(newValue, rowIdx);
        } else if ("priorityrulejson".equalsIgnoreCase(propName)) {
            this.priorityRuleJsonChanged(newValue, rowIdx);
        } else if ("srcoperation_desc".equals(propName)) {
            this.srcOperationDescChanged(newValue, rowIdx);
        } else if ("checkcondition".equalsIgnoreCase(propName) && (newValue == null || StringUtils.isEmpty((String)newValue.toString()))) {
            this.getModel().setValue("checkconditionjson_tag", (Object)"", rowIdx);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel parentModel = this.getView().getParentView().getModel();
        DynamicObject sscenter = (DynamicObject)parentModel.getValue("ssccenter");
        IDataModel model = this.getModel();
        this.setParentCreateTaskModel(parentModel, model);
        model.setValue("childssc", (Object)sscenter);
        if (sscenter == null) {
            this.getView().getParentView().showConfirm(ResManager.loadKDString((String)"\u8be5\u7528\u6237\u5728\u5f53\u524d\u5171\u4eab\u4e2d\u5fc3\u4e0b\u65e0\u65b0\u589e\u6743\u9650\uff0c\u8bf7\u5207\u6362\u5171\u4eab\u4e2d\u5fc3\u3002", (String)"TaskRuleChildEditPlugin_17", (String)"ssc-task-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
            return;
        }
        this.getPageCache().put("createOrg", sscenter.getString("id"));
        model.batchCreateNewEntryRow("entryentitylevel", 2);
        model.setValue("priority", (Object)1, 0);
        model.setValue("timeliness", (Object)4, 0);
        model.setValue("isdefault", (Object)Boolean.TRUE, 1);
        model.setValue("priority", (Object)2, 1);
        model.setValue("timeliness", (Object)48, 1);
        model.setValue("taskcount", (Object)1000);
        model.setValue("taskhour", (Object)4);
        int billOpRowCount = this.getModel().getEntryRowCount("entryentitybillop");
        if (billOpRowCount == 0) {
            model.batchCreateNewEntryRow("entryentitybillop", 2);
            model.setValue("ssc_auditop", (Object)"1", 0);
            model.setValue("ssc_auditop", (Object)"7", 1);
            model.setValue("srcoperation_desc", (Object)ResManager.loadKDString((String)"save-\u4fdd\u5b58", (String)"TaskRuleChildEditPlugin_19", (String)"ssc-task-formplugin", (Object[])new Object[0]), 0);
            model.setValue("srcoperation_desc", (Object)ResManager.loadKDString((String)"save-\u4fdd\u5b58", (String)"TaskRuleChildEditPlugin_19", (String)"ssc-task-formplugin", (Object[])new Object[0]), 1);
            model.setValue("srcoperation_key", (Object)"save", 0);
            model.setValue("srcoperation_key", (Object)"save", 1);
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.setParentCreateTaskModel(this.getView().getParentView().getModel(), this.getModel());
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentitylevel");
        if (entryEntity != null && !entryEntity.isEmpty()) {
            for (int i = 0; i < entryEntity.size(); ++i) {
                String conditionJson = (String)this.getModel().getValue("priorityrulejson", i);
                if (!StringUtils.isNotEmpty((String)conditionJson)) continue;
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"isdefault"});
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operate = args.getSource().getClass().getName();
        if ("kd.bos.entity.operate.Save".equalsIgnoreCase(operate)) {
            String taskoriginal;
            IDataModel model = this.getModel();
            String string = taskoriginal = model.getValue("taskoriginal") == null ? null : model.getValue("taskoriginal").toString();
            if ("0".equalsIgnoreCase(taskoriginal)) {
                model.setValue("taskoprt", null);
                model.setValue("taskoprtnumber", null);
                model.setValue("executeoprt", null);
                model.setValue("executeoprtnumber", null);
                model.setValue("reverseoprt", null);
                model.setValue("reverseoprtnumber", null);
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        BasedataEdit edit = (BasedataEdit)e.getSource();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        List qFilters = showParameter.getListFilterParameter().getQFilters();
        DynamicObject childssc = (DynamicObject)this.getModel().getValue("childssc");
        Long sscId = childssc.getLong("id");
        if ("tasktype".equals(edit.getKey())) {
            qFilters.add(new QFilter("orgfield", "=", (Object)sscId));
            qFilters.add(new QFilter("qualityjudge", "!=", (Object)"1"));
            String createTaskModel = (String)this.getView().getParentView().getModel().getValue("createtaskmodel");
            if ("1".equals(createTaskModel)) {
                qFilters.add(new QFilter("tasklevel", "!=", (Object)" "));
            }
            String sscType = DutyManageDataHelper.getSSCType((long)sscId);
            if (!SSCTypeEnum.HR.getValue().equals(sscType)) {
                qFilters.add(new QFilter("qualityjudge", "!=", (Object)TaskPropertyEnum.HANDLE_TASK.getValue()));
            }
        } else if ("priority".equals(edit.getKey())) {
            List<String> containsPriority = this.getContainsPriorityList();
            this.getPageCache().put("taskrulechild_priority", containsPriority.toString());
        } else if ("datainsightschema".equals(edit.getKey())) {
            Object billObj = this.getView().getParentView().getModel().getValue("bindbill");
            if (billObj == null) {
                this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u6765\u6e90\u5355\u636e\u3002", (String)"TaskRuleChildEditPlugin_11", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                this.getView().sendFormAction(this.getView().getParentView());
                e.setCancel(true);
                return;
            }
            String billNumber = ((DynamicObject)billObj).getString("number");
            QFilter qFilter = new QFilter("sourceentitynumber.number", "in", Collections.singletonList(billNumber));
            qFilters.add(qFilter);
        } else if ("articheckpointconfig".equals(edit.getKey())) {
            QFilter qFilter = new QFilter("createorg", "=", (Object)sscId);
            showParameter.getListFilterParameter().setFilter(qFilter);
        } else if ("articheck".equalsIgnoreCase(edit.getKey())) {
            QFilter qFilter = new QFilter("createorg", "=", (Object)sscId);
            HashSet<Object> set = new HashSet<Object>(16);
            DynamicObjectCollection entryDyoCol = this.getModel().getEntryEntity("entryentityarticheck");
            if (entryDyoCol != null && !entryDyoCol.isEmpty()) {
                for (DynamicObject dyo : entryDyoCol) {
                    set.add(dyo.get("articheck_id"));
                }
            }
            if (!set.isEmpty()) {
                qFilter.and("id", "not in", set);
            }
            showParameter.getListFilterParameter().setFilter(qFilter);
        } else if ("pretasks".equals(edit.getKey())) {
            List<Long> taskTypeIds = this.getAllTaskTypeIdFormParentView();
            QFilter qFilter = new QFilter("id", "in", taskTypeIds);
            qFilters.add(qFilter);
        } else if ("bindform".equals(edit.getKey())) {
            DynamicObject billObj = (DynamicObject)this.getView().getParentView().getModel().getValue("bindbill");
            if (billObj == null) {
                this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u6765\u6e90\u5355\u636e\u3002", (String)"TaskRuleChildEditPlugin_11", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                this.getView().sendFormAction(this.getView().getParentView());
                e.setCancel(true);
                return;
            }
            DynamicObject externalERP = (DynamicObject)this.getView().getParentView().getModel().getValue("externalerp");
            if (externalERP == null) {
                this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u6240\u5c5e\u7cfb\u7edf\u3002", (String)"TaskRuleChildEditPlugin_18", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                this.getView().sendFormAction(this.getView().getParentView());
                e.setCancel(true);
                return;
            }
            this.setEntityFilter(showParameter, billObj, externalERP);
            QFilter typeFilter = new QFilter("modeltype", "in", Arrays.asList("BillFormModel", "BaseFormModel"));
            qFilters.add(typeFilter);
            showParameter.setCaption(ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u5217\u8868", (String)"TaskRuleEditPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
    }

    private void setEntityFilter(ListShowParameter showParameter, DynamicObject billObj, DynamicObject externalERP) {
        String paramValue;
        boolean supportErp;
        QFilter filter = new QFilter("paramname", "=", (Object)"ruleBindFormFilterEntitySupportErp");
        DynamicObject dy = BusinessDataServiceHelper.loadSingleFromCache((String)"task_paramcontrol", (String)"paramvalue", (QFilter[])filter.toArray());
        boolean bl = supportErp = dy != null && (paramValue = dy.getString("paramvalue")) != null && Arrays.stream(paramValue.split(",")).anyMatch(p -> p.equals(externalERP.getString("number")));
        if (supportErp) {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)billObj.getString("number"));
            String tableName = entityType.getAlias();
            HashSet entityMainIds = new HashSet(16);
            if (StringUtils.isNotEmpty((String)tableName)) {
                entityMainIds.addAll(SSCBosUtil.queryEntityByTable((String)tableName));
            }
            entityMainIds.addAll(SSCBosUtil.queryFormDesignByNumber(Collections.singletonList(billObj.getString("number"))));
            if (!entityMainIds.isEmpty()) {
                entityMainIds.addAll(SSCBosUtil.queryFormDesignByEntity(entityMainIds));
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)entityMainIds.toArray()));
            }
        }
    }

    public void afterF7Select(AfterF7SelectEvent e) {
        String containsPriority = this.getPageCache().get("taskrulechild_priority");
        if (StringUtils.isEmpty((String)containsPriority)) {
            return;
        }
        IDataModel model = this.getModel();
        ListSelectedRowCollection listSelectedRows = e.getListSelectedRowCollection();
        for (ListSelectedRow row : listSelectedRows) {
            DynamicObject priorityObj;
            if ((Long)row.getPrimaryKeyValue() == 0L || !containsPriority.contains((priorityObj = (DynamicObject)model.getValue("priority", model.getEntryCurrentRowIndex("entryentitylevel"))).getString("name"))) continue;
            IFormView parentView = this.getView().getParentView();
            parentView.showTipNotification(ResManager.loadKDString((String)"\u76f8\u540c\u7ea7\u522b\u7684\u4f18\u5148\u7ea7\u8bb0\u5f55\u88ab\u91cd\u590d\u6dfb\u52a0\uff0c\u8bf7\u5220\u9664\u3002", (String)"TaskRuleChildEditPlugin_10", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            this.getView().sendFormAction(parentView);
        }
    }

    private List<String> getContainsPriorityList() {
        IDataModel model = this.getModel();
        DynamicObjectCollection entrys = model.getEntryEntity("entryentitylevel");
        ArrayList<String> priorityList = new ArrayList<String>(2);
        for (DynamicObject entry : entrys) {
            String priority;
            DynamicObject priorityObject = entry.getDynamicObject("priority");
            if (priorityObject == null || priorityList.contains(priority = priorityObject.getString("name"))) continue;
            priorityList.add(priority);
        }
        return priorityList;
    }

    private void showBillAttrConfig(String entityNumber) {
        if (StringUtils.isEmpty((String)entityNumber)) {
            log.error("\u5f02\u5e38\uff1ashowBillAttrConfig()\u63a5\u6536\u7684entityNumber\u4e3a" + entityNumber);
            return;
        }
        FormShowParameter showParam = new FormShowParameter();
        showParam.setFormId("task_billattributeconfig");
        showParam.setCustomParam("entityNumber", (Object)entityNumber);
        showParam.setCustomParam("jsonvalue", this.getModel().getValue("billattriconfigjson_tag"));
        showParam.setHasRight(true);
        showParam.setShowTitle(true);
        showParam.getOpenStyle().setShowType(ShowType.Modal);
        showParam.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "billattriconfig"));
        this.getView().showForm(showParam);
    }

    private List<Long> getAllTaskTypeIdFormParentView() {
        ArrayList<Long> taskTypeIdList = new ArrayList<Long>(2);
        IFormView parentView = this.getView().getParentView();
        IDataModel parentModel = parentView.getModel();
        DynamicObjectCollection entrys = parentModel.getEntryEntity("entryentity");
        for (DynamicObject taskConfig : entrys) {
            Long taskTypeId;
            Object taskTypeIdTmp = taskConfig.get("tasktype");
            if (!(taskTypeIdTmp instanceof DynamicObject) || taskTypeIdList.contains(taskTypeId = Long.valueOf(((DynamicObject)taskTypeIdTmp).getLong("id")))) continue;
            taskTypeIdList.add(taskTypeId);
        }
        Object curTaskTypeTmp = this.getModel().getValue("tasktype");
        if (curTaskTypeTmp instanceof DynamicObject) {
            Long curTaskTypeId = ((DynamicObject)curTaskTypeTmp).getLong("id");
            taskTypeIdList.remove(curTaskTypeId);
        }
        return taskTypeIdList;
    }

    private void taskTypeChanged(IFormView parentView, IDataModel parentModel, Object newValue) {
        DynamicObject propValue = (DynamicObject)newValue;
        int parentEntryIndex = Integer.parseInt(this.getView().getFormShowParameter().getCustomParam("parentEntryIndex").toString());
        if (propValue == null) {
            return;
        }
        parentModel.setValue("tasktype", (Object)propValue, parentEntryIndex);
        this.getView().sendFormAction(parentView);
        parentView.updateView("entryentity");
    }

    private void timelineChanged(IFormView parentView, Object newValue, Object oldValue, int rowIdx) {
        IDataModel model = this.getModel();
        int countLevel = model.getEntryRowCount("entryentitylevel");
        DynamicObject priorityCurrent = (DynamicObject)model.getValue("priority", rowIdx);
        if (priorityCurrent == null) {
            model.setValue("timeliness", (Object)0, rowIdx);
            if (this.neverShowSetPriorityTipsFlag) {
                this.neverShowSetPriorityTipsFlag = false;
                parentView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u914d\u7f6e\u4f18\u5148\u7ea7\u3002", (String)"TaskRuleChildEditPlugin_16", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                this.getView().sendFormAction(parentView);
            }
            return;
        }
        int priorityCurrentValue = (Integer)priorityCurrent.get("priority");
        if (newValue != null && ((BigDecimal)newValue).compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal timelinessCurrent = (BigDecimal)newValue;
            if (timelinessCurrent.intValue() < 0) {
                parentView.showTipNotification(ResManager.loadKDString((String)"\u65f6\u6548\u4e0d\u80fd\u4e3a\u8d1f\u6570\u3002", (String)"TaskRuleChildEditPlugin_13", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                this.getView().sendFormAction(parentView);
                model.setValue("timeliness", oldValue, rowIdx);
            } else {
                BigDecimal warntime = (BigDecimal)model.getValue("warningtime", rowIdx);
                if (timelinessCurrent.compareTo(warntime) < 0) {
                    parentView.showTipNotification(ResManager.loadKDString((String)"\u65f6\u6548\uff08\u5c0f\u65f6\uff09\u4e0d\u80fd\u5c0f\u4e8e\u9884\u8b66\u65f6\u95f4\uff08\u5c0f\u65f6\uff09\u3002", (String)"TaskRuleChildEditPlugin_15", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    this.getView().sendFormAction(parentView);
                    model.setValue("timeliness", oldValue, rowIdx);
                    return;
                }
                for (int i = 0; i < countLevel; ++i) {
                    if (rowIdx == i) continue;
                    DynamicObject priority = (DynamicObject)model.getValue("priority", i);
                    if (priority == null) {
                        return;
                    }
                    BigDecimal timeliness = (BigDecimal)model.getValue("timeliness", i);
                    int priorityValue = (Integer)priority.get("priority");
                    if (priorityCurrentValue > priorityValue) {
                        if (timelinessCurrent.intValue() >= timeliness.intValue()) continue;
                        parentView.showTipNotification(ResManager.loadKDString((String)"\u6b64\u4f18\u5148\u7ea7\u6bd4\u8f83\u4f4e\uff0c\u5f55\u5165\u7684\u65f6\u6548\u592a\u77ed\u4e0d\u5408\u7406\u3002", (String)"TaskRuleChildEditPlugin_6", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                        this.getView().sendFormAction(parentView);
                        model.setValue("timeliness", oldValue, rowIdx);
                        break;
                    }
                    if (priorityCurrentValue >= priorityValue || timeliness.compareTo(BigDecimal.ZERO) <= 0 || timelinessCurrent.intValue() <= timeliness.intValue()) continue;
                    parentView.showTipNotification(ResManager.loadKDString((String)"\u6b64\u4f18\u5148\u7ea7\u6bd4\u8f83\u9ad8\uff0c\u5f55\u5165\u7684\u65f6\u6548\u592a\u957f\u4e0d\u5408\u7406\u3002", (String)"TaskRuleChildEditPlugin_7", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    this.getView().sendFormAction(parentView);
                    model.setValue("timeliness", oldValue, rowIdx);
                    break;
                }
            }
        }
    }

    private void warningTimeChanged(IFormView parentView, IDataModel model, Object newValue, Object oldValue, int rowIdx) {
        BigDecimal timeliness;
        BigDecimal warnTime;
        if (newValue != null && (warnTime = (BigDecimal)newValue).compareTo(timeliness = (BigDecimal)model.getValue("timeliness", rowIdx)) > 0) {
            model.beginInit();
            model.setValue("warningtime", oldValue);
            model.endInit();
            parentView.showTipNotification(ResManager.loadKDString((String)"\u9884\u8b66\u65f6\u95f4\uff08\u5c0f\u65f6\uff09\u4e0d\u80fd\u5927\u4e8e\u65f6\u6548\uff08\u5c0f\u65f6\uff09\u3002", (String)"TaskRuleChildEditPlugin_14", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            this.getView().sendFormAction(parentView);
        }
    }

    private void taskOprtChanged(Object newValue) {
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        String taskoprt = (String)newValue;
        if (StringUtils.isBlank((String)taskoprt)) {
            taskoprt = "1";
        }
        pageCache.put("newTaskoprt", taskoprt);
        if (newValue == null || StringUtils.isEmpty((String)newValue.toString())) {
            this.getModel().setValue("taskoprtnumber", (Object)"");
        }
    }

    private void taskOprtNumberChanged(Object newValue) {
        IPageCache pageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
        String taskoprtNumber = (String)newValue;
        if (StringUtils.isBlank((String)taskoprtNumber)) {
            taskoprtNumber = "1";
        }
        pageCache.put("newTaskoprtnumber", taskoprtNumber);
    }

    private void executeOprtChanged(Object newValue) {
        if (newValue == null || StringUtils.isEmpty((String)newValue.toString())) {
            this.getModel().setValue("executeoprtnumber", (Object)"");
        }
    }

    private void reverseOprtChanged(Object newValue) {
        if (newValue == null || StringUtils.isEmpty((String)newValue.toString())) {
            this.getModel().setValue("reverseoprtnumber", (Object)"");
        }
    }

    private void billAttriConfigChanged(IDataModel model, Object newValue) {
        if (newValue == null || StringUtils.isEmpty((String)newValue.toString())) {
            model.beginInit();
            model.setValue("billattriconfigjson", null);
            model.setValue("billattriconfigjson_tag", null);
            model.endInit();
        }
    }

    private void taskOriChanged(IDataModel model, Object newValue) {
        model.setValue("pretasks", null);
        if ("3".equals(newValue)) {
            model.beginInit();
            model.setValue("issame", (Object)false);
            model.endInit();
            this.getView().updateView("issame");
        }
    }

    private void taskSubjectChanged(Object newValue) {
        if (newValue == null || StringUtils.isEmpty((String)newValue.toString())) {
            this.getModel().setValue("tasksubjectid", (Object)0);
        }
    }

    private void bindFormChanged(IDataModel model, Object newValue) {
        model.beginInit();
        model.setValue("billattriconfig", null);
        model.setValue("billattriconfigjson", null);
        model.setValue("billattriconfigjson_tag", null);
        model.setValue("billoperationconfig", null);
        model.endInit();
        this.getModel().deleteEntryData("entryentitybillop");
        this.getView().updateView("billattriconfig");
    }

    private void priorityChanged(Object newValue, int rowIdx) {
        DynamicObject tasklevel = (DynamicObject)newValue;
        if (tasklevel == null) {
            return;
        }
        this.getModel().setValue("timeliness", null, rowIdx);
    }

    private void priorityRuleChanged(Object newValue, int rowIdx) {
        if (newValue == null || StringUtils.isEmpty((String)newValue.toString())) {
            this.getModel().setValue("priorityrulejson", (Object)"", rowIdx);
        }
    }

    private void priorityRuleJsonChanged(Object newValue, int rowIdx) {
        if (newValue != null && !StringUtils.isEmpty((String)newValue.toString())) {
            this.getModel().setValue("isdefault", (Object)"0", rowIdx);
            this.getView().setEnable(Boolean.FALSE, rowIdx, new String[]{"isdefault"});
        } else {
            this.getView().setEnable(Boolean.TRUE, rowIdx, new String[]{"isdefault"});
        }
    }

    private void srcOperationDescChanged(Object newValue, int rowIdx) {
        String newSrcOp = (String)newValue;
        if (StringUtils.isBlank((String)newSrcOp)) {
            this.getModel().setValue("srcoperation_key", null, rowIdx);
        }
    }

    private void viewControl(IFormView view) {
        this.itemControl(Boolean.FALSE, view);
    }

    private void viewNotControl(IFormView view) {
        this.itemControl(Boolean.TRUE, view);
    }

    private void itemControl(Boolean enable, IFormView view) {
        view.setEnable(enable, new String[]{"tasktype"});
        view.setEnable(enable, new String[]{"fieldsetpanelap1"});
    }

    public void beforeQuickAddNew(BeforeQuickAddNewEvent e) {
        BasedataEdit basedataEdit = (BasedataEdit)e.getSource();
        String fieldKey = basedataEdit.getFieldKey();
        if ("priority".equals(fieldKey)) {
            e.getShowParameter().setCustomParam(SSC_ID, (Object)this.getPageCache().get(SSC_ID));
        }
    }

    private void setTaskOriCombo(boolean sscCreateTaskModel) {
        ComboEdit taskoriComboEdit = (ComboEdit)this.getView().getControl("taskoriginal");
        ComboProp taskOriComboProp = (ComboProp)this.getModel().getProperty("taskoriginal");
        List vmItems = taskOriComboProp.getComboItems();
        ArrayList<ComboItem> cbItems = new ArrayList<ComboItem>(vmItems.size());
        for (ValueMapItem vmItem : vmItems) {
            if (sscCreateTaskModel ? "3".equals(vmItem.getValue()) : "2".equals(vmItem.getValue())) continue;
            ComboItem cbItem = new ComboItem();
            cbItem.setValue(vmItem.getValue());
            cbItem.setCaption(vmItem.getName());
            cbItem.setItemVisible(vmItem.isItemVisible());
            cbItems.add(cbItem);
        }
        taskoriComboEdit.setComboItems(cbItems);
    }

    private void setParentCreateTaskModel(IDataModel parentModel, IDataModel dataModel) {
        String createTaskModel = (String)parentModel.getValue("createtaskmodel");
        dataModel.setValue("parentcreatetaskmodel", (Object)createTaskModel);
    }
}

