/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.tree.TreeFilterParameter;
import kd.bos.util.CollectionUtils;
import kd.ssc.task.business.helper.TaskBillClassifyHelper;
import kd.ssc.task.formplugin.imports.TaskAbstractListPlugin;
import kd.ssc.task.partask.util.ParTaskFlowVerifyUtil;

public class TaskRuleListPlugin
extends TaskAbstractListPlugin
implements ItemClickListener {
    private static final String ITEM_KEY_LOG = "viewsynlog";
    private static final String CACHE_KEY_SSC = "sscid";
    private static final String CACHE_KEY_OVER_CLICK = "overclick";
    private static final String CALLBACK_DELETE = "delete";
    private static final String CALLBACK_UNEFFECTIVE = "callback_uneffective";
    private static final String CACHE_CONFIRM_UNEFFECTIVE = "confirmUnEffective";

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        ListShowParameter formShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (!this.isOverClick() && !formShowParameter.isLookUp()) {
            this.getPageCache().put(CACHE_KEY_OVER_CLICK, "true");
            for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
                if (!(filterColumn instanceof CommonFilterColumn)) continue;
                CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
                String filterColumnField = commonFilterColumn.getFieldName();
                if ("ssccenter.id".equals(filterColumnField)) {
                    List list = commonFilterColumn.getDefaultValues();
                    if (list.size() > 0) {
                        String sscId = (String)list.get(0);
                        this.getPageCache().put(CACHE_KEY_SSC, sscId);
                        continue;
                    }
                    List comboItems = commonFilterColumn.getComboItems();
                    if (comboItems.size() <= 0) continue;
                    ComboItem comboItem = (ComboItem)comboItems.get(0);
                    String sscId = comboItem.getValue();
                    this.getPageCache().put(CACHE_KEY_SSC, sscId);
                    continue;
                }
                if (!"effective".equals(filterColumnField)) continue;
                commonFilterColumn.setDefaultValue("1");
            }
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map currentCommonFilter = args.getCurrentCommonFilter();
        if (currentCommonFilter != null && "ssccenter.id".equals(((List)currentCommonFilter.get("FieldName")).get(0))) {
            this.getPageCache().put(CACHE_KEY_SSC, String.valueOf(((List)currentCommonFilter.get("Value")).get(0)));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String opKey = operate.getOperateKey();
        if ("effective".equals(opKey)) {
            ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
            if (selectedRows.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"TaskRuleListPlugin_6", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        } else if ("uneffective".contains(opKey)) {
            ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
            Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
            QFilter existFilter = new QFilter("id", "in", (Object)primaryKeyValues);
            existFilter.and(new QFilter("effective", "=", (Object)"2"));
            if (QueryServiceHelper.exists((String)"task_taskbill", (QFilter[])existFilter.toArray())) {
                String isConfirm = this.getPageCache().get(CACHE_CONFIRM_UNEFFECTIVE);
                if ("true".equals(isConfirm)) {
                    this.getPageCache().remove(CACHE_CONFIRM_UNEFFECTIVE);
                } else {
                    String confirmMsg = ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u6240\u6709\u4f7f\u7528\u5171\u4eab\u4e2d\u5fc3\u521b\u5efa\u4efb\u52a1\u7684\u5728\u9014\u6d41\u7a0b\u5747\u5df2\u7ed3\u675f\uff0c\u5982\u4ecd\u6709\u5728\u9014\u6d41\u7a0b\u8fd0\u884c\uff0c\u53d6\u6d88\u5728\u9014\u4f7f\u7528\u6807\u8bb0\u540e\uff0c\u53ef\u80fd\u9020\u6210\u521b\u5efa\u4efb\u52a1\u5931\u8d25\u6216\u91cd\u590d\uff0c\u786e\u5b9a\u8981\u5931\u6548\u9009\u62e9\u7684\u4e1a\u52a1\u5355\u636e\u5417\uff1f", (String)"TaskRuleEditPlugin_21", (String)"ssc-task-formplugin", (Object[])new Object[0]);
                    this.getView().showConfirm(confirmMsg, MessageBoxOptions.YesNo, new ConfirmCallBackListener(CALLBACK_UNEFFECTIVE, (IFormPlugin)this));
                    args.setCancel(true);
                }
            }
        } else if ("exportdetails".equals(opKey) || "importdetails".equals(opKey)) {
            operate.setEntityId("task_taskbill4impt");
        }
    }

    private List<String> getSameBizBill(Long bizBillId, Long sscId, String sourceBillId) {
        List<QFilter> qFilters = this.getSameBizBillFilters(bizBillId, sscId, sourceBillId);
        DynamicObject[] sameBizBills = BusinessDataServiceHelper.load((String)"task_taskbill", (String)"name,number,bindbill", (QFilter[])qFilters.toArray(new QFilter[0]));
        if (sameBizBills.length == 0) {
            return new ArrayList<String>(0);
        }
        String sourceBillName = sameBizBills[0].getString("bindbill.name") + "";
        String bizBillNumber = sameBizBills[0].getString("number");
        String bizBillName = sameBizBills[0].getString("name") + "";
        ArrayList<String> tips = new ArrayList<String>(3);
        tips.add(sourceBillName);
        tips.add(bizBillNumber);
        tips.add(bizBillName);
        return tips;
    }

    private List<QFilter> getSameBizBillFilters(Long bizBillId, Long sscId, String sourceBillId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(4);
        qFilters.add(new QFilter("id", "!=", (Object)bizBillId));
        qFilters.add(new QFilter("bindbill", "=", (Object)sourceBillId));
        qFilters.add(new QFilter("ssccenter", "=", (Object)sscId));
        qFilters.add(new QFilter("effective", "=", (Object)"1"));
        return qFilters;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (CALLBACK_DELETE.equals(key)) {
            ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
            if (selectedRows.size() == 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e\u884c\u3002", (String)"TaskRuleListPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            } else {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CALLBACK_DELETE, (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u5f53\u524d\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5220\u9664\uff1f", (String)"TaskRuleListPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBacks);
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"number")) {
            boolean fromQualityCheck;
            ListSelectedRow selectedRow = ((BillList)args.getHyperLinkClickEvent().getSource()).getCurrentSelectedRowInfo();
            Long selectId = (Long)selectedRow.getPrimaryKeyValue();
            DynamicObject qryResult = QueryServiceHelper.queryOne((String)"task_taskbill", (String)"ssccenter", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)selectId)});
            String parentFormId = this.getView().getFormShowParameter().getParentFormId();
            boolean bl = fromQualityCheck = "task_qualitycheckscheme".equals(parentFormId) || "task_smartcheckscheme".equals(parentFormId);
            if (!fromQualityCheck && qryResult != null && ParTaskFlowVerifyUtil.isPartaskOnProcessing((Long)qryResult.getLong("ssccenter"), (Long)selectId)) {
                args.setCancel(true);
                BaseShowParameter showParameter = new BaseShowParameter();
                showParameter.setFormId("task_taskbill");
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setPkId((Object)selectId);
                showParameter.setStatus(OperationStatus.EDIT);
                showParameter.getCustomParams().put("isExistParTaskOnProcessing", "true");
                this.getView().showForm((FormShowParameter)showParameter);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callbackKey = e.getCallBackId();
        if (CALLBACK_DELETE.equals(callbackKey)) {
            ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
            if (e.getResult() == MessageBoxResult.Yes) {
                for (int i = 0; i < selectedRows.size(); ++i) {
                    Long id = (Long)selectedRows.get(i).getPrimaryKeyValue();
                    this.getBillEntryData(id);
                }
                this.getView().updateView("billlistap");
            }
        } else if (CALLBACK_UNEFFECTIVE.equals(callbackKey) && e.getResult() == MessageBoxResult.Yes) {
            this.getPageCache().put(CACHE_CONFIRM_UNEFFECTIVE, "true");
            this.getView().invokeOperation("uneffective");
        }
    }

    private void getBillEntryData(Long id) {
        ORM orm = ORM.create();
        QFilter filter = new QFilter("id", "=", (Object)id);
        DynamicObjectCollection col = orm.query("task_taskbill", "id,entryentity.id,entryentity.childpkid", filter.toArray());
        for (int i = 0; i < col.size(); ++i) {
            DynamicObjectCollection entry = (DynamicObjectCollection)((DynamicObject)col.get(i)).get("entryentity");
            for (int j = 0; j < entry.size(); ++j) {
                Long taskRuleid = Long.valueOf(((DynamicObject)entry.get(j)).get("childpkid") + "");
                QFilter filtersubject = new QFilter("id", "=", (Object)taskRuleid);
                DynamicObjectCollection subject = orm.query("task_taskbill_child", "id,tasksubjectid", filtersubject.toArray());
                if (subject.size() > 0) {
                    Long subjectID = Long.valueOf(((DynamicObject)subject.get(0)).get("tasksubjectid") + "");
                    this.deleteSubject(subjectID);
                }
                this.deleteTaskRule(Long.valueOf(((DynamicObject)entry.get(j)).get("childpkid") + ""));
            }
        }
        orm.delete("task_taskbill", (Object)id);
        this.deleteOpinionAndCoefficient(id);
    }

    private void deleteSubject(Long id) {
        ORM orm = ORM.create();
        orm.delete("task_tasksubject", (Object)id);
    }

    private void deleteTaskRule(Long id) {
        ORM orm = ORM.create();
        orm.delete("task_taskbill_child", (Object)id);
    }

    private void deleteOpinionAndCoefficient(Long billtypeid) {
        ORM orm = ORM.create();
        QFilter j = new QFilter("basetype", "=", (Object)billtypeid);
        DynamicObject opinionInfo = orm.queryOne("task_dealopinionsopen", "id", new QFilter[]{j});
        DynamicObject coefficientInfo = orm.queryOne("task_taskquantcoefficient", "id", new QFilter[]{j});
        if (opinionInfo != null) {
            orm.delete("task_dealopinionsopen", (Object)opinionInfo.getLong("id"));
        }
        if (coefficientInfo != null) {
            orm.delete("task_taskquantcoefficient", (Object)coefficientInfo.getLong("id"));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String itemKey = args.getOperateKey();
        if (ITEM_KEY_LOG.equals(itemKey)) {
            this.viewSynLog(this.getPageCache().get(CACHE_KEY_SSC));
        }
        if ("adjustclass".equals(itemKey)) {
            this.adjustClass();
        }
    }

    private void viewSynLog(String ssc) {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId("task_synorglog");
        parameter.setFormId("bos_list");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.getOpenStyle().setTargetKey("tabap");
        parameter.setCustomParam(CACHE_KEY_SSC, (Object)ssc);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void adjustClass() {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId("task_billclassify");
        parameter.setLookUp(true);
        parameter.setFormId("bos_templatetreelistf7");
        StyleCss css = new StyleCss();
        css.setWidth("960");
        css.setHeight("580");
        ListFilterParameter listFilterParameter = parameter.getListFilterParameter();
        listFilterParameter.setFilter(new QFilter("isleaf", "=", (Object)true));
        String ssccenterId = this.getPageCache().get(CACHE_KEY_SSC);
        listFilterParameter.setFilter(new QFilter("ssccenter", "=", (Object)Long.parseLong(ssccenterId)));
        parameter.getOpenStyle().setInlineStyleCss(css);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setMultiSelect(false);
        TreeFilterParameter treeFilterParameter = parameter.getTreeFilterParameter();
        treeFilterParameter.setQFilters(Collections.singletonList(new QFilter("ssccenter", "=", (Object)Long.parseLong(ssccenterId))));
        parameter.setTreeFilterParameter(treeFilterParameter);
        parameter.setHasRight(true);
        parameter.setShowTitle(false);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "adjustClass"));
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        if ("adjustClass".equals(actionId) && returnData != null && selectedRows.size() > 0) {
            ListSelectedRowCollection taskBillclassifys = (ListSelectedRowCollection)returnData;
            if (taskBillclassifys.size() > 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u6574\u5206\u7c7b\u53ea\u80fd\u9009\u62e9\u4e00\u4e2a\u4e1a\u52a1\u5355\u636e\u5206\u7c7b\u3002", (String)"TaskRuleListPlugin_8", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            }
            ArrayList<DynamicObject> updateDoList = new ArrayList<DynamicObject>();
            ArrayList<String> bindBillList = new ArrayList<String>(8);
            Long newGroupId = (Long)taskBillclassifys.get(0).getPrimaryKeyValue();
            QFilter qFilter1 = new QFilter("id", "=", (Object)newGroupId);
            QFilter qFilter2 = new QFilter("enabletaskpool", "=", (Object)"1");
            DynamicObjectCollection classifyDos = QueryServiceHelper.query((String)"task_billclassify", (String)"id,number,parent,taskpool.bill_new.FBasedataId", (QFilter[])new QFilter[]{qFilter1, qFilter2});
            Long parentId = null;
            if (CollectionUtils.isNotEmpty((Collection)classifyDos)) {
                parentId = ((DynamicObject)classifyDos.get(0)).getLong("parent");
                for (DynamicObject classifyDo : classifyDos) {
                    String bindBillItem = classifyDo.getString("taskpool.bill_new.FBasedataId");
                    if (bindBillItem == null) continue;
                    bindBillList.add(bindBillItem);
                }
            }
            Map bindBillListMap = TaskBillClassifyHelper.getAllUpBindBillMapByClassify(parentId);
            HashSet<Long> clearGroupIdSet = new HashSet<Long>();
            int totalTaskCount = selectedRows.size();
            StringBuilder errorMsg = new StringBuilder();
            for (ListSelectedRow p : selectedRows) {
                Object pkId = p.getPrimaryKeyValue();
                QFilter qFilter = new QFilter("id", "=", pkId);
                DynamicObject taskBillDo = BusinessDataServiceHelper.loadSingle((String)"task_taskbill", (String)"id,number,bindbill_new,group", (QFilter[])new QFilter[]{qFilter});
                String number = taskBillDo.getString("number");
                String bindBill = ((DynamicObject)taskBillDo.get("bindbill_new")).getString("number");
                if (CollectionUtils.isNotEmpty(bindBillList) && !bindBillList.contains(bindBill)) {
                    String itemMsg = String.format(ResManager.loadKDString((String)"%s\uff1a\u4e1a\u52a1\u5355\u636e\u7684\u6765\u6e90\u5355\u636e\uff0c\u672a\u5728\u6240\u9009\u4e1a\u52a1\u5355\u636e\u5206\u7c7b\u7684\u81ea\u5b9a\u4e49\u4efb\u52a1\u6c60\u6765\u6e90\u5355\u636e\u8303\u56f4\u5185\u3002", (String)"TaskRuleListPlugin_9", (String)"ssc-task-formplugin", (Object[])new Object[0]), number);
                    errorMsg.append(itemMsg).append('\n');
                    continue;
                }
                taskBillDo.set("group", (Object)newGroupId);
                updateDoList.add(taskBillDo);
                for (Map.Entry next : bindBillListMap.entrySet()) {
                    Long key = (Long)next.getKey();
                    List bindBillListItem = (List)next.getValue();
                    if (!CollectionUtils.isNotEmpty((Collection)bindBillListItem) || bindBillListItem.contains(bindBill)) continue;
                    clearGroupIdSet.add(key);
                }
            }
            if (CollectionUtils.isNotEmpty(updateDoList)) {
                SaveServiceHelper.update((DynamicObject[])updateDoList.toArray(new DynamicObject[updateDoList.size()]));
                TaskBillClassifyHelper.clearBindBillByClassify(clearGroupIdSet);
                Toolbar toolbarap = (Toolbar)this.getControl("toolbarap");
                toolbarap.itemClick("tblrefresh", "refresh");
            }
            int totalSuccessCount = updateDoList.size();
            String digest = ResManager.loadKDString((String)"\u5171%1$s\u6761\u4e1a\u52a1\u5355\u636e\uff0c\u8c03\u6574\u5206\u7c7b\u6210\u529f%2$s\u6761\uff0c\u5931\u8d25%3$s\u6761\u3002", (String)"TaskRuleListPlugin_10", (String)"ssc-task-formplugin", (Object[])new Object[0]);
            digest = String.format(digest, totalTaskCount, totalSuccessCount, totalTaskCount - totalSuccessCount);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(8);
            btnNameMaps.put(MessageBoxResult.OK.getValue(), ResManager.loadKDString((String)"\u6211\u77e5\u9053\u4e86", (String)"TaskRuleListPlugin_11", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            this.getView().showConfirm(digest, errorMsg.toString(), MessageBoxOptions.OK, ConfirmTypes.Default, null, btnNameMaps);
        }
    }

    private boolean isOverClick() {
        return "true".equals(this.getPageCache().get(CACHE_KEY_OVER_CLICK));
    }

    public void afterQueryOfExport(AfterQueryOfExportEvent e) {
        BillList billList = (BillList)((ListView)e.getSource()).getControl("billlistap");
        Object[] primaryKeyValues = billList.getSelectedRows().getPrimaryKeyValues();
        QFilter[] qFilters = primaryKeyValues.length > 0 ? new QFilter("id", "in", (Object)primaryKeyValues).toArray() : billList.generalFilterParameter().getQFilters().toArray(new QFilter[0]);
        DynamicObject[] taskBills = BusinessDataServiceHelper.load((String)"task_taskbill", (String)"id,number,name,ssccenter,group,sscbillorgpar,bindbill,taskpool,applycond,externalerp,isembed,isneedimage,description,createtaskmodel,entryentity.childpkid,entryentityfield.fieldconfiguration,entryentityfield.sourcefieldname,bindbill_new", (QFilter[])qFilters);
        if (taskBills.length == 0) {
            return;
        }
        HashSet<Long> childIds = new HashSet<Long>();
        for (DynamicObject taskBill : taskBills) {
            DynamicObjectCollection children = taskBill.getDynamicObjectCollection("entryentity");
            for (DynamicObject child : children) {
                childIds.add(child.getLong("childpkid"));
            }
        }
        DynamicObject[] childBills = BusinessDataServiceHelper.load((String)"task_taskbill_child", (String)"tasktype,taskoriginal,datainsightschema,entryentityarticheck.articheck,issame,pretasks", (QFilter[])new QFilter("id", "in", childIds).toArray());
        Map<Long, DynamicObject> id2ChildBill = Arrays.stream(childBills).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        DynamicObject[] queryValues = new DynamicObject[taskBills.length];
        int index = 0;
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"task_taskbill4impt");
        for (DynamicObject taskBill : taskBills) {
            DynamicObject curEntry;
            DynamicObject taskBill4Import = new DynamicObject((DynamicObjectType)type);
            taskBill4Import.set("number", taskBill.get("number"));
            taskBill4Import.set("name", taskBill.get("name"));
            taskBill4Import.set("ssccenter", taskBill.get("ssccenter"));
            taskBill4Import.set("group", taskBill.get("group"));
            taskBill4Import.set("sscbillorgpar", taskBill.get("sscbillorgpar"));
            taskBill4Import.set("bindbill", taskBill.get("bindbill"));
            taskBill4Import.set("taskpool", taskBill.get("taskpool"));
            taskBill4Import.set("applycond", taskBill.get("applycond"));
            taskBill4Import.set("externalerp", taskBill.get("externalerp"));
            taskBill4Import.set("isembed", taskBill.get("isembed"));
            taskBill4Import.set("isneedimage", taskBill.get("isneedimage"));
            taskBill4Import.set("description", taskBill.get("description"));
            taskBill4Import.set("createtaskmodel", taskBill.get("createtaskmodel"));
            taskBill4Import.set("bindbill_new", taskBill.get("bindbill_new"));
            DynamicObjectCollection fieldEntity4Import = taskBill4Import.getDynamicObjectCollection("entryentityfield");
            DynamicObjectCollection fieldEntity = taskBill.getDynamicObjectCollection("entryentityfield");
            for (DynamicObject entry : fieldEntity) {
                curEntry = fieldEntity4Import.addNew();
                curEntry.set("fieldconfiguration", entry.get("fieldconfiguration"));
                curEntry.set("sourcefieldname", entry.get("sourcefieldname"));
            }
            DynamicObjectCollection childEntity4Import = taskBill4Import.getDynamicObjectCollection("childbillentryentity");
            DynamicObjectCollection childEntity = taskBill.getDynamicObjectCollection("entryentity");
            for (DynamicObject child : childEntity) {
                DynamicObject childBill = id2ChildBill.get(child.getLong("childpkid"));
                curEntry = childEntity4Import.addNew();
                curEntry.set("tasktype", childBill.get("tasktype"));
                curEntry.set("taskoriginal", childBill.get("taskoriginal"));
                curEntry.set("datainsightschema", childBill.get("datainsightschema"));
                DynamicObjectCollection artiChecks = childBill.getDynamicObjectCollection("entryentityarticheck");
                if (artiChecks != null && !artiChecks.isEmpty()) {
                    DynamicObjectCollection artiCheckMulF7 = curEntry.getDynamicObjectCollection("articheckpointconfig");
                    for (DynamicObject dyo : artiChecks) {
                        DynamicObject dynamicObject = artiCheckMulF7.addNew();
                        dynamicObject.set("fbasedataid", dyo.get("articheck"));
                    }
                }
                curEntry.set("issame", childBill.get("issame"));
                curEntry.set("pretasks", childBill.get("pretasks"));
            }
            queryValues[index++] = taskBill4Import;
        }
        e.setQueryValues(queryValues);
        e.setCustomOrder(true);
    }
}

