/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.util.StringUtils;
import kd.ssc.task.business.helper.TaskMultiLangHelper;

public class TaskSubjectEditPlugin
extends AbstractFormPlugin
implements ItemClickListener {
    private static final String CACHE_COMBOITEMSMAP = "comboItemsMap";
    private static final String PROP_BILLFIELD = "billfield";
    private static final String PROP_PRETEXT = "pretext";
    private static final String PROP_POSTTEXT = "posttext";

    public void initialize() {
        super.initialize();
        Button cancel = (Button)this.getControl("cancel");
        cancel.addClickListener((ClickListener)this);
        Button ok = (Button)this.getControl("ok");
        ok.addClickListener((ClickListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView view = this.getView();
        String entityNumber = (String)view.getFormShowParameter().getCustomParam("entryNumber");
        if (StringUtils.isEmpty((String)entityNumber)) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u672a\u7ed1\u5b9a\u6765\u6e90\u5355\u636e", (String)"TaskSubjectEditPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            view.setStatus(OperationStatus.VIEW);
            return;
        }
        List<ComboItem> comboItems = this.createComboItems(entityNumber);
        ComboEdit comboEdit = (ComboEdit)this.getControl(PROP_BILLFIELD);
        comboEdit.setComboItems(comboItems);
        IDataModel model = this.getModel();
        int entryCnt = model.getEntryRowCount("entryentity");
        for (int i = 0; i < entryCnt; ++i) {
            model.setValue(PROP_PRETEXT, (Object)TaskMultiLangHelper.setLocaleValueDefault((OrmLocaleValue)((OrmLocaleValue)model.getValue(PROP_PRETEXT, i))), i);
            model.setValue(PROP_POSTTEXT, (Object)TaskMultiLangHelper.setLocaleValueDefault((OrmLocaleValue)((OrmLocaleValue)model.getValue(PROP_POSTTEXT, i))), i);
        }
        model.setDataChanged(false);
    }

    private List<ComboItem> createComboItems(String entityNumber) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        EntityTypeUtil typeUtil = new EntityTypeUtil();
        List filterFields = typeUtil.getFilterFields((IDataEntityType)entityType, false);
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(filterFields.size());
        HashMap<String, String> comboItemsMap = new HashMap<String, String>(filterFields.size());
        for (FilterField filterField : filterFields) {
            LocaleString caption = new LocaleString();
            caption.setLocaleValue(filterField.getFullFieldCaption());
            String fullFieldName = filterField.getFullFieldName();
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(caption);
            comboItem.setValue(fullFieldName);
            comboItems.add(comboItem);
            comboItemsMap.put(fullFieldName, caption.getLocaleValue());
        }
        this.getPageCache().put(CACHE_COMBOITEMSMAP, SerializationUtils.toJsonString(comboItemsMap));
        return comboItems;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        String propName = e.getProperty().getName();
        if (PROP_PRETEXT.equalsIgnoreCase(propName) || PROP_POSTTEXT.equalsIgnoreCase(propName)) {
            this.setNumber(model, false);
        } else if (PROP_BILLFIELD.equalsIgnoreCase(propName)) {
            this.setNumber(model, true);
        }
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        IDataModel model = this.getModel();
        String key = c.getKey();
        HashMap<String, String> retMap = new HashMap<String, String>();
        if ("cancel".equals(key)) {
            this.getView().close();
        } else if ("ok".equals(key)) {
            String remark = (String)model.getValue("remark");
            OperationStatus state = this.getView().getFormShowParameter().getStatus();
            OperationResult result = null;
            if (StringUtils.isNotEmpty((String)remark)) {
                result = this.getView().invokeOperation("save");
            } else if (OperationStatus.EDIT == state) {
                result = this.getView().invokeOperation("save");
            }
            if (result != null && result.isSuccess()) {
                String number = String.valueOf(model.getValue("remark"));
                String id = String.valueOf(result.getSuccessPkIds().get(0));
                retMap.put("number", number);
                retMap.put("id", id);
                this.getView().returnDataToParent(retMap);
                this.getView().close();
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        IDataModel model = this.getModel();
        this.setNumber(model, true);
    }

    private void setNumber(IDataModel model, boolean flag) {
        StringBuilder appendnumber = new StringBuilder();
        int size = model.getEntryRowCount("entryentity");
        if (size == 0) {
            model.setValue("remark", null);
            return;
        }
        String comboItemsMapStr = this.getPageCache().get(CACHE_COMBOITEMSMAP);
        Map comboItemsMap = (Map)SerializationUtils.fromJsonString((String)comboItemsMapStr, Map.class);
        for (int i = 0; i < size; ++i) {
            String fieldNumber;
            String fieldName;
            if (i != 0) {
                appendnumber.append('-');
            }
            OrmLocaleValue pretext = (OrmLocaleValue)model.getValue(PROP_PRETEXT, i);
            OrmLocaleValue posttext = (OrmLocaleValue)model.getValue(PROP_POSTTEXT, i);
            if (pretext != null && pretext.size() > 0 && pretext.toString() != null) {
                appendnumber.append(pretext);
            }
            if (StringUtils.isNotEmpty((String)(fieldName = (String)comboItemsMap.get(fieldNumber = (String)model.getValue(PROP_BILLFIELD, i))))) {
                appendnumber.append(fieldName);
            }
            if (posttext == null || posttext.size() <= 0 || posttext.toString() == null) continue;
            appendnumber.append(posttext);
        }
        String oldappendnumber = appendnumber + "";
        String newappendnumber = oldappendnumber.endsWith("-") ? oldappendnumber.substring(0, oldappendnumber.length() - 1) : oldappendnumber;
        model.setValue("remark", (Object)newappendnumber);
    }
}

