/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.achieve;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.events.SetFilterContainerFlatEvent;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.task.formplugin.util.AchieveUtil;

public class AchieveEmployeeRptListPlugin
extends AbstractListPlugin {
    private static final Log log = LogFactory.getLog(AchieveEmployeeRptListPlugin.class);
    private static final String OVERCLICK = "overclick";
    private List<FilterColumn> comFilters = new ArrayList<FilterColumn>();

    public void filterContainerSetFlat(SetFilterContainerFlatEvent args) {
        args.setNewFilter(false);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"_toolbar_"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        List<Long> selectIds;
        super.afterDoOperation(evt);
        OperationResult operationResult = evt.getOperationResult();
        String operateKey = evt.getOperateKey();
        IFormView view = this.getView();
        if ("recount".equals(operateKey) && operationResult.isSuccess() && !(selectIds = AchieveUtil.getSelectedRowIds((IListView)this.getView())).isEmpty()) {
            QFilter filter = new QFilter("id", "in", selectIds);
            String selectFileds = "id,sscid,assessplanid,examineeid,score,extrapoint,periodstart,periodend";
            String pointSelectFields = "id,score";
            DynamicObject[] load = BusinessDataServiceHelper.load((String)"ssc_employeeachieverpt", (String)selectFileds, (QFilter[])new QFilter[]{filter});
            if (load != null && load.length > 0) {
                for (DynamicObject obj : load) {
                    BigDecimal score = obj.getBigDecimal("score");
                    long empId = Long.parseLong(obj.getDynamicObject("examineeid").getPkValue().toString());
                    long sscid = Long.parseLong(obj.getDynamicObject("sscid").getPkValue().toString());
                    Date periodstart = obj.getDate("periodstart");
                    Date periodend = obj.getDate("periodend");
                    QFilter qFilter = new QFilter("sscid", "=", (Object)sscid);
                    qFilter.and("userid", "=", (Object)empId);
                    qFilter.and("date", ">=", (Object)periodstart);
                    qFilter.and("date", "<=", (Object)periodend);
                    DynamicObjectCollection query = QueryServiceHelper.query((String)"ssc_extrapoints", (String)pointSelectFields, (QFilter[])new QFilter[]{qFilter});
                    BigDecimal extraTotal = BigDecimal.valueOf(0L);
                    if (query != null && !query.isEmpty()) {
                        for (DynamicObject dyn : query) {
                            extraTotal = extraTotal.add(dyn.getBigDecimal("score"));
                        }
                    }
                    score = score.add(extraTotal).subtract(obj.getBigDecimal("extrapoint"));
                    obj.set("score", (Object)score);
                    obj.set("extrapoint", (Object)extraTotal);
                }
                SaveServiceHelper.save((DynamicObject[])load);
                this.getView().invokeOperation("refresh");
                view.showSuccessNotification(ResManager.loadKDString((String)"\u6570\u636e\u91cd\u7b97\u5df2\u5b8c\u6210\u3002", (String)"AchieveEmployeeRptListPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        String isMyRpt;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        boolean rule = AchieveUtil.codeRule("ssc_employeeachieverpt");
        if (!rule) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u6216\u5df2\u7981\u7528\u7ee9\u6548\u62a5\u544a\u7f16\u7801\u89c4\u5219\uff0c\u8bf7\u542f\u7528\u7f16\u7801\u89c4\u5219\u540e\u91cd\u8bd5\u3002", (String)"AchieveEmployeeRptListPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            qFilters.add(new QFilter("1", "=", (Object)0));
            e.setQFilters(qFilters);
            return;
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams != null && (isMyRpt = (String)customParams.get("isMyRpt")) != null && "true".equals(isMyRpt)) {
            QFilter filter = new QFilter("examineeid", "=", (Object)Long.parseLong(RequestContext.get().getUserId()));
            qFilters.add(filter);
            e.setQFilters(qFilters);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs event) {
        super.filterContainerInit(event);
        this.comFilters = event.getCommonFilterColumns();
        if (!this.isOverClick()) {
            String sscId = "";
            for (FilterColumn column : this.comFilters) {
                CommonFilterColumn comFilter = (CommonFilterColumn)column;
                if (comFilter.getFieldName().equals("sscid.name")) {
                    List defaultValues = comFilter.getDefaultValues();
                    String userId = RequestContext.get().getUserId();
                    List<ComboItem> allPermSSC = AchieveUtil.getAllPermSSC(Long.parseLong(userId), "ssc_employeeachieverpt");
                    if (allPermSSC == null || allPermSSC.isEmpty()) {
                        if (defaultValues == null || defaultValues.isEmpty()) {
                            comFilter.setDefaultValue("0");
                        }
                    } else if (defaultValues == null || defaultValues.isEmpty()) {
                        comFilter.setDefaultValue(allPermSSC.get(0).getValue());
                        sscId = allPermSSC.get(0).getValue();
                    } else {
                        sscId = String.valueOf(defaultValues.get(0));
                    }
                    this.getPageCache().put("SSC", sscId);
                }
                if (!comFilter.getFieldName().equals("assessplanid.name")) continue;
                List<Object> SchemeBySscId = new ArrayList(16);
                if (!sscId.isEmpty()) {
                    SchemeBySscId = AchieveEmployeeRptListPlugin.getSchemeBySscId(Long.parseLong(sscId));
                }
                comFilter.setComboItems(SchemeBySscId);
            }
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map currentCommonFilter = args.getCurrentCommonFilter();
        if (currentCommonFilter != null) {
            String curFieldName = (String)((List)currentCommonFilter.get("FieldName")).get(0);
            String curValue = (String)((List)currentCommonFilter.get("Value")).get(0);
            this.getPageCache().put(OVERCLICK, "true");
            if ("sscid.id".equals(curFieldName)) {
                this.getPageCache().put("SSC", curValue);
                Map filterValues = args.getFilterValues();
                List customfilter = (List)filterValues.get("customfilter");
                customfilter.forEach(filter -> {
                    String fieldName = (String)((List)filter.get("FieldName")).get(0);
                    if ("assessplanid.id".equals(fieldName)) {
                        this.rebuildCommonFilter(Long.parseLong(curValue), this.comFilters);
                    }
                });
            } else {
                this.rebuildCommonFilter(Long.parseLong(this.getPageCache().get("SSC")), this.comFilters);
            }
        }
    }

    private void rebuildCommonFilter(Long sscId, List<FilterColumn> filterColumnList) {
        CommonFilterColumn groupColumn = this.getL5CommonFilterColumn(filterColumnList);
        if (groupColumn != null && sscId != null) {
            List<ComboItem> comboItems = AchieveEmployeeRptListPlugin.getSchemeBySscId(sscId);
            groupColumn.setComboItems(comboItems);
        }
    }

    private CommonFilterColumn getL5CommonFilterColumn(List<FilterColumn> filterColumnList) {
        CommonFilterColumn groupColumn = null;
        for (FilterColumn column : filterColumnList) {
            CommonFilterColumn commonColumn = (CommonFilterColumn)column;
            if (!StringUtils.equals((CharSequence)commonColumn.getFieldName(), (CharSequence)"assessplanid.name")) continue;
            groupColumn = commonColumn;
        }
        return groupColumn;
    }

    private boolean isOverClick() {
        return StringUtils.equals((CharSequence)this.getPageCache().get(OVERCLICK), (CharSequence)"true");
    }

    private static List<ComboItem> getSchemeBySscId(Long sscId) {
        ArrayList<ComboItem> groupList = new ArrayList<ComboItem>(16);
        QFilter gfilter = new QFilter("sscid", "=", (Object)sscId);
        gfilter.and("enable", "=", (Object)Character.valueOf('1'));
        String selectFields = "id,name";
        DynamicObjectCollection schemes = QueryServiceHelper.query((String)"ssc_achievescheme", (String)selectFields, (QFilter[])new QFilter[]{gfilter});
        if (schemes != null && !schemes.isEmpty()) {
            for (DynamicObject obj : schemes) {
                ComboItem comboItem = new ComboItem();
                comboItem.setValue(String.valueOf(obj.getLong("id")));
                comboItem.setCaption(new LocaleString(obj.getString("name")));
                groupList.add(comboItem);
            }
        }
        return groupList;
    }
}

