/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.achieve;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.Submit;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.AdvContainer;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.UnitEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.container.AdvConAp;
import kd.bos.metadata.form.container.AdvConChildPanelAp;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.ssc.enums.achieve.ScoreComputeTypeEnum;
import kd.ssc.task.business.achieve.factory.ScoreComputeFactory;
import kd.ssc.task.business.achieve.score.IScoreComputeEngine;
import kd.ssc.utils.BuildDynamicControlUtil;

public class AchieveEvaluteFormPlugin
extends AbstractBillPlugIn {
    private static final Log log = LogFactory.getLog(AchieveEvaluteFormPlugin.class);
    private static final String KEY_DYNAMIC_PANEL = "dynamicadvpanel";
    private static final String DESIGN_ADV_CON_ID = "rH4b9oFL4c";
    private static final String DESIGN_ENTRY_KEY = "entryentity_po";
    private static final String SEPARATOR = "_";
    private static final String DYNAMIC_ENTRY_COUNT_KEY = "dynamicEntryCount";
    private static final String SQL_QUERY_GROUP_ID = "SELECT a.fgroupid FROM t_tk_achievetarget a INNER JOIN t_tk_eva_processoperation b ON b.fpoachieveid = a.fid WHERE b.fid = ?";
    private List<AdvConAp> dynamicAdvConAp;
    private List<EntryProp> dynamicEntryProp;
    private Map<String, Control> dynamicControlsCache;

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"scorelabel"});
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("scorelabel".equals(key)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("ssc_extrapoint_detail");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            long userId = ((DynamicObject)this.getModel().getValue("assessuserid")).getLong("id");
            long sscId = ((DynamicObject)this.getModel().getValue("sscid")).getLong("id");
            Date startDate = (Date)this.getModel().getValue("periodstart");
            Date endDate = (Date)this.getModel().getValue("periodend");
            HashMap<String, Object> pageParams = new HashMap<String, Object>(8);
            pageParams.put("userid", userId);
            pageParams.put("org", sscId);
            pageParams.put("periodstart", startDate);
            pageParams.put("periodend", endDate);
            pageParams.put("billstatus", "D");
            formShowParameter.setCustomParams(pageParams);
            this.getView().showForm(formShowParameter);
        }
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        List<Map<String, Object>> entryMeta;
        super.loadCustomControlMetas(e);
        BillShowParameter source = (BillShowParameter)e.getSource();
        Object pkId = source.getPkId();
        if (pkId == null) {
            return;
        }
        if (pkId instanceof String) {
            pkId = Long.parseLong((String)pkId);
        }
        if ((entryMeta = this.createEntryMeta(pkId)) == null || entryMeta.size() < 1) {
            return;
        }
        HashMap<String, Object> mapHead = new HashMap<String, Object>();
        mapHead.put("id", KEY_DYNAMIC_PANEL);
        mapHead.put("items", entryMeta);
        e.getItems().add(mapHead);
    }

    private List<Map<String, Object>> createEntryMeta(Object pkId) {
        Map<Long, String[]> classifyInfo = this.getClassifyInfo(pkId);
        if (classifyInfo.size() < 1) {
            return null;
        }
        QFilter idFilter = new QFilter("id", "=", pkId);
        DynamicObject status = QueryServiceHelper.queryOne((String)"ssc_achieveevalute", (String)"status", (QFilter[])idFilter.toArray());
        if (status == null) {
            return null;
        }
        List<AdvConAp> controlApList = this.getDynamicAdvConAp(classifyInfo, status.getString("status"));
        if (controlApList.size() < 1) {
            return null;
        }
        ArrayList<Map<String, Object>> datas = new ArrayList<Map<String, Object>>(controlApList.size());
        for (AdvConAp ele : controlApList) {
            datas.add(ele.createControl());
        }
        return datas;
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        super.getEntityType(e);
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new KDException((Throwable)ex, new ErrorCode("DynamicCreateEntry", ex.getMessage()), new Object[0]);
        }
        if (Objects.isNull(newMainType)) {
            return;
        }
        this.registerEntityType(newMainType);
        e.setNewEntityType(newMainType);
    }

    private void registerEntityType(MainEntityType newMainType) {
        for (EntryProp entryProp : this.getDynamicEntryProp(newMainType)) {
            newMainType.registerCollectionProperty((DynamicCollectionProperty)entryProp);
        }
    }

    private List<EntryProp> getDynamicEntryProp(MainEntityType newMainType) {
        if (this.dynamicEntryProp == null) {
            this.dynamicEntryProp = new ArrayList<EntryProp>(10);
            Object pkId = ((BillShowParameter)this.getView().getFormShowParameter()).getPkId();
            Map<Long, String[]> classifyInfo = this.getClassifyInfo(pkId);
            if (classifyInfo.size() < 1) {
                return this.dynamicEntryProp;
            }
            EntryType sourceEntryType = (EntryType)newMainType.getAllEntities().get(DESIGN_ENTRY_KEY);
            for (String[] value : classifyInfo.values()) {
                EntryProp entryProp = BuildDynamicControlUtil.cloneEntryPropertyByEntryType((EntryType)sourceEntryType, (String)value[1]);
                String displayName = String.format(ResManager.loadKDString((String)"%s\u5206\u5f55", (String)"AchieveEvaluteFormPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]), value[0]);
                entryProp.setDisplayName(new LocaleString(displayName));
                this.dynamicEntryProp.add(entryProp);
            }
        }
        return this.dynamicEntryProp;
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String key = e.getKey();
        if (StringUtils.isEmpty((String)key) || e.getControl() != null) {
            return;
        }
        if (key.startsWith(DESIGN_ENTRY_KEY)) {
            EntryGrid entryGrid = new EntryGrid();
            entryGrid.setEntryKey(key);
            entryGrid.setKey(key);
            entryGrid.setView(this.getView());
            entryGrid.setModel(this.getModel());
            e.setControl((Control)entryGrid);
        } else {
            BasedataEdit fieldEdit;
            String entryKey = this.getEntryKeyByField(key);
            if (entryKey == null) {
                return;
            }
            if (this.startWithAndNotEquals(key, "poachieveid")) {
                fieldEdit = new BasedataEdit();
            } else if (this.startWithAndNotEquals(key, "potargettype")) {
                fieldEdit = new ComboEdit();
            } else if (this.startWithAndNotEquals(key, "postandard") || this.startWithAndNotEquals(key, "potarget") || this.startWithAndNotEquals(key, "poactual") || this.startWithAndNotEquals(key, "poapproved") || this.startWithAndNotEquals(key, "poscore")) {
                fieldEdit = new DecimalEdit();
            } else if (this.startWithAndNotEquals(key, "podescription")) {
                fieldEdit = new TextEdit();
            } else if (this.startWithAndNotEquals(key, "pounitid")) {
                fieldEdit = new UnitEdit();
            } else {
                return;
            }
            fieldEdit.setEntryKey(entryKey);
            fieldEdit.setKey(key);
            fieldEdit.setModel(this.getModel());
            fieldEdit.setView(this.getView());
            e.setControl((Control)fieldEdit);
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.fillData();
    }

    private void fillData() {
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity(DESIGN_ENTRY_KEY);
        HashSet<String> propKey = new HashSet<String>(16);
        for (IDataEntityProperty property : entryEntity.getDynamicObjectType().getProperties()) {
            String name = property.getName();
            if ("id".equals(name) || "seq".equals(name) || name.endsWith("_id")) continue;
            propKey.add(name);
        }
        Map<Long, String[]> classifyInfo = this.getClassifyInfo(null);
        if (classifyInfo.size() < 1) {
            return;
        }
        this.getPageCache().put(DYNAMIC_ENTRY_COUNT_KEY, String.valueOf(classifyInfo.size()));
        for (String[] c : classifyInfo.values()) {
            model.deleteEntryData(DESIGN_ENTRY_KEY + c[1]);
        }
        for (DynamicObject row : entryEntity) {
            long groupId = row.getLong("poachieveid.group.id");
            String[] classify = classifyInfo.get(groupId);
            if (classify == null) continue;
            String suffix = classify[1];
            int index = model.createNewEntryRow(DESIGN_ENTRY_KEY + suffix);
            model.beginInit();
            for (String key : propKey) {
                model.setValue(key + suffix, row.get(key), index);
            }
            model.endInit();
            model.getEntryRowEntity(DESIGN_ENTRY_KEY + suffix, index).set("id", row.get("id"));
        }
        model.setDataChanged(false);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IFormView view = this.getView();
        Container container = (Container)view.getControl(KEY_DYNAMIC_PANEL);
        if (container == null) {
            return;
        }
        Map<String, Control> dynamicControlsCache = this.getDynamicControlsCache();
        for (Control control : dynamicControlsCache.values()) {
            if (!(control instanceof AdvContainer)) continue;
            container.getItems().add(control);
        }
        String reportType = (String)view.getParentView().getFormShowParameter().getCustomParam("reportType");
        if ("myReport".equals(reportType)) {
            view.setVisible(Boolean.valueOf(false), new String[]{"bar_audit"});
        }
        if (!"userReport".equals(reportType)) {
            view.setVisible(Boolean.valueOf(false), new String[]{"totalscore"});
            ((DecimalEdit)view.getControl("score")).hideTips();
        }
    }

    private Map<String, Control> getDynamicControlsCache() {
        if (this.dynamicControlsCache == null) {
            this.dynamicControlsCache = new HashMap<String, Control>(16);
            for (Control control : this.createDynamicControl()) {
                this.dynamicControlsCache.put(control.getKey(), control);
            }
        }
        return this.dynamicControlsCache;
    }

    private List<Control> createDynamicControl() {
        ArrayList<Control> controls = new ArrayList<Control>(16);
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        Object pkId = billShowParameter.getPkId();
        String billStatus = (String)this.getModel().getValue("status");
        Map<Long, String[]> classifyInfo = this.getClassifyInfo(pkId);
        List<AdvConAp> controlApList = this.getDynamicAdvConAp(classifyInfo, billStatus);
        if (controlApList.size() < 1) {
            return controls;
        }
        for (AdvConAp ele : controlApList) {
            Container container = (Container)ele.buildRuntimeControl();
            controls.addAll(this.getAllControlsAndSetView((Control)container));
        }
        return controls;
    }

    private List<Control> getAllControlsAndSetView(Control t) {
        ArrayList<Control> controls = new ArrayList<Control>();
        t.setView(this.getView());
        t.setModel(this.getModel());
        controls.add(t);
        if (t instanceof Container) {
            for (Control ctl : ((Container)t).getItems()) {
                controls.addAll(this.getAllControlsAndSetView(ctl));
            }
        }
        return controls;
    }

    private List<AdvConAp> getDynamicAdvConAp(Map<Long, String[]> classifyInfo, String billStatus) {
        if (this.dynamicAdvConAp == null) {
            this.dynamicAdvConAp = this.createControlAp(classifyInfo, billStatus);
        }
        return this.dynamicAdvConAp;
    }

    private List<AdvConAp> createControlAp(Map<Long, String[]> classifyInfo, String billStatus) {
        ArrayList<AdvConAp> advConApList = new ArrayList<AdvConAp>(10);
        if (classifyInfo == null || classifyInfo.size() < 1) {
            return advConApList;
        }
        String entityId = MetadataDao.getIdByNumber((String)"ssc_achieveevalute", (MetaCategory)MetaCategory.Form);
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Form);
        AdvConAp sourceAdvConAp = (AdvConAp)formMeta.getItem(DESIGN_ADV_CON_ID);
        EntityMetadata entityMeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        int index = 1;
        for (String[] value : classifyInfo.values()) {
            AdvConAp dynamicAdvAp = BuildDynamicControlUtil.cloneAdvConAp((AdvConAp)sourceAdvConAp, (EntityMetadata)entityMeta, (int)index, (String)value[0], (String)value[1]);
            dynamicAdvAp.setVisible("init,new,edit,view,submit,audit");
            this.setFieldMustInput((ContainerAp<?>)dynamicAdvAp, billStatus);
            advConApList.add(dynamicAdvAp);
            ++index;
        }
        return advConApList;
    }

    private void setFieldMustInput(ContainerAp<?> parent, String status) {
        String actualKey = "poactual";
        String approvedKey = "poapproved";
        for (ControlAp item : parent.getItems()) {
            if (item instanceof AdvConChildPanelAp || item instanceof EntryAp) {
                this.setFieldMustInput((ContainerAp)item, status);
                continue;
            }
            if (!(item instanceof EntryFieldAp) || (!"A".equals(status) || !item.getKey().startsWith(actualKey)) && (!"B".equals(status) || !item.getKey().startsWith(approvedKey))) continue;
            ((EntryFieldAp)item).getField().setMustInput(true);
        }
    }

    private Map<Long, String[]> getClassifyInfo(Object pkId) {
        IPageCache pageCache = this.getPageCache();
        if (pageCache == null) {
            return this.queryClassifyInfo(pkId);
        }
        String jsonStr = pageCache.get("classifyInfo");
        if (jsonStr == null) {
            Map<Long, String[]> classifyInfo = this.queryClassifyInfo(pkId);
            pageCache.put("classifyInfo", JSONObject.toJSONString(classifyInfo));
            return classifyInfo;
        }
        return (Map)JSON.parseObject((String)jsonStr, (TypeReference)new TypeReference<Map<Long, String[]>>(){}, (Feature[])new Feature[0]);
    }

    private Map<Long, String[]> queryClassifyInfo(Object pkId) {
        HashMap<Long, String[]> classifyInfo = new HashMap<Long, String[]>();
        Object[] params = new SqlParameter[]{new SqlParameter("FID", -5, pkId)};
        ArrayList ids = new ArrayList();
        try (DataSet dt = DB.queryDataSet((String)"fi.ssc.achieve.getClassifyInfo", (DBRoute)DBRoute.of((String)"ssc"), (String)SQL_QUERY_GROUP_ID, (Object[])params);){
            if (!dt.hasNext()) {
                HashMap<Long, String[]> hashMap = classifyInfo;
                return hashMap;
            }
            dt.distinct().forEach(row -> ids.add(row.getLong(0)));
        }
        QFilter idFilter = new QFilter("id", "in", ids);
        DynamicObject[] achieveGroup = BusinessDataServiceHelper.load((String)"ssc_achieveclassify", (String)"id,name", (QFilter[])idFilter.toArray());
        int index = 1;
        for (DynamicObject group : achieveGroup) {
            long id = group.getLong("id");
            String name = ((OrmLocaleValue)group.get("name")).getLocaleValue();
            String suffix = SEPARATOR + index;
            classifyInfo.computeIfAbsent(id, k -> new String[]{name, suffix});
            ++index;
        }
        return classifyInfo;
    }

    private String getEntryKeyByField(String fieldKey) {
        if (StringUtils.isEmpty((String)fieldKey)) {
            return null;
        }
        int pos = fieldKey.indexOf(SEPARATOR);
        if (pos <= 1) {
            return null;
        }
        return DESIGN_ENTRY_KEY + fieldKey.substring(pos);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        Object oldValue = valueSet[0].getOldValue();
        int rowIndex = valueSet[0].getRowIndex();
        if (StringUtils.isEmpty((String)propName)) {
            return;
        }
        if (this.startWithAndNotEquals(propName, "poactual") || this.startWithAndNotEquals(propName, "poapproved") || this.startWithAndNotEquals(propName, "poscore") || this.startWithAndNotEquals(propName, "podescription")) {
            String sourceFieldKey = this.getSourceFieldKey(propName);
            if (sourceFieldKey == null) {
                return;
            }
            int seqOfSourceEntry = this.getIndexOfSourceEntry(this.getEntryKeyByField(propName), rowIndex);
            if (seqOfSourceEntry >= 0) {
                model.setValue(sourceFieldKey, newValue, seqOfSourceEntry);
            }
        }
        if (this.startWithAndNotEquals(propName, "poapproved")) {
            int pos = propName.indexOf(SEPARATOR);
            if (pos < 1) {
                return;
            }
            String suffix = propName.substring(pos);
            String thisAchieveKey = "poachieveid" + suffix;
            DynamicObject achieveTarget = (DynamicObject)this.getModel().getValue(thisAchieveKey);
            if (achieveTarget != null) {
                BigDecimal maxScore = achieveTarget.getBigDecimal("maxScore");
                BigDecimal minScore = achieveTarget.getBigDecimal("minScore");
                boolean isSetUp = achieveTarget.getBoolean("setup");
                boolean isSetDown = achieveTarget.getBoolean("setdown");
                String scoringMethod = achieveTarget.getString("scoringmethod");
                BigDecimal newScore = this.computeScore((BigDecimal)newValue, rowIndex, suffix, scoringMethod);
                if (isSetUp && maxScore.compareTo(newScore) < 0) {
                    newScore = maxScore;
                } else if (isSetDown && minScore.compareTo(newScore) > 0) {
                    newScore = minScore;
                }
                model.setValue("poscore" + suffix, (Object)newScore, rowIndex);
            }
        }
        if ("poscore".equals(propName)) {
            Integer entryWeightValue = (Integer)model.getValue("poweight", rowIndex);
            BigDecimal entryWeight = new BigDecimal(entryWeightValue.toString()).divide(new BigDecimal("100"), 2, RoundingMode.HALF_UP);
            this.updateTotalScore((BigDecimal)oldValue, (BigDecimal)newValue, entryWeight);
        }
        if ("totalscore".equals(propName)) {
            String extrascore = this.getPageCache().get("extraPoint");
            BigDecimal extraScore = BigDecimal.ZERO;
            BigDecimal totalScore = (BigDecimal)newValue;
            if (!StringUtils.isEmpty((String)extrascore)) {
                extraScore = new BigDecimal(extrascore);
            }
            this.getModel().setValue("score", (Object)totalScore.add(extraScore));
        }
    }

    private String getSourceFieldKey(String fieldKey) {
        if (StringUtils.isEmpty((String)fieldKey)) {
            return null;
        }
        int pos = fieldKey.indexOf(SEPARATOR);
        if (pos <= 1) {
            return null;
        }
        return fieldKey.substring(0, pos);
    }

    private int getIndexOfSourceEntry(String currentEntryKey, int dataIndexOfCurrentEntry) {
        IDataModel model = this.getModel();
        long achieveId = model.getEntryRowEntity(currentEntryKey, dataIndexOfCurrentEntry).getLong("id");
        DynamicObjectCollection sourceEntryEntity = model.getEntryEntity(DESIGN_ENTRY_KEY);
        for (int i = 0; i < sourceEntryEntity.size(); ++i) {
            long id = ((DynamicObject)sourceEntryEntity.get(i)).getLong("id");
            if (achieveId != id) continue;
            return i;
        }
        return -1;
    }

    private BigDecimal computeScore(BigDecimal newApproveScore, int index, String suffix, String scoringMethod) {
        IDataModel model = this.getModel();
        Long indicatorId = (Long)model.getValue("poachieveid" + suffix + "_id", index);
        BigDecimal standScore = (BigDecimal)model.getValue("postandard" + suffix, index);
        BigDecimal targetScore = (BigDecimal)model.getValue("potarget" + suffix, index);
        BigDecimal actualValue = (BigDecimal)model.getValue("poactual" + suffix, index);
        IScoreComputeEngine scoreComputeInstance = ScoreComputeFactory.getScoreComputeInstance((ScoreComputeTypeEnum)ScoreComputeTypeEnum.getScoreComputeTypeByValue((String)scoringMethod));
        if (scoreComputeInstance == null) {
            ErrorCode code = new ErrorCode("fi.ssc.achieve.evaluateSubmit", "the score compute type don't have service.");
            throw new KDException(code, new Object[0]);
        }
        return scoreComputeInstance.computeIndicatorScore(indicatorId, standScore, targetScore, actualValue, newApproveScore);
    }

    private void updateTotalScore(BigDecimal oldValue, BigDecimal newValue, BigDecimal entryWeightValue) {
        IDataModel dateModel = this.getModel();
        BigDecimal oldTotalScore = (BigDecimal)dateModel.getValue("totalscore");
        BigDecimal oldEntryScore = oldValue.multiply(entryWeightValue).setScale(2, RoundingMode.HALF_UP);
        BigDecimal newEntryScore = newValue.multiply(entryWeightValue).setScale(2, RoundingMode.HALF_UP);
        BigDecimal newTotalScore = oldTotalScore.subtract(oldEntryScore).add(newEntryScore);
        dateModel.setValue("totalscore", (Object)newTotalScore);
    }

    private boolean startWithAndNotEquals(String value, String prefix) {
        return !value.equals(prefix) && value.startsWith(prefix);
    }

    public void setView(IFormView formView) {
        super.setView(formView);
        IFormPlugin plugin = (IFormPlugin)TypesContainer.createInstance((String)"kd.ssc.task.formplugin.achieve.AchieveReportStylePlugin");
        if (plugin != null) {
            formView.addPlugin(plugin);
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        FormShowParameter parentFormShowParameter;
        String reportType;
        super.preOpenForm(e);
        IPageCache parentPageCache = SessionManager.getCurrent().getPageCache(e.getFormShowParameter().getParentPageId());
        String parameter = parentPageCache.get(FormShowParameter.class.getSimpleName());
        if (StringUtils.isNotEmpty((String)parameter) && "myReport".equals(reportType = (String)(parentFormShowParameter = FormShowParameter.fromJsonString((String)parameter)).getCustomParam("reportType"))) {
            e.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u6211\u7684\u7ee9\u6548\u62a5\u544a", (String)"AchieveEvaluteFormPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        boolean dataChanged = this.getModel().getDataChanged();
        if (dataChanged) {
            IDataEntityType dataEntityType = this.getModel().getDataEntity().getDataEntityType();
            DataEntityPropertyCollection properties = dataEntityType.getProperties();
            for (IDataEntityProperty property : properties) {
                DynamicObjectCollection dynamicObjectCollection;
                if (!(property instanceof EntryProp) || !DESIGN_ENTRY_KEY.equals(property.getName()) || (dynamicObjectCollection = (DynamicObjectCollection)this.getModel().getValue(DESIGN_ENTRY_KEY)) == null || dynamicObjectCollection.size() <= 0) continue;
                for (DynamicObject dynamicObject : dynamicObjectCollection) {
                    DataEntityPropertyCollection props = dynamicObject.getDataEntityType().getProperties();
                    for (IDataEntityProperty prop : props) {
                        dynamicObject.getDataEntityState().setBizChanged(prop.getOrdinal(), false);
                    }
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        super.afterDoOperation(eventArgs);
        IDataModel model = this.getModel();
        Object source = eventArgs.getSource();
        if (eventArgs.getOperationResult() != null && eventArgs.getOperationResult().isSuccess()) {
            if (source instanceof Save) {
                if (!model.getDataChanged()) {
                    this.fillData();
                    this.getView().updateView();
                }
            } else if (source instanceof Submit) {
                this.fillData();
                this.getView().updateView();
            } else if ("rec_score".equals(eventArgs.getOperateKey())) {
                BigDecimal userExtScore = (BigDecimal)this.getModel().getValue("extrapoint");
                Label label = (Label)this.getControl("scorelabel");
                label.setText(String.valueOf(userExtScore.setScale(2)));
            }
        }
    }

    public void afterBindData(EventObject e) {
        String assessDimension = (String)this.getModel().getValue("assessdimension");
        if ("2".equals(assessDimension)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap"});
            BigDecimal userExtScore = (BigDecimal)this.getModel().getValue("extrapoint");
            Label label = (Label)this.getControl("scorelabel");
            label.setText(String.valueOf(userExtScore.setScale(2)));
            this.getView().setVisible(Boolean.TRUE, new String[]{"dept"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap", "dept"});
        }
        this.calTotalScore();
    }

    private void calTotalScore() {
        BigDecimal extraScore = (BigDecimal)this.getModel().getValue("extrapoint");
        BigDecimal score = (BigDecimal)this.getModel().getValue("totalscore");
        this.getModel().setValue("score", (Object)score.add(extraScore));
        this.getModel().setDataChanged(Boolean.FALSE.booleanValue());
    }
}

