/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.achieve;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.field.ItemClassTypeEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.ssc.enums.achieve.AssessTypeEnum;
import kd.ssc.task.business.achieve.helper.QueryDataHelper;
import kd.ssc.task.business.achieve.indicator.ComputeOverride4Trial;

public class AchieveTrialFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        BasedataEdit assessObj = (BasedataEdit)this.getControl("assessobj");
        assessObj.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit orgField = (BasedataEdit)this.getControl("orgfield");
        orgField.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void beforeBindData(EventObject e) {
        IDataModel model = this.getModel();
        FormShowParameter fsp = this.getView().getFormShowParameter();
        DateRangeEdit headFieldEdit = (DateRangeEdit)this.getView().getControl("assessrange");
        headFieldEdit.setMaxDate(new Date());
        String itemStr = (String)fsp.getCustomParam("baseData_item");
        if (StringUtils.isEmpty((String)itemStr)) {
            return;
        }
        List<String> customItems = Arrays.asList(itemStr.split(","));
        ItemClassTypeEdit selectDimTypeFields = (ItemClassTypeEdit)this.getControl("assessobjtype");
        ItemClassTypeProp prop = (ItemClassTypeProp)selectDimTypeFields.getProperty();
        List comboItems = prop.getComboItems();
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(3);
        for (ValueMapItem valueMapItem : comboItems) {
            String value = valueMapItem.getValue();
            if (!customItems.contains(value)) continue;
            ComboItem item = new ComboItem();
            item.setValue(value);
            item.setCaption(valueMapItem.getName());
            items.add(item);
        }
        selectDimTypeFields.setComboItems(items);
        String defValue = ((ComboItem)items.get(0)).getValue();
        model.setValue("assessobjtype", (Object)defValue);
        model.setValue("orgfield", (Object)this.getDefOrgId());
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        Set orgIds;
        IDataModel model = this.getModel();
        BasedataEdit baseData = (BasedataEdit)beforeF7SelectEvent.getSource();
        String key = baseData.getKey();
        String assessObjType = (String)model.getValue("assessobjtype");
        Long indicatorId = this.getIndicatorId();
        ListShowParameter lsp = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        List listFilters = lsp.getListFilterParameter().getQFilters();
        if ("assessobj".equals(key)) {
            boolean sscIsEmpty;
            Long orgId = (Long)model.getValue("orgfield_id");
            boolean bl = sscIsEmpty = orgId == null || orgId == 0L;
            if ("bos_user".equals(assessObjType)) {
                lsp.setF7Style(3);
                Set userIds = sscIsEmpty ? QueryDataHelper.queryIndicatorCtrlUserSet((Long)indicatorId) : QueryDataHelper.querySSCUsers((Long)orgId);
                QFilter listFilter = new QFilter("id", "in", (Object)userIds);
                listFilters.add(listFilter);
            } else if ("task_workgroup".equals(assessObjType)) {
                Set workgroupIds = sscIsEmpty ? QueryDataHelper.queryIndicatorCtrlWorkgroupSet((Long)indicatorId) : QueryDataHelper.queryWorkgroupBySSC((Long)orgId);
                if (workgroupIds == null) {
                    return;
                }
                QFilter listFilter = new QFilter("id", "in", (Object)workgroupIds);
                listFilters.add(listFilter);
            }
        } else if ("orgfield".equals(key) && (orgIds = QueryDataHelper.queryIndicatorCtrlOrgSet((Long)indicatorId)) != null) {
            QFilter listFilter = new QFilter("id", "in", (Object)orgIds);
            listFilters.add(listFilter);
        }
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("btnok".equals(key)) {
            this.trial();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        String changeProperty = e.getProperty().getName();
        if ("orgfield".equals(changeProperty) && !ObjectUtils.isEmpty((Object)newValue)) {
            model.setValue("assessobj", null);
        }
    }

    private long getDefOrgId() {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String mainOrg = (String)fsp.getCustomParam("mainOrg");
        if (StringUtils.isEmpty((String)mainOrg)) {
            return 0L;
        }
        return Long.parseLong(mainOrg);
    }

    private long getIndicatorId() {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String indicator = (String)fsp.getCustomParam("indicator");
        if (StringUtils.isEmpty((String)indicator)) {
            return 0L;
        }
        return Long.parseLong(indicator);
    }

    private void trial() {
        Long assessObjId;
        Long mainOrgId;
        boolean sscIsEmpty;
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        AssessTypeEnum assessObjType = this.getAssessType();
        if (assessObjType == null) {
            return;
        }
        Long sscId = (Long)model.getValue("orgfield_id");
        boolean bl = sscIsEmpty = sscId == null || sscId == 0L;
        if (AssessTypeEnum.SSC_ORG == assessObjType) {
            if (sscIsEmpty) {
                return;
            }
            mainOrgId = null;
            assessObjId = sscId;
        } else {
            DynamicObject assessObj = (DynamicObject)model.getValue("assessobj");
            if (assessObj == null) {
                return;
            }
            mainOrgId = sscIsEmpty ? null : sscId;
            assessObjId = assessObj.getLong("id");
        }
        Date startDate = (Date)model.getValue("startdate");
        Date endDate = (Date)model.getValue("enddate");
        if (startDate == null || endDate == null) {
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(endDate);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        endDate = calendar.getTime();
        try {
            ComputeOverride4Trial actualCompute = new ComputeOverride4Trial(mainOrgId, Long.valueOf(this.getIndicatorId()), startDate, endDate);
            Map indicatorActualValue = actualCompute.batchComputeIndicatorActualValue(assessObjType.getValue(), Collections.singleton(assessObjId));
            model.setValue("actualvalue", indicatorActualValue.get(assessObjId));
            view.showSuccessNotification(ResManager.loadKDString((String)"\u6307\u6807\u8bd5\u7b97\u6210\u529f\u3002", (String)"AchieveTrialFormPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
        catch (Exception ex) {
            view.showMessage(ResManager.loadKDString((String)"\u6307\u6807\u8bd5\u7b97\u51fa\u9519", (String)"AchieveTrialFormPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]), ex.getMessage(), MessageTypes.Default);
        }
    }

    private AssessTypeEnum getAssessType() {
        AssessTypeEnum result;
        String entityType;
        switch (entityType = (String)this.getModel().getValue("assessobjtype")) {
            case "bos_org": {
                result = AssessTypeEnum.SSC_ORG;
                break;
            }
            case "bos_user": {
                result = AssessTypeEnum.USER;
                break;
            }
            case "task_workgroup": {
                result = AssessTypeEnum.WORK_GROUP;
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }
}

