/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.achieve;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.achieve.AchieveDateUtil;
import kd.ssc.task.business.achieve.report.AchieveSchemeConverter;
import kd.ssc.task.common.LogBuildUtil;

public class AssessPreiodSelectPlugin
extends AbstractListPlugin {
    private static final Log log = LogFactory.getLog(AssessPreiodSelectPlugin.class);
    FormShowParameter formShowParameter = null;
    DynamicObject scheme = null;
    private static final String systemType = "ssc-task-formplugin";

    public void initialize() {
        super.initialize();
        this.formShowParameter = this.getView().getFormShowParameter();
        if (this.formShowParameter != null) {
            Long schemeId = (Long)this.formShowParameter.getCustomParam("schemeId");
            this.scheme = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"ssc_achievescheme");
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        Calendar c = Calendar.getInstance();
        int currentYear = c.get(1);
        int currentMonth = c.get(2);
        this.getModel().setValue("assess_year", (Object)currentYear);
        this.getModel().setValue("assess_month", (Object)(currentMonth + 1));
        this.genYearComboItems("assess_year", currentYear);
        String period = this.scheme.getString("assessperiod");
        this.hideField(period);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("btnok".equals(key)) {
            String result;
            String period = this.scheme.getString("assessperiod");
            Map<String, Date> periods = this.getPeriods(period);
            Date startDate = periods.get("start");
            Date endDate = periods.get("end");
            switch (result = this.validate(this.scheme.getLong("id"), startDate, endDate)) {
                case "A": {
                    ConfirmCallBackListener reimplement = new ConfirmCallBackListener("saveEvalute", (IFormPlugin)this);
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5df2\u751f\u6210\u7ee9\u6548\u62a5\u544a\uff0c\u662f\u5426\u8986\u76d6\uff1f", (String)"AssessPreiodSelectPlugin_2", (String)systemType, (Object[])new Object[0]), MessageBoxOptions.OKCancel, reimplement);
                    break;
                }
                case "B": 
                case "C": {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7ee9\u6548\u65b9\u6848\u751f\u6210\u7684\u7ee9\u6548\u62a5\u544a\u5df2\u63d0\u4ea4\u5ba1\u6279\uff0c\u65e0\u6cd5\u751f\u6210\u3002", (String)"AssessPreiodSelectPlugin_3", (String)systemType, (Object[])new Object[0]));
                    break;
                }
                default: {
                    if (!this.saveEvalute(this.scheme)) break;
                    this.addLog4SaveEvaluate(startDate, endDate);
                    this.getView().returnDataToParent((Object)"true");
                    this.getView().close();
                }
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent arg0) {
        super.confirmCallBack(arg0);
        if ("saveEvalute".equalsIgnoreCase(arg0.getCallBackId()) && MessageBoxResult.Yes.equals((Object)arg0.getResult())) {
            String period = this.scheme.getString("assessperiod");
            Map<String, Date> periods = this.getPeriods(period);
            Date startDate = periods.get("start");
            Date endDate = periods.get("end");
            this.deleteEvaluate(startDate, endDate, this.scheme.getLong("id"));
            if (this.saveEvalute(this.scheme)) {
                this.addLog4SaveEvaluate(startDate, endDate);
                this.getView().returnDataToParent((Object)"true");
                this.getView().close();
            }
        }
    }

    private void addLog4SaveEvaluate(Date startDate, Date endDate) {
        String number = this.scheme.getString("number");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String start = sdf.format(startDate);
        String end = sdf.format(endDate);
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u751f\u6210\u7ee9\u6548\u62a5\u544a", "AssessPeriodSelectPlugin_0", systemType);
        MultiLangEnumBridge opDes = new MultiLangEnumBridge("\u7ee9\u6548\u8003\u6838\u65b9\u6848[%1$s]\uff0c\u8003\u6838\u533a\u95f4%2$s~%3$s\u751f\u6210\u7ee9\u6548\u62a5\u544a\u6210\u529f", "AssessPeriodSelectPlugin_1", systemType);
        OpLogAppInfo opLogAppInfo = LogBuildUtil.buildLogInfo(this.getView(), null, "ssc_achievescheme", "generateAchieveReport", opName, opDes, number, start, end);
        LogServiceHelper.addLog((AppLogInfo)opLogAppInfo);
    }

    private void hideField(String period) {
        IFormView view = this.getView();
        switch (period) {
            case "1": {
                view.setVisible(Boolean.FALSE, new String[]{"assess_halfyear"});
                view.setVisible(Boolean.FALSE, new String[]{"assess_quarter"});
                break;
            }
            case "2": {
                view.setVisible(Boolean.FALSE, new String[]{"assess_halfyear"});
                view.setVisible(Boolean.FALSE, new String[]{"assess_month"});
                break;
            }
            case "3": {
                view.setVisible(Boolean.FALSE, new String[]{"assess_month"});
                view.setVisible(Boolean.FALSE, new String[]{"assess_quarter"});
                break;
            }
            case "4": {
                view.setVisible(Boolean.FALSE, new String[]{"assess_halfyear"});
                view.setVisible(Boolean.FALSE, new String[]{"assess_quarter"});
                view.setVisible(Boolean.FALSE, new String[]{"assess_month"});
                break;
            }
        }
    }

    private void genYearComboItems(String propertyName, int currentYear) {
        ComboEdit propertyField = (ComboEdit)this.getControl(propertyName);
        ArrayList<ComboItem> propertyItems = new ArrayList<ComboItem>(16);
        for (int i = currentYear - 10; i < currentYear + 10; ++i) {
            String year = String.valueOf(i);
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(year));
            comboItem.setValue(year);
            propertyItems.add(comboItem);
        }
        propertyField.setComboItems(propertyItems);
    }

    public boolean saveEvalute(DynamicObject scheme) {
        List achieveEvaluateDyos;
        boolean success = true;
        String period = scheme.getString("assessperiod");
        if (this.validPeriod(period)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u671f\u95f4\u7684\u503c\u662f\u5426\u6709\u6548\u3002", (String)"AssessPreiodSelectPlugin_0", (String)systemType, (Object[])new Object[0]));
            return false;
        }
        Map<String, Date> periods = this.getPeriods(period);
        Date startDate = periods.get("start");
        Date endDate = periods.get("end");
        try {
            achieveEvaluateDyos = new AchieveSchemeConverter(scheme, startDate, endDate).buildEvaluationData();
        }
        catch (Exception ex) {
            this.getView().showErrorNotification(ex.getMessage());
            return false;
        }
        try {
            DynamicObject[] achieveEvaluateArray = new DynamicObject[achieveEvaluateDyos.size()];
            achieveEvaluateDyos.toArray(achieveEvaluateArray);
            DynamicObject[] achEvaIds = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])achieveEvaluateArray);
            if (achEvaIds == null || achEvaIds.length == 0) {
                log.error("\u65b0\u589e\u7efc\u5408\u7ee9\u6548\u8bc4\u4ef7\u5355\u6570\u91cf\u4e3a0\uff0c\u6784\u5efa\u7684\u8bc4\u4ef7\u5355\u6570\u91cf\u4e3a" + achieveEvaluateDyos.size());
            }
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u7efc\u5408\u7ee9\u6548\u8bc4\u4ef7\u5355\u51fa\u9519\uff1a", (Throwable)e);
            return false;
        }
        return success;
    }

    public Map<String, Date> getPeriods(String period) {
        HashMap<String, Date> map = new HashMap<String, Date>(2);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        IDataModel model = this.getModel();
        String year_str = (String)model.getValue("assess_year");
        int year = Integer.parseInt(year_str);
        int begin = 0;
        int end = 0;
        switch (period) {
            case "1": {
                String month = (String)model.getValue("assess_month");
                int m = Integer.parseInt(month);
                Date fisrtDayOfMonth = AchieveDateUtil.getDateByYearMonth((int)year, (int)m, (boolean)true);
                Date lastDayOfMonth = AchieveDateUtil.getDateByYearMonth((int)year, (int)m, (boolean)false);
                map.put("start", fisrtDayOfMonth);
                map.put("end", lastDayOfMonth);
                break;
            }
            case "2": {
                int quarter = Integer.parseInt((String)model.getValue("assess_quarter"));
                switch (quarter) {
                    case 1: {
                        begin = 1;
                        end = 3;
                        break;
                    }
                    case 2: {
                        begin = 4;
                        end = 6;
                        break;
                    }
                    case 3: {
                        begin = 7;
                        end = 9;
                        break;
                    }
                    case 4: {
                        begin = 10;
                        end = 12;
                        break;
                    }
                }
                map.put("start", AchieveDateUtil.getDateByYearMonth((int)year, (int)begin, (boolean)true));
                map.put("end", AchieveDateUtil.getDateByYearMonth((int)year, (int)end, (boolean)false));
                break;
            }
            case "3": {
                String halfyear;
                switch (halfyear = (String)model.getValue("assess_halfyear")) {
                    case "1": {
                        begin = 1;
                        end = 6;
                        break;
                    }
                    case "2": {
                        begin = 7;
                        end = 12;
                    }
                }
                map.put("start", AchieveDateUtil.getDateByYearMonth((int)year, (int)begin, (boolean)true));
                map.put("end", AchieveDateUtil.getDateByYearMonth((int)year, (int)end, (boolean)false));
                break;
            }
            case "4": {
                begin = 1;
                end = 12;
                map.put("start", AchieveDateUtil.getDateByYearMonth((int)year, (int)begin, (boolean)true));
                map.put("end", AchieveDateUtil.getDateByYearMonth((int)year, (int)end, (boolean)false));
            }
        }
        return map;
    }

    private String validate(Long schemeId, Date start, Date end) {
        String result = "";
        String selectFields = "id,status";
        QFilter fliter = new QFilter("assessplanid", "=", (Object)schemeId);
        fliter.and("periodstart", "=", (Object)start);
        fliter.and("periodend", "=", (Object)end);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"ssc_achieveevalute", (String)selectFields, (QFilter[])new QFilter[]{fliter});
        if (dynamicObject != null) {
            result = dynamicObject.getString("status");
        }
        return result;
    }

    private boolean validPeriod(String period) {
        IDataModel model = this.getModel();
        String year = (String)model.getValue("assess_year");
        if (year == null || StringUtils.isBlank((CharSequence)year.trim())) {
            return true;
        }
        switch (period) {
            case "1": {
                String month = (String)model.getValue("assess_month");
                if (month != null && !StringUtils.isBlank((CharSequence)month.trim())) break;
                return true;
            }
            case "2": {
                String quarter = (String)model.getValue("assess_quarter");
                if (quarter != null && !StringUtils.isBlank((CharSequence)quarter.trim())) break;
                return true;
            }
            case "3": {
                String halfyear = (String)model.getValue("assess_halfyear");
                if (halfyear != null && !StringUtils.isBlank((CharSequence)halfyear.trim())) break;
                return true;
            }
        }
        return false;
    }

    private void deleteEvaluate(Date startDate, Date endDate, Long planId) {
        try {
            QFilter dateFiler = new QFilter("periodstart", "=", (Object)startDate);
            dateFiler.and(new QFilter("periodend", "=", (Object)endDate));
            QFilter schemeFilter = new QFilter("assessplanid", "=", (Object)planId);
            DeleteServiceHelper.delete((String)"ssc_achieveevalute", (QFilter[])new QFilter[]{dateFiler, schemeFilter});
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u8981\u8986\u76d6\u7684\u7efc\u5408\u7ee9\u6548\u8bc4\u4ef7\u5355\u51fa\u9519\uff1a", (Throwable)e);
        }
    }
}

