/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.achieve;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.FormulaException;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.service.IBaseDataService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.enums.achieve.TargetRule;
import kd.ssc.task.formplugin.pojo.achieve.OperatorEnum;

public class CalculateFormulaPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
SearchEnterListener {
    private static final String KEY_EXPRESSION = "expression";
    private static final String KEY_TRANEXPR = "tranexpr";
    private static final String KEY_DESCRIPTION = "description";
    private static final String OP_OK = "btnok";
    private static final String OP_CANCEL = "btncancel";
    private static final String TV_FIELDS = "tv_fields";
    private static final String[] Operaters = new String[]{"+", "-", "*", "/", "!=", "<>", "<=", ">=", "=", "<", ">"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{OP_OK, OP_CANCEL});
        this.addClickListeners(OperatorEnum.getCodeArray());
        TreeView tv = (TreeView)this.getView().getControl(TV_FIELDS);
        tv.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String sscId = (String)this.getView().getFormShowParameter().getCustomParam("sscid");
        List<TreeNode> treeNodes = this.buildCalFactorNodeList(Long.valueOf(sscId), this.getPageCache().get("cachedSearchText"));
        TreeNode root = new TreeNode("", "root", ResManager.loadKDString((String)"\u8ba1\u7b97\u56e0\u5b50", (String)"AchieveTargetFormPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]), true);
        root.setIsOpened(true);
        root.addChildren(treeNodes);
        TreeView tree = (TreeView)this.getView().getControl(TV_FIELDS);
        tree.addNode(root);
        this.getPageCache().put("rootNode", SerializationUtils.toJsonString((Object)root));
        String ruleJson = (String)this.getView().getFormShowParameter().getCustomParam("ruleJson");
        TargetRule ruleObj = this.deserializeRule(ruleJson);
        if (ruleObj != null) {
            this.getModel().setValue(KEY_EXPRESSION, (Object)ruleObj.getExpression());
            this.getModel().setValue(KEY_DESCRIPTION, (Object)ruleObj.getDescription().toString());
            String tranExpr = this.tranExpression(ruleObj.getExpression());
            this.getModel().setValue(KEY_TRANEXPR, (Object)tranExpr);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String opKey = ((Control)evt.getSource()).getKey();
        if (OP_OK.equalsIgnoreCase(opKey)) {
            if (this.getModel().getValue(KEY_EXPRESSION) != null) {
                String textAreaField = this.getModel().getValue(KEY_EXPRESSION).toString().replaceAll(" +", " ").replaceAll("\n", "");
                if (StringUtils.isBlank((CharSequence)textAreaField)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (String)"CalculateFormulaPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    return;
                }
                String ruleJson = (String)this.getView().getFormShowParameter().getCustomParam("ruleJson");
                TargetRule ruleObj = this.deserializeRule(ruleJson);
                this.getRuleObj(ruleObj);
                if (StringUtils.isNotEmpty((CharSequence)ruleObj.getExpression())) {
                    try {
                        String tranExpr = this.tranExpression(ruleObj.getExpression());
                        ruleObj.setExprTran(tranExpr);
                    }
                    catch (FormulaException var1) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6709\u8bed\u6cd5\u9519\u8bef\uff1a%s", (String)"CalculateFormulaPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]), var1.getCause() != null ? var1.getCause().getMessage() : var1.getMessage()));
                        return;
                    }
                    catch (Throwable var2) {
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6709\u8bed\u6cd5\u9519\u8bef\uff1a%s", (String)"CalculateFormulaPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]), var2.getMessage()));
                        return;
                    }
                }
                this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)ruleObj));
                this.getView().close();
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (String)"CalculateFormulaPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            }
        } else if (OP_CANCEL.equalsIgnoreCase(opKey)) {
            this.getView().close();
        } else if (OperatorEnum.isInclude(opKey)) {
            if (OperatorEnum.backspace.getCode().equalsIgnoreCase(opKey)) {
                this.backSpaceExpression(this.getView(), OperatorEnum.backspace.getCode(), KEY_EXPRESSION);
            } else {
                this.insertExpression(this.getView(), opKey, KEY_EXPRESSION, OperatorEnum.valueOf(opKey).getOpSymbol());
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (e.getProperty().getName().equalsIgnoreCase(KEY_EXPRESSION)) {
            String tranExpr;
            String expression = (String)this.getModel().getValue(KEY_EXPRESSION);
            try {
                tranExpr = this.tranExpression(expression);
            }
            catch (FormulaException var3) {
                tranExpr = var3.getCause() != null ? var3.getCause().getMessage() : var3.getMessage();
            }
            catch (Throwable var4) {
                tranExpr = ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u8bed\u6cd5\u89e3\u6790\u9519\u8bef\uff0c\u81ea\u52a8\u7ffb\u8bd1\u5931\u8d25\u3002", (String)"CalculateFormulaPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]);
            }
            this.getModel().setValue(KEY_TRANEXPR, (Object)tranExpr);
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = (String)evt.getNodeId();
        if (!nodeId.equals("root")) {
            this.insertExpression(this.getView(), TV_FIELDS, KEY_EXPRESSION, evt.getNodeId().toString());
        }
    }

    private TargetRule deserializeRule(String json) {
        TargetRule ruleObj = StringUtils.isEmpty((CharSequence)json) ? new TargetRule() : (TargetRule)SerializationUtils.fromJsonString((String)json, TargetRule.class);
        return ruleObj;
    }

    private String tranExpression(String expression) {
        if (StringUtils.isBlank((CharSequence)expression)) {
            return "";
        }
        String expressionDesc = expression;
        String[] vars = new String[]{};
        vars = FormulaEngine.extractVariables((String)expression);
        if (vars.length == 0 || StringUtils.isBlank((CharSequence)vars[0])) {
            return expressionDesc;
        }
        String json = this.getPageCache().get("rootNode");
        TreeNode rootNode = new TreeNode();
        if (StringUtils.isNotBlank((CharSequence)json)) {
            rootNode = (TreeNode)SerializationUtils.fromJsonString((String)json, TreeNode.class);
        }
        ArrayList<String> orderVars = new ArrayList<String>(10);
        for (String string : vars) {
            orderVars.add(string);
        }
        orderVars.sort((o1, o2) -> {
            if (o1.length() > o2.length()) {
                return -1;
            }
            if (o1.length() < o2.length()) {
                return 1;
            }
            return o2.compareTo((String)o1);
        });
        HashMap<String, String> tmpVariables = new HashMap<String, String>(16);
        int i = 1;
        for (String string : orderVars) {
            String tempVariable = String.format("###%s###", String.valueOf(i));
            String varCaption = string;
            TreeNode node = rootNode.getTreeNode(string, 5);
            if (node != null) {
                varCaption = node.getText();
            }
            tmpVariables.put(tempVariable, varCaption);
            expressionDesc = expressionDesc.replace(string, tempVariable);
            ++i;
        }
        for (Map.Entry entry : tmpVariables.entrySet()) {
            expressionDesc = expressionDesc.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        return expressionDesc;
    }

    private void insertExpression(IFormView view, String buttonKey, String textFieldKey, String str) {
        int cursorIndex;
        int pos = this.getCursorIndex(view, buttonKey, textFieldKey);
        String expression = (String)view.getModel().getValue(textFieldKey);
        if (StringUtils.isBlank((CharSequence)expression)) {
            expression = str;
            cursorIndex = str.length();
        } else {
            String insertStr = " " + str + " ";
            expression = this.insertCharacter(expression, insertStr, pos);
            cursorIndex = pos + insertStr.length();
        }
        view.getModel().setValue(textFieldKey, (Object)expression);
        this.setCursorIndex(view, textFieldKey, cursorIndex);
    }

    private int getCursorIndex(IFormView view, String buttonKey, String textFieldKey) {
        String textValue = (String)view.getModel().getValue(textFieldKey);
        int cursorIndex = StringUtils.isBlank((CharSequence)textValue) ? 0 : textValue.length();
        IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        Object listPostData = proxy.getViewState(buttonKey);
        if (listPostData instanceof Map) {
            Map focus;
            Map map = (Map)listPostData;
            if (map.get(textFieldKey) != null) {
                cursorIndex = (Integer)map.get(textFieldKey);
            } else if (map.get("focus") != null && (focus = (Map)map.get("focus")).get(textFieldKey) != null) {
                cursorIndex = (Integer)focus.get(textFieldKey);
            }
        }
        return cursorIndex;
    }

    private String insertCharacter(String pStr, String str, int pos) {
        int i;
        if (pStr.length() < pos) {
            pos = pStr.length();
        }
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < pos; ++i) {
            sb.append(pStr.charAt(i));
        }
        sb.append(str);
        for (i = pos; i < pStr.length(); ++i) {
            sb.append(pStr.charAt(i));
        }
        return sb.toString();
    }

    private void backSpaceExpression(IFormView view, String buttonKey, String textFieldKey) {
        String expression = (String)view.getModel().getValue(textFieldKey);
        if (StringUtils.isBlank((CharSequence)expression)) {
            return;
        }
        int cursorIndex = this.getCursorIndex(view, buttonKey, textFieldKey);
        String part1 = expression.substring(0, cursorIndex);
        String part2 = expression.substring(cursorIndex);
        String partDel = part1;
        for (String str : Operaters) {
            int lastIndex = partDel.lastIndexOf(str);
            if (lastIndex <= 0 || !"".equals((partDel = partDel.substring(lastIndex + str.length())).trim())) continue;
            partDel = str;
            break;
        }
        String[] fieldList = partDel.split(" ");
        for (int i = fieldList.length - 1; i >= 0; --i) {
            if ("".equals(fieldList[i].trim())) continue;
            partDel = fieldList[i];
            break;
        }
        expression = part1.substring(0, part1.lastIndexOf(partDel)) + part2;
        cursorIndex = part1.substring(0, part1.lastIndexOf(partDel)).length();
        view.getModel().setValue(textFieldKey, (Object)expression);
        this.setCursorIndex(view, textFieldKey, cursorIndex);
    }

    private void setCursorIndex(IFormView view, String textFieldKey, int cursorIndex) {
        HashMap<String, Object> cursorMap = new HashMap<String, Object>();
        cursorMap.put("ctrlKey", textFieldKey);
        cursorMap.put("cursorIndex", cursorIndex);
        IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        proxy.addAction("setTextareaCursorPosition", cursorMap);
    }

    private void getRuleObj(TargetRule ruleObj) {
        String expression = (String)this.getModel().getValue(KEY_EXPRESSION);
        ruleObj.setExpression(expression);
        String desc = (String)this.getModel().getValue(KEY_DESCRIPTION);
        ruleObj.getDescription().setItem(Lang.defaultLang().toString(), (Object)desc);
    }

    private List<TreeNode> buildCalFactorNodeList(Long sscId, String searchText) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(10);
        IBaseDataService baseDataService = (IBaseDataService)ServiceFactory.getService(IBaseDataService.class);
        QFilter useOrgFilter = baseDataService.getBaseDataFilter("ssc_calculationfactor", sscId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter nameFilter = null;
        if (StringUtils.isNotEmpty((CharSequence)searchText)) {
            nameFilter = new QFilter("name", "like", (Object)("%" + searchText + "%"));
        }
        DynamicObjectCollection results = QueryServiceHelper.query((String)"ssc_calculationfactor", (String)"number,name", (QFilter[])new QFilter[]{useOrgFilter, enableFilter, nameFilter});
        for (DynamicObject dynamicObject : results) {
            TreeNode treeNode = new TreeNode("", dynamicObject.getString("number"), dynamicObject.getString("name"));
            nodes.add(treeNode);
        }
        return nodes;
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        String text = searchEnterEvent.getText();
        this.getPageCache().put("cachedSearchText", text);
        String sscId = (String)this.getView().getFormShowParameter().getCustomParam("sscid");
        List<TreeNode> nodes = this.buildCalFactorNodeList(Long.valueOf(sscId), text);
        String rootNode = this.getPageCache().get("rootNode");
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)rootNode, TreeNode.class);
        root.setChildren(nodes);
        TreeView tree = (TreeView)this.getView().getControl(TV_FIELDS);
        tree.updateNode(root);
    }
}

