/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.achieve;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.events.SetFilterContainerFlatEvent;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterColumnSetFilterEvent;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.ssc.task.business.achieve.helper.QueryDataHelper;
import kd.ssc.task.util.SscLicenseUtil;

public class UserOnDutyTimeListPlugin
extends AbstractListPlugin {
    public void preOpenForm(PreOpenFormEventArgs e) {
        SscLicenseUtil.checkGroupLicense5_0((PreOpenFormEventArgs)e, (String)"ssc_userondutytime");
    }

    public void filterContainerSetFlat(SetFilterContainerFlatEvent args) {
        args.setNewFilter(false);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"_toolbar_"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("recount".equals(operateKey) && operationResult.isSuccess()) {
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "ssc_userondutytime");
            this.showForm("ssc_usertimeselect", closeCallBack, ShowType.Modal);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        IFormView view = this.getView();
        if ("ssc_userondutytime".equalsIgnoreCase(evt.getActionId())) {
            view.updateView();
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map currentCommonFilter = args.getCurrentCommonFilter();
        if (currentCommonFilter != null) {
            String curFieldName = (String)((List)currentCommonFilter.get("FieldName")).get(0);
            if ("sscid.id".equals(curFieldName)) {
                ((List)args.getFilterValues().get("customfilter")).removeIf(t -> ((List)t.get("FieldName")).get(0).equals("workgroup.id"));
                ((List)args.getFilterValues().get("customfilter")).removeIf(t -> ((List)t.get("FieldName")).get(0).equals("groupid.id"));
            } else if ("workgroup.id".equals(curFieldName)) {
                ((List)args.getFilterValues().get("customfilter")).removeIf(t -> ((List)t.get("FieldName")).get(0).equals("groupid.id"));
            }
        }
        super.filterContainerAfterSearchClick(args);
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        IListView listView = (IListView)this.getView();
        List sscIds = listView.getSelectedMainOrgIds();
        Long sscId = (Long)sscIds.get(0);
        if (sscId != null) {
            String fieldName = args.getFieldName();
            if ("groupid.id".equals(fieldName) || "groupid.name".equals(fieldName)) {
                args.addCustomQFilter(new QFilter("createorg", "=", (Object)sscId));
            } else if ("workgroup.id".equals(fieldName) || "workgroup.name".equals(fieldName)) {
                args.addCustomQFilter(new QFilter("createorg", "=", (Object)sscId));
            }
        }
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        String fieldName = args.getFieldName();
        FilterColumnSetFilterEvent args2 = (FilterColumnSetFilterEvent)args;
        if ("workgroup.name".equals(fieldName)) {
            List sscIds = args2.getCommonFilterValue("sscid.name");
            String curSSCId = sscIds.get(0).toString();
            args.addCustomQFilter(new QFilter("createorg.id", "=", (Object)Long.valueOf(curSSCId)));
        } else if ("groupid.name".equals(fieldName)) {
            List workgroupIds;
            List userGroupsId;
            List sscIds = args2.getCommonFilterValue("sscid.name");
            String curSSCId = sscIds.get(0).toString();
            args.addCustomQFilter(new QFilter("createorg.id", "=", (Object)Long.valueOf(curSSCId)));
            List workGroups = args2.getCommonFilterValue("workgroup.name");
            if (workGroups != null && workGroups.size() > 0 && !ObjectUtils.isEmpty(workGroups.get(0)) && (userGroupsId = QueryDataHelper.getUserGroupByWorkgroup(workgroupIds = workGroups.stream().map(d -> Long.parseLong(d.toString())).collect(Collectors.toList()))).size() > 0) {
                args.addCustomQFilter(new QFilter("id", "in", (Object)userGroupsId));
            }
        }
    }

    private void showForm(String formId, CloseCallBack closeCallBack, ShowType showType) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("formId", formId);
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(map);
        showParameter.getOpenStyle().setShowType(showType);
        showParameter.setCustomParams(map);
        if (closeCallBack != null) {
            showParameter.setCloseCallBack(closeCallBack);
        }
        this.getView().showForm(showParameter);
    }
}

