/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.condition;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.StringUtils;
import kd.ssc.task.business.condition.ConFieldTypeEnum;
import kd.ssc.task.business.condition.ConditionDataQueryHelper;

public class FieldMapping4ConditionEditPlugin
extends AbstractFormPlugin {
    private static final String OP_CHECK_SAVE = "check_save";
    private static final String KEY_OK = "btnok";
    private static final String CB_SELECT_PROP = "callback_selectProp";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{KEY_OK, "billfield"});
    }

    public void afterCreateNewData(EventObject e) {
        this.buildEntryData();
    }

    private void buildEntryData() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String entityNumbersStr = (String)view.getFormShowParameter().getCustomParam("entityNumbers");
        String conditionFieldsStr = (String)view.getFormShowParameter().getCustomParam("conditionFields");
        if (StringUtils.isEmpty((String)entityNumbersStr) || StringUtils.isEmpty((String)conditionFieldsStr)) {
            return;
        }
        Set entityNumbers = (Set)SerializationUtils.fromJsonString((String)entityNumbersStr, Set.class);
        Set conditionFields = (Set)SerializationUtils.fromJsonString((String)conditionFieldsStr, Set.class);
        Map fieldIds = ConditionDataQueryHelper.queryFieldIdByNumber(conditionFields = conditionFields.stream().map(k -> k.split("\\.")[0]).collect(Collectors.toSet()));
        if (fieldIds.isEmpty()) {
            return;
        }
        QFilter joinFilter = QFilter.join((String)"id", (String)"ssc_confield_mapping.confield", (QFilter)new QFilter("ssc_confield_mapping.sourcebill", "in", (Object)entityNumbers));
        QFilter ableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter fieldFilter = new QFilter("id", "in", fieldIds.values());
        String selectField = "id confield,R.id mId,R.sourcebill sourcebill,R.billfield billfield,R.billfieldnumber billfieldnumber";
        selectField = selectField.replaceAll("R", "ssc_confield_mapping");
        DynamicObjectCollection mappingCol = QueryServiceHelper.query((String)"ssc_condition_field", (String)selectField, (QFilter[])new QFilter[]{joinFilter, ableFilter, fieldFilter});
        Set distributed = mappingCol.stream().map(m -> m.getString("sourcebill") + "-" + m.getString("confield")).collect(Collectors.toSet());
        for (String entityNumber : entityNumbers) {
            for (Long conField : fieldIds.values()) {
                if (distributed.contains(entityNumber + "-" + conField)) continue;
                int index = model.createNewEntryRow("entryentity");
                model.setValue("sourcebill", (Object)entityNumber, index);
                model.setValue("confield", (Object)conField, index);
            }
        }
        if (mappingCol.size() > 0) {
            int i = 0;
            for (int index : model.batchCreateNewEntryRow("entryentity", mappingCol.size())) {
                DynamicObject mapping = (DynamicObject)mappingCol.get(i);
                model.setValue("id", (Object)mapping.getLong("mId"), index);
                model.setValue("sourcebill", (Object)mapping.getString("sourcebill"), index);
                model.setValue("confield", (Object)mapping.getLong("confield"), index);
                model.setValue("billfield", (Object)mapping.getString("billfield"), index);
                model.setValue("billfieldnumber", (Object)mapping.getString("billfieldnumber"), index);
                ++i;
            }
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("billfield".equals(key)) {
            this.showPropSelectForm();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        String operateKey = eventArgs.getOperateKey();
        if (OP_CHECK_SAVE.equals(operateKey) && eventArgs.getOperationResult().isSuccess()) {
            this.saveDataAndCloseView();
        }
    }

    private void saveDataAndCloseView() {
        DynamicObjectCollection mappingCol;
        List changedRows;
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        if (model.getDataChanged() && (changedRows = (mappingCol = model.getEntryEntity("entryentity")).stream().filter(c -> c.getDataEntityState().isBizChanged()).collect(Collectors.toList())).size() > 0) {
            OperationResult operationResult;
            ArrayList<DynamicObject> saveData = new ArrayList<DynamicObject>(changedRows.size());
            HashMap<Long, DynamicObject> updateTempData = new HashMap<Long, DynamicObject>(changedRows.size());
            for (DynamicObject changedRow : changedRows) {
                long mappingId = changedRow.getLong("id");
                String billField = changedRow.getString("billfield");
                String billFieldNumber = changedRow.getString("billfieldnumber");
                if (mappingId > 0L && StringUtils.isNotEmpty((String)billFieldNumber)) {
                    updateTempData.put(mappingId, changedRow);
                    continue;
                }
                if (mappingId != 0L || !StringUtils.isNotEmpty((String)billFieldNumber)) continue;
                DynamicObject newData = BusinessDataServiceHelper.newDynamicObject((String)"ssc_confield_mapping");
                newData.set("confield", changedRow.get("confield"));
                newData.set("sourcebill", changedRow.get("sourcebill"));
                newData.set("billfield", (Object)billField);
                newData.set("billfieldnumber", (Object)billFieldNumber);
                saveData.add(newData);
            }
            if (updateTempData.size() > 0) {
                DynamicObject[] load;
                for (DynamicObject row : load = BusinessDataServiceHelper.load((Object[])updateTempData.keySet().toArray(new Long[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ssc_confield_mapping"))) {
                    Long id = row.getLong("id");
                    DynamicObject temp = (DynamicObject)updateTempData.get(id);
                    if (temp == null) continue;
                    row.set("billfield", temp.get("billfield"));
                    row.set("billfieldnumber", temp.get("billfieldnumber"));
                    saveData.add(row);
                }
            }
            if (saveData.size() > 0 && !(operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"ssc_confield_mapping", (DynamicObject[])saveData.toArray(new DynamicObject[0]), null)).isSuccess()) {
                this.getView().showTipNotification(operationResult.getMessage());
                return;
            }
        }
        view.returnDataToParent((Object)"ok");
        view.close();
    }

    private void showPropSelectForm() {
        IDataModel model = this.getModel();
        int currentRowIndex = model.getEntryCurrentRowIndex("entryentity");
        String entityNumber = ((DynamicObject)model.getValue("sourcebill", currentRowIndex)).getString("number");
        DynamicObject conField = (DynamicObject)model.getValue("confield", currentRowIndex);
        String fieldType = conField.getString("fieldtype");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ssc_entitytree");
        showParameter.setCustomParam("entityNumber", (Object)entityNumber);
        showParameter.setCustomParam("conFieldType", (Object)fieldType);
        if (ConFieldTypeEnum.BASE_DATA.getValue().equals(fieldType)) {
            showParameter.setCustomParam("baseDataType", (Object)conField.getString("basedatatype.number"));
        }
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CB_SELECT_PROP));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        IDataModel model = this.getModel();
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        Map map = (Map)returnData;
        if (CB_SELECT_PROP.equals(actionId)) {
            String number = (String)map.get("number");
            String name = (String)map.get("name");
            int currentRowIndex = model.getEntryCurrentRowIndex("entryentity");
            model.setValue("billfield", (Object)name, currentRowIndex);
            model.setValue("billfieldnumber", (Object)number, currentRowIndex);
        }
    }
}

