/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.duty;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.bill.IBillPlugin;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.org.utils.Utils;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.ssc.enums.SSCTypeEnum;
import kd.ssc.task.business.helper.DutyManageDataHelper;
import kd.ssc.task.business.helper.OrgRelationQueryHelper;
import kd.ssc.task.business.task.OrgF7ViewShowHelper;

public class DutyManageEditPlugin
extends AbstractFormPlugin
implements IBillPlugin {
    private static final String CK_DUTY_COMBO_ITEM = "dutyComboItem";
    private static final String CK_OLD_VALUE = "preConfirm_oldValue";
    private static final String CK_DISSATISFY_ORG = "dissatisfyOrg";

    public void preOpenForm(PreOpenFormEventArgs e) {
        FormShowParameter formShowParameter = e.getFormShowParameter();
        Object sscIdObj = formShowParameter.getCustomParam("sscId");
        if (sscIdObj == null) {
            e.setCancel(true);
            return;
        }
        long sscId = Long.parseLong(sscIdObj.toString());
        long userId = RequestContext.get().getCurrUserId();
        HasPermOrgResult userHasPermOrg = PermissionServiceHelper.getUserHasPermOrgs((long)userId, (boolean)false);
        if (userHasPermOrg.hasAllOrgPerm()) {
            return;
        }
        if (userHasPermOrg.getHasPermOrgs() != null && !userHasPermOrg.getHasPermOrgs().contains(sscId)) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u65e0\u8be5\u7ec4\u7ec7\u7684\u201c\u5171\u4eab\u804c\u8d23\u7ba1\u7406\u201d\u914d\u7f6e\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"DutyManageEditPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"entrybar"});
    }

    public void afterBindData(EventObject e) {
        IFormView view = this.getView();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        Object canEdit = formShowParameter.getCustomParam("canEdit");
        if (!"true".equals(canEdit)) {
            view.setEnable(Boolean.FALSE, new String[]{"baseinfoflex", "advconap"});
        }
        String sscType = (String)this.getModel().getValue("sscbusinesstype");
        this.setDutyComboEdit(!SSCTypeEnum.FI.getValue().equals(sscType));
        this.handleSSCType4App();
    }

    public void afterCreateNewData(EventObject e) {
        Object sscIdObj = this.getView().getFormShowParameter().getCustomParam("sscId");
        long sscId = Long.parseLong(sscIdObj.toString());
        this.getModel().setValue("sscorg", (Object)sscId);
        this.loadNoPhyTableProp();
    }

    public void afterLoadData(EventObject e) {
        this.loadNoPhyTableProp();
        String sscType = (String)this.getModel().getValue("sscbusinesstype");
        if (SSCTypeEnum.HR.getValue().equals(sscType)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"sscbusinesstype"});
        }
        this.getModel().setDataChanged(false);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId = event.getActionId();
        Object returnData = event.getReturnData();
        if ("addOrgRelation".equals(actionId)) {
            this.fillBackOrgF7SelectedData(returnData);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("addrow".equals(itemKey)) {
            this.showOrgView();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        List<Long> notSatisfyOrg;
        String propName = e.getProperty().getName();
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        if ("sscbusinesstype".equals(propName)) {
            Object obj = model.getValue("sscdutyscope");
            String dutyScopeStr = obj == null ? null : obj.toString();
            List dutyScope = DutyManageDataHelper.getMulComboValueList((String)dutyScopeStr);
            if (SSCTypeEnum.FI.getValue().equals(newValue.toString())) {
                this.setDutyComboEdit(false);
                int rowSize = this.getModel().getEntryEntity("entryentity").size();
                if (dutyScope == null && rowSize == 0) {
                    model.beginInit();
                    model.setValue("sscdutyscope", (Object)",10,09,40,");
                    model.endInit();
                    view.updateView("sscdutyscope");
                } else if (dutyScope == null) {
                    List<Long> onlyHrOrgs = this.queryOnlyHrOrg();
                    if (!ObjectUtils.isEmpty(onlyHrOrgs)) {
                        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("dutyScopeChange", (IFormPlugin)this);
                        view.showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u5171\u4eab\u4e2d\u5fc3\u7c7b\u578b\u540e\uff0c\u975e\u804c\u80fd\u7ba1\u7406\u8303\u56f4\u5185\u7684\u59d4\u6258\u5173\u7cfb\u5c06\u88ab\u6e05\u9664\uff0c\u786e\u8ba4\u5207\u6362\uff1f", (String)"DutyManageEditPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBacks);
                        this.getPageCache().put(CK_OLD_VALUE, (String)oldValue);
                        this.getPageCache().put(CK_DISSATISFY_ORG, SerializationUtils.toJsonString(onlyHrOrgs));
                    }
                } else {
                    dutyScope.remove("11");
                    model.setValue("sscdutyscope", (Object)String.join((CharSequence)",", dutyScope));
                }
            } else if (SSCTypeEnum.HR.getValue().equals(newValue.toString())) {
                boolean notNeedCheck;
                boolean bl = notNeedCheck = dutyScope != null && dutyScope.size() == 1 && "11".equals(dutyScope.get(0));
                if (!notNeedCheck) {
                    List<Long> notSatisfyOrg2 = this.notSatisfyOrg(Collections.singletonList("11"));
                    if (!ObjectUtils.isEmpty(notSatisfyOrg2)) {
                        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("switchToHR", (IFormPlugin)this);
                        view.showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u5171\u4eab\u4e2d\u5fc3\u7c7b\u578b\u540e\uff0c\u975e\u804c\u80fd\u7ba1\u7406\u8303\u56f4\u5185\u7684\u59d4\u6258\u5173\u7cfb\u5c06\u88ab\u6e05\u9664\uff0c\u786e\u8ba4\u5207\u6362\uff1f", (String)"DutyManageEditPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBacks);
                        this.getPageCache().put(CK_OLD_VALUE, (String)oldValue);
                        this.getPageCache().put(CK_DISSATISFY_ORG, SerializationUtils.toJsonString(notSatisfyOrg2));
                    } else {
                        model.setValue("sscdutyscope", (Object)"11");
                        view.updateView("sscdutyscope");
                    }
                }
            }
            if (SSCTypeEnum.FI.getValue().equals(oldValue)) {
                this.setDutyComboEdit(true);
            }
        } else if ("sscdutyscope".equals(propName) && !ObjectUtils.isEmpty(notSatisfyOrg = this.notSatisfyOrg(DutyManageDataHelper.getMulComboValueList((String)((String)newValue))))) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("dutyScopeChange", (IFormPlugin)this);
            view.showConfirm(ResManager.loadKDString((String)"\u6539\u53d8\u804c\u8d23\u7ba1\u7406\u8303\u56f4\u540e\uff0c\u975e\u804c\u8d23\u7ba1\u7406\u8303\u56f4\u5185\u7684\u59d4\u6258\u5173\u7cfb\u5c06\u88ab\u6e05\u9664\uff0c\u786e\u8ba4\u8981\u5207\u6362\u5417\uff1f", (String)"DutyManageEditPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBacks);
            this.getPageCache().put(CK_OLD_VALUE, (String)oldValue);
            this.getPageCache().put(CK_DISSATISFY_ORG, SerializationUtils.toJsonString(notSatisfyOrg));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        IDataModel model = this.getModel();
        String callBackId = event.getCallBackId();
        MessageBoxResult result = event.getResult();
        if ("switchToHR".equals(callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)result)) {
                String dissatisfy = this.getPageCache().get(CK_DISSATISFY_ORG);
                List dutyScopeIds = SerializationUtils.fromJsonStringToList((String)dissatisfy, Long.class);
                int[] indexByOrgId = this.getIndexByOrgId(dutyScopeIds);
                if (indexByOrgId != null && indexByOrgId.length > 0) {
                    model.deleteEntryRows("entryentity", indexByOrgId);
                }
                model.setValue("sscdutyscope", (Object)"11");
            } else {
                model.beginInit();
                model.setValue("sscbusinesstype", (Object)this.getPageCache().get(CK_OLD_VALUE));
                model.endInit();
                this.getView().updateView("sscbusinesstype");
            }
            this.getPageCache().remove(CK_DISSATISFY_ORG);
            this.getPageCache().remove(CK_OLD_VALUE);
        } else if ("dutyScopeChange".equals(callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)result)) {
                String dissatisfy = this.getPageCache().get(CK_DISSATISFY_ORG);
                List dutyScopeIds = SerializationUtils.fromJsonStringToList((String)dissatisfy, Long.class);
                int[] indexByOrgId = this.getIndexByOrgId(dutyScopeIds);
                if (indexByOrgId != null && indexByOrgId.length > 0) {
                    model.deleteEntryRows("entryentity", indexByOrgId);
                }
            } else {
                model.beginInit();
                model.setValue("sscdutyscope", (Object)this.getPageCache().get(CK_OLD_VALUE));
                model.endInit();
                this.getView().updateView("sscdutyscope");
            }
            this.getPageCache().remove(CK_DISSATISFY_ORG);
            this.getPageCache().remove(CK_OLD_VALUE);
        }
    }

    private void loadNoPhyTableProp() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object parentIdObj = formShowParameter.getCustomParam("parentId");
        if (parentIdObj != null) {
            long parentId = Long.parseLong(parentIdObj.toString());
            this.getModel().setValue("parentorg", (Object)parentId);
        }
        this.initEntry();
    }

    private void initEntry() {
        List<Long> relationOrgList = this.getRelationOrg();
        if (relationOrgList != null && relationOrgList.size() > 0) {
            List<Long> notSatisfyOrg;
            IDataModel model = this.getModel();
            Object obj = model.getValue("sscdutyscope");
            String dutyScopeStr = obj == null ? null : obj.toString();
            String sscType = (String)model.getValue("sscbusinesstype");
            if (SSCTypeEnum.FI.getValue().equals(sscType) && StringUtils.isEmpty((String)dutyScopeStr)) {
                notSatisfyOrg = this.queryOnlyHrOrg(relationOrgList);
            } else {
                List dutyScope = DutyManageDataHelper.getMulComboValueList((String)dutyScopeStr);
                notSatisfyOrg = this.notSatisfyOrg(dutyScope, relationOrgList);
            }
            TableValueSetter tvs = new TableValueSetter(new String[0]);
            tvs.addField("delegateorg", new Object[0]);
            tvs.addField("orgstate", new Object[0]);
            for (int i = 0; i < relationOrgList.size(); ++i) {
                Long orgId = relationOrgList.get(i);
                String state = notSatisfyOrg == null || !notSatisfyOrg.contains(orgId) ? "1" : "0";
                tvs.addRow(new Object[]{orgId, state});
            }
            ((AbstractFormDataModel)model).batchCreateNewEntryRow("entryentity", tvs);
        }
    }

    private void showOrgView() {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        filters.add(enableFilter);
        List<Long> orgList = this.getEntryOrgList();
        if (orgList != null && !orgList.isEmpty()) {
            QFilter orgFilter = new QFilter("id", "not in", orgList);
            filters.add(orgFilter);
        }
        ListShowParameter lsp = OrgF7ViewShowHelper.buildOrgShowFormParameter((boolean)true, filters);
        String sscDutyScope = (String)this.getModel().getValue("sscdutyscope");
        String sscType = (String)this.getModel().getValue("sscbusinesstype");
        if (!StringUtils.isEmpty((String)sscDutyScope) || SSCTypeEnum.FI.getValue().equals(sscType)) {
            List dutySet = DutyManageDataHelper.getMulComboValueList((String)sscDutyScope);
            if (dutySet != null && dutySet.size() == 1) {
                lsp.setCustomParam("orgFuncId", dutySet.get(0));
            } else if (dutySet != null && dutySet.size() > 1) {
                lsp.setCustomParam("initOrgFuncId", dutySet.get(0));
                lsp.setCustomParam("orgFunScope", (Object)SerializationUtils.toJsonString((Object)dutySet));
            } else {
                List<ComboItem> orgBizList = this.getOrgBizList();
                orgBizList.removeIf(o -> "11".equals(o.getValue()));
                List collect = orgBizList.stream().map(ComboItem::getValue).collect(Collectors.toList());
                lsp.setCustomParam("rejectInitFun", (Object)"1");
                lsp.setCustomParam("orgFunScope", (Object)SerializationUtils.toJsonString(collect));
            }
        }
        lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addOrgRelation"));
        this.getView().showForm((FormShowParameter)lsp);
    }

    private void fillBackOrgF7SelectedData(Object orgData) {
        if (orgData == null) {
            return;
        }
        ArrayList<String> selectedOrgList = new ArrayList<String>();
        if (orgData instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)orgData;
            for (ListSelectedRow row : rows) {
                selectedOrgList.add(row.getPrimaryKeyValue().toString());
            }
        }
        if (selectedOrgList.isEmpty()) {
            return;
        }
        IDataModel model = this.getModel();
        TableValueSetter tvs = new TableValueSetter(new String[0]);
        tvs.addField("delegateorg", new Object[0]);
        for (int i = 0; i < selectedOrgList.size(); ++i) {
            tvs.addRow(new Object[]{selectedOrgList.get(i)});
        }
        ((AbstractFormDataModel)model).batchCreateNewEntryRow("entryentity", tvs);
    }

    private List<ComboItem> getOrgBizList() {
        String dutyComboItem = this.getPageCache().get(CK_DUTY_COMBO_ITEM);
        if (dutyComboItem != null) {
            return SerializationUtils.fromJsonStringToList((String)dutyComboItem, ComboItem.class);
        }
        QFilter baseFilter = new QFilter("isbasetype", "=", (Object)Boolean.TRUE);
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter visibleFilter = new QFilter("visiable", "=", (Object)Boolean.TRUE);
        QFilter baseMainFilter = new QFilter("basemaintain", "=", (Object)Boolean.TRUE);
        QFilter categoryFilter = new QFilter("category", "=", (Object)"1").or(new QFilter("id", "=", (Object)1L));
        QFilter[] filters = new QFilter[]{baseFilter, enableFilter, visibleFilter, categoryFilter, baseMainFilter};
        Map bizMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_biz", (String)"id,fnumber,fname", (QFilter[])filters, (String)"fnumber");
        if (bizMap.isEmpty()) {
            return new ArrayList<ComboItem>(0);
        }
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(bizMap.size());
        for (Map.Entry entry : bizMap.entrySet()) {
            DynamicObject bizObj = (DynamicObject)entry.getValue();
            ComboItem item = new ComboItem();
            item.setValue(bizObj.getString("fnumber"));
            item.setCaption(new LocaleString(bizObj.getString("fname")));
            comboItems.add(item);
        }
        this.getPageCache().put(CK_DUTY_COMBO_ITEM, SerializationUtils.toJsonString(comboItems));
        return comboItems;
    }

    private void setDutyComboEdit(boolean containHr) {
        List<ComboItem> orgBizList = this.getOrgBizList();
        if (!containHr) {
            orgBizList.removeIf(o -> o.getValue().equals("11"));
        }
        if (Utils.isListEmpty(orgBizList)) {
            return;
        }
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl("sscdutyscope");
        comboEdit.setComboItems(orgBizList);
    }

    private List<Long> getEntryOrgList() {
        DynamicObjectCollection orgEntry = this.getModel().getEntryEntity("entryentity");
        if (orgEntry.size() < 1) {
            return null;
        }
        ArrayList<Long> orgList = new ArrayList<Long>(orgEntry.size());
        for (DynamicObject orgDyn : orgEntry) {
            long id = orgDyn.getLong("delegateorg_id");
            if (id <= 0L) continue;
            orgList.add(id);
        }
        return orgList;
    }

    private List<Long> getRelationOrg() {
        DynamicObject sscOrg = (DynamicObject)this.getModel().getValue("sscorg");
        if (sscOrg == null) {
            return null;
        }
        return OrgRelationQueryHelper.loadOrgRelationFromDb((Long)sscOrg.getLong("id"));
    }

    private List<Long> notSatisfyOrg(List<String> dutyScope) {
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entryentity");
        if (ObjectUtils.isEmpty((Object)entry) || ObjectUtils.isEmpty(dutyScope)) {
            return null;
        }
        List<Long> orgList = entry.stream().map(e -> e.getLong("delegateorg_id")).collect(Collectors.toList());
        HashSet satisfyOrg = new HashSet((int)((float)orgList.size() / 0.75f) + 1);
        for (String duty : dutyScope) {
            List dutyOrg = OrgUnitServiceHelper.filterOrgDuty(orgList, (String)duty);
            if (dutyOrg == null) continue;
            satisfyOrg.addAll(dutyOrg);
        }
        orgList.removeAll(satisfyOrg);
        return orgList;
    }

    private List<Long> notSatisfyOrg(List<String> dutyScope, List<Long> orgList) {
        if (ObjectUtils.isEmpty(dutyScope) || ObjectUtils.isEmpty(orgList)) {
            return null;
        }
        ArrayList<Long> result = new ArrayList<Long>(orgList);
        HashSet satisfyOrg = new HashSet((int)((float)orgList.size() / 0.75f) + 1);
        for (String duty : dutyScope) {
            List dutyOrg = OrgUnitServiceHelper.filterOrgDuty(orgList, (String)duty);
            if (dutyOrg == null) continue;
            satisfyOrg.addAll(dutyOrg);
        }
        result.removeAll(satisfyOrg);
        return result;
    }

    private int[] getIndexByOrgId(List<Long> orgList) {
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entryentity");
        if (ObjectUtils.isEmpty((Object)entry)) {
            return null;
        }
        return entry.stream().filter(e -> orgList.contains(e.getLong("delegateorg_id"))).mapToInt(e -> e.getInt("seq") - 1).toArray();
    }

    private List<Long> queryOnlyHrOrg() {
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entryentity");
        if (ObjectUtils.isEmpty((Object)entry)) {
            return null;
        }
        List<Long> orgList = entry.stream().map(e -> e.getLong("delegateorg_id")).collect(Collectors.toList());
        QFilter idFilter = new QFilter("id", "in", orgList);
        QFilter viewFilter = new QFilter("structure.view", "!=", (Object)Long.parseLong("11"));
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"ssc.DutyManageQueryOrg", (String)"bos_org", (String)"id", (QFilter[])new QFilter[]{idFilter, viewFilter}, null);){
            ds.forEach(d -> orgList.remove(d.getLong("id")));
        }
        return orgList;
    }

    private List<Long> queryOnlyHrOrg(List<Long> orgList) {
        if (orgList == null || orgList.isEmpty()) {
            return null;
        }
        ArrayList<Long> result = new ArrayList<Long>(orgList);
        QFilter idFilter = new QFilter("id", "in", orgList);
        QFilter viewFilter = new QFilter("structure.view", "!=", (Object)Long.parseLong("11"));
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"ssc.DutyManageQueryOrg", (String)"bos_org", (String)"id", (QFilter[])new QFilter[]{idFilter, viewFilter}, null);){
            ds.forEach(d -> result.remove(d.getLong("id")));
        }
        return result;
    }

    private void handleSSCType4App() {
        IFormView view = this.getView();
        ComboEdit sscType = (ComboEdit)view.getControl("sscbusinesstype");
        String appId = view.getFormShowParameter().getAppId();
        if ("ssc".equals(appId) && sscType != null) {
            List comboItemsM = ((ComboProp)sscType.getProperty()).getComboItems();
            if (comboItemsM == null) {
                return;
            }
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(2);
            for (ValueMapItem itemM : comboItemsM) {
                String value = itemM.getValue();
                if ("3".equals(value)) continue;
                ComboItem item = new ComboItem();
                item.setValue(value);
                item.setCaption(itemM.getName());
                comboItems.add(item);
            }
            sscType.setComboItems(comboItems);
        }
    }
}

