/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.imports;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.bill.IBillView;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.list.option.ListUserOption;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.dto.ImportPermissionParam;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.mservice.ImportPermissionService;
import kd.bos.form.operate.DefaultDynamicFormOperate;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.svc.util.OpExistChecker;

public class TaskBillExportOperation
extends DefaultDynamicFormOperate
implements IConfirmCallBack {
    private static final String EXPORTPARAMETER = "ExportParameter";
    private static final String ENTITYNUMBER = "EntityNumber";
    private static final String BILLLISTAP = "billlistap";
    private static final String BOS_IMPORT_TEMPLATE = "bos_importtemplate";
    private static final String BOS_EXPORT = "bos-export";
    private ImportPermissionService importPermissionService = new ImportPermissionService();

    private boolean isBillView() {
        return this.getView() instanceof IBillView;
    }

    public boolean needSelectData() {
        return false;
    }

    protected String getTemplateType() {
        return "IMPT";
    }

    protected int checkRightInListForm(MainEntityType mainEntityType, OperationResult result) {
        this.checkPermission(result);
        return 1;
    }

    private void checkPermission(OperationResult result) {
        if (this.getView() instanceof IListView) {
            List mainOrgIds = ((IListView)this.getView()).getSelectedMainOrgIds();
            mainOrgIds.removeIf(id -> id == null);
            if (mainOrgIds.isEmpty()) {
                this.doPermission(result, this.getPermissionItemId(), 0L);
            } else {
                this.doPermission(result, this.getPermissionItemId(), mainOrgIds);
            }
        } else {
            this.doPermission(result, this.getPermissionItemId(), this.mainOrgId != null ? this.mainOrgId : 0L);
        }
    }

    protected boolean beforeInvokeOperation(OperationResult e) {
        return super.beforeInvokeOperation(e);
    }

    public OperationResult invokeOperation() {
        if (!this.isBillView() && !(this.getView() instanceof IListView)) {
            return null;
        }
        Boolean opExist = OpExistChecker.check((String)this.getEntityId(), (String)this.getType(), (IFormView)this.getView());
        if (!opExist.booleanValue()) {
            return null;
        }
        if (this.isBillView()) {
            IBillView billView = (IBillView)this.getView();
            boolean isFormDB = billView.getModel().getDataEntity().getDataEntityState().getFromDatabase();
            boolean isChange = billView.getModel().getDataChanged();
            if (isFormDB) {
                this.saveCacheForPermission(billView.getPageCache());
                billView.getPageCache().put(EXPORTPARAMETER, SerializationUtils.toJsonString((Object)this.getParameter()));
                billView.getPageCache().put(ENTITYNUMBER, this.getEntityId());
                String description = this.getExportConfirmMsg(1, isChange);
                billView.showConfirm(description, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("ExportListConfirmCallBack", (IConfirmCallBack)this));
            } else {
                billView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4fdd\u5b58\u540e\u518d\u5bfc\u51fa\u3002", (String)"TaskBillExportOperation_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            }
            return null;
        }
        IListView listview = (IListView)this.getView();
        BillList billList = (BillList)listview.getControl(BILLLISTAP);
        int billNum = billList.getSelectedRows().getPrimaryKeyValues().length;
        listview.getPageCache().put(EXPORTPARAMETER, SerializationUtils.toJsonString((Object)this.getParameter()));
        listview.getPageCache().put(ENTITYNUMBER, "task_taskbill4impt");
        if (billNum == 0) {
            if (this.isDefaultExportListAll() && (billNum = billList.queryBillDataCount()) > 0) {
                this.saveCacheForPermission(listview.getPageCache());
                String showMsg = this.getExportConfirmMsg(billNum, false);
                this.getView().showConfirm(showMsg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("ExportListConfirmCallBack", (IConfirmCallBack)this));
                return null;
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\u53ef\u4ee5\u5bfc\u51fa\u3002", (String)"TaskBillExportOperation_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        } else {
            this.export();
        }
        return null;
    }

    private String getExportConfirmMsg(int billNum, boolean isChanged) {
        String message = ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u5c06\u5bfc\u51fa%1$d\u5f20\u201c%1$s\u201d\uff0c\u786e\u5b9a\u5bfc\u51fa\uff1f", (String)"TaskBillExportOperation_3", (String)"ssc-task-formplugin", (Object[])new Object[0]);
        String displayName = ResManager.loadKDString((String)"\u5355\u636e", (String)"TaskBillExportOperation_4", (String)"ssc-task-formplugin", (Object[])new Object[0]);
        MainEntityType entityType = null;
        if (this.isBillView()) {
            IBillView billView = (IBillView)this.getView();
            entityType = billView.getModel().getDataEntityType();
            displayName = entityType.getDisplayName().toString();
            if (isChanged) {
                return String.format(ResManager.loadKDString((String)"\u5f53\u524d\u201c%1$s\u201d\u4fee\u6539\u540e\u672a\u4fdd\u5b58\uff0c\u786e\u5b9a\u5bfc\u51fa\uff1f", (String)"TaskBillExportOperation_5", (String)"ssc-task-formplugin", (Object[])new Object[0]), displayName);
            }
        } else if (this.getView() instanceof IListView) {
            IListView listview = (IListView)this.getView();
            entityType = listview.getListModel().getDataEntityType();
            displayName = entityType.getDisplayName().toString();
        }
        return String.format(message, billNum, displayName);
    }

    private void saveCacheForPermission(IPageCache pageCache) {
        String billFormId = null;
        String listName = null;
        IFormView view = this.getView();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        if (view instanceof IListView) {
            IListView listview = (IListView)view;
            FormConfig config = FormMetadataCache.getFormConfig((String)listview.getBillFormId());
            billFormId = config.getEntityTypeId();
            listName = config.getCaption().toString();
            pageCache.put("BillTypeId", "" + ((ListShowParameter)formShowParameter).getBillTypeId());
        } else if (this.isBillView()) {
            billFormId = view.getEntityId();
            String caption = formShowParameter.getCaption();
            listName = StringUtils.isNotBlank((CharSequence)caption) ? caption : (formShowParameter.getFormConfig() != null ? formShowParameter.getFormConfig().getCaption().toString() : "");
            pageCache.put("BillTypeId", "" + this.getView().getEntityId());
        }
        pageCache.put("ServiceAppId", formShowParameter.getServiceAppId());
        pageCache.put("CheckRightAppId", formShowParameter.getCheckRightAppId());
        pageCache.put("BillFormId", billFormId);
        pageCache.put("ListName", listName);
        pageCache.put("OperateKey", this.getOperateKey());
        pageCache.put("PermissionItemId", this.getPermissionItemId());
        pageCache.put("RealPermissionEntityId", this.getRealPermissionEntityId());
        ArrayList<Long> mainOrgIds = null;
        if (view instanceof IListView) {
            mainOrgIds = ((IListView)this.getView()).getSelectedMainOrgIds();
        } else if (this.mainOrgId != null) {
            mainOrgIds = new ArrayList<Long>();
            mainOrgIds.add(this.mainOrgId);
        }
        if (mainOrgIds != null && !mainOrgIds.isEmpty()) {
            pageCache.put("MainOrgIds", JSONArray.toJSONString(mainOrgIds));
        }
        pageCache.put("OperateName", this.getOperateName().toString());
    }

    private boolean isDefaultExportListAll() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (formShowParameter instanceof ListShowParameter) {
            ListShowParameter listShowParameter = (ListShowParameter)formShowParameter;
            ListUserOption listOption = listShowParameter.getListUserOption();
            if (listOption == null) {
                listOption = new ListUserOption();
            }
            return listOption.isDefaultExportListAll();
        }
        return false;
    }

    private void showProgressForm(String entitynumber, long templateId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_exportdataprogress");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        Map parameter = (Map)SerializationUtils.fromJsonString((String)this.getView().getPageCache().get(EXPORTPARAMETER), Map.class);
        Map customParams = showParameter.getCustomParams();
        customParams.put("ServiceAppId", this.getView().getFormShowParameter().getServiceAppId());
        customParams.put("entitynumber", entitynumber);
        customParams.put("entityname", StringUtils.isBlank((CharSequence)this.getView().getFormShowParameter().getCaption()) ? this.getView().getFormShowParameter().getFormConfig().getCaption().getLocaleValue() : this.getView().getFormShowParameter().getCaption());
        customParams.put("templateId", String.valueOf(templateId));
        customParams.put("fillparent", String.valueOf("EXPT".equals(this.getTemplateType())));
        customParams.put("byList", String.valueOf(parameter.get("byList")));
        customParams.put("billViewExport", this.isBillView());
        customParams.put("EXPORT_LIST_TYPE", this.getTemplateType());
        this.getView().showForm(showParameter);
    }

    private void export() {
        DynamicObject template = QueryServiceHelper.queryOne((String)BOS_IMPORT_TEMPLATE, (String)"id", (QFilter[])new QFilter("id", "=", (Object)1465052565409675264L).toArray());
        if (template == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u7684\u4e1a\u52a1\u5355\u636e\u5f15\u5165\u6a21\u677f\u4e0d\u5b58\u5728\u3002", (String)"TaskBillExportOperation_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        String entityNumber = this.getView().getPageCache().get(ENTITYNUMBER);
        this.showProgressForm(entityNumber, template.getLong("id"));
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (messageBoxClosedEvent.getResult() != MessageBoxResult.Yes) {
            return;
        }
        try {
            this.handleCancelDataRight();
            this.handleCancelRight();
        }
        catch (KDBizException e) {
            this.getView().showErrorNotification(e.getMessage());
            return;
        }
        if (!this.checkPermission()) {
            return;
        }
        this.export();
    }

    private void handleCancelDataRight() {
        if (!this.getView().getFormShowParameter().isCancelDataRight()) {
            return;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u7684\u6570\u636e\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"TaskBillExportOperation_6", (String)"ssc-task-formplugin", (Object[])new Object[0]));
    }

    private void handleCancelRight() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (formShowParameter.getCancelRight() == 0) {
            return;
        }
        FormConfig config = formShowParameter.getFormConfig();
        String formName = config.getCaption().toString();
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u60a8\u7684\u201c%1$s\u201d\u529f\u80fd\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"TaskBillExportOperation_7", (String)"ssc-task-formplugin", (Object[])new Object[0]), formName));
    }

    private boolean checkPermission() {
        OperationResult result = new OperationResult();
        IFormView view = this.getView();
        String orgIdsStr = view.getPageCache().get("MainOrgIds");
        ImportPermissionParam.Buidler importPermissionParamBuidler = new ImportPermissionParam.Buidler().setBizAppId(view.getPageCache().get("CheckRightAppId")).setMainOrgIds(StringUtils.isNotBlank((CharSequence)orgIdsStr) ? JSONObject.parseArray((String)orgIdsStr, Long.class) : new ArrayList(0)).setRealEntityId(view.getPageCache().get("RealPermissionEntityId")).setCurrentEntityId(view.getPageCache().get("BillFormId")).setOperateName(view.getPageCache().get("OperateName")).setPermissionItemId(view.getPageCache().get("PermissionItemId")).setResult(result);
        if (!this.importPermissionService.validatePermission(importPermissionParamBuidler.build())) {
            this.importPermissionService.doFailCheckRight(this.getView(), result);
            return false;
        }
        return true;
    }
}

