/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.indicators;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ValueTextItem;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.ssc.task.business.indicators.CalFormulaUtil;

public class ReportSchemeListPlugin
extends AbstractListPlugin {
    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"_toolbar_"});
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        BillShowParameter bsp = e.getParameter();
        if (BillOperationStatus.ADDNEW == bsp.getBillStatus()) {
            Object org;
            IListView listView = (IListView)this.getView();
            ControlFilters filters = listView.getControlFilters();
            if (filters == null) {
                return;
            }
            List orgFilters = filters.getFilter("useorg.id");
            if (CollectionUtils.isEmpty((Collection)orgFilters)) {
                orgFilters = filters.getFilter("useorg.name");
                org = null;
            } else {
                org = orgFilters.get(0);
            }
            bsp.setCustomParam("createorg", org);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (operateKey.equals("showreport")) {
            BillList billList = (BillList)this.getControl("billlistap");
            Long id = (Long)billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
            ListShowParameter listShowParameter = new ListShowParameter();
            listShowParameter.setBillFormId("som_report");
            listShowParameter.setFormId("bos_list");
            listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            QFilter filter = new QFilter("reportscheme", "=", (Object)id);
            listShowParameter.getListFilterParameter().setFilter(filter);
            listShowParameter.setCustomParam("sscId", (Object)this.getPageCache().get("createOrg"));
            this.getView().showForm((FormShowParameter)listShowParameter);
        } else if ("generatereport".equals(operateKey)) {
            ListSelectedRowCollection rows = this.getSelectedRows();
            if (rows.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ReportSchemeListPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            if (rows.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5355\u65b9\u6848\u751f\u6210\u62a5\u544a\u3002", (String)"ReportSchemeListPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            Object id = rows.get(0).getPrimaryKeyValue();
            DynamicObject dy = BusinessDataServiceHelper.loadSingle((Object)id, (String)"som_reportscheme");
            if (dy.getString("enable").equals("0")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u542f\u7528\u7684\u6570\u636e\u3002", (String)"ReportSchemeListPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject report = BusinessDataServiceHelper.newDynamicObject((String)"som_report");
            report.set("creator", dy.get("creator"));
            report.set("org", dy.get("org"));
            report.set("billstatus", (Object)"A");
            report.set("reportscheme", id);
            report.set("reportperiod", dy.get("reportperiod"));
            report.set("monitortypeselect", dy.get("monitortypeselect"));
            report.set("monitortext", dy.get("monitortext"));
            report.set("indicatortext_tag", (Object)this.calIndicators((Long)id));
            SaveServiceHelper.saveOperate((String)"som_report", (DynamicObject[])new DynamicObject[]{report}, (OperateOption)OperateOption.create());
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u751f\u6210\u62a5\u544a\u6210\u529f\u3002", (String)"ReportSchemeListPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
    }

    private String calIndicators(Long reportSchemeId) {
        DynamicObject reportScheme = BusinessDataServiceHelper.loadSingle((Object)reportSchemeId, (String)"som_reportscheme");
        String monitorType = reportScheme.getString("monitortypeselect");
        List monitors = null;
        if (!"taskusermonitor".equals(monitorType)) {
            DynamicObjectCollection dys = reportScheme.getDynamicObjectCollection(monitorType);
            monitors = dys.stream().map(dy -> dy.getLong("fbasedataid.id")).collect(Collectors.toList());
        } else {
            List taskUserMonitors = JSONArray.parseArray((String)reportScheme.getString("taskusermonitor_tag")).toJavaList(ValueTextItem.class);
            monitors = taskUserMonitors.stream().map(valueTextItem -> Long.valueOf(valueTextItem.getValue())).collect(Collectors.toList());
            QFilter idFilter = new QFilter("id", "in", monitors);
            DynamicObject[] taskUsers = BusinessDataServiceHelper.load((String)"task_user", (String)"entryid,userfield.id,userfield.name", (QFilter[])new QFilter[]{idFilter});
            monitors = Arrays.stream(taskUsers).map(dynamicObject -> dynamicObject.getLong("userfield.id")).collect(Collectors.toList());
        }
        DynamicObjectCollection entry = reportScheme.getDynamicObjectCollection("entryentity");
        ArrayList<Long> indicatorIds = new ArrayList<Long>(entry.size());
        ArrayList<Map<String, Object>> columnInfo = new ArrayList<Map<String, Object>>(entry.size());
        columnInfo.add(this.getPublicColumnInfo());
        for (DynamicObject dy2 : entry) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            long id = dy2.getLong("indicator_id");
            String name = dy2.getString("indicator.name");
            String number = dy2.getString("indicator.number");
            String type = dy2.getString("indicatortype");
            indicatorIds.add(id);
            map.put("columnId", id);
            map.put("columnName", name);
            map.put("columnNumber", number);
            map.put("columnType", type);
            columnInfo.add(map);
        }
        Map rows = CalFormulaUtil.calculateIndicators(indicatorIds, monitors);
        if (rows == null || rows.isEmpty()) {
            return "";
        }
        Map<String, String> result = null;
        Map<Object, String> monitor = null;
        if (!"taskusermonitor".equals(monitorType)) {
            DynamicObjectCollection dys = reportScheme.getDynamicObjectCollection(monitorType);
            Map<Object, String> monitorMap = dys.stream().collect(Collectors.toMap(dy -> ((DynamicObject)dy.get("fbasedataid")).getPkValue(), dy -> ((DynamicObject)dy.get("fbasedataid")).getLocaleString("name").getLocaleValue()));
            result = rows.entrySet().stream().collect(Collectors.toMap(e -> (String)monitorMap.get(e.getKey()), Map.Entry::getValue));
            monitor = monitorMap;
        } else {
            List taskUserMonitors = JSONArray.parseArray((String)reportScheme.getString("taskusermonitor_tag")).toJavaList(ValueTextItem.class);
            List taskUserIds = taskUserMonitors.stream().map(taskUser -> Long.valueOf(taskUser.getValue())).collect(Collectors.toList());
            QFilter idFilter = new QFilter("id", "in", taskUserIds);
            DynamicObject[] taskUsers = BusinessDataServiceHelper.load((String)"task_user", (String)"entryid,userfield.id,userfield.name", (QFilter[])new QFilter[]{idFilter});
            monitor = Arrays.stream(taskUsers).collect(Collectors.toMap(d -> d.get("userfield.id"), d -> d.getString("userfield.name")));
            Map<Object, String> monitorMap = monitor;
            result = rows.entrySet().stream().collect(Collectors.toMap(e -> (String)monitorMap.get(e.getKey()), Map.Entry::getValue));
        }
        String columnInfoStr = SerializationUtils.toJsonString(columnInfo);
        String rowDataStr = SerializationUtils.toJsonString(result);
        HashMap<String, String> indicatorInfo = new HashMap<String, String>();
        indicatorInfo.put("columnInfo", columnInfoStr);
        indicatorInfo.put("rowData", rowDataStr);
        return SerializationUtils.toJsonString(indicatorInfo);
    }

    private Map<String, Object> getPublicColumnInfo() {
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put("columnName", ResManager.loadKDString((String)"\u76d1\u63a7\u5bf9\u8c61", (String)"ReportSchemeListPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        map.put("columnNumber", "monitor");
        map.put("columnType", "-1");
        map.put("columnId", "-1");
        return map;
    }
}

