/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.rpt;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.ExportExcel;
import kd.bos.orm.query.QFilter;
import kd.bos.report.events.SortAndFilterEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.ssc.task.business.task.OrgF7ViewShowHelper;
import kd.ssc.task.cache.CacheKey;
import kd.ssc.task.common.CommonFilterUtil;
import kd.ssc.task.formplugin.rpt.TaskRptHelper;
import kd.ssc.task.formplugin.util.SscUtil;

public class RptTaskQualityDetailFormPlugin
extends AbstractReportFormPlugin {
    private List<FilterColumn> commonFilters = null;

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object operation = args.getSource();
        if (operation instanceof ExportExcel) {
            int isPermission;
            Long userId = RequestContext.get().getCurrUserId();
            Long sscId = Long.parseLong(this.getPageCache().get("rptTaskQualityDetail_sscid.id"));
            String appId = this.getView().getFormShowParameter().getAppId();
            if (StringUtils.isBlank((CharSequence)appId)) {
                appId = "ssc";
            }
            if ((isPermission = PermissionServiceHelper.checkPermission((Long)userId, (Long)sscId, (String)"12", (String)appId, (String)"task_taskqualitydetailrpt", (String)"4730fc9f000004ae")) != 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u4efb\u52a1\u8d28\u91cf\u660e\u7ec6\u62a5\u8868\u201d\u7684\u201c\u5bfc\u51fa\u201d\u7684\u6743\u9650\u3002", (String)"RptTaskQualityDetailFormPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void processRowData(String gridId, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        for (DynamicObject dynamicObject : rowData) {
            String spendtime = (String)dynamicObject.get("spendtime");
            if (spendtime == null || spendtime.trim().equals("")) {
                dynamicObject.set("spendtime", (Object)"");
                continue;
            }
            int seconds = (int)(Double.parseDouble(spendtime) * 3600.0);
            StringBuilder sb = new StringBuilder();
            int hour = seconds / 3600;
            int minute = seconds % 3600 / 60;
            int second = seconds % 3600 % 60;
            sb.append(hour).append(':');
            if (minute < 10) {
                sb.append('0').append(minute).append(':');
            } else {
                sb.append(minute).append(':');
            }
            if (second < 10) {
                sb.append('0').append(second);
            } else {
                sb.append(second);
            }
            dynamicObject.set("spendtime", (Object)sb.toString());
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        FilterItemInfo itemInfoComm = filterInfo.getFilterItem("sharecenter.id");
        FilterItemInfo itemInfoSche = filterInfo.getFilterItem("sharecenter.name");
        if (itemInfoComm == null && itemInfoSche == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5171\u4eab\u4e2d\u5fc3\u3002", (String)"RptTaskQualityDetailFormPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected void filterContainerInit(FilterContainerInitEvent contInitEvent, ReportQueryParam queryParam) {
        super.filterContainerInit(contInitEvent, queryParam);
        String sscid = "-1";
        this.commonFilters = contInitEvent.getCommonFilterColumns();
        if (this.getPageCache().get(CacheKey.getSSCKey((Object)"rptTaskQualityDetailFirstRoad")) == null) {
            for (FilterColumn filterColumn : this.commonFilters) {
                String fieldName;
                CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
                switch (fieldName = commonFilterColumn.getFieldName()) {
                    case "sharecenter.name": {
                        List sscItems = commonFilterColumn.getComboItems();
                        Long orgId = RequestContext.get().getOrgId();
                        sscid = TaskRptHelper.getDefSscId(sscItems, orgId);
                        commonFilterColumn.setDefaultValue(sscid);
                        commonFilterColumn.setDefValue(sscid);
                        commonFilterColumn.setMustInput(true);
                        this.getPageCache().put(CacheKey.getSSCKey((Object)"rptTaskQualityDetailFirstRoad"), "true");
                        if (this.getPageCache().getAll().containsKey("rptTaskQualityDetail_sscid.id")) break;
                        this.getPageCache().put("rptTaskQualityDetail_sscid.id", sscid);
                        break;
                    }
                    case "orgcommonfilter": {
                        QFilter filter = CommonFilterUtil.getDeputeOrgOfSSCCenterFilter(this.getPageCache(), "rptTaskQualityDetailOrgFilter", sscid);
                        CommonFilterUtil.resetComboItems(this.getPageCache(), "rptTaskQualityDetailOrg", commonFilterColumn, "bos_org", filter, sscid, true);
                        break;
                    }
                    case "date": {
                        filterColumn.setDefaultValue("92");
                        break;
                    }
                    case "tasktypefilter": {
                        if (!StringUtils.isNotBlank((CharSequence)sscid)) break;
                        QFilter idFilter = new QFilter("orgfield.id", "=", (Object)Long.valueOf(sscid));
                        QFilter judgeFilter = new QFilter("qualityjudge", "=", (Object)"0");
                        CommonFilterUtil.resetComboItems(this.getPageCache(), "rptTaskQualityDetailTaskType", commonFilterColumn, "task_tasktype", idFilter.and(judgeFilter), sscid, true);
                        break;
                    }
                    case "jobstate": {
                        List comboItems = commonFilterColumn.getComboItems();
                        if (comboItems.size() <= 0) break;
                        commonFilterColumn.setDefaultValue(((ComboItem)comboItems.get(0)).getValue());
                        break;
                    }
                    case "billtypecommonfilter": {
                        if (!StringUtils.isNotBlank((CharSequence)sscid)) break;
                        QFilter filter = new QFilter("ssccenter.id", "=", (Object)Long.valueOf(sscid));
                        CommonFilterUtil.resetComboItems(this.getPageCache(), "rptTaskQualityDetailBillType", commonFilterColumn, "task_taskbill", filter, sscid, true);
                        break;
                    }
                }
            }
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        String currentFieldName;
        Map currentFilter = args.getCurrentCommonFilter();
        List currentFieldNames = (List)currentFilter.get("FieldName");
        if (currentFieldNames != null && !currentFieldNames.isEmpty() && "sharecenter.id".equalsIgnoreCase(currentFieldName = currentFieldNames.get(0).toString())) {
            List sscidValues = (List)currentFilter.get("Value");
            String sscid = "";
            if (sscidValues != null && !sscidValues.isEmpty()) {
                sscid = (String)sscidValues.get(0);
            }
            if (!sscid.equals(this.getPageCache().get("rptTaskQualityDetail_sscid.id"))) {
                this.getPageCache().put("rptTaskQualityDetail_sscid.id", sscid);
                Map filterValues = args.getSearchClickEvent().getFilterValues();
                List customFiterList = (List)filterValues.get("customfilter");
                for (Map filter : customFiterList) {
                    List fieldNames = (List)filter.get("FieldName");
                    if (fieldNames == null || fieldNames.isEmpty()) continue;
                    String fieldName = fieldNames.get(0).toString();
                    if ("tasktypefilter.id".equalsIgnoreCase(fieldName)) {
                        filter.replace("Value", Collections.singletonList(""));
                    }
                    if ("orgcommonfilter.id".equalsIgnoreCase(fieldName)) {
                        filter.replace("Value", Collections.singletonList(""));
                    }
                    if (!"billtypecommonfilter.id".equalsIgnoreCase(fieldName)) continue;
                    filter.replace("Value", Collections.singletonList(""));
                }
                List filterItems = this.getQueryParam().getFilter().getFilterItems();
                Iterator iterator = filterItems.iterator();
                while (iterator.hasNext()) {
                    FilterItemInfo next = (FilterItemInfo)iterator.next();
                    String propName = next.getPropName();
                    if ("sharecenter.id".equals(propName) || "completetime".equals(propName) || "jobstate".equals(propName)) continue;
                    iterator.remove();
                }
            }
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String name = args.getFieldName();
        List qfilters = args.getQfilters();
        String sscIDStr = this.getPageCache().get("rptTaskQualityDetail_sscid.id");
        if (kd.bos.util.StringUtils.isNotEmpty((String)sscIDStr)) {
            if ("tasktypefilter.id".equals(name)) {
                qfilters.add(new QFilter("orgfield", "=", (Object)Long.valueOf(sscIDStr)));
                qfilters.add(new QFilter("qualityjudge", "=", (Object)"0"));
            } else if ("billtypecommonfilter.id".equals(name)) {
                qfilters.add(new QFilter("ssccenter", "=", (Object)Long.valueOf(sscIDStr)));
            } else if ("orgcommonfilter.id".equals(name)) {
                OrgF7ViewShowHelper.beforeFilterContainerF7((BeforeFilterF7SelectEvent)args, (Long)Long.parseLong(sscIDStr));
            }
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        if (this.commonFilters == null || this.commonFilters.size() == 0) {
            return;
        }
        for (FilterColumn filterColumn : this.commonFilters) {
            Object sscFilterValue;
            String comType;
            FilterItemInfo oItemInfo;
            FilterInfo oFilterInfo;
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if ("tasktypefilter".equalsIgnoreCase(fieldName)) {
                oFilterInfo = queryParam.getFilter();
                oItemInfo = oFilterInfo.getFilterItem("sharecenter.id");
                if (oItemInfo == null) continue;
                comType = oItemInfo.getCompareType();
                sscFilterValue = oItemInfo.getValue();
                QFilter idFilter = new QFilter("orgfield.id", comType, sscFilterValue);
                QFilter judgeFilter = new QFilter("qualityjudge", "=", (Object)"0");
                CommonFilterUtil.resetComboItems(this.getPageCache(), "rptTaskQualityDetailTaskType", commonFilterColumn, "task_tasktype", idFilter.and(judgeFilter), sscFilterValue, true);
                continue;
            }
            if ("orgcommonfilter".equalsIgnoreCase(fieldName)) {
                QFilter filter;
                oFilterInfo = queryParam.getFilter();
                oItemInfo = oFilterInfo.getFilterItem("sharecenter.id");
                if (oItemInfo == null) continue;
                Object sscFilterValue2 = oItemInfo.getValue();
                if (sscFilterValue2 instanceof List) {
                    List sscValues = (List)sscFilterValue2;
                    filter = CommonFilterUtil.getDeputeOrgOfSSCCenterFilter(this.getPageCache(), "rptTaskQualityDetailOrgFilter", sscValues.get(0));
                    for (int i = 1; i < sscValues.size(); ++i) {
                        filter.or(CommonFilterUtil.getDeputeOrgOfSSCCenterFilter(this.getPageCache(), "rptTaskQualityDetailOrgFilter", sscValues.get(i)));
                    }
                } else {
                    filter = CommonFilterUtil.getDeputeOrgOfSSCCenterFilter(this.getPageCache(), "rptTaskQualityDetailOrgFilter", sscFilterValue2);
                }
                CommonFilterUtil.resetComboItems(this.getPageCache(), "rptTaskQualityDetailOrg", commonFilterColumn, "bos_org", filter, sscFilterValue2, true);
                continue;
            }
            if (!"billtypecommonfilter".equalsIgnoreCase(fieldName) || (oItemInfo = (oFilterInfo = queryParam.getFilter()).getFilterItem("sharecenter.id")) == null) continue;
            comType = oItemInfo.getCompareType();
            sscFilterValue = oItemInfo.getValue();
            QFilter filter = new QFilter("ssccenter.id", comType, sscFilterValue);
            CommonFilterUtil.resetComboItems(this.getPageCache(), "rptTaskQualityDetailBillType", commonFilterColumn, "task_taskbill", filter, sscFilterValue, true);
        }
    }

    public void setSortAndFilter(List<SortAndFilterEvent> list) {
        super.setSortAndFilter(list);
        for (SortAndFilterEvent event : list) {
            if (!"user".equals(event.getColumnName())) continue;
            event.setSort(false);
            event.setFilter(true);
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        List<Long> allPermSSC = SscUtil.getAllPermSSC(RequestContext.get().getCurrUserId(), "task_taskqualitydetailrpt", e.getFormShowParameter().getAppId());
        if (allPermSSC.size() == 0) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u65e0\u5f53\u524d\u83dc\u5355\u6743\u9650\u3002", (String)"RptTaskQualityDetailFormPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
    }
}

