/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.rpt;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.ssc.enums.TaskStateEnum;
import kd.ssc.task.common.TaskFilterEnum;

public class RptTaskQualityDetailPlugin
extends AbstractReportListDataPlugin {
    private static String[] selTask = new String[]{"id", "orgname", "tasktype", "billtype", "subject", "receivetime", "levelname", "user", "spendtime"};
    private static String[] selState = new String[]{"jobid", "handletime", "message", "operation", "state"};

    public DataSet query(ReportQueryParam param, Object obj) throws Throwable {
        List filterItems = param.getFilter().getFilterItems();
        List headitems = param.getFilter().getTableHeadFilterItems();
        filterItems.addAll(headitems);
        DataSet taskDataSet = null;
        DataSet stateDataSet = null;
        DataSet taskHisDataSet = null;
        DataSet stateHisDateSet = null;
        DataSet unionDataSet = null;
        taskDataSet = this.getTaskDataSet(param, obj);
        stateDataSet = this.getStateDataSet(param, obj);
        taskHisDataSet = this.getTaskHisDataSet(param, obj);
        stateHisDateSet = this.getStateHisDataSet(param, obj);
        DataSet taskStateDataSet = taskDataSet.join(stateDataSet, JoinType.INNER).select(selTask, selState).on("id", "jobid").finish();
        DataSet taskStateHisDataSet = taskHisDataSet.join(stateHisDateSet, JoinType.INNER).select(selTask, selState).on("id", "jobid").finish();
        unionDataSet = taskStateDataSet.union(taskStateHisDataSet);
        return unionDataSet.orderBy(new String[]{"orgname", "tasktype", "billtype", "user"});
    }

    private DataSet getStateHisDataSet(ReportQueryParam param, Object obj) {
        ORM orm = ORM.create();
        String selField = this.getFields(param, "stateFlag");
        QFilter[] filters = this.getFilters(param, "stateFlag");
        DataSet queryDataSet = orm.queryDataSet("task_stateHis", "task_statechangehis", selField, filters);
        return queryDataSet;
    }

    private DataSet getTaskHisDataSet(ReportQueryParam param, Object obj) {
        ORM orm = ORM.create();
        String selField = this.getFields(param, "taskFlag");
        QFilter[] filters = this.getFilters(param, "taskFlag");
        DataSet queryDataSet = orm.queryDataSet("task_taskHis", "task_taskhistory", selField, filters);
        return queryDataSet;
    }

    private DataSet getStateDataSet(ReportQueryParam param, Object obj) {
        ORM orm = ORM.create();
        String selField = this.getFields(param, "stateFlag");
        QFilter[] filters = this.getFilters(param, "stateFlag");
        DataSet queryDataSet = orm.queryDataSet("task_state", "task_statechange", selField, filters);
        return queryDataSet;
    }

    private DataSet getTaskDataSet(ReportQueryParam param, Object obj) {
        ORM orm = ORM.create();
        String selField = this.getFields(param, "taskFlag");
        QFilter[] filters = this.getFilters(param, "taskFlag");
        DataSet queryDataSet = orm.queryDataSet("task_task", "task_task", selField, filters);
        return queryDataSet;
    }

    private QFilter[] getFilters(ReportQueryParam param, String flag) {
        ArrayList<QFilter> qfList = new ArrayList<QFilter>(10);
        QFilter qFilter = null;
        QFilter notQuaCheckTask = new QFilter("qualitysamplelibrary", "=", (Object)TaskFilterEnum.NOTQUACHECKTASK);
        FilterInfo filter = param.getFilter();
        List filterItems = filter.getFilterItems();
        if ("taskFlag".equals(flag)) {
            qfList.add(notQuaCheckTask);
            block16: for (FilterItemInfo itemInfo : filterItems) {
                String propName = itemInfo.getPropName();
                if ("sharecenter.id".equals(propName)) {
                    qFilter = new QFilter("sscid.id", itemInfo.getCompareType(), itemInfo.getValue());
                    qfList.add(qFilter);
                    continue;
                }
                if ("tasktypefilter.id".equals(propName)) {
                    qFilter = new QFilter("tasktypeid.id", itemInfo.getCompareType(), itemInfo.getValue());
                    qfList.add(qFilter);
                    continue;
                }
                if ("handleperson".equals(propName)) {
                    qFilter = new QFilter("personid.id", itemInfo.getCompareType(), itemInfo.getValue());
                    qfList.add(qFilter);
                    continue;
                }
                if ("org".equals(propName) || "orgcommonfilter.id".equals(propName)) {
                    qFilter = new QFilter("orgid.id", itemInfo.getCompareType(), itemInfo.getValue());
                    qfList.add(qFilter);
                    continue;
                }
                if ("billtypename".equals(propName) || "billtypecommonfilter.id".equals(propName)) {
                    qFilter = new QFilter("billtype.id", itemInfo.getCompareType(), itemInfo.getValue());
                    qfList.add(qFilter);
                    continue;
                }
                if ("levelnamefilter".equals(propName)) {
                    qFilter = new QFilter("tasklevelid.id", itemInfo.getCompareType(), itemInfo.getValue());
                    qfList.add(qFilter);
                    continue;
                }
                if ("subjectfilter".equals(propName)) {
                    qFilter = new QFilter("subject", itemInfo.getCompareType(), itemInfo.getValue());
                    qfList.add(qFilter);
                    continue;
                }
                if (!"user".equalsIgnoreCase(propName)) continue;
                switch (itemInfo.getCompareType()) {
                    case "LIKE": {
                        qFilter = new QFilter("personid.name", itemInfo.getCompareType(), (Object)("%" + itemInfo.getValue() + "%"));
                        qfList.add(qFilter);
                        continue block16;
                    }
                    case "NOT LIKE": {
                        qFilter = new QFilter("personid.name", itemInfo.getCompareType(), (Object)("%" + itemInfo.getValue() + "%"));
                        qfList.add(qFilter);
                        continue block16;
                    }
                    case "lIKE": {
                        qFilter = new QFilter("personid.name", itemInfo.getCompareType(), (Object)(itemInfo.getValue() + "%"));
                        qfList.add(qFilter);
                        continue block16;
                    }
                    case "like": {
                        qFilter = new QFilter("personid.name", itemInfo.getCompareType(), (Object)("%" + itemInfo.getValue()));
                        qfList.add(qFilter);
                        continue block16;
                    }
                    case "NOTISNULL": {
                        qFilter = new QFilter("personid.name", "is not null", (Object)"");
                        qfList.add(qFilter);
                        continue block16;
                    }
                    case "ISNULL": {
                        qFilter = new QFilter("personid.name", "is null", (Object)"");
                        qfList.add(qFilter);
                        continue block16;
                    }
                }
                qFilter = new QFilter("personid.name", itemInfo.getCompareType(), itemInfo.getValue());
                qfList.add(qFilter);
            }
        } else if ("stateFlag".equals(flag)) {
            FilterItemInfo operationFilter;
            FilterItemInfo filterItem;
            List dateFilter = filter.getFilterItems("date");
            if (dateFilter != null) {
                qFilter = new QFilter("changetime", ((FilterItemInfo)dateFilter.get(0)).getCompareType(), ((FilterItemInfo)dateFilter.get(0)).getValue());
                qfList.add(qFilter);
                qFilter = new QFilter("changetime", ((FilterItemInfo)dateFilter.get(1)).getCompareType(), ((FilterItemInfo)dateFilter.get(1)).getValue());
                qfList.add(qFilter);
            }
            if ((filterItem = filter.getFilterItem("jobstate")) == null) {
                ArrayList<String> stateList = new ArrayList<String>();
                stateList.add(TaskStateEnum.AUDIT_PASSED.getValue());
                stateList.add(TaskStateEnum.AUDIT_NOTPASSED.getValue());
                stateList.add(TaskStateEnum.PAUSE.getValue());
                stateList.add(TaskStateEnum.RESCAN.getValue());
                qFilter = new QFilter("newjobstate", "in", stateList);
                qfList.add(qFilter);
            } else {
                qFilter = new QFilter("newjobstate", filterItem.getCompareType(), filterItem.getValue());
                qfList.add(qFilter);
            }
            FilterItemInfo messageFilter = filter.getFilterItem("messagefilter");
            if (messageFilter != null) {
                qFilter = new QFilter("message", messageFilter.getCompareType(), messageFilter.getValue());
                qfList.add(qFilter);
            }
            if ((operationFilter = filter.getFilterItem("operationfilter")) != null) {
                qFilter = new QFilter("operation", operationFilter.getCompareType(), operationFilter.getValue());
                qfList.add(qFilter);
            }
        }
        return qfList.toArray(new QFilter[qfList.size()]);
    }

    private String getFields(ReportQueryParam param, String flag) {
        String s = null;
        if ("taskFlag".equals(flag)) {
            s = "id,orgid.name as orgname,tasktypeid.name as tasktype,billtype.name as billtype,subject,receivetime,tasklevelid.name as levelname,personid.id as user, costwaittime as spendtime";
        } else if ("stateFlag".equals(flag)) {
            s = "jobid,changetime as handletime,message,operation,newjobstate as state";
        }
        return s;
    }
}

