/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.rpt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.ssc.task.cache.CacheKey;
import kd.ssc.task.common.CommonFilterUtil;
import kd.ssc.task.formplugin.rpt.TaskRptHelper;
import kd.ssc.task.formplugin.util.SscUtil;

public class RptUnpassCheckPointFormPlugin
extends AbstractReportFormPlugin {
    private static final String KEY_RPTQCUNPASS_FIRSTROAD = "rptQCUnpassFirstRoad";
    private List<FilterColumn> commonFilters;

    public void processRowData(String gridId, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        for (DynamicObject row : rowData) {
            int taskcount = row.getInt("taskcount");
            int unpasstime = row.getInt("unpasstime");
            int totalunpasstime = row.getInt("totalunpasstime");
            if (taskcount != 0) {
                row.set("unpassrate", (Object)(100.0 * (double)unpasstime / (double)taskcount));
            } else {
                row.set("unpassrate", (Object)0);
            }
            if (totalunpasstime != 0) {
                row.set("unpasspercent", (Object)(100.0 * (double)unpasstime / (double)totalunpasstime));
                continue;
            }
            row.set("unpasspercent", (Object)0);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        String valueStr = (String)this.getModel().getValue("dimension");
        FilterInfo filterInfo = queryParam.getFilter();
        FilterItemInfo itemInfo = filterInfo.getFilterItem("dimension");
        if ("alldim".equalsIgnoreCase(valueStr)) {
            if (itemInfo != null) {
                itemInfo.setValue(null);
            }
            return;
        }
        ArrayList<String> dimensionlist = new ArrayList<String>();
        dimensionlist.add(valueStr);
        if (itemInfo != null) {
            itemInfo.setValue(dimensionlist);
            return;
        }
        filterInfo.addFilterItem("dimension", dimensionlist, "in");
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        List<String> nullFieldValues0 = Arrays.asList("tasktype.id", "taskbill.id");
        String cacheSscId = CommonFilterUtil.handleMultiSelectSSC(args, "sharecenter.id", nullFieldValues0);
        if (CommonFilterUtil.hasSsc(cacheSscId)) {
            this.getPageCache().put("sscid", CommonFilterUtil.getSscIdListString(cacheSscId));
        }
        if (this.commonFilters != null && this.commonFilters.size() > 0) {
            List<String> nullFieldValues = Arrays.asList("org.id", "qualitycheckscheme.id");
            String sscId = CommonFilterUtil.handleMultiSelectSSC(args, "sharecenter.id", nullFieldValues);
            for (FilterColumn filterColumn : this.commonFilters) {
                CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
                String fieldName = commonFilterColumn.getFieldName();
                if ("org".equalsIgnoreCase(fieldName)) {
                    if (!CommonFilterUtil.hasSsc(sscId)) continue;
                    QFilter filter = CommonFilterUtil.getDeputeOrgOfSSCCenterFilter(this.getPageCache(), "qualityCheckFail_orgFilter", sscId);
                    CommonFilterUtil.resetComboItems(this.getPageCache(), "qualityCheckFail_org", commonFilterColumn, "bos_org", filter, sscId, false);
                    continue;
                }
                if (!"qualitycheckscheme".equalsIgnoreCase(fieldName) || !CommonFilterUtil.hasSsc(sscId)) continue;
                List<Long> sscIdList = CommonFilterUtil.getSscIdList(sscId);
                QFilter filter = new QFilter("ssccenter.id", "in", sscIdList);
                filter.and(new QFilter("status", "=", (Object)"C"));
                CommonFilterUtil.resetComboItems(this.getPageCache(), "qualityCheckFail_schemeId", commonFilterColumn, "task_qualitycheckscheme", filter, "createtime desc", sscId, false);
                sscIdList.forEach(id -> CommonFilterUtil.createSmartSchemeFilter(commonFilterColumn, id));
            }
            Map currentCommonFilter = args.getCurrentCommonFilter();
            if ("sharecenter.id".equals(((List)currentCommonFilter.get("FieldName")).get(0))) {
                List filterItems = this.getQueryParam().getFilter().getFilterItems();
                Iterator iterator = filterItems.iterator();
                while (iterator.hasNext()) {
                    FilterItemInfo next = (FilterItemInfo)iterator.next();
                    String propName = next.getPropName();
                    if ("sharecenter.id".equals(propName) || "completetime".equals(propName) || "aduittype".equals(propName)) continue;
                    iterator.remove();
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if ("dimension".equalsIgnoreCase(propertyName)) {
            this.getView().refresh();
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        FilterItemInfo itemInfoComm = filterInfo.getFilterItem("sharecenter.id");
        FilterItemInfo itemInfoSche = filterInfo.getFilterItem("sharecenter.name");
        if (itemInfoComm == null && itemInfoSche == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5171\u4eab\u4e2d\u5fc3\u3002", (String)"RptUnpassCheckPointFormPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected void filterContainerInit(FilterContainerInitEvent contInitEvent, ReportQueryParam queryParam) {
        super.filterContainerInit(contInitEvent, queryParam);
        String sscId = "-1";
        this.commonFilters = contInitEvent.getCommonFilterColumns();
        if (this.getPageCache().get(CacheKey.getSSCKey((Object)KEY_RPTQCUNPASS_FIRSTROAD)) == null) {
            for (FilterColumn filterColumn : contInitEvent.getCommonFilterColumns()) {
                QFilter filter;
                CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
                String fieldName = commonFilterColumn.getFieldName();
                if ("sharecenter.name".equals(fieldName)) {
                    List sscItems = commonFilterColumn.getComboItems();
                    Long orgId = RequestContext.get().getOrgId();
                    sscId = TaskRptHelper.getDefSscId(sscItems, orgId);
                    commonFilterColumn.setDefaultValue(sscId);
                    commonFilterColumn.setDefValue(sscId);
                    commonFilterColumn.setMustInput(true);
                    this.getPageCache().put("sscid", sscId);
                    this.getPageCache().put(CacheKey.getSSCKey((Object)KEY_RPTQCUNPASS_FIRSTROAD), "true");
                    continue;
                }
                if ("completetime".equals(fieldName)) {
                    filterColumn.setDefaultValue("63");
                    continue;
                }
                if ("org".equals(fieldName)) {
                    filter = CommonFilterUtil.getDeputeOrgOfSSCCenterFilter(this.getPageCache(), "qualityCheckFail_orgFilter", sscId);
                    CommonFilterUtil.resetComboItems(this.getPageCache(), "qualityCheckFail_org", commonFilterColumn, "bos_org", filter, sscId, false);
                    continue;
                }
                if (!"qualitycheckscheme".equals(fieldName) || !StringUtils.isNotBlank((CharSequence)sscId)) continue;
                filter = new QFilter("ssccenter.id", "=", (Object)Long.valueOf(sscId));
                filter.and(new QFilter("status", "=", (Object)"C"));
                CommonFilterUtil.resetComboItems(this.getPageCache(), "qualityCheckFail_schemeId", commonFilterColumn, "task_qualitycheckscheme", filter, "createtime desc", sscId, false);
                CommonFilterUtil.createSmartSchemeFilter(commonFilterColumn, Long.parseLong(sscId));
            }
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        List qfilters = args.getQfilters();
        String sscid = this.getPageCache().get("sscid");
        String name = args.getFieldName();
        if (CommonFilterUtil.hasSsc(sscid) && "qualitycheckscheme.id".equals(name)) {
            qfilters.add(new QFilter("ssccenter", "in", CommonFilterUtil.getSscIdList(sscid)));
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        List<Long> allPermSSC = SscUtil.getAllPermSSC(RequestContext.get().getCurrUserId(), "task_qcpointfaildetailrpt", e.getFormShowParameter().getAppId());
        if (allPermSSC.size() == 0) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u65e0\u5f53\u524d\u83dc\u5355\u6743\u9650\u3002", (String)"RptUnpassCheckPointFormPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
    }
}

