/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.satisfiedmanage;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.Donothing;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.events.SetFilterContainerFlatEvent;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.util.StringUtils;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.ssc.enums.EnableStatusEnum;
import kd.ssc.task.formplugin.satisfiedmanage.SatisfiedQStatusEnum;
import kd.ssc.task.formplugin.satisfiedmanage.SatisfiedRequestUtil;
import kd.ssc.task.util.SscLicenseUtil;
import kd.ssc.task.util.UUIDUtil;

public class SatisfiedQuestionListPlugin
extends AbstractListPlugin {
    private final String systemType = "ssc-task-formplugin";
    private final Set<String> itemClick = new HashSet<String>(Arrays.asList("edit", "launchlist", "copy", "launch", "viewreport", "preview"));
    private final Set<String> beforeItemClick = new HashSet<String>(Arrays.asList("copy", "launch", "edit", "viewreport", "preview"));
    private static final Log log = LogFactory.getLog(SatisfiedQuestionListPlugin.class);

    public void filterContainerSetFlat(SetFilterContainerFlatEvent args) {
        args.setNewFilter(false);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        String version = LicenseServiceHelper.getProductVersion();
        if ("4.0".equals(version)) {
            return;
        }
        SscLicenseUtil.checkGroupLicense5_0((PreOpenFormEventArgs)e, (String)"task_satisfiedquestion");
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String formType = (String)formShowParameter.getCustomParam("formType");
        if (!SatisfiedRequestUtil.codeRule()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u6216\u5df2\u7981\u7528\u95ee\u5377\u7f16\u7801\u89c4\u5219\uff0c\u8bf7\u542f\u7528\u7f16\u7801\u89c4\u5219\u540e\u91cd\u8bd5\u3002", (String)"SatisfiedQuestionListPlugin_35", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((String)formType) || formType.equals("setting")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tblanalysis"});
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u6ee1\u610f\u5ea6\u8bbe\u7f6e", (String)"SatisfiedQuestionListPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        } else if (formType.equals("analyze")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tblnew", "tbledit", "tbllaunch", "tbldisable", "tblsyncdata", "operationap", "preview"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"operationap"});
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u6ee1\u610f\u5ea6\u5206\u6790", (String)"SatisfiedQuestionListPlugin_27", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        ListSelectedRowCollection rows = args.getListSelectedData();
        if (this.beforeItemClick.contains(operate.getOperateKey()) && !this.onlySelectedOne(rows.size())) {
            args.setCancel(true);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List comFilters = args.getCommonFilterColumns();
        for (FilterColumn column : comFilters) {
            CommonFilterColumn comFilter = (CommonFilterColumn)column;
            if (!comFilter.getFieldName().equals("createorg.name")) continue;
            List comboItems = comFilter.getComboItems();
            List defaultValue = comFilter.getDefaultValues();
            if ((defaultValue == null || defaultValue.isEmpty()) && comboItems != null && !comboItems.isEmpty()) {
                comFilter.setDefaultValue(((ComboItem)comboItems.get(0)).getValue());
            }
            String sscId = this.getPageCache().get("sscId");
            if (this.getPageCache().get("sscId") == null) {
                sscId = comFilter.getDefaultValues().get(0) + "";
                this.getPageCache().put("sscId", sscId);
            } else {
                comFilter.setDefaultValue(sscId);
            }
            Map<String, String> tenantMap = this.validTenant(Long.parseLong(sscId));
            if (tenantMap != null) {
                this.getPageCache().put("satisfiedTenant", SerializationUtils.toJsonString(tenantMap));
                continue;
            }
            this.getPageCache().remove("satisfiedTenant");
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        if (args.getFilterValues().get("customfilter") != null) {
            Map currentCommonFilter = args.getCurrentCommonFilter();
            if (currentCommonFilter == null || currentCommonFilter.size() == 0) {
                return;
            }
            String curFieldName = "";
            String curValue = "";
            if (currentCommonFilter.containsKey("FieldName") && currentCommonFilter.get("FieldName") != null && ((List)currentCommonFilter.get("FieldName")).size() > 0) {
                curFieldName = (String)((List)currentCommonFilter.get("FieldName")).get(0);
            }
            if (currentCommonFilter.containsKey("Value") && currentCommonFilter.get("Value") != null && ((List)currentCommonFilter.get("Value")).size() > 0) {
                curValue = (String)((List)currentCommonFilter.get("Value")).get(0);
            }
            String oldSSC = this.getPageCache().get("sscId");
            if ("createorg.id".equals(curFieldName) && !curValue.equals(oldSSC)) {
                this.getPageCache().put("sscId", curValue);
                Map<String, String> tenantMap = this.validTenant(Long.parseLong(curValue));
                if (tenantMap != null) {
                    this.getPageCache().put("satisfiedTenant", SerializationUtils.toJsonString(tenantMap));
                } else {
                    this.getPageCache().remove("satisfiedTenant");
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        boolean codeRule = SatisfiedRequestUtil.codeRule();
        if (!codeRule && key.equals("refresh")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u6216\u5df2\u7981\u7528\u95ee\u5377\u7f16\u7801\u89c4\u5219\uff0c\u8bf7\u542f\u7528\u7f16\u7801\u89c4\u5219\u540e\u91cd\u8bd5\u3002", (String)"SatisfiedQuestionListPlugin_35", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
        if (args.getSource() instanceof Donothing && args.getOperationResult().isSuccess()) {
            String sscId = this.getPageCache().get("sscId");
            String satisfiedTenant = this.getPageCache().get("satisfiedTenant");
            if (satisfiedTenant == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5171\u4eab\u4e2d\u5fc3\u672a\u521b\u5efa\u95ee\u5377\u7cfb\u7edf\u79df\u6237\uff0c\u8bf7\u521b\u5efa\u540e\u91cd\u8bd5\u3002", (String)"SatisfiedQuestionListPlugin_19", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            Map tenantMap = (Map)SerializationUtils.fromJsonString((String)satisfiedTenant, Map.class);
            if (!((String)tenantMap.get("userstatus")).equals("0")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5171\u4eab\u4e2d\u5fc3\u95ee\u5377\u7cfb\u7edf\u79df\u6237\u5df2\u88ab\u7981\u7528\uff0c\u65e0\u6cd5\u64cd\u4f5c\u3002", (String)"SatisfiedQuestionListPlugin_26", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject question = null;
            QFilter qFilter = new QFilter("id", "=", (Object)"");
            if (this.itemClick.contains(key)) {
                Donothing operate = (Donothing)args.getSource();
                Object questionId = operate.getListSelectedData().get(0).getPrimaryKeyValue();
                this.getPageCache().put("questionId", questionId + "");
                qFilter = new QFilter("id", "=", questionId);
                question = QueryServiceHelper.queryOne((String)"task_satisfiedquestion", (String)"id,questionstatus,bestcemeditlink,name,bestcemdelivertype,deliverurl,bestcemresponselink,bestcempreviewlink", (QFilter[])qFilter.toArray());
            }
            switch (args.getOperateKey()) {
                case "new": {
                    String addLink = (String)tenantMap.get("url");
                    if (StringUtils.isNotEmpty((String)addLink)) {
                        if (!codeRule) {
                            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65b0\u589e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u7f16\u7801\u89c4\u5219\u3002", (String)"SatisfiedQuestionListPlugin_34", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                            return;
                        }
                        this.getView().openUrl(addLink);
                        break;
                    }
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u95ee\u5377\u672a\u914d\u7f6e\u7cfb\u7edf\u53c2\u6570\uff0c\u8bf7\u914d\u7f6e\u540e\u91cd\u8bd5\u3002", (String)"SatisfiedQuestionListPlugin_5", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "copy": {
                    if (question == null) break;
                    if (!codeRule) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u590d\u5236\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u7f16\u7801\u89c4\u5219\u3002", (String)"SatisfiedQuestionListPlugin_33", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    this.openCopyForm(question.get("id"), question.getString("name"));
                    break;
                }
                case "edit": {
                    SatisfiedRequestUtil.getProjectInfo(sscId, "2");
                    question = QueryServiceHelper.queryOne((String)"task_satisfiedquestion", (String)"id,questionstatus,bestcemeditlink,name,bestcemdelivertype,deliverurl,bestcemresponselink,bestcempreviewlink", (QFilter[])qFilter.toArray());
                    if (question == null) break;
                    if (question.getString("questionstatus").equals(SatisfiedQStatusEnum.delete_kd.getValue()) || question.getString("questionstatus").equals(SatisfiedQStatusEnum.recycled.getValue())) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u5df2\u7ed3\u675f\u201d\u6216\u201c\u5df2\u5220\u9664\u201d\u72b6\u6001\u7684\u6570\u636e\u4e0d\u80fd\u7f16\u8f91\u3002", (String)"SatisfiedQuestionListPlugin_29", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    String editLink = question.get("bestcemeditlink") + "";
                    if (StringUtils.isNotEmpty((String)editLink)) {
                        this.getView().openUrl(editLink);
                        break;
                    }
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u95ee\u5377\u672a\u914d\u7f6e\u7cfb\u7edf\u53c2\u6570\uff0c\u8bf7\u914d\u7f6e\u540e\u91cd\u8bd5\u3002", (String)"SatisfiedQuestionListPlugin_5", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "launch": {
                    if (question == null) break;
                    if (question.getString("questionstatus").equals(SatisfiedQStatusEnum.start_kd.getValue())) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u5f00\u59cb\u72b6\u6001\u7684\u95ee\u5377\u4e0d\u5141\u8bb8\u6295\u653e\u3002", (String)"SatisfiedQuestionListPlugin_25", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    if (question.getString("questionstatus").equals(SatisfiedQStatusEnum.launched.getValue())) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u95ee\u5377\u5df2\u6295\u653e\uff0c\u65e0\u9700\u518d\u6b21\u6295\u653e\u3002", (String)"SatisfiedQuestionListPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    if (question.get("questionstatus").equals(SatisfiedQStatusEnum.recycled.getValue())) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ed3\u675f\u7684\u95ee\u5377\u4e0d\u652f\u6301\u518d\u6b21\u6295\u653e\u3002", (String)"SatisfiedQuestionListPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    if (question.getString("questionstatus").equals(SatisfiedQStatusEnum.delete_kd.getValue())) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5220\u9664\u72b6\u6001\u7684\u95ee\u5377\u4e0d\u5141\u8bb8\u6295\u653e\u3002", (String)"SatisfiedQuestionListPlugin_31", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    String deliverurl = question.getString("deliverurl");
                    if (StringUtils.isEmpty((String)deliverurl)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u6295\u653e\u94fe\u63a5\uff0c\u8bf7\u540c\u6b65\u6570\u636e\u3002", (String)"SatisfiedQuestionListPlugin_22", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    this.openBosUserForm();
                    break;
                }
                case "viewreport": {
                    if (question == null) break;
                    if (question.getString("questionstatus").equals(SatisfiedQStatusEnum.delete_kd.getValue())) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5220\u9664\u72b6\u6001\u7684\u95ee\u5377\u4e0d\u5141\u8bb8\u67e5\u770b\u3002", (String)"SatisfiedQuestionListPlugin_32", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    String responseLink = question.get("bestcemresponselink") + "";
                    if (StringUtils.isNotEmpty((String)responseLink)) {
                        this.getView().openUrl(responseLink);
                        break;
                    }
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u95ee\u5377\u672a\u914d\u7f6e\u7cfb\u7edf\u53c2\u6570\uff0c\u8bf7\u914d\u7f6e\u540e\u91cd\u8bd5\u3002", (String)"SatisfiedQuestionListPlugin_5", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "preview": {
                    if (question == null) break;
                    if (question.getString("questionstatus").equals(SatisfiedQStatusEnum.delete_kd.getValue())) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5220\u9664\u72b6\u6001\u7684\u95ee\u5377\u4e0d\u5141\u8bb8\u9884\u89c8\u3002", (String)"SatisfiedQuestionListPlugin_30", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    String preViewLink = question.get("bestcempreviewlink") + "";
                    if (StringUtils.isNotEmpty((String)preViewLink)) {
                        this.getView().openUrl(preViewLink);
                        break;
                    }
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u95ee\u5377\u672a\u914d\u7f6e\u7cfb\u7edf\u53c2\u6570\uff0c\u8bf7\u914d\u7f6e\u540e\u91cd\u8bd5\u3002", (String)"SatisfiedQuestionListPlugin_5", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "syncdata": {
                    if (!SatisfiedRequestUtil.getProjectInfo(sscId, "1")) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u540c\u6b65\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"SatisfiedQuestionListPlugin_21", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u540c\u6b65\u6570\u636e\u6210\u529f\u3002", (String)"SatisfiedQuestionListPlugin_23", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    this.getView().invokeOperation("refresh");
                    break;
                }
                case "launchlist": {
                    if (question == null) break;
                    if (question.get("questionstatus").equals(SatisfiedQStatusEnum.prelaunch.getValue()) || question.get("questionstatus").equals(SatisfiedQStatusEnum.start_kd.getValue())) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u95ee\u5377\u672c\u5730\u6295\u653e\u540e\uff0c\u60a8\u53ef\u4ee5\u67e5\u770b\u6295\u653e\u540d\u5355\u3002", (String)"SatisfiedQuestionListPlugin_7", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    this.openLaunchListForm(question.get("id"));
                    break;
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        String key = e.getActionId();
        String questionId = this.getPageCache().get("questionId");
        if (returnData != null && StringUtils.isNotEmpty((String)questionId)) {
            if ("launch".equalsIgnoreCase(key)) {
                ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)returnData;
                if (selectedRows.size() == 0) {
                    return;
                }
                Object[] userIds = selectedRows.getPrimaryKeyValues();
                log.info("\u500d\u5e02\u5f97\u95ee\u5377\u5206\u53d1\uff0c\u603b\u5171\u5206\u53d1\u4efd\u6570\uff1a" + userIds.length);
                QFilter userDeptQFilter = new QFilter("id", "in", (Object)userIds);
                userDeptQFilter.and("id", "in", (Object)userIds);
                userDeptQFilter.and("entryentity.ispartjob", "=", (Object)Boolean.FALSE);
                DynamicObjectCollection userDept = QueryServiceHelper.query((String)"bos_user", (String)"id,name,number,entryentity.dpt dept", (QFilter[])userDeptQFilter.toArray());
                DynamicObject question = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(questionId), (String)"task_satisfiedquestion");
                question.set("questionstatus", (Object)SatisfiedQStatusEnum.launched.getValue());
                question.set("launchtime", (Object)new Date());
                DynamicObjectCollection entryentity = question.getDynamicObjectCollection("entryentity");
                DynamicObjectType entryEntityType = entryentity.getDynamicObjectType();
                ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>(10);
                String questionUrl = question.getString("deliverurl");
                if (StringUtils.isNotEmpty((String)questionUrl)) {
                    try {
                        if (questionUrl.contains("?") && questionUrl.contains("&")) {
                            for (DynamicObject user : userDept) {
                                DynamicObject dateEntry = new DynamicObject(entryEntityType);
                                dateEntry.set("userfield", user.get("id"));
                                dateEntry.set("userdept", user.get("dept"));
                                String deliverLink = this.createQuestionUrl(questionUrl, user.getLong("id"));
                                if (StringUtils.isNotEmpty((String)deliverLink)) {
                                    dateEntry.set("userdeliverurl", (Object)deliverLink);
                                    messageInfos.add(this.createMessageInfo(user.getString("name"), user.getLong("id"), deliverLink));
                                } else {
                                    log.info("\u6ee1\u610f\u5ea6\u7ba1\u7406-\u95ee\u5377\u6295\u653e\uff0c\u62fc\u63a5\u7b54\u5377\u94fe\u63a5\u5931\u8d25\uff1a\u95ee\u5377\uff08" + question.get("id") + "),\u7528\u6237\uff08" + user.get("id"));
                                }
                                entryentity.add((Object)dateEntry);
                            }
                        } else {
                            for (DynamicObject user : userDept) {
                                DynamicObject dateEntry = new DynamicObject(entryEntityType);
                                dateEntry.set("userfield", user.get("id"));
                                dateEntry.set("userdept", user.get("dept"));
                                dateEntry.set("userdeliverurl", (Object)questionUrl);
                                entryentity.add((Object)dateEntry);
                                messageInfos.add(this.createMessageInfo(user.getString("name"), user.getLong("id"), questionUrl));
                            }
                        }
                    }
                    catch (UnsupportedEncodingException ex) {
                        log.info("\u6ee1\u610f\u5ea6\u7ba1\u7406-\u95ee\u5377\u6295\u653e\uff0c\u62fc\u63a5\u7b54\u5377\u94fe\u63a5\u5931\u8d25UnsupportedEncodingException\uff1a\u95ee\u5377\uff08" + question.get("id") + ")");
                    }
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{question});
                    log.info("\u6ee1\u610f\u5ea6\u7ba1\u7406-\u95ee\u5377\u6295\u653e\uff0c\u5b9e\u9645\u5206\u53d1\u4efd\u6570\uff1a" + messageInfos.size());
                    if (messageInfos.size() > 0) {
                        messageInfos.forEach(info -> MessageCenterServiceHelper.sendMessage((MessageInfo)info));
                    }
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6295\u653e\u6210\u529f\u3002", (String)"SatisfiedQuestionListPlugin_24", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    this.getView().invokeOperation("refresh");
                }
            } else if ("copy".equalsIgnoreCase(key)) {
                if ("success".equals(returnData)) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u590d\u5236\u6210\u529f\u3002", (String)"SatisfiedQuestionListPlugin_20", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    this.getView().invokeOperation("refresh");
                } else if ("fail".equals(returnData)) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u590d\u5236\u6210\u529f\u3002", (String)"SatisfiedQuestionListPlugin_20", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    this.getView().invokeOperation("syncdata");
                    this.getView().invokeOperation("refresh");
                }
            }
        }
    }

    private void openBosUserForm() {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId("bos_user");
        parameter.setFormId("bos_usertreelistf7");
        parameter.setCaption(ResManager.loadKDString((String)"\u6295\u653e\u540d\u5355", (String)"SatisfiedQuestionListPlugin_14", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        StyleCss css = new StyleCss();
        css.setWidth("960px");
        css.setHeight("580px");
        parameter.getOpenStyle().setInlineStyleCss(css);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setLookUp(true);
        parameter.setShowTitle(false);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "launch"));
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void openLaunchListForm(Object questionId) {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId("task_satisfiedlaunchlist");
        StyleCss css = new StyleCss();
        css.setWidth("960px");
        css.setHeight("580px");
        parameter.getOpenStyle().setInlineStyleCss(css);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "launchList"));
        parameter.getListFilterParameter().getQFilters().add(new QFilter("satisfiedquestion", "=", questionId));
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void openCopyForm(Object questionId, String title) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("task_satisfiedqcopy");
        parameter.setCaption(ResManager.loadKDString((String)"\u590d\u5236\u95ee\u5377", (String)"SatisfiedQuestionListPlugin_15", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "copy"));
        parameter.setCustomParam("questionId", questionId);
        parameter.setCustomParam("title", (Object)title);
        this.getView().showForm(parameter);
    }

    private String createQuestionUrl(String generalDeliverUrl, Long userId) {
        String[] url = generalDeliverUrl.split("\\?");
        String[] urlParams = url[1].split("&");
        HashMap<String, String> paramMap = new HashMap<String, String>(16);
        for (String param : urlParams) {
            String[] keyValue = param.split("=");
            if (keyValue.length == 1) {
                paramMap.put(keyValue[0], "");
                continue;
            }
            paramMap.put(keyValue[0], keyValue[1]);
        }
        String uuid = UUIDUtil.generateShortUuid() + Long.toHexString(userId);
        String nonce = UUIDUtil.generateUuid();
        paramMap.put("uuid", uuid);
        paramMap.put("nonce", nonce);
        Set keySet = paramMap.keySet();
        ArrayList list = new ArrayList(keySet);
        Collections.sort(list);
        StringBuilder originalSb = new StringBuilder();
        list.forEach(key -> {
            if (!key.equals("sign")) {
                originalSb.append((String)key).append('|').append((String)paramMap.get(key)).append('|');
            }
        });
        String sign = this.md5(originalSb.toString());
        if (StringUtils.isNotEmpty((String)sign)) {
            paramMap.put("sign", sign);
            StringBuilder urlSb = new StringBuilder();
            urlSb.append(url[0]).append('?');
            paramMap.forEach((key, value) -> urlSb.append((String)key).append('=').append((String)value).append('&'));
            generalDeliverUrl = urlSb.toString().substring(0, urlSb.length() - 1);
            return generalDeliverUrl;
        }
        return "";
    }

    private MessageInfo createMessageInfo(String userName, Long userId, String questionUrl) throws UnsupportedEncodingException {
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setTitle(ResManager.loadKDString((String)"\u8d22\u52a1\u5171\u4eab\u4e2d\u5fc3\u6ee1\u610f\u5ea6\u8bc4\u4ef7", (String)"SatisfiedQuestionListPlugin_11", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        StringBuilder content = new StringBuilder(String.format(ResManager.loadKDString((String)"%s", (String)"SatisfiedQuestionListPlugin_13", (String)"ssc-task-formplugin", (Object[])new Object[0]), userName + "\uff0c"));
        content.append("<div>").append(ResManager.loadKDString((String)"\u60a8\u597d\uff01", (String)"SatisfiedQuestionListPlugin_12", (String)"ssc-task-formplugin", (Object[])new Object[0])).append("</div>").append("<div>").append(ResManager.loadKDString((String)"\u4e3a\u4e86\u5e2e\u52a9\u8d22\u52a1\u5171\u4eab\u4e2d\u5fc3\u66f4\u597d\u5730\u5b8c\u5584\u670d\u52a1\u8d28\u91cf\uff0c\u8bf7\u70b9\u51fb\u4ee5\u4e0b\u94fe\u63a5\u5bf9\u5171\u4eab\u4e2d\u5fc3\u8fdb\u884c\u8bc4\u4ef7\uff1a", (String)"SatisfiedQuestionListPlugin_10", (String)"ssc-task-formplugin", (Object[])new Object[0])).append("</div>").append(questionUrl);
        messageInfo.setContent(content.toString());
        messageInfo.setUserIds(Collections.singletonList(userId));
        messageInfo.setTag(ResManager.loadKDString((String)"\u6ee1\u610f\u5ea6\u95ee\u5377\u8c03\u67e5", (String)"SatisfiedQuestionListPlugin_8", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        messageInfo.setSenderId(Long.valueOf(Long.parseLong(RequestContext.get().getUserId())));
        messageInfo.setType("message");
        messageInfo.setNotifyType("mcenter");
        messageInfo.setContentUrl(RequestContext.get().getClientFullContextPath() + "index.html?formId=task_satisfiedqpersonal&pkId=1LS3JVVI2/W2&businessUrl=" + URLEncoder.encode(questionUrl, "UTF-8"));
        return messageInfo;
    }

    private boolean onlySelectedOne(int rows) {
        if (rows > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"SatisfiedQuestionListPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private Map<String, String> validTenant(Long sscId) {
        QFilter filter = new QFilter("enable", "=", (Object)EnableStatusEnum.Enable.getValue());
        filter.and(new QFilter("sscid", "=", (Object)sscId));
        DynamicObject satisfiedTenant = QueryServiceHelper.queryOne((String)"task_satisfiedtenant", (String)"id,url,userstatus", (QFilter[])new QFilter[]{filter});
        HashMap<String, String> tenantMap = null;
        if (satisfiedTenant != null) {
            tenantMap = new HashMap<String, String>(3);
            tenantMap.put("id", satisfiedTenant.getPkValue() + "");
            tenantMap.put("url", satisfiedTenant.getString("url"));
            tenantMap.put("userstatus", satisfiedTenant.getString("userstatus"));
        }
        return tenantMap;
    }

    private String md5(String s) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        try {
            byte[] btInput = s.getBytes(StandardCharsets.UTF_8);
            MessageDigest mdInst = MessageDigest.getInstance("MD5");
            mdInst.update(btInput);
            byte[] md = mdInst.digest();
            int j = md.length;
            char[] str = new char[j * 2];
            int k = 0;
            for (int i = 0; i < j; ++i) {
                byte byte0 = md[i];
                str[k++] = hexDigits[byte0 >>> 4 & 0xF];
                str[k++] = hexDigits[byte0 & 0xF];
            }
            return new String(str);
        }
        catch (Exception e) {
            log.error("\u500d\u5e02\u5f97\u95ee\u5377\u5206\u53d1\uff0c\u83b7\u53d6sign\u5931\u8d25\uff1a", (Object)e.getMessage());
            return "";
        }
    }
}

