/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.sla;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.ssc.sla.AccountBookUtil;
import kd.ssc.sla.SlaUtil;

public class SlaServiceBillFormPlugin
extends AbstractFormPlugin {
    private static final String ENTRY_BILLDETAIL = "billdetails";
    private static final String ENTRY_STERIDETAILS = "steridetails";
    private static final String Caller_BindData = "binddata";
    private static final String Caller_PropChange = "propchange";
    private static final String BillType_settle = "sla_servicebill_settle_BT_S";
    private static final String BillType_te = "sla_servicebill_te_BT_S";
    private static final String BILLING_QTY = "qty";
    private static final String BILLING_FIXED = "fixed";
    private static final String TOOLBAR_ADVCON2 = "advcontoolbarap2";

    public void initialize() {
        super.initialize();
        this.getView().setEnable(Boolean.FALSE, new String[]{"billtype"});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TOOLBAR_ADVCON2});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initBillInfo();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        OperationStatus opStatus = view.getFormShowParameter().getStatus();
        if (opStatus.equals((Object)OperationStatus.ADDNEW)) {
            Object org = model.getValue("org");
            if (org == null) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u4e3b\u4e1a\u52a1\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SlaServiceContractFormPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject initData = SlaUtil.getSscInitData((Long)((DynamicObject)org).getLong("id"));
            if (initData != null) {
                boolean isFinishInit = (Boolean)initData.get("isfinishinit");
                if (!isFinishInit) {
                    LocaleString ls = new LocaleString(ResManager.loadKDString((String)"\u671f\u521d\u5171\u4eab\u670d\u52a1\u8d26\u5355", (String)"SlaServiceBillListPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    view.setFormTitle(ls);
                }
            } else {
                this.lockPanel(view);
                view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u6ca1\u6709\u7ef4\u62a4SLA\u521d\u59cb\u5316\u8bbe\u7f6e\u3002", (String)"SlaServiceContractFormPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]), ((DynamicObject)org).getLocaleString("name")));
                return;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        OperationStatus opStatus = this.getView().getFormShowParameter().getStatus();
        if (opStatus.equals((Object)OperationStatus.ADDNEW)) {
            this.initBillInfo();
        }
        this.setButtonVisible();
        this.initLableValue(Caller_BindData);
        this.initColProByBillType(view);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        IDataModel model = this.getModel();
        this.setButtonVisible();
        this.getView().updateView(ENTRY_STERIDETAILS);
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        IDataModel model = this.getModel();
        String entryName = e.getEntryProp().getName();
        if (ENTRY_BILLDETAIL.equals(entryName) && BillType_settle.equals(this.getBillType())) {
            model.setValue("billamt", (Object)this.getVouchAmtSum());
            model.setValue("billamtstd", (Object)this.getVouchAmtStdSum());
            model.setValue("billrecamt", (Object)this.getVouchAmtSum().subtract(this.getSdSteriamtSum()));
            model.setValue("billrecamtstd", (Object)this.getVouchAmtStdSum().subtract(this.getSdSteriamtStdSum()));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        Object hisValue = valueSet[0].getOldValue();
        int rowIndex = valueSet[0].getRowIndex();
        if (StringUtils.equals((CharSequence)propName, (CharSequence)"exratetable")) {
            this.setExchangeRate();
        } else if (StringUtils.equals((CharSequence)propName, (CharSequence)"exratedate")) {
            this.setExchangeRate();
        } else if (StringUtils.equals((CharSequence)propName, (CharSequence)"exrate")) {
            this.setStdAmtByRateChanged((BigDecimal)propValue);
        } else if (StringUtils.equals((CharSequence)propName, (CharSequence)"amount")) {
            BigDecimal exrate = (BigDecimal)model.getValue("exrate");
            model.setValue("amountstd", (Object)exrate.multiply((BigDecimal)propValue));
            if (BillType_te.equals(this.getBillType())) {
                Object taxRate = model.getValue("taxrate");
                if (taxRate != null) {
                    BigDecimal taxamt = this.getTaxamt((BigDecimal)propValue, ((DynamicObject)taxRate).getBigDecimal("taxrate"));
                    model.setValue("taxamt", (Object)taxamt);
                }
                model.setValue("steriableamt", propValue);
            }
        } else if (StringUtils.equals((CharSequence)propName, (CharSequence)"vouchamt")) {
            BigDecimal exrate = (BigDecimal)model.getValue("exrate");
            model.setValue("vouchamtstd", (Object)exrate.multiply((BigDecimal)propValue), rowIndex);
            Object taxRate = model.getValue("taxrate");
            if (taxRate != null) {
                BigDecimal taxamount = this.getTaxamt((BigDecimal)propValue, ((DynamicObject)taxRate).getBigDecimal("taxrate"));
                model.setValue("taxamount", (Object)taxamount, rowIndex);
            }
            model.setValue("billamt", (Object)this.getVouchAmtSum());
            model.setValue("billrecamt", (Object)this.getVouchAmtSum().subtract(this.getSdSteriamtSum()));
        } else if (StringUtils.equals((CharSequence)propName, (CharSequence)"vouchamtstd")) {
            model.setValue("billamtstd", (Object)this.getVouchAmtStdSum());
            model.setValue("billrecamtstd", (Object)this.getVouchAmtStdSum().subtract(this.getSdSteriamtStdSum()));
        } else if (StringUtils.equals((CharSequence)propName, (CharSequence)"billamt")) {
            this.initLableValue(Caller_PropChange);
        } else if (StringUtils.equals((CharSequence)propName, (CharSequence)"deducamt")) {
            BigDecimal exrate = (BigDecimal)model.getValue("exrate");
            model.setValue("deducamtstd", (Object)exrate.multiply((BigDecimal)propValue), rowIndex);
            BigDecimal bdAmount = (BigDecimal)model.getValue("bdamount", rowIndex);
            model.setValue("vouchamt", (Object)bdAmount.subtract((BigDecimal)propValue), rowIndex);
        } else if (StringUtils.equals((CharSequence)propName, (CharSequence)BILLING_QTY)) {
            if (BillType_settle.equals(this.getBillType())) {
                BigDecimal price = (BigDecimal)model.getValue("price", rowIndex);
                model.setValue("bdamount", (Object)price.multiply((BigDecimal)propValue), rowIndex);
            }
        } else if (StringUtils.equals((CharSequence)propName, (CharSequence)"bdamount")) {
            BigDecimal exrate = (BigDecimal)model.getValue("exrate");
            model.setValue("bdamountstd", (Object)exrate.multiply((BigDecimal)propValue), rowIndex);
            BigDecimal deducAmt = (BigDecimal)model.getValue("deducamt", rowIndex);
            model.setValue("vouchamt", (Object)((BigDecimal)propValue).subtract(deducAmt), rowIndex);
        } else if (StringUtils.equals((CharSequence)propName, (CharSequence)"billrecamt")) {
            Object taxRate;
            if (BillType_settle.equals(this.getBillType()) && (taxRate = model.getValue("taxrate")) != null) {
                BigDecimal taxamt = this.getTaxamt((BigDecimal)propValue, ((DynamicObject)taxRate).getBigDecimal("taxrate"));
                model.setValue("taxamt", (Object)taxamt);
            }
            this.initLableValue(Caller_PropChange);
        } else if (StringUtils.equals((CharSequence)propName, (CharSequence)"taxrate")) {
            if (propValue != null) {
                BigDecimal taxamt;
                if (BillType_te.equals(this.getBillType())) {
                    BigDecimal amount = (BigDecimal)model.getValue("amount");
                    taxamt = this.getTaxamt(amount, ((DynamicObject)propValue).getBigDecimal("taxrate"));
                    model.setValue("taxamt", (Object)taxamt);
                } else if (BillType_settle.equals(this.getBillType())) {
                    BigDecimal billRecAmt = (BigDecimal)model.getValue("billrecamt");
                    taxamt = this.getTaxamt(billRecAmt, ((DynamicObject)propValue).getBigDecimal("taxrate"));
                    model.setValue("taxamt", (Object)taxamt);
                }
            }
            if (propValue != null) {
                BigDecimal vouchAmt = (BigDecimal)model.getValue("vouchamt");
                BigDecimal taxamount = this.getTaxamt(vouchAmt, ((DynamicObject)propValue).getBigDecimal("taxrate"));
                model.setValue("taxamount", (Object)taxamount, rowIndex);
            }
            this.initLableValue(Caller_PropChange);
        } else if (StringUtils.equals((CharSequence)propName, (CharSequence)"taxamount")) {
            BigDecimal exrate = (BigDecimal)model.getValue("exrate");
            model.setValue("taxamountstd", (Object)exrate.multiply((BigDecimal)propValue), rowIndex);
            BigDecimal vouchAmt = (BigDecimal)model.getValue("vouchamt", rowIndex);
            model.setValue("vouchnotaxamt", (Object)vouchAmt.subtract((BigDecimal)propValue), rowIndex);
        } else if (StringUtils.equals((CharSequence)propName, (CharSequence)"vouchnotaxamt")) {
            BigDecimal exrate = (BigDecimal)model.getValue("exrate");
            model.setValue("vouchnotaxamtstd", (Object)exrate.multiply((BigDecimal)propValue), rowIndex);
        } else if (StringUtils.equals((CharSequence)propName, (CharSequence)"sdsteriamt")) {
            BigDecimal exrate = (BigDecimal)model.getValue("exrate");
            model.setValue("sdsteriamtstd", (Object)exrate.multiply((BigDecimal)propValue), rowIndex);
            BigDecimal sdTaxRate = (BigDecimal)model.getValue("sdtaxrate", rowIndex);
            BigDecimal sdSteriTaxAmt = this.getTaxamt((BigDecimal)propValue, sdTaxRate);
            model.setValue("sdsteritaxamt", (Object)sdSteriTaxAmt);
            model.setValue("billrecamt", (Object)this.getVouchAmtSum().subtract(this.getSdSteriamtSum()));
        } else if (StringUtils.equals((CharSequence)propName, (CharSequence)"sdsteriamtstd")) {
            model.setValue("billrecamtstd", (Object)this.getVouchAmtStdSum().subtract(this.getSdSteriamtStdSum()));
        } else if (StringUtils.equals((CharSequence)propName, (CharSequence)"sdsteritaxamt")) {
            BigDecimal exrate = (BigDecimal)model.getValue("exrate");
            model.setValue("sdsteritaxamtstd", (Object)exrate.multiply((BigDecimal)propValue), rowIndex);
        } else if (StringUtils.equals((CharSequence)propName, (CharSequence)"taxamt")) {
            this.initLableValue(Caller_PropChange);
        } else if (StringUtils.equals((CharSequence)propName, (CharSequence)"servicepriod")) {
            int billDetailsSize = model.getEntryRowCount(ENTRY_BILLDETAIL);
            for (int i = 0; i < billDetailsSize; ++i) {
                model.setValue("bdservicepriod", propValue, i);
            }
        }
    }

    private void setStdAmtByRateChanged(BigDecimal exrate) {
        IDataModel model = this.getModel();
        if (BillType_te.equals(this.getBillType())) {
            model.setValue("amountstd", (Object)exrate.multiply((BigDecimal)model.getValue("amount")));
        } else if (BillType_settle.equals(this.getBillType())) {
            DynamicObject row;
            int i;
            DynamicObjectCollection billDetailsEntry = model.getEntryEntity(ENTRY_BILLDETAIL);
            DynamicObjectCollection steriDetailsEntry = model.getEntryEntity(ENTRY_STERIDETAILS);
            for (i = 0; i < billDetailsEntry.size(); ++i) {
                row = (DynamicObject)billDetailsEntry.get(i);
                model.setValue("bdamountstd", (Object)exrate.multiply(row.getBigDecimal("bdamount")), i);
                model.setValue("vouchamtstd", (Object)exrate.multiply(row.getBigDecimal("vouchamt")), i);
                model.setValue("deducamtstd", (Object)exrate.multiply(row.getBigDecimal("deducamt")), i);
                model.setValue("taxamountstd", (Object)exrate.multiply(row.getBigDecimal("taxamount")), i);
                model.setValue("vouchnotaxamtstd", (Object)exrate.multiply(row.getBigDecimal("vouchnotaxamt")), i);
            }
            for (i = 0; i < steriDetailsEntry.size(); ++i) {
                row = (DynamicObject)steriDetailsEntry.get(i);
                model.setValue("sdsteriamtstd", (Object)exrate.multiply(row.getBigDecimal("sdsteriamt")), i);
                model.setValue("sdsteritaxamtstd", (Object)exrate.multiply(row.getBigDecimal("sdsteritaxamt")), i);
            }
        }
    }

    private boolean setExchangeRate() {
        IDataModel model = this.getModel();
        Object currencyObj = model.getValue("currency");
        Object localCurrencyObj = model.getValue("basecurrency");
        Object exRateTableObj = model.getValue("exratetable");
        Object exRateDate = model.getValue("exratedate");
        if (currencyObj == null || localCurrencyObj == null || exRateTableObj == null) {
            return false;
        }
        Map exrateMap = AccountBookUtil.getExchangeRate((Long)((Long)((DynamicObject)exRateTableObj).getPkValue()), (Long)((Long)((DynamicObject)currencyObj).getPkValue()), (Long)((Long)((DynamicObject)localCurrencyObj).getPkValue()), (Date)((Date)exRateDate));
        if (!ObjectUtils.isEmpty((Object)exrateMap)) {
            BigDecimal exrate = (BigDecimal)exrateMap.get("exrate");
            int precision = (Integer)exrateMap.get("precision");
            if (precision == 0) {
                precision = 8;
            }
            model.setValue("exrate", (Object)exrate);
            return true;
        }
        model.setValue("exrate", (Object)BigDecimal.ZERO);
        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6c47\u7387\u8868\u65e0\u5bf9\u5e94\u7684\u8f6c\u6362\u6c47\u7387\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u3002", (String)"SlaServiceBillFormPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        return false;
    }

    private void initBillInfo() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        Object org = model.getValue("org");
        if (org == null) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u4e3b\u4e1a\u52a1\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SlaServiceContractFormPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject initData = SlaUtil.getSscInitData((Long)((DynamicObject)org).getLong("id"));
        if (initData == null) {
            this.lockPanel(view);
            view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u6ca1\u6709\u7ef4\u62a4SLA\u521d\u59cb\u5316\u8bbe\u7f6e\u3002", (String)"SlaServiceContractFormPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]), ((DynamicObject)org).getLocaleString("name")));
            return;
        }
        boolean isFinishInit = (Boolean)initData.get("isfinishinit");
        model.setValue("isperiod", (Object)(!isFinishInit ? 1 : 0));
        this.setExchangeRate();
        this.setBillDetailsData();
        this.setSteriDetails();
    }

    private void setBillDetailsData() {
        IDataModel model = this.getModel();
        DynamicObjectCollection billDetailsEntry = model.getEntryEntity(ENTRY_BILLDETAIL);
        for (int i = 0; i < billDetailsEntry.size(); ++i) {
            DynamicObject row = (DynamicObject)billDetailsEntry.get(i);
            if (!BillType_settle.equals(this.getBillType())) continue;
            if (BILLING_FIXED.equals(row.getString("billing"))) {
                model.setValue("bdamount", (Object)row.getBigDecimal("fixedamount"), i);
                continue;
            }
            if (!BILLING_QTY.equals(row.getString("billing"))) continue;
            model.setValue("bdamount", (Object)row.getBigDecimal(BILLING_QTY).multiply(row.getBigDecimal("price")), i);
        }
    }

    private void setSteriDetails() {
        IDataModel model = this.getModel();
        DynamicObjectCollection steriDetailsEntry = model.getEntryEntity(ENTRY_STERIDETAILS);
        for (int i = 0; i < steriDetailsEntry.size(); ++i) {
            DynamicObject row = (DynamicObject)steriDetailsEntry.get(i);
            if (!BillType_settle.equals(this.getBillType())) continue;
            BigDecimal sdsteriAmt = row.getBigDecimal("sdsteriamt");
            BigDecimal exrate = (BigDecimal)model.getValue("exrate");
            model.setValue("sdsteriamtstd", (Object)exrate.multiply(sdsteriAmt), i);
            BigDecimal sdTaxRate = (BigDecimal)model.getValue("sdtaxrate", i);
            BigDecimal sdSteriTaxAmt = this.getTaxamt(sdsteriAmt, sdTaxRate);
            model.setValue("sdsteritaxamt", (Object)sdSteriTaxAmt);
            model.setValue("billrecamt", (Object)this.getVouchAmtSum().subtract(this.getSdSteriamtSum()));
        }
    }

    private void lockPanel(IFormView view) {
        view.setVisible(Boolean.FALSE, new String[]{"bar_save", "bar_submit"});
        view.setEnable(Boolean.FALSE, new String[]{"contentpanel"});
    }

    public void initLableValue(String caller) {
        IDataModel model = this.getModel();
        Object currency = model.getValue("currency");
        if (currency != null) {
            String val4;
            String currName = ((DynamicObject)currency).getString("name");
            String currSign = ((DynamicObject)currency).getString("sign");
            int precision = ((DynamicObject)currency).getInt("amtprecision");
            if (precision == 0) {
                precision = 10;
            }
            Label lbCurrencyVal = (Label)this.getControl("lbcurrencyval");
            lbCurrencyVal.setText(currName);
            Label lbTaxRateVal = (Label)this.getControl("lbtaxrateval");
            Object taxRate = model.getValue("taxrate");
            String val3 = taxRate != null ? ((DynamicObject)taxRate).getBigDecimal("taxrate").stripTrailingZeros().toPlainString().concat("%") : "0";
            lbTaxRateVal.setText(val3);
            BigDecimal taxAmt = (BigDecimal)model.getValue("taxamt");
            Label lbTaxAmtVal = (Label)this.getControl("lbtaxamtval");
            if (BigDecimal.ZERO.compareTo(taxAmt) != 0) {
                taxAmt = taxAmt.setScale(precision);
                val4 = currSign.concat(taxAmt.toString());
            } else {
                val4 = currSign.concat("0.00");
            }
            lbTaxAmtVal.setText(val4);
            if (BillType_settle.equals(this.getBillType())) {
                String val2;
                String val1;
                BigDecimal billAmt = (BigDecimal)model.getValue("billamt");
                Label lbBillAmtVal = (Label)this.getControl("lbbillamtval");
                if (BigDecimal.ZERO.compareTo(billAmt) != 0) {
                    billAmt = billAmt.setScale(precision);
                    val1 = currSign.concat(billAmt.toString());
                } else {
                    val1 = currSign.concat("0.00");
                }
                lbBillAmtVal.setText(val1);
                BigDecimal billRecAmt = (BigDecimal)model.getValue("billrecamt");
                Label lbBillRecAmtVal = (Label)this.getControl("lbbillrecamtval");
                if (BigDecimal.ZERO.compareTo(billRecAmt) != 0) {
                    billRecAmt = billRecAmt.setScale(precision);
                    val2 = currSign.concat(billRecAmt.toString());
                } else {
                    val2 = currSign.concat("0.00");
                }
                lbBillRecAmtVal.setText(val2);
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"lbbillamt", "lbbillamtval", "seg2", "lbbillrecamt", "lbbillrecamtval", "seg3"});
            }
        }
    }

    private String getBillType() {
        IDataModel model = this.getModel();
        DynamicObject billType = (DynamicObject)model.getValue("billtype");
        return billType.getString("number");
    }

    private BigDecimal getVouchAmtSum() {
        IDataModel model = this.getModel();
        DynamicObjectCollection billDetailsEntry = model.getEntryEntity(ENTRY_BILLDETAIL);
        BigDecimal vouchAmtSum = billDetailsEntry.stream().map(v -> v.getBigDecimal("vouchamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
        return vouchAmtSum;
    }

    private BigDecimal getVouchAmtStdSum() {
        IDataModel model = this.getModel();
        DynamicObjectCollection billDetailsEntry = model.getEntryEntity(ENTRY_BILLDETAIL);
        BigDecimal vouchAmtStdSum = billDetailsEntry.stream().map(v -> v.getBigDecimal("vouchamtstd")).reduce(BigDecimal.ZERO, BigDecimal::add);
        return vouchAmtStdSum;
    }

    public BigDecimal getSdSteriamtSum() {
        IDataModel model = this.getModel();
        DynamicObjectCollection steriDetailsEntry = model.getEntryEntity(ENTRY_STERIDETAILS);
        BigDecimal sdSteriamtSum = steriDetailsEntry.stream().map(v -> v.getBigDecimal("sdsteriamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
        return sdSteriamtSum;
    }

    public BigDecimal getSdSteriamtStdSum() {
        IDataModel model = this.getModel();
        DynamicObjectCollection steriDetailsEntry = model.getEntryEntity(ENTRY_STERIDETAILS);
        BigDecimal sdSteriamtStdSum = steriDetailsEntry.stream().map(v -> v.getBigDecimal("sdsteriamtstd")).reduce(BigDecimal.ZERO, BigDecimal::add);
        return sdSteriamtStdSum;
    }

    private void initColProByBillType(IFormView view) {
        EntryGrid entryGrid = (EntryGrid)view.getControl(ENTRY_BILLDETAIL);
        if (BillType_settle.equals(this.getBillType())) {
            entryGrid.setColumnProperty("price", "header", (Object)new LocaleString(ResManager.loadKDString((String)"\u7ed3\u7b97\u5355\u4ef7", (String)"SlaServiceContractFormPlugin_5", (String)"ssc-task-formplugin", (Object[])new Object[0])));
            entryGrid.setColumnProperty("fixedamount", "header", (Object)new LocaleString(ResManager.loadKDString((String)"\u7ed3\u7b97\u56fa\u5b9a\u4ef7\u683c", (String)"SlaServiceContractFormPlugin_7", (String)"ssc-task-formplugin", (Object[])new Object[0])));
        } else if (BillType_te.equals(this.getBillType())) {
            entryGrid.setColumnProperty("price", "header", (Object)new LocaleString(ResManager.loadKDString((String)"\u6682\u4f30\u5355\u4ef7", (String)"SlaServiceContractFormPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0])));
            entryGrid.setColumnProperty("fixedamount", "header", (Object)new LocaleString(ResManager.loadKDString((String)"\u6682\u4f30\u56fa\u5b9a\u4ef7\u683c", (String)"SlaServiceContractFormPlugin_6", (String)"ssc-task-formplugin", (Object[])new Object[0])));
        }
    }

    private void setButtonVisible() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String billStatus = (String)model.getValue("billstatus");
        boolean isPeriod = (Boolean)model.getValue("isperiod");
        switch (billStatus) {
            case "A": {
                view.setVisible(Boolean.FALSE, new String[]{"bar_viewimage"});
                view.setVisible(Boolean.FALSE, new String[]{"bar_viewflow"});
                view.setVisible(Boolean.FALSE, new String[]{"bar_push"});
                view.setVisible(Boolean.TRUE, new String[]{"bar_track"});
                break;
            }
            case "B": {
                view.setVisible(Boolean.TRUE, new String[]{"bar_viewimage"});
                view.setVisible(Boolean.TRUE, new String[]{"bar_viewflow"});
                view.setVisible(Boolean.TRUE, new String[]{"bar_track"});
                if (!isPeriod) break;
                view.setVisible(Boolean.FALSE, new String[]{"bar_audit"});
                break;
            }
            case "C": {
                view.setVisible(Boolean.TRUE, new String[]{"bar_viewimage"});
                view.setVisible(Boolean.TRUE, new String[]{"bar_viewflow"});
                view.setVisible(Boolean.TRUE, new String[]{"bar_track"});
                view.setVisible(Boolean.TRUE, new String[]{"bar_push"});
                if (!isPeriod) break;
                view.setVisible(Boolean.FALSE, new String[]{"bar_audit"});
                break;
            }
        }
    }

    private BigDecimal getTaxamt(BigDecimal amount, BigDecimal taxrate) {
        BigDecimal taxrate_ = taxrate.divide(new BigDecimal("100"), 4, 4);
        return amount.multiply(taxrate_).divide(taxrate_.add(new BigDecimal("1")), 10, 4);
    }
}

