/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.smartApproval;

import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ssc.task.formplugin.pojo.FactorInfo;
import kd.ssc.task.formplugin.smartApproval.AffectFactorParser;

public class TaskPredictParseMiniPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(TaskPredictParseMiniPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"detaillabel"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long taskId = this.parseTaskId();
        DynamicObject predictResult = this.loadPredictResult(taskId);
        if (predictResult == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"contentfp"});
            return;
        }
        List<FactorInfo> factorInfoList = this.parseAffectFactorInfo(predictResult);
        if (factorInfoList.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"contentfp"});
            return;
        }
        this.fillAffectInfo(factorInfoList);
    }

    private Long parseTaskId() {
        FormShowParameter parameter = this.getView().getParentView().getFormShowParameter();
        Object taskIdObj = parameter.getCustomParam("sourcetaskid");
        Long taskId = taskIdObj == null || taskIdObj instanceof Integer ? (Long)parameter.getCustomParam("taskid") : (Long)taskIdObj;
        this.getPageCache().put("taskid", taskId.toString());
        return taskId;
    }

    private void fillAffectInfo(List<FactorInfo> factorInfoList) {
        for (int i = 0; i < factorInfoList.size(); ++i) {
            FactorInfo factorInfo = factorInfoList.get(i);
            Label fieldLabel = (Label)this.getControl("fieldlabel" + i);
            fieldLabel.setText(factorInfo.getField());
            Label percentLabel = (Label)this.getControl("percentlabel" + i);
            percentLabel.setText(factorInfo.getValue() + "%");
            ProgressBar bar = (ProgressBar)this.getControl("progressbar" + i);
            bar.setPercent(factorInfo.getValue().intValue());
        }
    }

    private DynamicObject loadPredictResult(Long taskId) {
        return BusinessDataServiceHelper.loadSingle((String)"task_approval_result", (String)"taskid,affect,predictpass", (QFilter[])new QFilter("taskid", "=", (Object)taskId).toArray());
    }

    private List<FactorInfo> parseAffectFactorInfo(DynamicObject predictResult) {
        try {
            HashMap<String, FactorInfo> fieldName2Info = AffectFactorParser.parseAffectFactorInfo(predictResult);
            return fieldName2Info.values().stream().sorted((e1, e2) -> e2.getValue().compareTo(e1.getValue())).limit(3L).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error(String.format("Error to parse affect field of task %s", predictResult.getString("taskid")), (Throwable)e);
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u9884\u6d4b\u6570\u636e\u89e3\u6790\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a%1$s\u3002", (String)"TaskPredictParseMiniPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]), e.getMessage()));
            return Collections.emptyList();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (key.startsWith("detaillabel")) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("task_predict_parse");
            showParameter.getOpenStyle().setTargetKey("tabap");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setCustomParam("taskId", (Object)Long.parseLong(this.getPageCache().get("taskid")));
            this.getView().showForm(showParameter);
            this.getView().close();
        }
    }
}

