/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.smartcs.rpt;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.control.events.ChartClickEvent;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.ssc.smartcs.enums.UserFeedbackEnum;
import kd.ssc.task.util.AlgUtil;

public class RptKnowledgeQAFormPlugin
extends AbstractReportFormPlugin {
    private static final String[] COLORS = new String[]{"#40A9FF", "#45DAD1", "#73D13D", "#FFC53D"};
    private static final String CACHE_ASK_CHART = "CACHE_ASK_CHART";
    private static final String CACHE_ASK_CHART_NAME = "CACHE_ASK_CHART_NAME";
    private static final String ASK_PIE = "askpiechart";
    private final Supplier<String> askChartName = () -> ResManager.loadKDString((String)"\u77e5\u8bc6\u9886\u57df\u95ee\u8be2\u5360\u6bd4", (String)"RptKnowledgeQAFormPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]);
    private final Supplier<String> subjectChartName = () -> ResManager.loadKDString((String)"\u7c7b\u76ee\u95ee\u8be2\u5360\u6bd4", (String)"RptKnowledgeQAFormPlugin_7", (String)"ssc-task-formplugin", (Object[])new Object[0]);
    private final Supplier<String> otherTag = () -> ResManager.loadKDString((String)"\u5176\u4ed6", (String)"RptKnowledgeQAFormPlugin_8", (String)"ssc-task-formplugin", (Object[])new Object[0]);
    private static final Log log = LogFactory.getLog(RptKnowledgeQAFormPlugin.class);

    public void initialize() {
        Chart pieChart = (Chart)this.getControl(ASK_PIE);
        pieChart.setMerge(false);
    }

    protected void filterContainerInit(FilterContainerInitEvent contInitEvent, ReportQueryParam queryParam) {
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{ASK_PIE});
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        for (DynamicObject row : rowData) {
            int askNum = row.getInt("asknum");
            int satisfyNum = row.getInt("satisfynum");
            BigDecimal percentVal = BigDecimal.ZERO;
            if (askNum != 0) {
                percentVal = BigDecimal.valueOf((float)satisfyNum / (float)askNum * 100.0f).setScale(0, RoundingMode.HALF_UP);
            }
            row.set("satisfypercent", (Object)percentVal.intValue());
        }
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        IReportView view = this.getView();
        List<QFilter> filters = this.getFilters(queryParam);
        int total = this.getTotal(new ArrayList<QFilter>(filters));
        ItemValue[] askPieChartData = this.getAskPieChartData(new ArrayList<QFilter>(filters), total);
        Chart askPieChart = (Chart)this.getControl(ASK_PIE);
        if (askPieChartData.length > 0) {
            view.setVisible(Boolean.TRUE, new String[]{ASK_PIE});
            this.setAskPieChart(askPieChart, askPieChartData);
            askPieChart.refresh();
            this.getPageCache().put(CACHE_ASK_CHART, SerializationUtils.toJsonString((Object)askPieChartData));
        } else {
            view.setVisible(Boolean.FALSE, new String[]{ASK_PIE});
            this.getPageCache().remove(CACHE_ASK_CHART);
        }
        ItemValue[] answerPieChartData = this.getAnswerPieChartData(new ArrayList<QFilter>(filters), total);
        Chart answerPieChart = (Chart)this.getControl("answerpiechart");
        if (answerPieChartData.length > 0) {
            view.setVisible(Boolean.TRUE, new String[]{"answerpiechart"});
            this.setAnswerPieChart(answerPieChart, answerPieChartData, total);
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"answerpiechart"});
        }
        List<String> askData = this.getAskNumTop5(new ArrayList<QFilter>(filters));
        this.setAskNumTop5(askData);
    }

    private int getTotal(List<QFilter> filters) {
        String algoKey = ((Object)((Object)this)).getClass() + ".getTotal()";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"som_knowledge_qa_log", (String)"id", (QFilter[])filters.toArray(new QFilter[filters.size()]), null);){
            int n = dataSet.count("id", false);
            return n;
        }
    }

    private ItemValue[] getAskPieChartData(List<QFilter> filters, int total) {
        ArrayList<ItemValue> returnData;
        block41: {
            if (total == 0) {
                return new ItemValue[0];
            }
            returnData = new ArrayList<ItemValue>(4);
            String algoKey = ((Object)((Object)this)).getClass() + ".getAskPieChartData()";
            String selFields = "knowledge.area area";
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"som_knowledge_qa_log", (String)selFields, (QFilter[])filters.toArray(new QFilter[filters.size()]), null);
                 DataSet resultSet = dataSet.groupBy(new String[]{"area"}).count("asknum").finish().orderBy(new String[]{"asknum desc"}).top(4);
                 DataSet resultSet_ = resultSet.copy();){
                Map<Object, DynamicObject> areaMap = this.loadAreaDynObjs(resultSet_);
                if (areaMap == null) break block41;
                int i = 0;
                int addUpPercent = 0;
                int addUpAskNum = 0;
                for (Row row : resultSet) {
                    StringBuilder sb;
                    DynamicObject areaObj = areaMap.get(row.getLong("area"));
                    if (areaObj == null) continue;
                    int askNum = row.getInteger("asknum");
                    int percent = BigDecimal.valueOf((float)askNum / (float)total * 100.0f).setScale(0, RoundingMode.HALF_UP).intValue();
                    if (i < 3) {
                        sb = new StringBuilder();
                        sb.append(areaObj.getString("name")).append(" | ").append(percent).append('%');
                        returnData.add(new ItemValue(sb.toString(), (Number)askNum, COLORS[i]));
                        addUpPercent += percent;
                    } else {
                        if (i != 3 || addUpPercent >= 100) break;
                        sb = new StringBuilder(ResManager.loadKDString((String)"\u5176\u5b83", (String)"RptKnowledgeQAFormPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                        sb.append(" | ").append(100 - addUpPercent).append('%');
                        returnData.add(new ItemValue(sb.toString(), (Number)(total - addUpAskNum), COLORS[i]));
                    }
                    addUpAskNum += askNum;
                    ++i;
                }
            }
        }
        return returnData.toArray(new ItemValue[returnData.size()]);
    }

    private ItemValue[] getAnswerPieChartData(List<QFilter> filters, int total) {
        if (total == 0) {
            return new ItemValue[0];
        }
        ArrayList<ItemValue> returnData = new ArrayList<ItemValue>(4);
        String algoKey = ((Object)((Object)this)).getClass() + ".getAnswerPieChartData()";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"som_knowledge_qa_log", (String)"feedback", (QFilter[])filters.toArray(new QFilter[filters.size()]), null);
             DataSet resultSet = dataSet.groupBy(new String[]{"feedback"}).count("asknum").finish();){
            for (Row row : resultSet) {
                String color;
                String title;
                int askNum = row.getInteger("asknum");
                String feedBackVal = row.getString("feedback");
                if (UserFeedbackEnum.NOTHING.getValue().equals(feedBackVal)) {
                    title = ResManager.loadKDString((String)"\u6ca1\u6709", (String)"RptKnowledgeQAFormPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]);
                    color = COLORS[0];
                } else if (UserFeedbackEnum.SUPPORT.getValue().equals(feedBackVal)) {
                    title = ResManager.loadKDString((String)"\u8d5e", (String)"RptKnowledgeQAFormPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]);
                    color = COLORS[1];
                } else {
                    if (!UserFeedbackEnum.OPPOSE.getValue().equals(feedBackVal)) continue;
                    title = ResManager.loadKDString((String)"\u8e29", (String)"RptKnowledgeQAFormPlugin_5", (String)"ssc-task-formplugin", (Object[])new Object[0]);
                    color = COLORS[2];
                }
                returnData.add(new ItemValue(title, (Number)askNum, color));
            }
        }
        ItemValue[] data = returnData.toArray(new ItemValue[returnData.size()]);
        this.calPercent(data);
        return data;
    }

    private List<QFilter> getFilters(ReportQueryParam queryParam) {
        List qFilters = queryParam.getFilter().getQFilters();
        return qFilters.stream().filter(p -> "asktime".equals(p.getProperty())).collect(Collectors.toList());
    }

    private Map<Object, DynamicObject> loadAreaDynObjs(DataSet resultSet_) {
        ArrayList<Long> areaIds = new ArrayList<Long>(4);
        for (Row row : resultSet_) {
            areaIds.add(row.getLong("area"));
        }
        if (areaIds.isEmpty()) {
            return null;
        }
        QFilter qFilter = new QFilter("id", "in", areaIds);
        Map areaDoMap = BusinessDataServiceHelper.loadFromCache((String)"som_knowledge_area", (String)"id,area", (QFilter[])new QFilter[]{qFilter});
        return areaDoMap;
    }

    private List<String> getAskNumTop5(List<QFilter> filters) {
        ArrayList<String> returnData = new ArrayList<String>(5);
        String algoKey = ((Object)((Object)this)).getClass() + ".getAskNumTop5()";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"som_knowledge_qa_log", (String)"knowledge.id knowlid, knowledge.question question ", (QFilter[])filters.toArray(new QFilter[filters.size()]), null);
             DataSet resultSet = dataSet.groupBy(new String[]{"knowlid", "question"}).count("asknum").finish().orderBy(new String[]{"asknum desc"}).top(5);
             DataSet resultSet_ = resultSet.copy();){
            for (Row row : resultSet) {
                returnData.add(row.getString("question"));
            }
        }
        return returnData;
    }

    private Map<Object, DynamicObject> loadKnowledgeDynObjs(DataSet resultSet_) {
        DynamicObject[] dynObjs;
        HashMap<Object, DynamicObject> returnData = new HashMap<Object, DynamicObject>(5);
        ArrayList<Long> knowlIds = new ArrayList<Long>(4);
        for (Row row : resultSet_) {
            knowlIds.add(row.getLong("knowledge"));
        }
        if (knowlIds.isEmpty()) {
            return null;
        }
        QFilter idFilter = new QFilter("id", "in", knowlIds);
        for (DynamicObject dynObj : dynObjs = BusinessDataServiceHelper.load((String)"som_knowledge_info", (String)"id,question", (QFilter[])new QFilter[]{idFilter}, null)) {
            returnData.put(dynObj.getLong("id"), dynObj);
        }
        return returnData;
    }

    public void click(EventObject evt) {
        if (evt instanceof ChartClickEvent) {
            ChartClickEvent chartClick = (ChartClickEvent)evt;
            String seriesName = chartClick.getSeriesName();
            log.info(seriesName + "\u88ab\u70b9\u51fb\u3002");
            if (seriesName == null || !seriesName.equals(this.getPageCache().get(CACHE_ASK_CHART_NAME))) {
                return;
            }
            Chart pieChart = (Chart)this.getControl(ASK_PIE);
            pieChart.clearGraphic();
            pieChart.clearData();
            String askCacheData = this.getPageCache().get(CACHE_ASK_CHART);
            List itemValues = SerializationUtils.fromJsonStringToList((String)askCacheData, LinkedHashMap.class);
            ItemValue[] outerData = (ItemValue[])itemValues.stream().map(e -> new ItemValue((String)e.get("name"), (Number)e.get("value"), (String)e.get("color"))).toArray(ItemValue[]::new);
            this.setAskPieChart(pieChart, outerData);
            String name = chartClick.getName();
            String areaName = name.split(" \\|")[0];
            ItemValue[] innerData = this.getSubjectData(areaName);
            this.setSubjectPieChart(pieChart, innerData);
            pieChart.refresh();
        }
    }

    private void setAskPieChart(Chart pieChart, ItemValue[] data) {
        pieChart.addTooltip("trigger", (Object)"item");
        String askChartName = this.askChartName.get();
        this.getPageCache().put(CACHE_ASK_CHART_NAME, askChartName);
        PieSeries pieSeries = pieChart.createPieSeries(askChartName);
        pieSeries.setData(data);
        pieSeries.setRadius("55%", "75%");
        pieSeries.setCenter("110px", "115px");
        Label label = new Label();
        label.setShow(false);
        pieSeries.setLabel(label);
        pieChart.setShowTooltip(true);
        pieChart.setLegendPropValue("left", (Object)"230px");
        pieChart.setLegendPropValue("top", (Object)"50px");
        HashMap<String, String> textStyle = new HashMap<String, String>();
        textStyle.put("fontSize", "12");
        textStyle.put("color", "#000000");
        pieChart.setTitlePropValue("textStyle", textStyle);
        pieChart.setTitlePropValue("left", (Object)"90px");
        pieChart.setTitlePropValue("top", (Object)"90px");
    }

    private void setSubjectPieChart(Chart pieChart, ItemValue[] data) {
        PieSeries pieSeries = pieChart.createPieSeries(this.subjectChartName.get());
        pieSeries.setData(data);
        pieSeries.setRadius("0%", "35%");
        pieSeries.setCenter("110px", "115px");
        Label label = new Label();
        label.setShow(false);
        pieSeries.setLabel(label);
        pieChart.setShowTitle(false);
        pieChart.setShowTooltip(true);
        pieChart.setLegendPropValue("left", (Object)"230px");
        pieChart.setLegendPropValue("top", (Object)"50px");
        pieChart.setLegendPropValue("data", Arrays.stream(data).map(ItemValue::getName).collect(Collectors.toList()));
        HashMap<String, String> textStyle = new HashMap<String, String>();
        textStyle.put("fontSize", "12");
        textStyle.put("color", "#000000");
        pieChart.setTitlePropValue("textStyle", textStyle);
        pieChart.setTitlePropValue("left", (Object)"90px");
        pieChart.setTitlePropValue("top", (Object)"90px");
    }

    private void setAnswerPieChart(Chart pieChart, ItemValue[] data, int count) {
        pieChart.addTooltip("trigger", (Object)"item");
        PieSeries pieSeries = pieChart.createPieSeries(ResManager.loadKDString((String)"\u7528\u6237\u53cd\u9988\u5360\u6bd4", (String)"RptKnowledgeQAFormPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        pieSeries.setData(data);
        pieSeries.setCenter("110px", "115px");
        Label label = new Label();
        label.setShow(false);
        pieSeries.setLabel(label);
        pieChart.setShowTooltip(true);
        pieChart.setShowTitle(false);
        pieChart.setLegendPropValue("left", (Object)"230px");
        pieChart.setLegendPropValue("top", (Object)"90px");
        pieChart.refresh();
    }

    private void setAskNumTop5(List<String> data) {
        String baseField = "txtq";
        String baseControl = "flexq";
        ArrayList<String> displayFlexs = new ArrayList<String>(5);
        int size = data.size();
        for (int i = 0; i < size; ++i) {
            this.getModel().setValue(baseField + (i + 1), (Object)data.get(i));
            displayFlexs.add(baseControl + (i + 1));
        }
        if (!displayFlexs.isEmpty()) {
            this.getView().setVisible(Boolean.TRUE, displayFlexs.toArray(new String[displayFlexs.size()]));
        }
        ArrayList<String> hideFlexs = new ArrayList<String>(5);
        for (int i = size + 1; i < 6; ++i) {
            hideFlexs.add(baseControl + i);
        }
        if (!hideFlexs.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, hideFlexs.toArray(new String[hideFlexs.size()]));
        }
    }

    private ItemValue[] getSubjectData(String areaName) {
        IReportListModel reportList = ((ReportList)this.getControl("reportlistap")).getReportModel();
        DynamicObjectCollection rowData = reportList.getRowData(0, reportList.getRowCount(), false);
        Map<String, Integer> subjectNum = rowData.stream().filter(r -> areaName.equals(r.getString("knowlarea.name"))).collect(Collectors.groupingBy(e -> StringUtils.isEmpty((String)e.getString("subject")) ? this.otherTag.get() : e.getString("subject"), Collectors.summingInt(e -> e.getInt("asknum"))));
        List entries = subjectNum.entrySet().stream().sorted((e1, e2) -> ((Integer)e2.getValue()).compareTo((Integer)e1.getValue())).collect(Collectors.toList());
        int topN = 5;
        int other = 0;
        int cur = 0;
        ItemValue[] innerData = new ItemValue[Math.min(topN + 1, entries.size())];
        for (Map.Entry entry : entries) {
            if (this.otherTag.get().equals(entry.getKey()) || cur >= topN) {
                other += ((Integer)entry.getValue()).intValue();
                continue;
            }
            innerData[cur++] = new ItemValue((String)entry.getKey(), (Number)entry.getValue());
        }
        if (entries.size() > topN) {
            innerData[topN] = new ItemValue(this.otherTag.get(), (Number)other);
        }
        this.calPercent(innerData);
        return innerData;
    }

    private void calPercent(ItemValue[] data) {
        if (data == null || data.length == 0) {
            return;
        }
        double[] value = new double[data.length];
        for (int i = 0; i < data.length; ++i) {
            value[i] = data[i].getValue().doubleValue();
        }
        double[] doubles = AlgUtil.maxRemainder((double[])value, (int)0);
        String format = "0";
        DecimalFormat formatter = new DecimalFormat(format);
        for (int i = 0; i < data.length; ++i) {
            data[i].setName(data[i].getName() + " | " + formatter.format(doubles[i]) + "%");
        }
    }
}

