/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.smartqualitycheck;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.task.common.CommonFilterUtil;
import kd.ssc.task.formplugin.QualityCheckSchemePlugin;

public class SmartQualitySchemePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(QualityCheckSchemePlugin.class);
    private IDataModel model;
    private IFormView view;

    public void initialize() {
        super.initialize();
        this.model = this.getModel();
        this.view = this.getView();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ((BasedataEdit)this.getControl("qualitychecktasktype")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((BasedataEdit)this.getControl("tasktype")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((BasedataEdit)this.getControl("taskbill")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((BasedataEdit)this.getControl("selectedorg")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((BasedataEdit)this.getControl("cpname")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String ssc = (String)showParameter.getCustomParam("ssc");
        this.getModel().setValue("ssccenter", (Object)Long.parseLong(ssc));
        if ("0".equalsIgnoreCase(this.getModel().getValue("isautoprocess") + "")) {
            this.view.setEnable(Boolean.FALSE, new String[]{"disrule"});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        super.afterDoOperation(event);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        OperationStatus operationStatus = showParameter.getStatus();
        logger.info("\u667a\u80fd\u8d28\u68c0\u65b9\u6848\uff1a" + operationStatus.name() + operationStatus.getValue());
        if (event.getOperateKey().equals("save") && event.getOperationResult().isSuccess()) {
            QFilter filter = new QFilter("enable", "=", (Object)"1");
            filter.and(new QFilter("ssccenter", "=", (Object)Long.parseLong((String)showParameter.getCustomParam("ssc"))));
            DynamicObject[] schemes = BusinessDataServiceHelper.load((String)"task_smartcheckscheme", (String)"id,enable,createtime", (QFilter[])new QFilter[]{filter}, (String)"createtime desc");
            if (schemes.length < 2) {
                return;
            }
            for (int i = 1; i < schemes.length; ++i) {
                schemes[i].set("enable", (Object)"0");
            }
            SaveServiceHelper.update((DynamicObject[])schemes);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save) {
            OrmLocaleValue nameValue = (OrmLocaleValue)this.getModel().getValue("name");
            nameValue.setLocaleValue(ResManager.loadKDString((String)"\u667a\u80fd\u8d28\u68c0\u65b9\u6848", (String)"SmartQualitySchemePlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("name", (Object)nameValue);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = ((BasedataEdit)e.getSource()).getKey();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        Object ssc = this.model.getValue("ssccenter");
        Long sscId = ssc != null ? ((DynamicObject)ssc).getLong("id") : 0L;
        switch (key) {
            case "qualitychecktasktype": 
            case "tasktype": {
                QFilter sscFilter = new QFilter("orgfield", "=", (Object)sscId);
                showParameter.getListFilterParameter().setFilter(sscFilter);
                break;
            }
            case "taskbill": {
                QFilter sscFilter = new QFilter("ssccenter", "=", (Object)sscId);
                showParameter.getListFilterParameter().setFilter(sscFilter);
                break;
            }
            case "selectedorg": {
                QFilter sscFilter = CommonFilterUtil.getDeputeOrgOfSSCCenterFilter2(this.getPageCache(), "qualityCheckScheme_selectOrg", sscId);
                showParameter.getListFilterParameter().setFilter(sscFilter);
                showParameter.setFormId("ssc_orgtreelistf7");
                showParameter.setCustomParam("ServiceAppId", (Object)"ssc");
                showParameter.setCustomParam("sscId", (Object)sscId.toString());
                break;
            }
            case "cpname": {
                DynamicObjectCollection cpEntry = this.model.getEntryEntity("cpentry");
                ArrayList cpList = new ArrayList();
                cpEntry.forEach(entity -> {
                    DynamicObject cp = entity.getDynamicObject("cpname");
                    if (cp != null) {
                        cpList.add(cp.getLong("id"));
                    }
                });
                QFilter filter = new QFilter("id", "not in", cpList);
                filter.and(new QFilter("ssccenter", "=", (Object)sscId));
                showParameter.getListFilterParameter().setFilter(filter);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "cpname": {
                ChangeData data = e.getChangeSet()[0];
                Object newValue = data.getNewValue();
                int index = data.getRowIndex();
                if (newValue == null) break;
                this.model.beginInit();
                DynamicObject checkingPoint = (DynamicObject)newValue;
                this.model.setValue("cpnumber", (Object)checkingPoint.getString("number"), index);
                this.model.endInit();
                this.view.updateView();
                break;
            }
            case "isautoprocess": {
                this.handleDisRule();
                break;
            }
        }
    }

    private void handleDisRule() {
        String isautoprocess = this.model.getValue("isautoprocess") + "";
        if ("1".equalsIgnoreCase(isautoprocess)) {
            this.model.setValue("disrule", (Object)"1");
            this.view.setEnable(Boolean.TRUE, new String[]{"disrule"});
        } else if ("0".equalsIgnoreCase(isautoprocess)) {
            this.model.setValue("disrule", (Object)"0");
            this.view.setEnable(Boolean.FALSE, new String[]{"disrule"});
        } else {
            this.model.setValue("disrule", (Object)"0");
            this.view.setEnable(Boolean.TRUE, new String[]{"disrule"});
        }
    }
}

