/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.taskpool.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.tree.TreeNode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.task.formplugin.taskpool.helper.TaskPoolKDStringHelper;
import org.jetbrains.annotations.NotNull;

public class TaskPoolService {
    private static final Log LOG = LogFactory.getLog(TaskPoolService.class);
    private long sscId;
    private String type = "0";
    private Set<String> showClassSet = new HashSet<String>();
    private Map<String, List<DynamicObject>> classRefMap = new HashMap<String, List<DynamicObject>>();
    private Map<String, Integer> classRefNumMap = new HashMap<String, Integer>();
    private Map<String, Set<String>> classRefBillMap = new HashMap<String, Set<String>>();
    private Set<String> notClassSet = new LinkedHashSet<String>();
    private Map<String, Integer> billRefNumMap = new HashMap<String, Integer>();
    private Map<String, String> billRefNameMap = new HashMap<String, String>();
    private Map<String, String> billRefFormIdMap = new HashMap<String, String>();
    private Map<String, Set<String>> billRefEntryIdMap = new HashMap<String, Set<String>>();
    private Map<String, String> entryIdRefTaskIdMap = new HashMap<String, String>();
    private Map<String, Integer> entryIdRefNumMap = new HashMap<String, Integer>();
    private Map<String, String> entryIdRefNameMap = new HashMap<String, String>();
    private Map<String, String> entryIdRefFormIdMap = new HashMap<String, String>();

    public TaskPoolService(long sscId) {
        this.sscId = sscId;
    }

    public List<TreeNode> buildTree(TreeNode root) {
        LOG.info("TaskPoolService.buildTree a1={}", (Object)System.currentTimeMillis());
        ArrayList<TreeNode> childNodes = new ArrayList<TreeNode>();
        HashMap<Long, Map<Long, Integer>> shareTaskMap = new HashMap<Long, Map<Long, Integer>>();
        int shareTaskNum = this.getAllShareTask(shareTaskMap);
        LOG.info("TaskPoolService.buildTree a2={}", (Object)System.currentTimeMillis());
        int qiTaskNum = this.initShowInfo(shareTaskNum);
        LOG.info("TaskPoolService.buildTree a3={}", (Object)System.currentTimeMillis());
        if ("-1".equals(this.type)) {
            root.setText(TaskPoolKDStringHelper.shareTask());
            return childNodes;
        }
        if ("1".equals(this.type)) {
            root.setText(TaskPoolKDStringHelper.qiTask());
            this.setNodeNum(root, qiTaskNum);
            return childNodes;
        }
        if ("2".equals(this.type)) {
            root.setText(TaskPoolKDStringHelper.shareTask());
            this.setNodeNum(root, shareTaskNum);
            this.classRefNumMap.put(root.getId(), shareTaskNum);
            this.buildShareNode(root, childNodes, false, shareTaskMap);
            LOG.info("TaskPoolService.buildTree a4={}", (Object)System.currentTimeMillis());
            return childNodes;
        }
        TreeNode qiNode = new TreeNode(root.getId(), "10001", TaskPoolKDStringHelper.qiTask());
        this.setNodeNum(qiNode, qiTaskNum);
        qiNode.setChildren(null);
        childNodes.add(qiNode);
        TreeNode shareNode = new TreeNode(root.getId(), "10002", TaskPoolKDStringHelper.shareTask());
        this.setNodeNum(shareNode, shareTaskNum);
        this.buildShareNode(shareNode, childNodes, true, shareTaskMap);
        childNodes.add(shareNode);
        LOG.info("TaskPoolService.buildTree a4={}", (Object)System.currentTimeMillis());
        this.setRootNodeNumOfAll(root, qiTaskNum + shareTaskNum);
        return childNodes;
    }

    private void buildShareNode(TreeNode shareNode, List<TreeNode> childNodes, boolean haveQi, Map<Long, Map<Long, Integer>> shareTaskMap) {
        LOG.info("TaskPoolService.buildShareNode b1={}", (Object)System.currentTimeMillis());
        DynamicObject[] classArr = this.getBillClass();
        LOG.info("TaskPoolService.buildShareNode b2={}", (Object)System.currentTimeMillis());
        if (classArr == null || classArr.length == 0) {
            this.setNodeNum(shareNode, 0);
            shareNode.setChildren(null);
            return;
        }
        String shareKey = shareNode.getId();
        HashSet<DynamicObject> leafSet = new HashSet<DynamicObject>();
        this.buildTaskBillTypeRefMap(classArr, shareKey, leafSet);
        List<DynamicObject> level1 = this.classRefMap.get(shareKey);
        if (level1 == null || level1.isEmpty()) {
            this.setNodeNum(shareNode, 0);
            shareNode.setChildren(null);
            return;
        }
        Set<DynamicObject> allTaskBill = this.buildClassNum(level1, classArr, shareTaskMap);
        LOG.info("TaskPoolService.buildShareNode b3={}", (Object)System.currentTimeMillis());
        this.buildClassRefBill(allTaskBill, shareTaskMap);
        LOG.info("TaskPoolService.buildShareNode b4={}", (Object)System.currentTimeMillis());
        ArrayList<TreeNode> childNodeList = new ArrayList<TreeNode>(level1.size());
        for (DynamicObject classDy : level1) {
            String id = classDy.getString("id");
            if (!this.showClassSet.contains(id)) continue;
            TreeNode childNode = new TreeNode(shareKey, classDy.getString("id"), classDy.getString("name"));
            childNode.setData((Object)classDy.getString("number"));
            this.buildTreeNode(classDy, childNode);
            childNodeList.add(childNode);
        }
        LOG.info("TaskPoolService.buildShareNode b5={}", (Object)System.currentTimeMillis());
        this.buildHisBillType(childNodeList, shareNode.getId());
        LOG.info("TaskPoolService.buildShareNode b6={}", (Object)System.currentTimeMillis());
        if (haveQi) {
            shareNode.addChildren(childNodeList);
        } else {
            childNodes.addAll(childNodeList);
        }
    }

    private void buildHisBillType(List<TreeNode> childNodeList, String parentId) {
        if (this.notClassSet.isEmpty()) {
            return;
        }
        for (String billId : this.notClassSet) {
            Integer billNum = this.billRefNumMap.getOrDefault(billId, 0);
            TreeNode nextChildNode = new TreeNode(parentId, billId, this.billRefNameMap.get(billId));
            this.setNodeNum(nextChildNode, billNum);
            Set entrySet = this.billRefEntryIdMap.getOrDefault(billId, new HashSet());
            if (entrySet == null || entrySet.size() < 2) {
                nextChildNode.setLeaf(true);
                nextChildNode.setIsOpened(false);
            } else {
                ArrayList<TreeNode> taskNodeList = new ArrayList<TreeNode>(entrySet.size());
                for (String entryId : entrySet) {
                    TreeNode taskNode = new TreeNode(billId, entryId, this.entryIdRefNameMap.get(entryId));
                    this.setNodeNum(taskNode, this.entryIdRefNumMap.getOrDefault(entryId, 0));
                    taskNode.setLeaf(true);
                    taskNode.setIsOpened(false);
                    taskNodeList.add(taskNode);
                }
                nextChildNode.setChildren(taskNodeList);
            }
            childNodeList.add(nextChildNode);
        }
    }

    private void buildTreeNode(DynamicObject classDy, TreeNode childNode) {
        Set<String> billSet;
        TreeNode nextChildNode;
        List<DynamicObject> nextList;
        String id = classDy.getString("id");
        if (!this.showClassSet.contains(id)) {
            return;
        }
        ArrayList<TreeNode> nextChildNodeList = new ArrayList<TreeNode>();
        Integer num = this.classRefNumMap.get(id);
        if (num != null) {
            this.setNodeNum(childNode, num);
        }
        if ((nextList = this.classRefMap.get(id)) != null && !nextList.isEmpty()) {
            for (DynamicObject nextClassDy : nextList) {
                String nextClassId = nextClassDy.getString("id");
                if (!this.showClassSet.contains(nextClassId)) continue;
                nextChildNode = new TreeNode(id, nextClassDy.getString("id"), nextClassDy.getString("name"));
                this.buildTreeNode(nextClassDy, nextChildNode);
                nextChildNodeList.add(nextChildNode);
            }
        }
        if ((billSet = this.classRefBillMap.get(id)) != null && !billSet.isEmpty()) {
            for (String billKey : billSet) {
                nextChildNode = new TreeNode(id, billKey, this.billRefNameMap.get(billKey));
                Integer billNum = this.billRefNumMap.getOrDefault(billKey, 0);
                this.setNodeNum(nextChildNode, billNum);
                Set entrySet = this.billRefEntryIdMap.getOrDefault(billKey, new HashSet());
                if (entrySet == null || entrySet.size() < 2) {
                    nextChildNode.setIsOpened(false);
                    nextChildNode.setLeaf(true);
                } else {
                    ArrayList<TreeNode> taskNodeList = new ArrayList<TreeNode>(entrySet.size());
                    for (String entryId : entrySet) {
                        TreeNode taskNode = new TreeNode(billKey, entryId, this.entryIdRefNameMap.get(entryId));
                        this.setNodeNum(taskNode, this.entryIdRefNumMap.getOrDefault(entryId, 0));
                        taskNode.setIsOpened(false);
                        taskNode.setLeaf(true);
                        taskNodeList.add(taskNode);
                    }
                    nextChildNode.setChildren(taskNodeList);
                }
                nextChildNodeList.add(nextChildNode);
            }
        }
        if (nextChildNodeList.isEmpty()) {
            childNode.setIsOpened(false);
            childNode.setChildren(null);
        } else {
            childNode.setChildren(nextChildNodeList);
        }
    }

    private void buildClassRefBill(Set<DynamicObject> allTaskBill, Map<Long, Map<Long, Integer>> shareTaskMap) {
        for (DynamicObject billTypeDy : allTaskBill) {
            String classId = billTypeDy.getString("group.id");
            String billId = billTypeDy.getString("id");
            Set billSet = this.classRefBillMap.getOrDefault(classId, new HashSet());
            billSet.add(billId);
            this.classRefBillMap.put(classId, billSet);
            this.billRefNameMap.put(billId, billTypeDy.getString("name"));
            this.billRefFormIdMap.put(billId, billTypeDy.getString("id"));
            Map<Long, Integer> typeMap = shareTaskMap.get(billTypeDy.getLong("id"));
            int billNum = 0;
            if (typeMap != null) {
                Set<Map.Entry<Long, Integer>> entries = typeMap.entrySet();
                for (Map.Entry<Long, Integer> next : entries) {
                    Integer typeNum = next.getValue();
                    billNum += typeNum.intValue();
                }
            }
            this.billRefNumMap.put(billId, billNum);
            DynamicObjectCollection taskColl = billTypeDy.getDynamicObjectCollection("entryentity");
            if (taskColl == null || taskColl.size() < 2) continue;
            for (DynamicObject entry : taskColl) {
                String entryId = entry.getString("id");
                String taskId = entry.getString("tasktype.id");
                this.entryIdRefTaskIdMap.put(entryId, taskId);
                Set entryIdSet = this.billRefEntryIdMap.getOrDefault(billId, new HashSet());
                entryIdSet.add(entryId);
                this.billRefEntryIdMap.put(billId, entryIdSet);
                this.entryIdRefNameMap.put(entryId, entry.getString("tasktype.name"));
                this.entryIdRefFormIdMap.put(entryId, billTypeDy.getString("id"));
                int typeNum = 0;
                if (typeMap != null) {
                    typeNum = typeMap.getOrDefault(entry.getLong("tasktype.id"), 0);
                }
                this.entryIdRefNumMap.put(entryId, typeNum);
            }
        }
    }

    private Set<DynamicObject> buildClassNum(List<DynamicObject> level1, DynamicObject[] classArr, Map<Long, Map<Long, Integer>> shareTaskMap) {
        HashMap<Long, Integer> leafRefNumMap = new HashMap<Long, Integer>();
        HashSet<DynamicObject> processTaskBill = new HashSet<DynamicObject>();
        HashSet<DynamicObject> comTaskBill = new HashSet<DynamicObject>();
        HashSet<DynamicObject> ruleTaskBill = new HashSet<DynamicObject>();
        LOG.info("TaskPoolService.buildClassNum c1={}", (Object)System.currentTimeMillis());
        this.getTaskBill(processTaskBill, comTaskBill, ruleTaskBill, leafRefNumMap, shareTaskMap);
        LOG.info("TaskPoolService.buildClassNum c2={}", (Object)System.currentTimeMillis());
        Map<String, Integer> classRefNumMap = this.buildClassNum(processTaskBill, comTaskBill, ruleTaskBill, leafRefNumMap, classArr);
        LOG.info("TaskPoolService.buildClassNum c3={}", (Object)System.currentTimeMillis());
        for (DynamicObject classDy : level1) {
            String id = classDy.getString("id");
            if (!this.showClassSet.contains(id) || classDy.getBoolean("isleaf")) continue;
            this.calNum(this.showClassSet, classDy, classRefNumMap);
        }
        this.classRefNumMap.putAll(classRefNumMap);
        HashSet<DynamicObject> allTaskBill = new HashSet<DynamicObject>();
        allTaskBill.addAll(processTaskBill);
        allTaskBill.addAll(comTaskBill);
        allTaskBill.addAll(ruleTaskBill);
        return allTaskBill;
    }

    private int calNum(Set<String> showClassSet, DynamicObject classDy, Map<String, Integer> classRefNumMap) {
        String id = classDy.getString("id");
        if (!showClassSet.contains(id)) {
            return 0;
        }
        List<DynamicObject> childClassList = this.classRefMap.get(id);
        if (childClassList == null || childClassList.isEmpty()) {
            Integer integer = classRefNumMap.get(id);
            return integer == null ? 0 : integer;
        }
        int sum = 0;
        for (DynamicObject childClassDy : childClassList) {
            int ii = this.calNum(showClassSet, childClassDy, classRefNumMap);
            sum += ii;
        }
        Integer curNum = classRefNumMap.getOrDefault(id, 0);
        classRefNumMap.put(id, curNum + sum);
        return sum;
    }

    private Map<String, Integer> buildClassNum(Set<DynamicObject> processTaskBill, Set<DynamicObject> comTaskBill, Set<DynamicObject> ruleTaskBill, Map<Long, Integer> leafRefNumMap, @NotNull DynamicObject[] classArr) {
        Integer classNum;
        String classId;
        HashMap<String, String> classIdRefMap = new HashMap<String, String>(classArr.length);
        for (DynamicObject classDy : classArr) {
            classIdRefMap.put(classDy.getString("id"), classDy.getString("parent.id"));
        }
        HashMap<String, Integer> classRefNumMap = new HashMap<String, Integer>(processTaskBill.size());
        for (DynamicObject dy : processTaskBill) {
            Integer num = leafRefNumMap.getOrDefault(dy.getLong("id"), 0);
            String classId2 = dy.getString("group.id");
            if (classId2 == null) {
                this.notClassSet.add(dy.getString("id"));
                continue;
            }
            Integer classNum2 = classRefNumMap.getOrDefault(classId2, 0);
            classNum2 = classNum2 + num;
            classRefNumMap.put(classId2, classNum2);
            this.addClassId(classId2, classIdRefMap);
        }
        for (DynamicObject dy : comTaskBill) {
            classId = dy.getString("group.id");
            if (classId == null) {
                this.notClassSet.add(dy.getString("id"));
                continue;
            }
            classNum = classRefNumMap.getOrDefault(classId, 0);
            classRefNumMap.put(classId, classNum);
            this.addClassId(classId, classIdRefMap);
        }
        for (DynamicObject dy : ruleTaskBill) {
            classId = dy.getString("group.id");
            if (classId == null) {
                this.notClassSet.add(dy.getString("id"));
                continue;
            }
            classNum = classRefNumMap.getOrDefault(classId, 0);
            classRefNumMap.put(classId, classNum);
            this.addClassId(classId, classIdRefMap);
        }
        return classRefNumMap;
    }

    private void addClassId(String classId, Map<String, String> classIdRefMap) {
        this.showClassSet.add(classId);
        String parentClassId = classIdRefMap.get(classId);
        if (StringUtils.isEmpty((CharSequence)parentClassId)) {
            return;
        }
        this.addClassId(parentClassId, classIdRefMap);
    }

    private void getTaskBill(Set<DynamicObject> processTaskBill, Set<DynamicObject> comTaskBill, Set<DynamicObject> ruleTaskBill, Map<Long, Integer> leafRefNumMap, Map<Long, Map<Long, Integer>> shareTaskMap) {
        HashSet<Long> processBillIdSet = new HashSet<Long>(shareTaskMap.size());
        LOG.info("TaskPoolService.getTaskBill d1={}", (Object)System.currentTimeMillis());
        Set<Map.Entry<Long, Map<Long, Integer>>> entries = shareTaskMap.entrySet();
        for (Map.Entry<Long, Map<Long, Integer>> next : entries) {
            Long billTypeId = next.getKey();
            processBillIdSet.add(billTypeId);
            Integer num = leafRefNumMap.getOrDefault(billTypeId, 0);
            Map<Long, Integer> typeMap = next.getValue();
            if (typeMap != null) {
                Set<Map.Entry<Long, Integer>> entries1 = typeMap.entrySet();
                Iterator<Map.Entry<Long, Integer>> iteratorType = entries1.iterator();
                while (iteratorType.hasNext()) {
                    Integer typeNum = iteratorType.next().getValue();
                    num = num + typeNum;
                }
            }
            leafRefNumMap.put(billTypeId, num);
        }
        LOG.info("TaskPoolService.getTaskBill d2={}", (Object)System.currentTimeMillis());
        HashSet<Long> comBillIdSet = new HashSet<Long>();
        this.getComBillId(comBillIdSet);
        LOG.info("TaskPoolService.getTaskBill d3={}", (Object)System.currentTimeMillis());
        Set<Long> ruleBillIdSet = this.getRuleTaskBill();
        LOG.info("TaskPoolService.getTaskBill d4={}", (Object)System.currentTimeMillis());
        HashSet<Long> allBillIdSet = new HashSet<Long>();
        allBillIdSet.addAll(processBillIdSet);
        allBillIdSet.addAll(comBillIdSet);
        allBillIdSet.addAll(ruleBillIdSet);
        QFilter billIdQFilter = new QFilter("id", "in", allBillIdSet);
        DynamicObject[] taskBillArr = BusinessDataServiceHelper.load((String)"task_taskbill", (String)"id,name,effective,enable,group,bindbill,taskpool.id,entryentity.tasktype", (QFilter[])new QFilter[]{billIdQFilter});
        if (taskBillArr == null || taskBillArr.length == 0) {
            return;
        }
        LOG.info("TaskPoolService.getTaskBill d5={}", (Object)System.currentTimeMillis());
        for (DynamicObject taskBillDy : taskBillArr) {
            long taskBillId = taskBillDy.getLong("id");
            if (processBillIdSet.contains(taskBillId)) {
                processTaskBill.add(taskBillDy);
                continue;
            }
            if (comBillIdSet.contains(taskBillId)) {
                comTaskBill.add(taskBillDy);
                continue;
            }
            if (!ruleBillIdSet.contains(taskBillId) || "0".equals(taskBillDy.getString("effective"))) continue;
            ruleTaskBill.add(taskBillDy);
        }
    }

    private void getComBillId(Set<Long> comBillIdSet) {
        String algoKey = this.getClass().getName() + ".getComBillId";
        String sql = "select fbilltypeid from t_tk_taskhistory WHERE FSscID = ? AND FPersonID = ?  AND fqualitysamplelibraryid = 0  group by fbilltypeid";
        DBRoute dbRoute = this.getDb();
        try {
            DataSet rows = DB.queryDataSet((String)algoKey, (DBRoute)dbRoute, (String)sql, (Object[])new Object[]{this.sscId, RequestContext.get().getCurrUserId()});
            while (rows.hasNext()) {
                Row row = rows.next();
                Long billType = row.getLong("fbilltypeid");
                if (billType == null || billType == 0L) continue;
                comBillIdSet.add(billType);
            }
        }
        catch (Exception exception) {
            LOG.info("TaskPoolService.getComBillId error");
        }
    }

    private Set<Long> getRuleTaskBill() {
        QFilter sscOrg = new QFilter("createorg", "=", (Object)this.sscId);
        sscOrg.and(new QFilter("entryentity.userfield", "=", (Object)RequestContext.get().getCurrUserId()));
        sscOrg.and(new QFilter("status", "=", (Object)"C"));
        String algoKey = this.getClass().getName() + ".getRuleTaskBill";
        DataSet ruleData = QueryServiceHelper.queryDataSet((String)algoKey, (String)"task_usergroup", (String)"id", (QFilter[])new QFilter[]{sscOrg}, null);
        if (ruleData == null) {
            return new HashSet<Long>();
        }
        HashSet<Long> userGroupSet = new HashSet<Long>();
        for (Row next : ruleData) {
            userGroupSet.add(next.getLong("id"));
        }
        if (userGroupSet.isEmpty()) {
            return new HashSet<Long>();
        }
        QFilter sscOrg2 = new QFilter("ssccenter", "=", (Object)this.sscId);
        sscOrg2.and(new QFilter("entryentity1.usergroup", "in", userGroupSet));
        sscOrg2.and(new QFilter("status", "=", (Object)"C"));
        sscOrg2.and(new QFilter("enable", "=", (Object)"1"));
        DynamicObject[] disRuleArr = BusinessDataServiceHelper.load((String)"task_disrule", (String)"id,tasktype,entryentity.billtype", (QFilter[])new QFilter[]{sscOrg2});
        if (disRuleArr == null || disRuleArr.length == 0) {
            LOG.info("TaskPoolService_getDisTaskBill disRuleArr is null");
            return new HashSet<Long>();
        }
        HashSet<Long> billIdSet = new HashSet<Long>();
        for (DynamicObject disRuleDy : disRuleArr) {
            String qualityJudge = disRuleDy.getString("tasktype.qualityjudge");
            if ("1".equals(qualityJudge)) continue;
            DynamicObjectCollection entryColl = disRuleDy.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryColl) {
                DynamicObject billTypeDy = entry.getDynamicObject("billtype");
                if (billTypeDy == null) continue;
                billIdSet.add(billTypeDy.getLong("id"));
            }
        }
        return billIdSet;
    }

    private DynamicObject[] getAllMyTaskBill() {
        return BusinessDataServiceHelper.load((String)"task_task", (String)"id,tasktypeid,billtype", (QFilter[])new QFilter[]{this.getProcessQFilter()});
    }

    private int getQiTask() {
        int sum = 0;
        String algoKey = this.getClass().getName() + ".getQiTask";
        String sql = "select count(1) num from T_TK_TASK WHERE FSscID = ? AND FPersonID = ? AND FPoolType = ?   AND fqualitysamplelibraryid > 0 ";
        DBRoute dbRoute = this.getDb();
        try {
            DataSet rows = DB.queryDataSet((String)algoKey, (DBRoute)dbRoute, (String)sql, (Object[])new Object[]{this.sscId, RequestContext.get().getCurrUserId(), "1"});
            if (rows.hasNext()) {
                sum = rows.next().getInteger("num");
            }
        }
        catch (Exception exception) {
            LOG.info("TaskPoolService.getQiTask error");
        }
        return sum;
    }

    private DBRoute getDb() {
        IDataEntityType dataEntityType = BusinessDataServiceHelper.newDynamicObject((String)"task_task").getDataEntityType();
        return DBRoute.of((String)dataEntityType.getDBRouteKey());
    }

    private int getAllShareTask(Map<Long, Map<Long, Integer>> shareTaskMap) {
        int sum = 0;
        String algoKey = this.getClass().getName() + ".getAllShareBill";
        String sql = "select fbilltypeid,ftasktypeid,count(1) num from T_TK_TASK WHERE FSscID = ? AND FPersonID = ? AND FPoolType = ?   AND fqualitysamplelibraryid = 0 group by fbilltypeid,ftasktypeid";
        DBRoute dbRoute = this.getDb();
        try {
            DataSet rows = DB.queryDataSet((String)algoKey, (DBRoute)dbRoute, (String)sql, (Object[])new Object[]{this.sscId, RequestContext.get().getCurrUserId(), "1"});
            while (rows.hasNext()) {
                Row row = rows.next();
                Long billType = row.getLong("fbilltypeid");
                if (billType == null) continue;
                Long taskType = row.getLong("ftasktypeid");
                Integer num = row.getInteger("num");
                if (num == null) {
                    num = 0;
                }
                Map orDefault = shareTaskMap.getOrDefault(billType, new HashMap());
                orDefault.put(taskType, num);
                shareTaskMap.put(billType, orDefault);
                sum += num.intValue();
            }
        }
        catch (Exception exception) {
            LOG.info("TaskPoolService.getAllShareTask error");
        }
        return sum;
    }

    private QFilter getProcessQFilter() {
        QFilter commonQFilter = this.getCommonQFilter();
        commonQFilter.and(new QFilter("pooltype", "=", (Object)"1"));
        return commonQFilter;
    }

    private QFilter getCommonQFilter() {
        QFilter sscOrg = new QFilter("sscid", "=", (Object)this.sscId);
        Long reckoner = RequestContext.get().getCurrUserId();
        sscOrg.and(new QFilter("personid", "=", (Object)reckoner));
        return sscOrg;
    }

    private int initShowInfo(int shareTaskNum) {
        boolean exitComShareTask;
        boolean exitComQiTask;
        int qiTaskNum = this.getQiTask();
        if (shareTaskNum == 0 && qiTaskNum == 0) {
            boolean haveQi = this.exitComQiTask();
            boolean haveShare = this.exitComShareTask();
            String type = "0";
            if (!haveQi && !haveShare) {
                type = "-1";
            } else if (haveQi && !haveShare) {
                type = "1";
            } else if (!haveQi && haveShare) {
                type = "2";
            }
            this.type = type;
            return 0;
        }
        this.type = qiTaskNum == 0 ? ((exitComQiTask = this.exitComQiTask()) ? "0" : "2") : (shareTaskNum == 0 ? ((exitComShareTask = this.exitComShareTask()) ? "0" : "1") : "0");
        return qiTaskNum;
    }

    private boolean exitComQiTask() {
        QFilter commonQFilter = this.getCommonQFilter();
        commonQFilter.and(new QFilter("pooltype", "=", (Object)"2"));
        QFilter qi = new QFilter("tasktypeid.qualityjudge", "=", (Object)"1");
        return QueryServiceHelper.exists((String)"task_taskhistory", (QFilter[])new QFilter[]{commonQFilter, qi});
    }

    private boolean exitComShareTask() {
        QFilter commonQFilter = this.getCommonQFilter();
        commonQFilter.and(new QFilter("pooltype", "=", (Object)"2"));
        QFilter notQi = new QFilter("tasktypeid.qualityjudge", "!=", (Object)"1");
        return QueryServiceHelper.exists((String)"task_taskhistory", (QFilter[])new QFilter[]{commonQFilter, notQi});
    }

    public int getQiTask(DynamicObject[] taskBillColl) {
        List qiTask = Arrays.stream(taskBillColl).filter(dd -> "1".equals(dd.getString("tasktypeid.qualityjudge"))).collect(Collectors.toList());
        return qiTask.size();
    }

    private void buildTaskBillTypeRefMap(DynamicObject[] classArr, String shareKey, Set<DynamicObject> leafSet) {
        for (DynamicObject taskBillTypeDy : classArr) {
            String key = this.getParent(taskBillTypeDy, shareKey);
            List orDefault = this.classRefMap.getOrDefault(key, new ArrayList());
            orDefault.add(taskBillTypeDy);
            this.classRefMap.put(key, orDefault);
            if (!taskBillTypeDy.getBoolean("isleaf")) continue;
            leafSet.add(taskBillTypeDy);
        }
    }

    private String getParent(DynamicObject taskBillTypeDy, String shareKey) {
        String key = shareKey;
        DynamicObject parent = taskBillTypeDy.getDynamicObject("parent");
        if (parent != null) {
            key = parent.getString("id");
        }
        return key;
    }

    private DynamicObject[] getBillClass() {
        QFilter sscOrg = new QFilter("ssccenter", "=", (Object)this.sscId);
        QFilter status = new QFilter("status", "=", (Object)"C");
        status.and(sscOrg);
        return BusinessDataServiceHelper.load((String)"task_billclassify", (String)"id,number,name,level,parent,isleaf", (QFilter[])new QFilter[]{status}, (String)" modifytime asc");
    }

    private void setRootNodeNumOfAll(TreeNode node, int num) {
        if (num == 0) {
            node.setIsOpened(false);
            return;
        }
        node.setIsOpened(true);
        node.setText(TaskPoolKDStringHelper.all() + "\uff08" + num + "\uff09");
    }

    private void setNodeNum(TreeNode node, int num) {
        if (num == 0) {
            node.setIsOpened(false);
            return;
        }
        node.setIsOpened(true);
        String text = node.getText();
        text = null == text ? "" : text;
        node.setText(text + "\uff08" + num + "\uff09");
    }

    public Map<String, String> getBillRefFormIdMap() {
        return this.billRefFormIdMap;
    }

    public void setBillRefFormIdMap(Map<String, String> billRefFormIdMap) {
        this.billRefFormIdMap = billRefFormIdMap;
    }

    public Map<String, Integer> getClassRefNumMap() {
        return this.classRefNumMap;
    }

    public void setClassRefNumMap(Map<String, Integer> classRefNumMap) {
        this.classRefNumMap = classRefNumMap;
    }

    public Map<String, String> getEntryIdRefTaskIdMap() {
        return this.entryIdRefTaskIdMap;
    }

    public void setEntryIdRefTaskIdMap(Map<String, String> entryIdRefTaskIdMap) {
        this.entryIdRefTaskIdMap = entryIdRefTaskIdMap;
    }

    public Map<String, Set<String>> getBillRefEntryIdMap() {
        return this.billRefEntryIdMap;
    }

    public void setBillRefEntryIdMap(Map<String, Set<String>> billRefEntryIdMap) {
        this.billRefEntryIdMap = billRefEntryIdMap;
    }

    public Map<String, String> getEntryIdRefFormIdMap() {
        return this.entryIdRefFormIdMap;
    }

    public void setEntryIdRefFormIdMap(Map<String, String> entryIdRefFormIdMap) {
        this.entryIdRefFormIdMap = entryIdRefFormIdMap;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

