/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.param.AppParam;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.ssc.enums.SSCTypeEnum;
import kd.ssc.enums.TaskPoolTypeEnum;
import kd.ssc.task.business.helper.DutyManageDataHelper;

public class VoucherUtil {
    private static final Log log = LogFactory.getLog(VoucherUtil.class);

    public static String getSscBusinessTypeParam(String paramKey, long orgId, String defVal) {
        AppParam param = new AppParam("83bfebc8000020ac", "12", Long.valueOf(orgId), Long.valueOf(0L));
        Object params = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)param, (String)paramKey);
        log.info("\u5171\u4eab\u53c2\u6570sscbusinesstype\uff1a" + params);
        String result = defVal;
        if (null != params) {
            result = (String)params;
            log.info("\u7cfb\u7edf\u63a7\u5236\u51ed\u8bc1\u53c2\u6570\u503c\uff1a" + result);
        }
        return result;
    }

    public static String getSscBusinessTypeParam(long orgId, String defVal) {
        return DutyManageDataHelper.getSSCType((long)orgId);
    }

    @Deprecated
    public static boolean businessType(long orgId) {
        return "1".equals(VoucherUtil.getSscBusinessTypeParam(orgId, "1"));
    }

    public static boolean notFISscType(String sscId) {
        String sscType = DutyManageDataHelper.getSSCType((long)Long.parseLong(sscId));
        return !SSCTypeEnum.FI.getValue().equals(sscType);
    }

    public static List<Long> getVouncheridByBillid(Long billid) {
        ArrayList<Long> voucherIds = new ArrayList<Long>(16);
        QFilter filterRe = new QFilter("sourcebillid", "=", (Object)billid);
        QFilter[] filterRes = new QFilter[]{filterRe};
        DynamicObjectCollection ids = QueryServiceHelper.query((String)"ai_daptracker", (String)"voucherid", (QFilter[])filterRes);
        if (ids != null && !ids.isEmpty()) {
            ids.stream().forEach(v -> voucherIds.add(Long.parseLong(v.getString("voucherid"))));
        }
        return voucherIds;
    }

    public static List<String> getVouncheridsByBillid(Long billid) {
        ArrayList<String> voucherIds = new ArrayList<String>(16);
        QFilter filterRe = new QFilter("sourcebillid", "=", (Object)billid);
        QFilter[] filterRes = new QFilter[]{filterRe};
        DynamicObject[] relations = BusinessDataServiceHelper.load((String)"ai_daptracker", (String)"voucherid", (QFilter[])filterRes);
        if (relations != null && relations.length > 0) {
            Arrays.asList(relations).forEach(obj -> voucherIds.add(obj.getString("voucherid")));
        }
        return voucherIds;
    }

    public static Map<String, String> getVoucherConfig(Long billtypeid, Long tasktypeid, String billnumber, Long billId) {
        DynamicObjectCollection entryentity;
        boolean isneedvoucher;
        QFilter billIdFilter = new QFilter("id", "=", (Object)billId);
        HashMap<String, String> map = new HashMap<String, String>(2);
        DynamicObject task_taskbill = BusinessDataServiceHelper.loadSingle((Object)billtypeid, (String)"task_taskbill");
        if (task_taskbill != null && (isneedvoucher = task_taskbill.getBoolean("isneedvoucher")) && (entryentity = task_taskbill.getDynamicObjectCollection("entryentity")) != null && entryentity.size() > 0) {
            for (DynamicObject obj : entryentity) {
                DynamicObjectCollection entryentityvoucher;
                DynamicObject taskbillchild;
                DynamicObject tasktype = obj.getDynamicObject("tasktype");
                if (tasktype == null || tasktype.getLong("id") != tasktypeid.longValue() || (taskbillchild = BusinessDataServiceHelper.loadSingle((Object)obj.getLong("childpkid"), (String)"task_taskbill_child")) == null || (entryentityvoucher = taskbillchild.getDynamicObjectCollection("entryentityvoucher")) == null || entryentityvoucher.size() <= 0) continue;
                String voucheroperation = null;
                String voucherstatctrl = null;
                for (DynamicObject voucherObj : entryentityvoucher) {
                    String billconditionjson = voucherObj.getString("billconditionjson_tag");
                    if (StringUtils.isEmpty((CharSequence)billconditionjson)) {
                        voucheroperation = voucherObj.getString("voucheroperation");
                        voucherstatctrl = voucherObj.getString("voucherstatctrl");
                        break;
                    }
                    FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)billconditionjson, FilterCondition.class);
                    MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)billnumber);
                    FilterBuilder filterBuilder = new FilterBuilder(dataEntityType, condition);
                    filterBuilder.buildFilter();
                    filterBuilder.getQFilters();
                    QFilter filter = filterBuilder.getQFilter();
                    DynamicObject taskbill = BusinessDataServiceHelper.loadSingle((String)billnumber, (String)"id", (QFilter[])new QFilter[]{filter, billIdFilter});
                    if (taskbill == null) continue;
                    voucheroperation = voucherObj.getString("voucheroperation");
                    voucherstatctrl = voucherObj.getString("voucherstatctrl");
                    break;
                }
                if (!StringUtils.isNotEmpty(voucheroperation) || !StringUtils.isNotEmpty(voucherstatctrl)) continue;
                map.put("voucheroperation", voucheroperation);
                map.put("voucherstatctrl", voucherstatctrl);
                return map;
            }
        }
        return map;
    }

    public static String getVoucherStateById(Long voucherId) {
        String voucherState = null;
        if (QueryServiceHelper.exists((String)"gl_voucher", (Object)voucherId)) {
            DynamicObject voucherDyn = BusinessDataServiceHelper.loadSingle((Object)voucherId, (String)"gl_voucher", (String)"billstatus");
            voucherState = voucherDyn.getString("billstatus");
        }
        return voucherState;
    }

    public static List<String> getVoucherStateByBillId(Long billid) {
        ArrayList<String> voucherStates = new ArrayList<String>(16);
        List<String> vouncherids = VoucherUtil.getVouncheridsByBillid(billid);
        if (!vouncherids.isEmpty()) {
            vouncherids.forEach(v -> voucherStates.add(VoucherUtil.getVoucherStateById(Long.parseLong(v))));
        }
        return voucherStates;
    }

    public static Map<String, String> getResultbyOperate(String operate, List<String> states, boolean control) {
        HashMap<String, String> map = new HashMap<String, String>(2);
        String message = "";
        boolean result = false;
        switch (operate) {
            case "2": {
                boolean bl = result = states.contains("D") || states.isEmpty();
                if (!result) break;
                if (control) {
                    message = ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u9700\u751f\u6210\u51ed\u8bc1\uff0c\u5c1a\u672a\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u80fd\u63d0\u4ea4\u4efb\u52a1\u3002", (String)"VoucherUtil_12", (String)"ssc-task-formplugin", (Object[])new Object[0]);
                    break;
                }
                message = ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u9700\u751f\u6210\u51ed\u8bc1\uff0c\u51ed\u8bc1\u5c1a\u672a\u751f\u6210\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"VoucherUtil_11", (String)"ssc-task-formplugin", (Object[])new Object[0]);
                break;
            }
            case "3": {
                boolean bl = result = states.contains("A") || states.contains("D") || states.isEmpty();
                if (!result) break;
                if (control) {
                    message = ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u9700\u63d0\u4ea4\u51ed\u8bc1\uff0c\u51ed\u8bc1\u5c1a\u672a\u63d0\u4ea4\uff0c\u4efb\u52a1\u4e0d\u80fd\u63d0\u4ea4\u3002", (String)"VoucherUtil_9", (String)"ssc-task-formplugin", (Object[])new Object[0]);
                    break;
                }
                message = ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u9700\u63d0\u4ea4\u51ed\u8bc1\uff0c\u51ed\u8bc1\u5c1a\u672a\u63d0\u4ea4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"VoucherUtil_10", (String)"ssc-task-formplugin", (Object[])new Object[0]);
                break;
            }
            case "4": {
                boolean bl = result = states.contains("A") || states.contains("D") || states.contains("B") || states.isEmpty();
                if (!result) break;
                if (control) {
                    message = ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u9700\u5ba1\u6838\u51ed\u8bc1\uff0c\u51ed\u8bc1\u5c1a\u672a\u5ba1\u6838\uff0c\u4efb\u52a1\u4e0d\u80fd\u63d0\u4ea4\u3002", (String)"VoucherUtil_8", (String)"ssc-task-formplugin", (Object[])new Object[0]);
                    break;
                }
                message = ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u9700\u5ba1\u6838\u51ed\u8bc1\uff0c\u51ed\u8bc1\u5c1a\u672a\u5ba1\u6838\u3002", (String)"VoucherUtil_7", (String)"ssc-task-formplugin", (Object[])new Object[0]);
                break;
            }
        }
        map.put("result", String.valueOf(!result));
        map.put("message", message);
        return map;
    }

    public static Map<String, String> getResultbyReturn(List<String> states, String billNo) {
        HashMap<String, String> map = new HashMap<String, String>(2);
        String message = "";
        String result = "false";
        if (states.contains("C")) {
            result = "false";
            message = "";
            message = String.format(ResManager.loadKDString((String)"\u6309\u603b\u8d26\u51ed\u8bc1\u63a5\u53e3\u6821\u9a8c\u89c4\u5219\u63d0\u793a\uff0c\u51ed\u8bc1\u4e0d\u80fd\u5220\u9664\uff1b%s\u5355\u636e\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u51ed\u8bc1\u672a\u5220\u9664\u4e0d\u80fd\u6253\u56de\u3002", (String)"VoucherUtil_6", (String)"ssc-task-formplugin", (Object[])new Object[0]), "\n");
        } else {
            result = "true";
            message = String.format(ResManager.loadKDString((String)"\u5355\u636e\u6253\u56de\u51fa\u5171\u4eab\uff0c\u5df2\u751f\u6210\u7684%s\u51ed\u8bc1\u540c\u65f6\u5220\u9664\u3002", (String)"VoucherUtil_5", (String)"ssc-task-formplugin", (Object[])new Object[0]), billNo);
        }
        map.put("result", result);
        map.put("message", message);
        return map;
    }

    public static boolean voucherVerifyBySubmit(Long billtypeid, Long tasktypeid, String billnumber, Long billid, IFormView view, String operateTag) {
        boolean result = true;
        Map<String, String> map = null;
        List<String> voucherStates = VoucherUtil.getVoucherStateByBillId(billid);
        Map<String, String> voucherConfig = VoucherUtil.getVoucherConfig(billtypeid, tasktypeid, billnumber, billid);
        if (!voucherConfig.isEmpty()) {
            String voucheroperation = voucherConfig.get("voucheroperation");
            String voucherstatctrl = voucherConfig.get("voucherstatctrl");
            map = "2".equals(voucherstatctrl) ? VoucherUtil.getResultbyOperate(voucheroperation, voucherStates, false) : VoucherUtil.getResultbyOperate(voucheroperation, voucherStates, true);
            boolean resultValue = Boolean.parseBoolean(map.get("result"));
            String message = map.get("message");
            switch (voucherstatctrl) {
                case "2": {
                    if (resultValue) break;
                    if (StringUtils.isEmpty((CharSequence)operateTag)) {
                        view.showTipNotification(String.format(ResManager.loadKDString((String)"%s", (String)"VoucherUtil_0", (String)"ssc-task-formplugin", (Object[])new Object[0]), message));
                        break;
                    }
                    result = resultValue;
                    ConfirmCallBackListener call = new ConfirmCallBackListener(operateTag);
                    view.showConfirm(String.format(ResManager.loadKDString((String)"%s", (String)"VoucherUtil_0", (String)"ssc-task-formplugin", (Object[])new Object[0]), message), MessageBoxOptions.None, call);
                    break;
                }
                case "3": {
                    if (resultValue) break;
                    result = resultValue;
                    view.showErrorNotification(String.format(ResManager.loadKDString((String)"%s", (String)"VoucherUtil_0", (String)"ssc-task-formplugin", (Object[])new Object[0]), message));
                    break;
                }
            }
        }
        return result;
    }

    public static boolean voucherVerifyByReturn(String billnumber, Long billid, IFormView view, String operateTag, String billNo) {
        List<String> voucherStates = VoucherUtil.getVoucherStateByBillId(billid);
        if (voucherStates.isEmpty()) {
            return true;
        }
        Map<String, String> resultbyReturn = VoucherUtil.getResultbyReturn(voucherStates, billNo);
        boolean resultReturn = Boolean.parseBoolean(resultbyReturn.get("result"));
        String message = resultbyReturn.get("message");
        if (resultReturn) {
            try {
                OperateOption option = OperateOption.create();
                Map voucherOperate = EntityMetadataCache.getDataEntityOperate((String)billnumber, (String)"deletevoucher");
                OperationResult operationResult = OperationServiceHelper.executeOperate((String)((String)voucherOperate.get("key")), (String)billnumber, (Object[])new Object[]{billid}, (OperateOption)option);
                if (!operationResult.isSuccess()) {
                    List allErrorInfo = operationResult.getAllErrorInfo();
                    StringBuilder sb = new StringBuilder();
                    allErrorInfo.forEach(error -> sb.append(error.getMessage()));
                    log.info("\u5220\u9664\u51ed\u8bc1\u5931\u8d25\uff0c\u5355\u636eid\uff1a" + billid + "\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + sb);
                    view.showErrorNotification(ResManager.loadKDString((String)"\u5220\u9664\u51ed\u8bc1\u5931\u8d25\u3002\u8bf7\u624b\u52a8\u5220\u9664\u51ed\u8bc1\u540e\uff0c\u518d\u91cd\u65b0\u9a73\u56de\u5171\u4eab\u4efb\u52a1\u3002", (String)"VoucherUtil_3", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                    return false;
                }
            }
            catch (Exception e4) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u5220\u9664\u51ed\u8bc1\u5931\u8d25\u3002\u8bf7\u624b\u52a8\u5220\u9664\u51ed\u8bc1\u540e\uff0c\u518d\u91cd\u65b0\u9a73\u56de\u5171\u4eab\u4efb\u52a1\u3002", (String)"VoucherUtil_3", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                log.info("\u5220\u9664\u51ed\u8bc1\u5931\u8d25\uff0c\u5355\u636eid\uff1a" + billid + "\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + e4.getMessage());
                return false;
            }
            if (StringUtils.isEmpty((CharSequence)operateTag)) {
                view.showSuccessNotification(String.format(ResManager.loadKDString((String)"%s", (String)"VoucherUtil_0", (String)"ssc-task-formplugin", (Object[])new Object[0]), message));
            } else {
                resultReturn = false;
                ConfirmCallBackListener call = new ConfirmCallBackListener(operateTag);
                view.showConfirm(String.format(ResManager.loadKDString((String)"%s", (String)"VoucherUtil_0", (String)"ssc-task-formplugin", (Object[])new Object[0]), message), MessageBoxOptions.None, call);
            }
        } else {
            view.showErrorNotification(String.format(ResManager.loadKDString((String)"%s", (String)"VoucherUtil_0", (String)"ssc-task-formplugin", (Object[])new Object[0]), message));
        }
        return resultReturn;
    }

    public static List<Long> getSelectedRowIds(ListSelectedRowCollection selectedRows) {
        ArrayList<Long> selectedRowIds = new ArrayList<Long>();
        for (ListSelectedRow listSelectedRow : selectedRows) {
            Long selectedRowId = Long.valueOf(listSelectedRow.getPrimaryKeyValue() + "");
            selectedRowIds.add(selectedRowId);
        }
        return selectedRowIds;
    }

    public static DynamicObjectCollection getTaskVoucherInfos(List<Long> taskIds, String entityName) {
        String selectFields = "id,billid,tasktypeid,billtype.bindbill.number billnumber,billtype,billnumber billNo,billtype.isembed";
        QFilter filters = new QFilter("id", "in", taskIds);
        return QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])new QFilter[]{filters});
    }

    public static String getTaskBillNo(String billid) {
        String biilNo = "";
        String selectFields = "billnumber";
        QFilter filters = new QFilter("billid", "=", (Object)billid);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"task_task", (String)selectFields, (QFilter[])new QFilter[]{filters});
        if (dynamicObject != null) {
            biilNo = dynamicObject.getString("billnumber");
        }
        return biilNo;
    }

    public static void viewVoucher(String billid, IFormView view, boolean isCreate) {
        try {
            List<Long> vouncheridByBillid = VoucherUtil.getVouncheridByBillid(Long.parseLong(billid));
            if (vouncheridByBillid.isEmpty()) {
                view.showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u5b58\u5728\u5173\u8054\u51ed\u8bc1\u3002", (String)"VoucherUtil_4", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            VoucherUtil.showVoucher(vouncheridByBillid, view, isCreate);
        }
        catch (Exception e2) {
            view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u67e5\u770b\u51ed\u8bc1\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a%s\u3002", (String)"VoucherUtil_1", (String)"ssc-task-formplugin", (Object[])new Object[0]), e2.getMessage()));
            log.info("\u67e5\u770b\u51ed\u8bc1\u5931\u8d25\uff0c\u5355\u636eid\uff1a" + billid + "\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + e2.getMessage());
        }
    }

    public static void showVoucher(List<Long> voucherids, IFormView view, boolean editEnable) {
        if (view == null || CollectionUtils.isEmpty(voucherids)) {
            return;
        }
        if (voucherids.size() == 1) {
            Long voucherId = voucherids.get(0);
            BillShowParameter parameter = new BillShowParameter();
            parameter.setPkId((Object)voucherId);
            parameter.setFormId("gl_voucher");
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            String from = (String)view.getFormShowParameter().getCustomParam("from");
            if ("admin".equals(from)) {
                editEnable = false;
            } else {
                long orgId = 0L;
                try (DataSet ds = QueryServiceHelper.queryDataSet((String)"TraceVoucher_queryvoucher", (String)"gl_voucher", (String)"org", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)voucherId)}, null);){
                    for (Row row : ds) {
                        orgId = row.getLong("org");
                    }
                }
                long userId = RequestContext.get().getCurrUserId();
                int result = PermissionServiceHelper.checkPermission((long)userId, (String)"DIM_ORG", (long)orgId, (String)"83bfebc8000017ac", (String)"gl_voucher", (String)"4715a0df000000ac");
                if (result != 1) {
                    editEnable = false;
                }
            }
            if (editEnable) {
                parameter.setStatus(OperationStatus.EDIT);
            } else {
                parameter.setStatus(OperationStatus.VIEW);
            }
            view.showForm((FormShowParameter)parameter);
        } else {
            ListShowParameter listShowParameter = new ListShowParameter();
            listShowParameter.setBillFormId("gl_voucher");
            listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            listShowParameter.setShowFilter(false);
            listShowParameter.setShowQuickFilter(false);
            for (Long pkid : voucherids) {
                listShowParameter.addLinkQueryPkId((Object)pkid);
            }
            listShowParameter.getCustomParams().put("org", "");
            listShowParameter.getCustomParams().put("booktype", "");
            view.showForm((FormShowParameter)listShowParameter);
        }
    }

    public static void checkVoucher(IFormView view) {
        ListSelectedRowCollection selectedRows = ((IListView)view).getSelectedRows();
        if (selectedRows.size() == 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"MytaskListPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        String entityName = "task_task";
        if (TaskPoolTypeEnum.COMPLETE.getValue().equals(view.getPageCache().get("pooltype"))) {
            entityName = "task_taskhistory";
        }
        List taskIds = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        DynamicObjectCollection tasks = QueryServiceHelper.query((String)entityName, (String)"billid", (QFilter[])new QFilter("id", "in", taskIds).toArray());
        ArrayList<Long> billIds = new ArrayList<Long>();
        for (DynamicObject task : tasks) {
            if (!kd.bos.util.StringUtils.isNumeric((String)task.getString("billid"))) continue;
            billIds.add(Long.valueOf(task.getString("billid")));
        }
        DynamicObjectCollection vouchers = QueryServiceHelper.query((String)"ai_daptracker", (String)"voucherid", (QFilter[])new QFilter("sourcebillid", "in", billIds).toArray());
        if (vouchers.isEmpty()) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u5b58\u5728\u5173\u8054\u51ed\u8bc1\u3002", (String)"VoucherUtil_4", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return;
        }
        List<Long> voucherIds = vouchers.stream().map(v -> v.getLong("voucherid")).collect(Collectors.toList());
        boolean editEnable = "bos_list".equals(((ListView)view).getFormId());
        VoucherUtil.showVoucher(voucherIds, view, editEnable);
    }
}

