/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.formplugin.workbill;

import com.alibaba.fastjson.JSONArray;
import java.util.EventObject;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.util.StringUtils;

public class PanelFormPlugin
extends AbstractFormPlugin {
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String panelType;
        String number;
        boolean validateResult;
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        if ("donothing".equals(key) && (validateResult = this.numberValidate(number = (String)this.getModel().getValue("number"), panelType = (String)this.getModel().getValue("paneltype")))) {
            DynamicObject object = this.getModel().getDataEntity();
            this.getView().returnDataToParent((Object)object);
            this.getView().close();
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String actionId = formShowParameter.getCloseCallBack().getActionId();
        if ("editPanelEntry".equals(actionId)) {
            Map customParams = formShowParameter.getCustomParams();
            this.getModel().setValue("paneltype", customParams.get("panelType"));
            this.getModel().setValue("name", customParams.get("name"));
            this.getModel().setValue("number", customParams.get("number"));
            this.getModel().setValue("hidden", (Object)((Boolean)customParams.get("isVisible") == false ? 1 : 0));
            Boolean isPreset = (Boolean)customParams.get("isPreset");
            String checkMeta = (String)customParams.get("pCheckMeta");
            if (isPreset.booleanValue() || checkMeta.equals("1")) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"number"});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"paneltype"});
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        if ("number".equals(propName)) {
            String newNumber = (String)propValue;
            if (newNumber == null || newNumber.isEmpty()) {
                return;
            }
            String amendedNumber = this.amendNumber(newNumber);
            if (!newNumber.equals(amendedNumber)) {
                model.setValue("number", (Object)amendedNumber);
            }
        }
    }

    private boolean numberValidate(String number, String panelType) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        JSONArray numberSet = (JSONArray)formShowParameter.getCustomParam("numberSet");
        String paramNumber = (String)formShowParameter.getCustomParam("number");
        if (!StringUtils.isEmpty((String)paramNumber)) {
            numberSet.remove((Object)paramNumber);
        }
        if (panelType.equalsIgnoreCase("0") && number.length() > 25) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u666e\u901a\u9762\u677f\u7f16\u7801\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc725\u3002", (String)"PanelFormPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (panelType.equalsIgnoreCase("1") && number.length() > 20) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u5f55\u9762\u677f\u7f16\u53f7\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc720\u3002", (String)"PanelFormPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (numberSet.contains((Object)number)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9762\u677f\u7f16\u53f7\u91cd\u590d\u3002", (String)"PanelFormPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (!this.numberPatternMatcher(number)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9762\u677f\u7f16\u7801\u4e0d\u5408\u6cd5\uff0c\u8bf7\u91c7\u7528\u82f1\u6587\u5b57\u6bcd\u3001\u6570\u5b57\u548c\u4e0b\u5212\u7ebf\u547d\u540d\u3002", (String)"PanelFormPlugin_4", (String)"ssc-task-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (panelType.equalsIgnoreCase("2")) {
            String tableName = "t_" + number + "_e";
            boolean existTable = DB.exitsTable((DBRoute)DBRoute.of((String)"ssc"), (String)tableName);
            if (existTable) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u5f55\u9762\u677f\u8868\u540d\u5df2\u5b58\u5728\u3002", (String)"PanelFormPlugin_5", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    private boolean numberPatternMatcher(String number) {
        String eng = "^[a-zA-Z][a-zA-Z0-9_]*$";
        Pattern pattern = Pattern.compile(eng);
        Matcher matcher = pattern.matcher(number);
        return matcher.matches();
    }

    private String amendNumber(String original) {
        FormShowParameter formShowParameter;
        String isvPrefix;
        String result = original.replace(" ", "").toLowerCase(Locale.ENGLISH);
        if (!result.startsWith(isvPrefix = (String)(formShowParameter = this.getView().getFormShowParameter()).getCustomParam("developerLogo"))) {
            result = isvPrefix + result;
        }
        return result;
    }
}

