/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.satisfactionevaluation;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Rate;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RateEvent;
import kd.bos.form.control.events.RateListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.bos.workflow.component.ApprovalRecord;
import kd.ssc.enums.satisfactionevaluation.EvaluateStatusEnum;
import kd.ssc.satisfactionevaluation.service.EvaluateOpHelper;
import kd.ssc.task.satisfactionevaluation.common.EvaluateCommonFields;
import kd.ssc.task.satisfactionevaluation.util.EvaluateFormUtil;

public class BillEvaluateFormPlugin
extends AbstractFormPlugin
implements RateListener {
    private static Log log = LogFactory.getLog(BillEvaluateFormPlugin.class);

    public void registerListener(EventObject e) {
        Rate rate;
        int i;
        super.registerListener(e);
        for (i = 1; i <= 10; ++i) {
            rate = (Rate)this.getControl("rateap" + i);
            rate.addRateListener((RateListener)this);
        }
        for (i = 1; i <= 10; ++i) {
            rate = (Rate)this.getControl("userrate" + i);
            rate.addRateListener((RateListener)this);
        }
        Button btn = (Button)this.getView().getControl("btn_ok");
        btn.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        long billId = Long.parseLong((String)formShowParameter.getCustomParam("billId"));
        String entityNumber = (String)formShowParameter.getCustomParam("entityNumber");
        String fieldKey = (String)formShowParameter.getCustomParam("permFieldKey");
        String evaluateStatus = (String)formShowParameter.getCustomParam("evaluateStatus");
        String billNo = (String)formShowParameter.getCustomParam("billNo");
        String billTypeName = (String)formShowParameter.getCustomParam("billTypeName");
        if (StringUtils.isNotEmpty((String)evaluateStatus)) {
            this.setRateTexts();
            this.openBill(billId, entityNumber);
            this.setBillAuditRecord(billId);
        } else {
            if (!this.hasPermOpen(billId, entityNumber, fieldKey)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5355\u636e\u521b\u5efa\u4eba\u624d\u80fd\u8bc4\u4ef7\u3002", (String)"BillEvaluateFormPlugin_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            this.setRateTexts();
            this.openBill(billId, entityNumber);
            this.setBillAuditRecord(billId);
            long billType = 0L;
            QFilter idFilter = new QFilter("billid", "=", (Object)billId);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.ssc.task.satisfactionevaluation.BillEvaluateFormPlugin.afterCreateNewData.queryEvaluatingData", (String)"som_evaluating_data", (String)"billno,billtype,status", (QFilter[])new QFilter[]{idFilter}, (String)"createtime desc", (int)1);){
                for (Row row : dataSet) {
                    evaluateStatus = row.getString("status");
                    billNo = row.getString("billno");
                    billType = row.getLong("billtype");
                }
            }
            if (StringUtils.isEmpty((String)billNo)) {
                dataSet = QueryServiceHelper.queryDataSet((String)"kd.ssc.task.satisfactionevaluation.BillEvaluateFormPlugin.afterCreateNewData.queryEvaluatedData", (String)"som_evaluatedetail", (String)"billno,billtype", (QFilter[])new QFilter[]{idFilter}, null, (int)1);
                var14_12 = null;
                try {
                    for (Row row : dataSet) {
                        evaluateStatus = EvaluateStatusEnum.EVALUATED_STATE.getStatus();
                        billNo = row.getString("billno");
                        billType = row.getLong("billtype");
                    }
                }
                catch (Throwable throwable) {
                    var14_12 = throwable;
                    throw throwable;
                }
                finally {
                    if (dataSet != null) {
                        if (var14_12 != null) {
                            try {
                                dataSet.close();
                            }
                            catch (Throwable throwable) {
                                var14_12.addSuppressed(throwable);
                            }
                        } else {
                            dataSet.close();
                        }
                    }
                }
            }
            if (StringUtils.isEmpty((String)evaluateStatus) || EvaluateStatusEnum.INIT_STATE.getStatus().equals(evaluateStatus)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u4e0d\u53ef\u8fdb\u884c\u8bc4\u4ef7\u3002", (String)"BillEvaluateFormPlugin_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                return;
            }
            QFilter filter = new QFilter("id", "=", (Object)billType);
            Map billTypeNameMap = BusinessDataServiceHelper.loadFromCache((String)"task_taskbill", (String)"name", (QFilter[])new QFilter[]{filter});
            DynamicObject[] billTypeNames = billTypeNameMap.values().toArray(new DynamicObject[0]);
            if (billTypeNames.length > 0) {
                billTypeName = billTypeNames[0].getString("name");
            }
        }
        if (EvaluateStatusEnum.EVALUATED_STATE.getStatus().equals(evaluateStatus)) {
            EvaluateFormUtil.showEvaluatedData(this.getView(), billNo, billTypeName);
        } else {
            EvaluateFormUtil.showEvaluatingData(this.getView(), billNo, billTypeName);
        }
    }

    private void setRateTexts() {
        Rate rate;
        int i;
        for (i = 1; i <= 10; ++i) {
            rate = (Rate)this.getControl("rateap" + i);
            rate.setRateTexts(Arrays.asList(EvaluateCommonFields.VERY_BAD, EvaluateCommonFields.BAD, EvaluateCommonFields.NORMAL, EvaluateCommonFields.SATISFIED, EvaluateCommonFields.VERY_SATISFIED));
        }
        for (i = 1; i <= 10; ++i) {
            rate = (Rate)this.getControl("userrate" + i);
            rate.setRateTexts(Arrays.asList(EvaluateCommonFields.VERY_BAD, EvaluateCommonFields.BAD, EvaluateCommonFields.NORMAL, EvaluateCommonFields.SATISFIED, EvaluateCommonFields.VERY_SATISFIED));
        }
    }

    private boolean hasPermOpen(long billId, String entityNumber, String fieldKey) {
        try {
            DynamicObject creator = BusinessDataServiceHelper.loadSingle((Object)billId, (String)entityNumber, (String)fieldKey);
            long creatorId = (Long)((DynamicObject)creator.get(fieldKey)).getPkValue();
            if (creator != null && creatorId == RequestContext.get().getCurrUserId()) {
                return true;
            }
        }
        catch (Exception e) {
            log.info("loadCreator Exception:", (Object)e);
            return false;
        }
        return false;
    }

    private void setBillAuditRecord(long billId) {
        HashMap<String, String> parameters = new HashMap<String, String>(4);
        parameters.put("isPC", "true");
        ((ApprovalRecord)this.getControl("approvalrecordap")).setParameters(parameters);
        ((ApprovalRecord)this.getControl("approvalrecordap")).setBusinessKey(String.valueOf(billId));
    }

    private void openBill(long billId, String entityNumber) {
        BillShowParameter parameter = new BillShowParameter();
        parameter.setPkId((Object)billId);
        parameter.setFormId(entityNumber);
        parameter.getOpenStyle().setTargetKey("billcontainer");
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.setStatus(OperationStatus.VIEW);
        parameter.setBillStatus(BillOperationStatus.VIEW);
        parameter.setHasRight(true);
        parameter.setCustomParam("isIgnoreLicense", (Object)Boolean.TRUE);
        parameter.setCustomParam("ssc_hide_approvalrecord", (Object)Boolean.TRUE);
        parameter.addCustPlugin("kd.bos.ext.ssc.plugin.QualityCheckHideToolBarPlugin");
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void update(RateEvent rateEvent) {
        Number rateScore = rateEvent.getRateScore();
        String key = ((Rate)rateEvent.getSource()).getKey();
        this.getModel().setValue(key + "value", (Object)rateScore);
        int dimensionNum = Integer.parseInt(this.getPageCache().get("dimensionNum"));
        int userNum = Integer.parseInt(this.getPageCache().get("userNum"));
        if (key.startsWith("rateap")) {
            int score;
            for (int i = 1; i <= dimensionNum; ++i) {
                String rateAp = "rateap" + i;
                if (!rateAp.equals(key)) continue;
                EvaluateFormUtil.setReason(this.getView(), this.getModel().getValue("dimension" + i), i, rateScore.intValue(), "reason", "text");
            }
            if ("rateap1".equals(key) && (score = ((Integer)this.getModel().getValue(key + "value")).intValue()) >= 3 && !EvaluateFormUtil.isScoredOther(this.getModel(), dimensionNum)) {
                EvaluateFormUtil.setOtherScore(this.getView(), dimensionNum, score);
            }
        } else if (key.startsWith("userrate")) {
            for (int i = 1; i <= userNum; ++i) {
                String rateAp = "userrate" + i;
                if (!rateAp.equals(key)) continue;
                EvaluateFormUtil.setReason(this.getView(), this.getModel().getValue("dimension11"), i, rateScore.intValue(), "userreason", "usertext");
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        if (propertyName.startsWith("reason")) {
            EvaluateFormUtil.setTextFlexVisible(this.getView(), propertyName, "text", newValue);
        } else if (propertyName.startsWith("userreason")) {
            EvaluateFormUtil.setTextFlexVisible(this.getView(), propertyName, "usertext", newValue);
        }
    }

    public void afterBindData(EventObject e) {
        int i;
        super.afterBindData(e);
        for (i = 1; i <= 10; ++i) {
            Object dimensionId = this.getModel().getValue("dimension" + i);
            if (dimensionId != null) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"dimensionflex" + i});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"dimensionflex" + i});
            }
            EvaluateFormUtil.setReasonTextVisible(this.getView(), "rateap", "reason", "text", i);
        }
        for (i = 1; i <= 10; ++i) {
            Object user = this.getModel().getValue("user" + i);
            if (user != null) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"flexuser" + i});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexuser" + i});
            }
            EvaluateFormUtil.setReasonTextVisible(this.getView(), "userrate", "userreason", "usertext", i);
        }
        EvaluateFormUtil.bindAttachments(this.getView());
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if ("btn_ok".equals(control.getKey())) {
            Map<String, Object> paramMap = EvaluateFormUtil.generateParamMap(this.getView());
            Optional opResult = EvaluateOpHelper.doEvaluate(paramMap);
            if (opResult.isPresent()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff1a%s", (String)"BillEvaluateFormPlugin_2", (String)"ssc-task-formplugin", (Object[])new Object[]{opResult.get()}));
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\u3002", (String)"BillEvaluateFormPlugin_3", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                this.getView().invokeOperation("refresh");
            }
        }
    }
}

