/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.schedule;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.ssc.enums.satisfactionevaluation.EvaluateStarEnum;
import kd.ssc.enums.satisfactionevaluation.EvaluateStatusEnum;
import kd.ssc.satisfactionevaluation.vo.EvaluateIntermediate;
import kd.ssc.task.approveRebuild.helper.TaskApproveSuccessHelper;
import kd.ssc.task.util.SSCBosUtil;

public class AutoEvaluateScheduleTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(AutoEvaluateScheduleTask.class);
    private static final String SELECT_FILED = "billid,billno,entitynumber,org,sscid,billtype,waitevaluatetime,createtime";
    private static final String REIMBURSEMENT_UPDATE_SQL = "update t_dhc_mybilllist set fevaluatestatus=? where fbillid =? and fevaluatestatus=?";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        if (!TaskApproveSuccessHelper.getEnableEvaluateParam()) {
            log.info("param is not open.");
            return;
        }
        int days = (Integer)SSCBosUtil.getSscSettingInfo((String)"autoevaluatedays", (boolean)false);
        QFilter statusFilter = new QFilter("status", "=", (Object)EvaluateStatusEnum.EVALUATING_STATE.getStatus());
        Date date = this.getBeforeDay(days - 1);
        log.info("days:{},date:{}", (Object)days, (Object)date);
        QFilter timeFilter = new QFilter("waitevaluatetime", "<", (Object)date);
        this.deleteIllegalData();
        HashMap<Long, EvaluateIntermediate> billIdRowMap = new HashMap<Long, EvaluateIntermediate>(1024);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.ssc.task.schedule.AutoEvaluateScheduleTask.execute.queryData", (String)"som_evaluating_data", (String)SELECT_FILED, (QFilter[])new QFilter[]{statusFilter, timeFilter}, null);
             DataSet orderDataSet = dataSet.orderBy(new String[]{"billid", "createtime desc"});){
            long billId = 0L;
            EvaluateIntermediate newestRow = null;
            for (Row row : orderDataSet) {
                if (billId == 0L || billId != row.getLong("billid")) {
                    newestRow = new EvaluateIntermediate();
                    newestRow.setBillId(row.getLong("billid").longValue());
                    newestRow.setBillNo(row.getString("billno"));
                    newestRow.setEntityNumber(row.getString("entitynumber"));
                    newestRow.setOrg(row.getLong("org").longValue());
                    newestRow.setSscId(row.getLong("sscid").longValue());
                    newestRow.setBillType(row.getLong("billtype").longValue());
                    newestRow.setWaitEvaluateTime(row.getDate("waitevaluatetime"));
                }
                if (billIdRowMap.containsKey(billId = row.getLong("billid").longValue())) continue;
                billIdRowMap.put(billId, newestRow);
            }
        }
        if (billIdRowMap.size() > 0) {
            Set idSet = billIdRowMap.keySet();
            QFilter qFilter = new QFilter("billid", "in", idSet);
            HashMap<Long, Set<Long>> billIdUserMap = new HashMap<Long, Set<Long>>(1024);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.ssc.task.schedule.AutoEvaluateScheduleTask.execute.querySscUser", (String)"som_evaluating_data", (String)"billid,handlerid", (QFilter[])new QFilter[]{qFilter}, null);){
                for (Row row : dataSet) {
                    long billId = row.getLong("billid");
                    billIdUserMap.putIfAbsent(billId, new HashSet());
                    ((Set)billIdUserMap.get(billId)).add(row.getLong("handlerid"));
                }
            }
            List<DynamicObject> detailList = this.setAutoEvaluateData(billIdRowMap, billIdUserMap, requestContext);
            if (detailList.size() > 0) {
                TXHandle tx = TX.required((String)"kd.ssc.task.schedule.AutoEvaluateScheduleTask.saveDetail");
                Object object = null;
                try {
                    try {
                        SaveServiceHelper.save((DynamicObject[])detailList.toArray(new DynamicObject[0]));
                        DeleteServiceHelper.delete((String)"som_evaluating_data", (QFilter[])new QFilter[]{qFilter});
                        ArrayList<Object[]> batchParams = new ArrayList<Object[]>(idSet.size());
                        for (Long billId : idSet) {
                            batchParams.add(new Object[]{EvaluateStatusEnum.EVALUATED_STATE.getStatus(), billId, EvaluateStatusEnum.EVALUATING_STATE.getStatus()});
                        }
                        DB.executeBatch((DBRoute)DBRoute.of((String)"fi"), (String)REIMBURSEMENT_UPDATE_SQL, batchParams);
                    }
                    catch (Throwable e) {
                        tx.markRollback();
                        log.error("save data e:", e);
                        throw new KDBizException(BosErrorCode.systemError, new Object[]{ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AutoEvaluateScheduleTask_0", (String)"ssc-task-formplugin", (Object[])new Object[0])});
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (tx != null) {
                        if (object != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            tx.close();
                        }
                    }
                }
            }
        }
    }

    private void deleteIllegalData() {
        String sql = "select fid from  t_tk_evaluating_data a where exists (select 1 from t_tk_evaluatedetail b where a.fbillid=b.fbillid) ";
        HashSet idSet = new HashSet(16);
        try (DataSet dataSet = DB.queryDataSet((String)"kd.ssc.task.schedule.AutoEvaluateScheduleTask.execute.queryIllegalData", (DBRoute)DBRoute.of((String)"ssc"), (String)sql);){
            dataSet.forEach(row -> idSet.add(row.getLong("fid")));
        }
        log.info("deleteIllegalData ids:", idSet);
        QFilter idFilter = new QFilter("id", "in", idSet);
        DeleteServiceHelper.delete((String)"som_evaluating_data", (QFilter[])new QFilter[]{idFilter});
    }

    private List<DynamicObject> setAutoEvaluateData(Map<Long, EvaluateIntermediate> billIdRowMap, Map<Long, Set<Long>> billIdUserMap, RequestContext requestContext) {
        ArrayList<DynamicObject> detailList = new ArrayList<DynamicObject>(1024);
        Set sscIdSet = billIdRowMap.values().stream().map(EvaluateIntermediate::getSscId).collect(Collectors.toSet());
        HashMap<Long, DynamicObject[]> orgEvaluativeDimensionIdMap = new HashMap<Long, DynamicObject[]>(8);
        for (Long l : sscIdSet) {
            QFilter statusFilter;
            QFilter filter = BaseDataServiceHelper.getBaseDataFilter((String)"som_evaluative_dimension", (Long)l);
            DynamicObject[] evaluativeDimensions = BusinessDataServiceHelper.load((String)"som_evaluative_dimension", (String)"id,number", (QFilter[])new QFilter[]{filter, statusFilter = new QFilter("enable", "=", (Object)"1")});
            if (evaluativeDimensions == null || evaluativeDimensions.length <= 0) continue;
            orgEvaluativeDimensionIdMap.put(l, evaluativeDimensions);
        }
        for (Map.Entry entry : billIdRowMap.entrySet()) {
            DynamicObject[] evaluativeDimensions = (DynamicObject[])orgEvaluativeDimensionIdMap.get(((EvaluateIntermediate)entry.getValue()).getSscId());
            Date date = new Date();
            for (DynamicObject evaluativeDimension : evaluativeDimensions) {
                DynamicObject evaluateDetail = BusinessDataServiceHelper.newDynamicObject((String)"som_evaluatedetail");
                evaluateDetail.set("billid", entry.getKey());
                evaluateDetail.set("billno", (Object)((EvaluateIntermediate)entry.getValue()).getBillNo());
                evaluateDetail.set("creator", (Object)requestContext.getCurrUserId());
                evaluateDetail.set("org", (Object)((EvaluateIntermediate)entry.getValue()).getOrg());
                evaluateDetail.set("sscid", (Object)((EvaluateIntermediate)entry.getValue()).getSscId());
                evaluateDetail.set("evaluativedimension", (Object)evaluativeDimension.getLong("id"));
                evaluateDetail.set("autoevaluate", (Object)true);
                evaluateDetail.set("isattachments", (Object)false);
                evaluateDetail.set("createtime", (Object)date);
                evaluateDetail.set("evaluatebegintime", (Object)((EvaluateIntermediate)entry.getValue()).getWaitEvaluateTime());
                evaluateDetail.set("billtype", (Object)((EvaluateIntermediate)entry.getValue()).getBillType());
                DynamicObjectCollection detailEntryList = evaluateDetail.getDynamicObjectCollection("entryentity");
                if ("ssc_staff".equals(evaluativeDimension.getString("number"))) {
                    Set<Long> userSet = billIdUserMap.get(entry.getKey());
                    if (CollectionUtils.isNotEmpty(userSet)) {
                        for (Long user : userSet) {
                            DynamicObject detailEntry = new DynamicObject(detailEntryList.getDynamicObjectType());
                            detailEntry.set("sscuser", (Object)user);
                            detailEntry.set("stars", (Object)EvaluateStarEnum.FOUR.getValue());
                            detailEntryList.add((Object)detailEntry);
                        }
                    }
                } else {
                    DynamicObject detailEntry = new DynamicObject(detailEntryList.getDynamicObjectType());
                    detailEntry.set("stars", (Object)EvaluateStarEnum.FOUR.getValue());
                    detailEntryList.add((Object)detailEntry);
                }
                detailList.add(evaluateDetail);
            }
        }
        return detailList;
    }

    private Date getBeforeDay(int days) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -days);
        Date time = calendar.getTime();
        try {
            time = sdf.parse(sdf.format(time));
        }
        catch (ParseException e) {
            log.info(e.getMessage());
        }
        return time;
    }
}

