/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.schedule;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.ssc.enums.TaskStateEnum;
import kd.ssc.eventSend.poolexecutor.PreDistributionPoolExecutor;

public class PreDistributionSchedule
extends AbstractTask {
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        List<Long> toDealTaskIds = this.getToDealTaskIds();
        List<Long> preDisTaskIds = this.getPreDisTaskIds();
        this.deletePreDisResult(toDealTaskIds, preDisTaskIds);
        this.predisTask(toDealTaskIds, preDisTaskIds);
    }

    private void predisTask(List<Long> toDealTaskIds, List<Long> disTaskIds) {
        ArrayList<Long> preDisTaskIds = new ArrayList<Long>(toDealTaskIds);
        preDisTaskIds.removeAll(disTaskIds);
        if (preDisTaskIds.isEmpty()) {
            return;
        }
        Map<Long, List<Long>> preDistMap = this.getPreDistMap(preDisTaskIds);
        if (preDistMap.isEmpty()) {
            return;
        }
        for (Map.Entry<Long, List<Long>> entry : preDistMap.entrySet()) {
            Long sscId = entry.getKey();
            List<Long> taskIds = entry.getValue();
            PreDistributionPoolExecutor executor = new PreDistributionPoolExecutor(sscId, taskIds);
            executor.run();
        }
    }

    private Map<Long, List<Long>> getPreDistMap(List<Long> preDisTaskIds) {
        String selectFields = "id,sscid";
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", preDisTaskIds)};
        DynamicObjectCollection tasks = QueryServiceHelper.query((String)"task_task", (String)selectFields, (QFilter[])qFilters);
        if (tasks == null || tasks.isEmpty()) {
            return new HashMap<Long, List<Long>>();
        }
        HashMap<Long, List<Long>> preDistMap = new HashMap<Long, List<Long>>();
        for (DynamicObject task : tasks) {
            Long sscId = task.getLong("sscid");
            Long taskId = task.getLong("id");
            List taskIds = preDistMap.computeIfAbsent(sscId, v -> new ArrayList());
            if (taskIds.contains(taskId)) continue;
            taskIds.add(taskId);
        }
        return preDistMap;
    }

    private void deletePreDisResult(List<Long> toDealTaskIds, List<Long> preDisTaskIds) {
        ArrayList<Long> deleteTaskIds = new ArrayList<Long>(preDisTaskIds);
        deleteTaskIds.removeAll(toDealTaskIds);
        if (deleteTaskIds.isEmpty()) {
            return;
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("taskid", "in", deleteTaskIds)};
        DeleteServiceHelper.delete((String)"task_predis_result", (QFilter[])qFilters);
    }

    private List<Long> getPreDisTaskIds() {
        DynamicObjectCollection tasks = QueryServiceHelper.query((String)"task_predis_result", (String)"taskid", null);
        if (tasks == null || tasks.isEmpty()) {
            return Collections.emptyList();
        }
        return tasks.stream().map(d -> d.getLong("taskid")).distinct().collect(Collectors.toList());
    }

    private List<Long> getToDealTaskIds() {
        ArrayList<String> toDealStates = new ArrayList<String>();
        toDealStates.add(TaskStateEnum.TO_BE_DIS.getValue());
        toDealStates.add(TaskStateEnum.DIS_EXCEPTION.getValue());
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("state", "in", toDealStates));
        DynamicObjectCollection tasks = QueryServiceHelper.query((String)"task_task", (String)"id", (QFilter[])qFilters.toArray(qFilters.toArray(new QFilter[0])));
        if (tasks == null || tasks.isEmpty()) {
            return Collections.emptyList();
        }
        return tasks.stream().map(d -> d.getLong("id")).collect(Collectors.toList());
    }
}

