/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.schedule;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.ext.ssc.enums.ImageScannerShowTypeEnum;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.util.StringUtils;
import kd.ssc.task.image.SscImageServiceUtil;

public class TaskWfPassScheduleTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(TaskWfPassScheduleTask.class);
    private static final String TASK_BILLIMAGEMAP = "task_billimagemap";
    private static final String SELECFIELD = "imagenumber,billnumber,billid,modifier,scanuserid,creator";
    private static final String WF_TASK_CATEGORY = "category";
    private static final String WF_TASK = "wf_task";
    private static final String WF_EXECUTION_SUSPENSIONSTATE = "suspensionstate";
    private static final String WF_EXECUTION = "wf_execution";
    private static final Long DAY_MILLS = 86400000L;

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        Set billIds;
        QFilter pauseBillFilter;
        QFilter hasImageFilter;
        DynamicObject[] billImages;
        QFilter categoryFilter = new QFilter(WF_TASK_CATEGORY, "=", (Object)"SSCImageUploadNew");
        DataSet uploadTask = QueryServiceHelper.queryDataSet((String)"ImageExpireRemindTask_wfTask", (String)WF_TASK, (String)"id,processinstanceid as proinstid,businesskey as billid,createdate as enternodetime", (QFilter[])new QFilter[]{categoryFilter}, null);
        QFilter stateFilter = new QFilter(WF_EXECUTION_SUSPENSIONSTATE, "=", (Object)"1");
        DataSet runningProcess = QueryServiceHelper.queryDataSet((String)"ImageExpireRemindTask_wfexecution", (String)WF_EXECUTION, (String)"processinstanceid,currenttaskid,businesskey", (QFilter[])new QFilter[]{stateFilter}, null);
        DataSet resultDataSet = uploadTask.join(runningProcess).on("id", "currenttaskid").select(new String[]{"id", "billid", "enternodetime"}).finish();
        HashMap<String, String> billTaskMap = new HashMap<String, String>(16);
        while (resultDataSet.hasNext()) {
            Row row = resultDataSet.next();
            String billId = row.getString("billid");
            String taskId = row.getString("id");
            billTaskMap.put(billId, taskId);
        }
        if (billTaskMap.size() == 0) {
            log.info("\u5f53\u524d\u65e0\u963b\u585e\u5728\u5f71\u50cf\u4e0a\u4f20\u8282\u70b9\u7684\u6d41\u7a0b");
        }
        if ((billImages = BusinessDataServiceHelper.load((String)TASK_BILLIMAGEMAP, (String)SELECFIELD, (QFilter[])new QFilter[]{hasImageFilter = new QFilter("imagestate", "in", (Object)new String[]{"2", "4"}), pauseBillFilter = new QFilter("billid", "in", billIds = billTaskMap.keySet())})) != null && billImages.length > 0) {
            for (DynamicObject billImage : billImages) {
                long creator;
                String billNumber = billImage.getString("billnumber");
                String scanUserId = billImage.getString("scanuserid");
                String billId = billImage.getString("billid");
                String taskId = (String)billTaskMap.get(billId);
                String param = SscImageServiceUtil.getScannerShowControlParam();
                Long userId = -1L;
                if (ImageScannerShowTypeEnum.SCANNER.getShowType().equals(param)) {
                    if (StringUtils.isNumberString((String)scanUserId)) {
                        userId = Long.parseLong(scanUserId);
                    }
                } else if (ImageScannerShowTypeEnum.SUBMITTER.getShowType().equals(param) && (creator = billImage.getLong("creator_id")) > 0L) {
                    userId = creator;
                }
                try {
                    WorkflowServiceHelper.completeTask((Long)Long.valueOf(taskId), (Long)userId, (String)"Consent", (String)ResManager.loadKDString((String)"\u4e0a\u4f20\u5f71\u50cf\u6210\u529f", (String)"TaskWfPassSchedule_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
                }
                catch (Exception e) {
                    log.info(billNumber + "\u63a8\u5de5\u4f5c\u6d41completeTask\u5931\u8d25 \uff1a" + e.getMessage());
                }
            }
        }
        log.info("\u5de5\u4f5c\u6d41\u8282\u70b9\u63a8\u8fdb\u8865\u507f\u4efb\u52a1\u5b8c\u6210\uff0c\u5f00\u59cb\u5220\u9664\u5f71\u50cf\u8865\u507f");
    }
}

