/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.service.fatvs;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.param.AppParam;
import kd.bos.ext.fi.fatvs.skilldata.ISkillRunnable;
import kd.bos.ext.fi.fatvs.skilldata.SkillRunContext;
import kd.bos.ext.fi.fatvs.skilldata.SkillRunResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public class SmartServicePullData
implements ISkillRunnable {
    private static final Log log = LogFactory.getLog(SmartServicePullData.class);

    public SkillRunResult pullData(SkillRunContext skillRunContext) {
        SkillRunResult skillResult = skillRunContext.getSkillResult();
        String skillNum = skillRunContext.getSkillNum();
        Date startTime = skillRunContext.getStartTime();
        Date endTime = skillRunContext.getEndTime();
        skillResult.setDate(startTime);
        switch (skillNum) {
            case "znzj": {
                this.smartQualityInspection(skillResult, startTime, endTime);
                break;
            }
            case "gxkfjqr": {
                this.smartService(skillResult, startTime, endTime);
            }
        }
        return skillResult;
    }

    private void smartQualityInspection(SkillRunResult skillResult, Date startTime, Date endTime) {
        skillResult.setFailCount(Integer.valueOf(0));
        skillResult.setTotalCount(Integer.valueOf(0));
        String selectField = "id";
        QFilter qFilter0 = new QFilter("predictlevel", "!=", (Object)" ");
        qFilter0.and(QFilter.of((String)"completetime > ? and completetime <= ?", (Object[])new Object[]{startTime, endTime}));
        DynamicObjectCollection operationInfos = QueryServiceHelper.query((String)"task_taskhistory", (String)selectField, (QFilter[])qFilter0.toArray());
        if (operationInfos != null) {
            skillResult.setTotalCount(Integer.valueOf(operationInfos.size()));
        }
        ArrayList resultList = new ArrayList();
        HashMap<String, String> resultMap1 = new HashMap<String, String>();
        resultMap1.put("number", "zql");
        resultMap1.put("name", ResManager.loadKDString((String)"\u51c6\u786e\u7387", (String)"SmartServicePullData_0", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        resultMap1.put("valueType", "1");
        HashMap<String, String> resultMap2 = new HashMap<String, String>();
        resultMap2.put("number", "yjzl");
        resultMap2.put("name", ResManager.loadKDString((String)"\u9884\u68c0\u603b\u91cf", (String)"SmartServicePullData_1", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        resultMap2.put("valueType", "0");
        HashMap<String, String> resultMap3 = new HashMap<String, String>();
        resultMap3.put("number", "ddxll");
        resultMap3.put("name", ResManager.loadKDString((String)"\u8fed\u4ee3\u8bad\u7ec3\u91cf", (String)"SmartServicePullData_2", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        resultMap3.put("valueType", "0");
        QFilter qFilter = new QFilter("status", "=", (Object)"0");
        DynamicObjectCollection query = QueryServiceHelper.query((String)"task_modelinitrecord", (String)"accuracy, usedtimes, traindata", (QFilter[])qFilter.toArray(), (String)"createtime desc", (int)1);
        double acc = 0.0;
        String usedtimes = "0";
        String traindata = "0";
        if (!CollectionUtils.isEmpty((Collection)query)) {
            DynamicObject dy = (DynamicObject)query.get(0);
            String accuracy = dy.getString("accuracy");
            BigDecimal bigDecimal = new BigDecimal(accuracy);
            acc = bigDecimal.multiply(new BigDecimal(100)).setScale(2, 4).doubleValue();
            usedtimes = dy.getString("usedtimes");
            traindata = dy.getString("traindata");
        }
        resultMap1.put("value", acc + "%");
        resultMap2.put("value", usedtimes);
        resultMap3.put("value", traindata);
        resultList.add(resultMap1);
        resultList.add(resultMap2);
        resultList.add(resultMap3);
        skillResult.setData(resultList);
    }

    private void smartService(SkillRunResult skillResult, Date startTime, Date endTime) {
        skillResult.setFailCount(Integer.valueOf(0));
        skillResult.setTotalCount(Integer.valueOf(0));
        QFilter qFilter = QFilter.of((String)"asktime > ? and asktime <= ?", (Object[])new Object[]{startTime, endTime});
        DynamicObjectCollection query = QueryServiceHelper.query((String)"som_knowledge_qa_log", (String)"id", (QFilter[])qFilter.toArray());
        if (null != query) {
            skillResult.setTotalCount(Integer.valueOf(query.size()));
        }
        ArrayList resultList = new ArrayList();
        HashMap<String, String> resultMap2 = new HashMap<String, String>();
        resultMap2.put("number", "wxzcs");
        resultMap2.put("name", ResManager.loadKDString((String)"\u95ee\u8be2\u603b\u6b21\u6570", (String)"SmartServicePullData_3", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        resultMap2.put("valueType", "0");
        resultMap2.put("value", this.getTotal(null) + "");
        HashMap<String, String> resultMap3 = new HashMap<String, String>();
        resultMap3.put("number", "wxcszgwt");
        resultMap3.put("name", ResManager.loadKDString((String)"\u95ee\u8be2\u6b21\u6570\u6700\u9ad8\u95ee\u9898", (String)"SmartServicePullData_4", (String)"ssc-task-formplugin", (Object[])new Object[0]));
        resultMap3.put("valueType", "2");
        resultMap3.put("value", this.getAskNumTop1(null));
        resultList.add(resultMap2);
        resultList.add(resultMap3);
        skillResult.setData(resultList);
    }

    private String getAskNumTop1(QFilter[] filters) {
        String ques = "";
        String algoKey = this.getClass() + ".getAskNumTop1()";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"som_knowledge_qa_log", (String)"knowledge.id knowlid, knowledge.question question ", (QFilter[])filters, null);
             DataSet resultSet = dataSet.groupBy(new String[]{"knowlid", "question"}).count("asknum").finish().orderBy(new String[]{"asknum desc"}).top(1);){
            for (Row row : resultSet) {
                if (StringUtils.isNotEmpty((CharSequence)ques)) {
                    break;
                }
                ques = row.getString("question");
            }
        }
        return ques;
    }

    private int getTotal(QFilter[] filters) {
        String algoKey = this.getClass() + ".getTotal()";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"som_knowledge_qa_log", (String)"id", (QFilter[])filters, null);){
            int n = dataSet.count("id", false);
            return n;
        }
    }

    private static boolean getSscSettingInfo(String key) {
        AppParam param = new AppParam("83bfebc8000020ac", "12", Long.valueOf(OrgUnitServiceHelper.getRootOrgId()), Long.valueOf(0L));
        Object params = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)param, (String)key);
        if (params == null || !(params instanceof Boolean)) {
            log.info("\u4efb\u52a1\u98ce\u9669\u9884\u6d4b-\u83b7\u53d6\u914d\u7f6e\uff1a\u83b7\u53d6 " + key + "\u8bbe\u7f6e\u53c2\u6570\u4e3a\u7a7a");
            return false;
        }
        return (Boolean)params;
    }
}

