/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.workcalendar;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.task.common.QualityCheckSchemeUtil;
import kd.ssc.task.common.TaskPropertyEnum;
import kd.ssc.task.workcalendar.RemainingTimeCalculate;
import kd.ssc.task.workcalendar.WorkDateUtil;
import kd.ssc.task.workcalendar.pojo.RemainingTimeInfo;
import kd.ssc.task.workcalendar.pojo.SimpleJob;
import kd.ssc.task.workcalendar.pojo.SimpleJobStateTime;

public class RemainingTimeCalculateImpl
implements RemainingTimeCalculate {
    private static final Log logger = LogFactory.getLog(RemainingTimeCalculateImpl.class);
    private RemainingTimeInfo remainingTimeInfo = null;
    private static final String T_TK_TASK = "task_task";
    private Map<Long, WorkDateUtil> instanceMap = new HashMap<Long, WorkDateUtil>();

    @Override
    public void calRemainingTime(List<Long> jobIds) {
        DataSet dataset = this.getCalculateJob(jobIds, null);
        this.calRemainingTime(dataset);
    }

    @Override
    public void calRemainTimeOfQuaCheckTask(List<Long> jobIds) {
        DataSet quaCheckJobData = this.getCalculateQuaCheckJob(jobIds, null);
        Map<Long, RemainingTimeInfo> remainingTimeInfo = this.calRemainingTime(quaCheckJobData);
        QualityCheckSchemeUtil.changeQualitySampleLib(remainingTimeInfo);
    }

    @Override
    public void calRemainingTimeWithQFilter(List<QFilter> filters) {
        HashMap<Long, SimpleJob> jobId_simpleJob = new HashMap<Long, SimpleJob>();
        HashMap<Long, List<SimpleJobStateTime>> jobId_simpleJobStaTimList = new HashMap<Long, List<SimpleJobStateTime>>();
        long begin = System.currentTimeMillis();
        DataSet dataset = this.getCalculateJob(null, filters);
        this.parseJobData(jobId_simpleJob, jobId_simpleJobStaTimList, dataset);
        Map<Long, RemainingTimeInfo> remainingTime = this.getReminderTimeMap(jobId_simpleJob, jobId_simpleJobStaTimList);
        long end = System.currentTimeMillis();
        logger.info(String.format("\u8ba1\u7b97\u8fc7\u7a0b\u8017\u65f6\uff1abegin:%s == end:%s  == total time:%s", begin, end, end - begin));
        begin = System.currentTimeMillis();
        this.updateToDB(remainingTime);
        end = System.currentTimeMillis();
        logger.info(String.format("update\u65b9\u6cd5\uff1abegin:%s == end:%s  == total time:%s", begin, end, end - begin));
    }

    @Override
    public void calCompletedTime(List<Long> jobIds) {
        HashMap<Long, SimpleJob> jobId_simpleJob = new HashMap<Long, SimpleJob>();
        HashMap<Long, List<SimpleJobStateTime>> jobId_simpleJobStaTimList = new HashMap<Long, List<SimpleJobStateTime>>();
        DataSet dateset = this.getCalculateJob(jobIds, null);
        this.parseJobData(jobId_simpleJob, jobId_simpleJobStaTimList, dateset);
        Map<Long, RemainingTimeInfo> remainingTime = this.getReminderTimeMap(jobId_simpleJob, jobId_simpleJobStaTimList);
        this.updateToDB2(remainingTime);
    }

    @Override
    public Map<Long, RemainingTimeInfo> getRemainingTime(List<Long> jobIds) {
        HashMap<Long, SimpleJob> jobId_simpleJob = new HashMap<Long, SimpleJob>();
        HashMap<Long, List<SimpleJobStateTime>> jobId_simpleJobStaTimList = new HashMap<Long, List<SimpleJobStateTime>>();
        DataSet dateset = this.getCalculateJob(jobIds, null);
        this.parseJobData(jobId_simpleJob, jobId_simpleJobStaTimList, dateset);
        Map<Long, RemainingTimeInfo> remainingTime = this.getReminderTimeMap(jobId_simpleJob, jobId_simpleJobStaTimList);
        return remainingTime;
    }

    @Override
    public Map<String, List<Long>> countExpiredJob(List<QFilter> filters) {
        HashMap<String, List<Long>> map = new HashMap<String, List<Long>>();
        ArrayList<Long> OutOfDate = new ArrayList<Long>();
        ArrayList<Long> InOfDate = new ArrayList<Long>();
        HashMap<Long, SimpleJob> jobId_simpleJob = new HashMap<Long, SimpleJob>();
        HashMap<Long, List<SimpleJobStateTime>> jobId_simpleJobStaTimList = new HashMap<Long, List<SimpleJobStateTime>>();
        DataSet dateset = this.getCalculateJob(null, filters);
        this.parseJobData(jobId_simpleJob, jobId_simpleJobStaTimList, dateset);
        Map<Long, RemainingTimeInfo> remainingTime = this.getReminderTimeMap(jobId_simpleJob, jobId_simpleJobStaTimList);
        for (Map.Entry<Long, RemainingTimeInfo> entry : remainingTime.entrySet()) {
            long jobId = entry.getKey();
            RemainingTimeInfo remainingTimeInfo = entry.getValue();
            if (remainingTimeInfo.getExpireState().equals("2")) {
                OutOfDate.add(jobId);
                continue;
            }
            InOfDate.add(jobId);
        }
        map.put("OutOfDate", OutOfDate);
        map.put("InOfDate", InOfDate);
        return map;
    }

    @Override
    public List<Long> countExpiredJob(List<QFilter> filters, String expireState) {
        ArrayList<Long> ids = new ArrayList<Long>();
        HashMap<Long, SimpleJob> jobId_simpleJob = new HashMap<Long, SimpleJob>();
        HashMap<Long, List<SimpleJobStateTime>> jobId_simpleJobStaTimList = new HashMap<Long, List<SimpleJobStateTime>>();
        DataSet dateset = this.getCalculateJob(null, filters);
        this.parseJobData(jobId_simpleJob, jobId_simpleJobStaTimList, dateset);
        Map<Long, RemainingTimeInfo> remainingTime = this.getReminderTimeMap(jobId_simpleJob, jobId_simpleJobStaTimList);
        for (Map.Entry<Long, RemainingTimeInfo> entry : remainingTime.entrySet()) {
            long jobId = entry.getKey();
            RemainingTimeInfo remainingTimeInfo = entry.getValue();
            if (!expireState.equals(remainingTimeInfo.getExpireState())) continue;
            ids.add(jobId);
        }
        return ids;
    }

    private DataSet getCalculateJob(List<Long> jobIds, List<QFilter> qfilter) {
        if (qfilter == null) {
            qfilter = new ArrayList<QFilter>();
        }
        if (jobIds != null) {
            QFilter fjobId = new QFilter("id", "in", jobIds);
            qfilter.add(fjobId);
        }
        QFilter[] filter = qfilter.toArray(new QFilter[0]);
        ORM orm = ORM.create();
        String selectField1 = "id,entryentitylevel.priority priority,entryentitylevel.timeliness timeliness,entryentitylevel.warningtime warntime";
        DataSet dataSet1 = orm.queryDataSet("ssc.getCreateRule", "task_taskbill_child", selectField1, null);
        String selectField = "id,receivetime,tasklevelid.id,tasktypeid.id,sscid,billtype.entryentity.tasktype childtasktype,billtype.entryentity.childpkid childpkid";
        DataSet dataSet2 = orm.queryDataSet("ssc.getCalculateJob", T_TK_TASK, selectField, filter).filter("tasktypeid.id = childtasktype");
        DataSet dataSet = dataSet2.join(dataSet1).on("childpkid", "id").select(new String[]{"id", "receivetime", "tasklevelid.id", "sscid"}, new String[]{"priority", "timeliness", "warntime"}).finish().filter("tasklevelid.id = priority");
        String selectfield2 = "job,changetime";
        DataSet dataSet_pri = orm.queryDataSet("ssc.getJobPriorityChange", "task_prioritychangerecord", selectfield2, null).groupBy(new String[]{"job"}).max("changetime").finish();
        DataSet resultSet = dataSet.join(dataSet_pri, JoinType.LEFT).on("id", "job").select(new String[]{"id", "receivetime", "sscid", "timeliness", "warntime"}, new String[]{"changetime"}).finish();
        return resultSet;
    }

    private DataSet getCalculateQuaCheckJob(List<Long> jobIds, List<QFilter> qfilter) {
        if (qfilter == null) {
            qfilter = new ArrayList<QFilter>();
        }
        if (jobIds != null) {
            QFilter fjobId = new QFilter("id", "in", jobIds);
            QFilter qualityFil = new QFilter("tasktypeid.qualityjudge", "=", (Object)TaskPropertyEnum.QUACHECKTASK.getValue());
            qfilter.add(fjobId);
            qfilter.add(qualityFil);
        }
        String algoKey = "RemainingTimeCalculateImpl.getCalculateQualityJob()";
        String selectFields = "id,receivetime,sscid,qualitysamplelibrary.checkscheme.taskduration as timeliness,qualitysamplelibrary.checkscheme.warningtime warntime";
        DataSet taskData = QueryServiceHelper.queryDataSet((String)algoKey, (String)T_TK_TASK, (String)selectFields, (QFilter[])qfilter.toArray(new QFilter[qfilter.size()]), null);
        return taskData.addNullField("changetime");
    }

    private Map<Long, RemainingTimeInfo> calRemainingTime(DataSet taskPrepareData) {
        HashMap<Long, SimpleJob> jobId_simpleJob = new HashMap<Long, SimpleJob>();
        HashMap<Long, List<SimpleJobStateTime>> jobId_simpleJobStaTimList = new HashMap<Long, List<SimpleJobStateTime>>();
        this.parseJobData(jobId_simpleJob, jobId_simpleJobStaTimList, taskPrepareData);
        Map<Long, RemainingTimeInfo> remainingTime = this.getReminderTimeMap(jobId_simpleJob, jobId_simpleJobStaTimList);
        this.updateToDB(remainingTime);
        return remainingTime;
    }

    private Map<Long, RemainingTimeInfo> getReminderTimeMap(Map<Long, SimpleJob> jobId_simpleJob, Map<Long, List<SimpleJobStateTime>> jobId_simpleJobStaTimList) {
        HashMap<Long, RemainingTimeInfo> jobId_reminderTime = new HashMap<Long, RemainingTimeInfo>(16);
        if (jobId_simpleJob == null || jobId_simpleJob.isEmpty()) {
            return jobId_reminderTime;
        }
        for (Map.Entry<Long, SimpleJob> entry : jobId_simpleJob.entrySet()) {
            this.remainingTimeInfo = new RemainingTimeInfo();
            long jobId = entry.getKey();
            SimpleJob simpleJob = entry.getValue();
            List<SimpleJobStateTime> listSimpleJobStateTime = jobId_simpleJobStaTimList.get(jobId);
            WorkDateUtil util = null;
            if (simpleJob.getShareCenterId() == 0L) {
                logger.info("\u8be5\u4efb\u52a1\u6ca1\u6709\u8bbe\u7f6e\u5171\u4eab\u4e2d\u5fc3\u7ec4\u7ec7,\u7ee7\u7eed\u4e0b\u6761\u4efb\u52a1\u8ba1\u7b97\uff01\u4efb\u52a1ID\uff1a" + jobId);
                continue;
            }
            try {
                util = this.instanceMap.get(simpleJob.getShareCenterId());
                if (util == null) {
                    Date startDate = this.getStartDate(simpleJob.getShareCenterId());
                    util = WorkDateUtil.getInstance(simpleJob.getShareCenterId(), startDate, new Date(System.currentTimeMillis()));
                    this.instanceMap.put(simpleJob.getShareCenterId(), util);
                }
            }
            catch (Exception e) {
                logger.info("\u521d\u59cb\u5316\u5171\u4eab\u4e2d\u5fc3\u51fa\u9519\uff01\u4efb\u52a1ID" + jobId + "==\u9519\u8bef\u4fe1\u606f\uff1a" + Arrays.toString(e.getStackTrace()));
            }
            if (util == null) continue;
            long costTime_rec = 0L;
            long limitTime = 0L;
            long remainTime = 0L;
            long allCostTime = 0L;
            try {
                limitTime = this.hourToMillisecond(simpleJob.getTaskduration() == null ? 0.0 : simpleJob.getTaskduration().doubleValue());
                if (simpleJob.getChangeTime() != null) {
                    List<SimpleJobStateTime> simpleJobStateFromChange = this.getSimpleJobStateFromChange(listSimpleJobStateTime, simpleJob.getChangeTime());
                    long costTime_pro = util.calWorkTime(simpleJob.getChangeTime(), new Date(System.currentTimeMillis()), 0);
                    long stateChangeCost = this.getStateChangeCost(simpleJobStateFromChange, util);
                    costTime_rec = util.calWorkTime(simpleJob.getReceiveTime(), new Date(System.currentTimeMillis()), 0);
                    long allStateChangeCost = this.getStateChangeCost(listSimpleJobStateTime, util);
                    long costTime = costTime_pro - stateChangeCost;
                    remainTime = limitTime - costTime;
                    allCostTime = costTime_rec - allStateChangeCost;
                } else {
                    costTime_rec = util.calWorkTime(simpleJob.getReceiveTime(), new Date(System.currentTimeMillis()), 0);
                    long stateChangeCost = this.getStateChangeCost(listSimpleJobStateTime, util);
                    allCostTime = costTime_rec - stateChangeCost;
                    remainTime = limitTime - allCostTime;
                }
                if (allCostTime < 36000L) {
                    allCostTime = 36000L;
                }
                this.remainingTimeInfo.setReminderTime(BigDecimal.valueOf(this.millisecondToHour(remainTime)).setScale(2, RoundingMode.HALF_UP));
                this.remainingTimeInfo.setCostWorkTime(BigDecimal.valueOf(this.millisecondToHour(allCostTime)).setScale(2, RoundingMode.HALF_UP));
                BigDecimal tipLimit = simpleJob.getTipLimit();
                BigDecimal remainTime2 = this.remainingTimeInfo.getReminderTime();
                String expireState = null;
                expireState = remainTime2.compareTo(new BigDecimal("0")) <= 0 ? "2" : (tipLimit != null && remainTime2.compareTo(tipLimit) < 0 ? "3" : "1");
                this.remainingTimeInfo.setExpireState(expireState);
            }
            catch (Exception e) {
                logger.error("\u4efb\u52a1:" + jobId + "\u8ba1\u7b97\u5269\u4f59\u65f6\u95f4\u65f6\u51fa\u9519==\u9519\u8bef\u4fe1\u606f\uff1a" + e.getCause(), (Throwable)e);
                continue;
            }
            jobId_reminderTime.put(jobId, this.remainingTimeInfo);
        }
        return jobId_reminderTime;
    }

    private List<SimpleJobStateTime> getSimpleJobStateFromChange(List<SimpleJobStateTime> listSimpleJobStateTime, Timestamp priChangeTime) {
        ArrayList<SimpleJobStateTime> list = new ArrayList<SimpleJobStateTime>();
        for (SimpleJobStateTime s : listSimpleJobStateTime) {
            Timestamp time = s.getChangeTime();
            if (!time.after(priChangeTime)) continue;
            list.add(s);
        }
        return list;
    }

    private Date getStartDate(Long sscId) {
        Date startDate = null;
        QFilter fjobtype = new QFilter("pooltype", "=", (Object)"1");
        QFilter fjobstate1 = new QFilter("state", "=", (Object)"1");
        QFilter fjobstate2 = new QFilter("state", "=", (Object)"7");
        QFilter fjobstate3 = new QFilter("state", "=", (Object)"0");
        QFilter fjobstate4 = new QFilter("state", "=", (Object)"2");
        QFilter f = QFilter.and((QFilter)fjobstate1.or(fjobstate2).or(fjobstate3).or(fjobstate4), (QFilter)fjobtype);
        QFilter fdate = QFilter.isNotNull((String)"receivetime");
        QFilter[] filter = new QFilter[]{f, fdate};
        String selectField = "id,receivetime";
        try (DataSet dataSet = ORM.create().queryDataSet("ssc.getStartDate", T_TK_TASK, selectField, filter, "receivetime", 1);){
            for (Row row : dataSet) {
                startDate = row.getDate("receivetime");
            }
        }
        return startDate;
    }

    private long getStateChangeCost(List<SimpleJobStateTime> listSimpleJobStateTime, WorkDateUtil util) {
        if (listSimpleJobStateTime == null || listSimpleJobStateTime.size() == 0) {
            return 0L;
        }
        listSimpleJobStateTime.sort(Comparator.comparing(SimpleJobStateTime::getChangeTime));
        long stateChangeCost = 0L;
        int len = listSimpleJobStateTime.size();
        for (int i = 0; i < len - 1; ++i) {
            stateChangeCost += this.getOneCost(listSimpleJobStateTime.get(i), listSimpleJobStateTime.get(i + 1), util);
        }
        SimpleJobStateTime simpleJobState = listSimpleJobStateTime.get(listSimpleJobStateTime.size() - 1);
        if (simpleJobState.getNewJobState().equals("0") || simpleJobState.getNewJobState().equals("2")) {
            stateChangeCost += util.calWorkTime(simpleJobState.getChangeTime(), new Date(System.currentTimeMillis()), 0);
        }
        return stateChangeCost;
    }

    private long getOneCost(SimpleJobStateTime state, SimpleJobStateTime nextstate, WorkDateUtil util) {
        if ((state.getOldJobState().equals("1") || state.getOldJobState().equals("7")) && state.getNewJobState().equals("0") && nextstate.getOldJobState().equals("0") && (nextstate.getNewJobState().equals("1") || nextstate.getNewJobState().equals("7"))) {
            long costTime = util.calWorkTime(state.getChangeTime(), nextstate.getChangeTime(), 0);
            return costTime;
        }
        if ((state.getOldJobState().equals("1") || state.getOldJobState().equals("7")) && state.getNewJobState().equals("2") && nextstate.getOldJobState().equals("2") && (nextstate.getNewJobState().equals("1") || nextstate.getNewJobState().equals("9"))) {
            long costTime = util.calWorkTime(state.getChangeTime(), nextstate.getChangeTime(), 0);
            return costTime;
        }
        return 0L;
    }

    private long hourToMillisecond(double hour) {
        return (long)(hour * 3600.0 * 1000.0);
    }

    private double millisecondToHour(long millisecond) {
        return (double)millisecond / 3600000.0;
    }

    public void updateToDB(Map<Long, RemainingTimeInfo> remainingTime) {
        if (remainingTime == null || remainingTime.isEmpty()) {
            return;
        }
        String sql = "update t_tk_task set FRestTime=?,FExpireState=? where fid=?";
        ArrayList<Object[]> params = new ArrayList<Object[]>(10);
        DBRoute ssc = DBRoute.of((String)"ssc");
        for (Map.Entry<Long, RemainingTimeInfo> entry : remainingTime.entrySet()) {
            long jobId = entry.getKey();
            RemainingTimeInfo remainingTimeInfo = entry.getValue();
            Object[] param = new Object[]{remainingTimeInfo.getReminderTime(), remainingTimeInfo.getExpireState(), jobId};
            params.add(param);
            if (params.size() % 500 != 0) continue;
            try (TXHandle h = TX.requiresNew();){
                try {
                    DB.executeBatch((DBRoute)ssc, (String)sql, params);
                }
                catch (Throwable e) {
                    h.markRollback();
                }
            }
            params.clear();
        }
        if (params.size() > 0) {
            try (TXHandle h = TX.requiresNew();){
                try {
                    DB.executeBatch((DBRoute)ssc, (String)sql, params);
                }
                catch (Throwable e) {
                    h.markRollback();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseJobData(Map<Long, SimpleJob> jobId_simpleJob, Map<Long, List<SimpleJobStateTime>> jobId_simpleJobStaTimList, DataSet job_data) {
        try {
            SimpleJob simpleJob = null;
            ArrayList<Long> idList = new ArrayList<Long>();
            for (Row row : job_data) {
                long jobId = row.getLong("id");
                Timestamp receiveTime = row.getTimestamp("receivetime");
                BigDecimal taskduration = row.getBigDecimal("timeliness");
                BigDecimal tipLimit = row.getBigDecimal("warntime");
                long centerId = row.getLong("sscid");
                Timestamp priorityChangeTime = row.getTimestamp("changetime");
                simpleJob = new SimpleJob(receiveTime, tipLimit, taskduration, priorityChangeTime, centerId);
                jobId_simpleJob.put(jobId, simpleJob);
                idList.add(jobId);
            }
            if (jobId_simpleJob == null || jobId_simpleJob.size() == 0) {
                return;
            }
            logger.info("\u4efb\u52a1\u6570\uff1a" + idList.size());
            try (DataSet jobStatusChangeData = this.getJobStatusChangeData(idList);){
                SimpleJobStateTime simpleJobStateTime = null;
                ArrayList<SimpleJobStateTime> list = new ArrayList<SimpleJobStateTime>();
                SimpleJob jobTemp = null;
                HashSet<Long> set = new HashSet<Long>();
                for (Row row1 : jobStatusChangeData) {
                    Long job_id = row1.getLong("jobid");
                    if (set.add(job_id)) {
                        jobTemp = jobId_simpleJob.get(job_id);
                        set.clear();
                        list = new ArrayList();
                        jobId_simpleJobStaTimList.put(job_id, list);
                    }
                    if (jobTemp == null) continue;
                    Timestamp timetemp = jobTemp.getReceiveTime();
                    Timestamp changeTime = row1.getTimestamp("changetime");
                    if (changeTime.before(timetemp)) continue;
                    String oldStatus = row1.getString("oldjobstate");
                    String newStatus = row1.getString("newjobstate");
                    simpleJobStateTime = new SimpleJobStateTime(changeTime, oldStatus, newStatus);
                    list.add(simpleJobStateTime);
                }
            }
        }
        finally {
            job_data.close();
        }
    }

    private DataSet getJobStatusChangeData(List<Long> jobId) {
        QFilter f1 = new QFilter("jobid", "in", jobId);
        QFilter f2 = new QFilter("operation", "!=", (Object)"26");
        QFilter[] filter = new QFilter[]{f1, f2};
        String selectField = "jobid,oldjobstate,newjobstate,changetime";
        String orderby = "jobid,changetime";
        DataSet dataSet = ORM.create().queryDataSet("ssc.getJobStatusChangeData", "task_statechange", selectField, filter, orderby);
        return dataSet;
    }

    private void updateToDB2(Map<Long, RemainingTimeInfo> remainingTime) {
        if (remainingTime == null || remainingTime.isEmpty()) {
            return;
        }
        String sql = "update t_tk_task set FExpireState=?,FCostWaitTime=? where fid=?";
        ArrayList<Object[]> params = new ArrayList<Object[]>(10);
        Iterator<Map.Entry<Long, RemainingTimeInfo>> iterator = remainingTime.entrySet().iterator();
        DBRoute ssc = DBRoute.of((String)"ssc");
        for (Map.Entry<Long, RemainingTimeInfo> entry : remainingTime.entrySet()) {
            long jobId = entry.getKey();
            RemainingTimeInfo remainingTimeInfo = entry.getValue();
            Object[] param = new Object[]{remainingTimeInfo.getExpireState(), remainingTimeInfo.getCostWorkTime(), jobId};
            params.add(param);
            if (params.size() % 500 != 0) continue;
            DB.executeBatch((DBRoute)ssc, (String)sql, params);
            params.clear();
        }
        if (params.size() > 0) {
            try (TXHandle h = TX.requiresNew();){
                try {
                    DB.executeBatch((DBRoute)ssc, (String)sql, params);
                }
                catch (Throwable e) {
                    h.markRollback();
                }
            }
        }
    }
}

