/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.workcalendar;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.ssc.task.workcalendar.pojo.TimeIgnoretDate;
import kd.ssc.task.workcalendar.pojo.WorkTime;

public class WorkDateUtil {
    private Log log = LogFactory.getLog((String)"kd.ssc.task.workcalendar.WorkDateUtil");
    private List<String> morning_workDateList = null;
    private List<String> afternoon_workDateList = null;
    private WorkTime workTimeInfo;

    public static synchronized WorkDateUtil getInstance(long shareCenterId, Date startDate, Date endDate) {
        return new WorkDateUtil(shareCenterId, startDate, endDate);
    }

    public WorkDateUtil(long shareCenterId, Date startDate, Date endDate) {
        this.iniCanledar(shareCenterId, startDate, endDate);
    }

    private void iniCanledar(long centerId, Date startDate, Date endDate) {
        Date startDateCopy = new Date(startDate.getYear(), startDate.getMonth(), startDate.getDate());
        Date endDateCopy = new Date(endDate.getYear(), endDate.getMonth(), endDate.getDate());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        BaseDataServiceHelper dbService = new BaseDataServiceHelper();
        DynamicObject calendar = dbService.getWorkCalendar(Long.valueOf(centerId), startDateCopy, endDateCopy);
        this.workTimeInfo = new WorkTime();
        if (calendar != null) {
            this.workTimeInfo.setId(calendar.getLong("id"));
            this.workTimeInfo.setHourofbegintimeam(calendar.getInt("hourofbegintimeam"));
            this.workTimeInfo.setMinofbegintimeam(calendar.getInt("minofbegintimeam"));
            this.workTimeInfo.setHourofendtimeam(calendar.getInt("hourofendtimeam"));
            this.workTimeInfo.setMinofendtimeam(calendar.getInt("minofendtimeam"));
            this.workTimeInfo.setHourofbegintimepm(calendar.getInt("hourofbegintimepm"));
            this.workTimeInfo.setMinofbegintimepm(calendar.getInt("minofbegintimepm"));
            this.workTimeInfo.setHourofendtimepm(calendar.getInt("hourofendtimepm"));
            this.workTimeInfo.setMinofendtimepm(calendar.getInt("minofendtimepm"));
            DynamicObjectCollection calendarEntry = calendar.getDynamicObjectCollection("dateentry");
            int days = calendarEntry.size();
            this.morning_workDateList = new ArrayList<String>(days);
            this.afternoon_workDateList = new ArrayList<String>(days);
            for (DynamicObject obj : calendarEntry) {
                String datetype = obj.getString("datetype");
                String date_str = dateFormat.format(obj.getDate("workdate"));
                if ("1".equals(datetype)) {
                    this.morning_workDateList.add(date_str);
                    this.afternoon_workDateList.add(date_str);
                    continue;
                }
                if (!"2".equals(datetype)) continue;
                this.morning_workDateList.add(date_str);
            }
            String logStr = String.format(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5171\u4eab\u4e2d\u5fc3\uff1a%1$s\u7684\u5de5\u4f5c\u65e5\u5386\uff08%2$s\uff0c%3$s\uff09\uff0c\u4e0a\u5348\u5de5\u4f5c\u6570\u91cf\uff1a%4$s\uff0c\u4e0b\u5348\u5de5\u4f5c\u6570\u91cf\uff1a%5$s\uff0c\u5de5\u4f5c\u65e5\u5386\u5206\u5f55dataentry\uff1a%6$s", (String)"WorkDateUtil_0", (String)"ssc-task-formplugin", (Object[])new Object[0]), centerId, startDateCopy, endDateCopy, this.morning_workDateList.size(), this.afternoon_workDateList.size(), days);
            this.log.info(logStr);
        } else {
            this.workTimeInfo.setHourofbegintimeam(9);
            this.workTimeInfo.setMinofbegintimeam(0);
            this.workTimeInfo.setHourofendtimeam(12);
            this.workTimeInfo.setMinofendtimeam(0);
            this.workTimeInfo.setHourofbegintimepm(12);
            this.workTimeInfo.setMinofbegintimepm(0);
            this.workTimeInfo.setHourofendtimepm(17);
            this.workTimeInfo.setMinofendtimepm(0);
            if (this.morning_workDateList == null) {
                int days = 0;
                Date start_date = null;
                Date end_date = null;
                try {
                    start_date = dateFormat.parse(dateFormat.format(startDate));
                    end_date = dateFormat.parse(dateFormat.format(endDate));
                    days = (int)((end_date.getTime() - start_date.getTime()) / 1000L / 3600L / 24L);
                }
                catch (ParseException e) {
                    this.log.error("format date error!!" + e.getMessage(), (Throwable)e);
                    throw new KDException("format date error!!" + e.getMessage());
                }
                this.morning_workDateList = new ArrayList<String>(days);
                this.afternoon_workDateList = new ArrayList<String>(days);
                Date temp = start_date;
                String date_str = dateFormat.format(temp);
                for (int i = 0; i <= days; ++i) {
                    if (this.isNotWeekend(temp) && this.morning_workDateList.add(date_str)) {
                        this.afternoon_workDateList.add(date_str);
                    }
                    temp = new Date(temp.getTime() + 86400000L);
                    date_str = dateFormat.format(temp);
                }
            }
        }
    }

    public long calWorkTime(Date receiveTime, Date now, int type) {
        if (receiveTime == null || now == null) {
            return 0L;
        }
        if (receiveTime.after(now)) {
            return 0L;
        }
        BigDecimal b1000 = new BigDecimal(1000);
        BigDecimal b60 = new BigDecimal(60);
        long workTimes = this.calWorkTimeBetweenDay(receiveTime, now);
        BigDecimal temp = null;
        switch (type) {
            case 0: {
                temp = new BigDecimal(workTimes).setScale(2);
                break;
            }
            case 1: {
                temp = new BigDecimal(workTimes).divide(b1000, 2, RoundingMode.HALF_UP);
                break;
            }
            case 2: {
                temp = new BigDecimal(workTimes).divide(b1000.multiply(b60), 2, RoundingMode.HALF_UP);
                break;
            }
            case 3: {
                temp = new BigDecimal(workTimes).divide(b1000.multiply(b60).multiply(b60), 2, RoundingMode.HALF_UP);
            }
        }
        if (temp != null) {
            return temp.longValue();
        }
        return 0L;
    }

    private long calWorkTimeBetweenDay(Date receiveTime, Date now) {
        long result = 0L;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String d1 = dateFormat.format(receiveTime);
        String d2 = dateFormat.format(now);
        float f1_morning = this.getIndexFromList_morning(d1);
        float f2_morning = this.getIndexFromList_morning(d2);
        float f1_afternoon = this.getIndexFromList_afternoon(d1);
        float f2_afternoon = this.getIndexFromList_afternoon(d2);
        int morning_days = BigDecimal.valueOf(f2_morning).subtract(BigDecimal.valueOf(f1_morning)).setScale(0, RoundingMode.FLOOR).intValue();
        long morningWorkTime = (long)morning_days * this.workTimeInfo.getMorningWorkTimeMilSec();
        int afternoon_days = BigDecimal.valueOf(f2_afternoon).subtract(BigDecimal.valueOf(f1_afternoon)).setScale(0, RoundingMode.FLOOR).intValue();
        long afternoonWorkTime = (long)afternoon_days * (this.workTimeInfo.getOneDayWorkTimeMilSec() - this.workTimeInfo.getMorningWorkTimeMilSec());
        result = morningWorkTime + afternoonWorkTime;
        result -= this.calWorkedTimeInDay(receiveTime);
        return result += this.calWorkedTimeInDay(now);
    }

    public long calDaysBetweenDates(Date startTime, Date endTime) {
        long days = 0L;
        Calendar cal = Calendar.getInstance();
        cal.setTime(startTime);
        long startTimeLong = cal.getTimeInMillis();
        cal.setTime(endTime);
        long endTimeLong = cal.getTimeInMillis();
        long spanTime = endTimeLong - startTimeLong;
        BigDecimal b1000 = new BigDecimal(1000);
        BigDecimal b60 = new BigDecimal(60);
        BigDecimal b24 = new BigDecimal(24);
        BigDecimal daysBg = new BigDecimal(spanTime).divide(b1000.multiply(b60).multiply(b60).multiply(b24), 2, RoundingMode.HALF_UP);
        days = daysBg.longValue();
        return days;
    }

    public boolean isNotWeekend(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(7) != 1 && cal.get(7) != 7;
    }

    private boolean isNotWorkDay(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String date_str = dateFormat.format(date);
        return !this.morning_workDateList.contains(date_str) && !this.afternoon_workDateList.contains(date_str);
    }

    private boolean isHalfDay_AfternoonRest(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String date_str = dateFormat.format(date);
        return this.morning_workDateList.contains(date_str) && !this.afternoon_workDateList.contains(date_str);
    }

    private long calWorkedTimeInDay(Date date) {
        long workTime = 0L;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        TimeIgnoretDate dateTime = new TimeIgnoretDate(date);
        if (this.isNotWorkDay(date)) {
            return 0L;
        }
        workTime = this.isHalfDay_AfternoonRest(date) ? (dateTime.before(this.workTimeInfo.getStartTimestampAM()) ? 0L : (dateTime.before(this.workTimeInfo.getEndTimestampAM()) ? (long)dateTime.compareTo(this.workTimeInfo.getEndTimestampAM()) : this.workTimeInfo.getMorningWorkTimeMilSec())) : (dateTime.before(this.workTimeInfo.getStartTimestampAM()) ? 0L : (dateTime.before(this.workTimeInfo.getEndTimestampAM()) ? (long)dateTime.compareTo(this.workTimeInfo.getStartTimestampAM()) : (dateTime.before(this.workTimeInfo.getStartTimestampPM()) ? this.workTimeInfo.getMorningWorkTimeMilSec() : (dateTime.before(this.workTimeInfo.getEndTimestampPM()) ? (long)dateTime.compareTo(this.workTimeInfo.getStartTimestampPM()) + this.workTimeInfo.getMorningWorkTimeMilSec() : this.workTimeInfo.getOneDayWorkTimeMilSec()))));
        return workTime;
    }

    public float getIndexFromList_morning(String date) {
        float result;
        block7: {
            result = -1.0f;
            int index = this.morning_workDateList.indexOf(date);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            if (index == -1) {
                try {
                    Calendar now = this.strToCalendar(date);
                    Calendar startDate = this.strToCalendar(this.morning_workDateList.get(0));
                    Calendar endDate = this.strToCalendar(this.morning_workDateList.get(this.morning_workDateList.size() - 1));
                    if (now.before(startDate)) {
                        result = -0.5f;
                        break block7;
                    }
                    if (now.after(endDate)) {
                        result = (float)this.morning_workDateList.size() - 0.5f;
                        break block7;
                    }
                    now.add(5, 1);
                    String temp = dateFormat.format(now.getTime());
                    index = this.morning_workDateList.indexOf(temp);
                    while (index == -1) {
                        now.add(5, 1);
                        temp = dateFormat.format(now.getTime());
                        index = this.morning_workDateList.indexOf(temp);
                        if (!now.after(endDate)) continue;
                        this.log.info("\u5bfb\u627e\u65e5\u671f\u4e0b\u6807\u5931\u8d25\uff0c\u5f53\u524d\u65f6\u95f4\uff1a" + now.getTime() + ",endDate:" + endDate.getTime());
                        return -1.0f;
                    }
                    result = (float)index - 0.5f;
                }
                catch (Exception e) {
                    this.log.error("WorkDateUtil.getIndexFromList_morning\u89e3\u6790\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
                    result = -1.0f;
                }
            } else {
                result = index;
            }
        }
        return result;
    }

    public float getIndexFromList_afternoon(String date) {
        float result;
        block7: {
            result = -1.0f;
            int index = this.afternoon_workDateList.indexOf(date);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            if (index == -1) {
                try {
                    Calendar now = this.strToCalendar(date);
                    Calendar startDate = this.strToCalendar(this.afternoon_workDateList.get(0));
                    Calendar endDate = this.strToCalendar(this.afternoon_workDateList.get(this.afternoon_workDateList.size() - 1));
                    if (now.before(startDate)) {
                        result = -0.5f;
                        break block7;
                    }
                    if (now.after(endDate)) {
                        result = (float)this.afternoon_workDateList.size() - 0.5f;
                        break block7;
                    }
                    now.add(5, 1);
                    String temp = dateFormat.format(now.getTime());
                    index = this.afternoon_workDateList.indexOf(temp);
                    while (index == -1) {
                        now.add(5, 1);
                        temp = dateFormat.format(now.getTime());
                        index = this.afternoon_workDateList.indexOf(temp);
                        if (!now.after(endDate)) continue;
                        this.log.info("\u5bfb\u627e\u65e5\u671f\u4e0b\u6807\u5931\u8d25\uff0c\u5f53\u524d\u65f6\u95f4\uff1a" + now.getTime() + ",endDate:" + endDate.getTime());
                        return -1.0f;
                    }
                    result = (float)index - 0.5f;
                }
                catch (Exception e) {
                    this.log.error("WorkDateUtil.getIndexFromList_afternoon\u89e3\u6790\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
                    result = -1.0f;
                }
            } else {
                result = index;
            }
        }
        return result;
    }

    public Date strToDate(String date) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, Integer.parseInt(date.substring(0, 4)));
        cal.set(2, Integer.parseInt(date.substring(5, 7)) - 1);
        cal.set(5, Integer.parseInt(date.substring(8)));
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        return cal.getTime();
    }

    public Calendar strToCalendar(String date) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, Integer.parseInt(date.substring(0, 4)));
        cal.set(2, Integer.parseInt(date.substring(5, 7)) - 1);
        cal.set(5, Integer.parseInt(date.substring(8)));
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        return cal;
    }

    public WorkTime getWorkTimeInfo() {
        return this.workTimeInfo;
    }
}

