/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.exception.factory;

import kd.ssc.exception.compensate.CompensateHandler;
import kd.ssc.exception.compensate.RuleTaskCompensateHandler;
import kd.ssc.exception.compensate.WfSynCompensateHandler;
import kd.ssc.exception.compensate.WfTaskCompensateHandler;
import kd.ssc.exception.dto.ExceptionDTO;
import kd.ssc.exception.enums.ExceptionTypeEnum;

public class CompensateCreateFactory {
    public static CompensateHandler getCompensateInstance(ExceptionDTO dto) {
        CompensateHandler compensateHandler = null;
        if (dto == null || dto.getExceptionCode() == null) {
            return null;
        }
        if (ExceptionTypeEnum.getExceptionTypeByCode(dto.getExceptionCode()) == ExceptionTypeEnum.EXCEPTION_TYPE_TASK_WF) {
            compensateHandler = new WfTaskCompensateHandler(dto);
        } else if (ExceptionTypeEnum.getExceptionTypeByCode(dto.getExceptionCode()) == ExceptionTypeEnum.EXCEPTION_TYPE_TASK_RULE) {
            compensateHandler = new RuleTaskCompensateHandler(dto);
        } else if (ExceptionTypeEnum.getExceptionTypeByCode(dto.getExceptionCode()) == ExceptionTypeEnum.EXCEPTION_TYPE_WF_SYN_STAS) {
            compensateHandler = new WfSynCompensateHandler(dto);
        } else if (ExceptionTypeEnum.getExceptionTypeByCode(dto.getExceptionCode()) == ExceptionTypeEnum.EXCEPTION_TYPE_TASK_CREATEMETHOD) {
            compensateHandler = new WfTaskCompensateHandler(dto);
        }
        return compensateHandler;
    }
}

