/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.exception.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.ssc.exception.compensate.CompensateHandler;
import kd.ssc.exception.domain.ExceptionDO;
import kd.ssc.exception.dto.CompensateFieldDTO;
import kd.ssc.exception.dto.ExceptionDTO;
import kd.ssc.exception.enums.CompensateStatusEnum;
import kd.ssc.exception.enums.DealTypeEnum;
import kd.ssc.exception.factory.CompensateCreateFactory;
import kd.ssc.exception.factory.DtoCreateFactory;
import kd.ssc.exception.pojo.ExcRecordNotifyArgs;
import kd.ssc.exception.util.ExceptionHandlerUtil;

public class ExceptionHelperUtil {
    private static final String PARAM_NAME = "excRecordNotifyArgs";
    private static final Log log = LogFactory.getLog(ExceptionHelperUtil.class);

    public static void updateTableData(ExceptionDTO eDto, CompensateFieldDTO cDto) {
        ExceptionDO exceptionDo = ExceptionHelperUtil.merge2ExceptionDo(eDto, cDto);
        if (exceptionDo != null) {
            exceptionDo.saveAndUpdate();
            exceptionDo.saveHisTable();
        }
    }

    public static MessageInfo getMessageInfoBySscParam(ExcRecordNotifyArgs args, Integer statisCount) {
        if (args == null || statisCount == null) {
            return null;
        }
        MessageInfo messageInfo = new MessageInfo();
        String titleValue = null;
        String contentValue = null;
        List<Map<String, String>> usersInfo = null;
        if (args.getTitle() != null) {
            titleValue = args.getTitle();
        }
        if (args.getContent() != null && args.getContent().contains("%d")) {
            contentValue = String.format(args.getContent(), statisCount);
        }
        if (args.getUserList() != null) {
            usersInfo = args.getUserList();
        }
        List<Long> receiverIds = ExceptionHelperUtil.getUsersId(usersInfo);
        if (titleValue == null || contentValue == null || usersInfo == null || receiverIds == null) {
            return null;
        }
        LocaleString title = new LocaleString();
        title.setLocaleValue_zh_CN(titleValue);
        messageInfo.setMessageTitle((ILocaleString)title);
        LocaleString content = new LocaleString();
        content.setLocaleValue_zh_CN(contentValue);
        messageInfo.setMessageContent((ILocaleString)content);
        messageInfo.setUserIds(receiverIds);
        messageInfo.setMessageTag((ILocaleString)ResManager.getLocaleString((String)"\u5f02\u5e38\u901a\u77e5", (String)"ExceptionHelperUtil_0", (String)"ssc-task-common"));
        messageInfo.setType("message");
        return messageInfo;
    }

    public static void updateSscParam() {
        String sscParam = new ExcRecordNotifyArgs().toJsonString();
        QFilter paramNameFilter = new QFilter("paramname", "=", (Object)PARAM_NAME);
        if (QueryServiceHelper.exists((String)"task_paramcontrol", (QFilter[])new QFilter[]{paramNameFilter})) {
            DynamicObject saveData = BusinessDataServiceHelper.loadSingle((String)"task_paramcontrol", (String)"paramvalue", (QFilter[])new QFilter[]{paramNameFilter});
            saveData.set("paramvalue", (Object)sscParam);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{saveData});
        } else {
            DynamicObject saveData = BusinessDataServiceHelper.newDynamicObject((String)"task_paramcontrol");
            saveData.set("paramname", (Object)PARAM_NAME);
            saveData.set("paramvalue", (Object)sscParam);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{saveData});
        }
    }

    public static void updateTableAfterCompensateException(Throwable e, ExceptionDTO dto) {
        if (e == null || dto == null) {
            return;
        }
        log.warn("CompensateExceptionMeta:" + dto);
        String exceptionMsg = e instanceof KDException ? ((KDException)e).getStackTraceMessage() : Arrays.toString(e.getStackTrace());
        dto.setFailureReason(exceptionMsg);
        dto.setFailureMsg(e.getMessage());
        ExceptionHelperUtil.updateTableAfterCompensate(CompensateStatusEnum.FAILURE, dto);
    }

    public static void updateTableAfterCompensate(CompensateStatusEnum statusEnum, ExceptionDTO eDto) {
        if (eDto != null || statusEnum != null) {
            Date retryTime = new Date();
            int retryCounts = ExceptionHelperUtil.getRetryCounts(eDto) + 1;
            String compensateStatus = statusEnum.getValue();
            CompensateFieldDTO cDto = new CompensateFieldDTO(retryTime, retryCounts, compensateStatus);
            log.info("CompensateMsg:" + cDto);
            ExceptionHelperUtil.updateTableData(eDto, cDto);
        }
    }

    public static void updateTableAfterException(ExceptionDTO dto) {
        log.warn("saveTableMeta:" + dto);
        ExceptionHandlerUtil.handleException(dto);
    }

    public static boolean isLegalDto(ExceptionDTO dto) {
        return StringUtils.isNotBlank((CharSequence)dto.getBillId()) && StringUtils.isNotBlank((CharSequence)dto.getBillType()) && StringUtils.isNotBlank((CharSequence)dto.getExceptionCode());
    }

    public static int batchCompensate(DynamicObjectCollection collection, boolean isAuto) {
        log.warn("\u6279\u91cf\u8865\u507f\u5f00\u59cb");
        if (collection == null) {
            return 0;
        }
        log.warn("\u8865\u507f\u5355\u636e\u6570\u76ee:" + collection.size());
        DealTypeEnum dealTypeEnum = isAuto ? DealTypeEnum.AutoDeal : DealTypeEnum.ManualDeal;
        ArrayList<ExceptionDO> excDoList = new ArrayList<ExceptionDO>();
        for (DynamicObject excRecord : collection) {
            excDoList.add(new ExceptionDO(excRecord));
        }
        ArrayList<ExceptionDTO> excDtoList = new ArrayList<ExceptionDTO>();
        for (ExceptionDO excDo : excDoList) {
            ExceptionDTO dto = DtoCreateFactory.transFromDo2Dto(excDo);
            if (dto == null) continue;
            dto.setDealType(dealTypeEnum.getValue());
            excDtoList.add(dto);
        }
        return ExceptionHelperUtil.batchCompensateWithDTO(excDtoList);
    }

    public static boolean taskIsExisted(String billId, Long taskTypeId) {
        if (StringUtils.isBlank((CharSequence)billId) || taskTypeId == null) {
            return false;
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("billid", "=", (Object)billId), new QFilter("tasktypeid", "=", (Object)taskTypeId)};
        boolean taskExisted = QueryServiceHelper.exists((String)"task_task", (QFilter[])qFilters);
        boolean taskHisExisted = QueryServiceHelper.exists((String)"task_taskhistory", (QFilter[])qFilters);
        return taskExisted || taskHisExisted;
    }

    private static int batchCompensateWithDTO(List<ExceptionDTO> excDtoList) {
        int count = 0;
        if (excDtoList != null) {
            for (ExceptionDTO excDto : excDtoList) {
                boolean compensateSuccess;
                CompensateHandler handler = CompensateCreateFactory.getCompensateInstance(excDto);
                if (handler == null || !(compensateSuccess = handler.exceptionCompensate())) continue;
                ++count;
            }
        }
        return count;
    }

    private static List<Long> getUsersId(List<Map<String, String>> usrInfo) {
        ArrayList<Long> userId = new ArrayList<Long>();
        if (usrInfo != null && usrInfo.size() > 0) {
            for (Map<String, String> map : usrInfo) {
                if (map.get("id") == null) continue;
                userId.add(Long.valueOf(map.get("id")));
            }
        }
        if (userId.size() > 0) {
            return userId;
        }
        return null;
    }

    private static int getRetryCounts(ExceptionDTO eDto) {
        int count = 0;
        if (ExceptionHelperUtil.isLegalDto(eDto)) {
            QFilter[] filters = new QFilter[]{new QFilter("billid", "=", (Object)eDto.getBillId()), new QFilter("billtype", "=", (Object)eDto.getBillType()), new QFilter("exceptiontype", "=", (Object)eDto.getExceptionCode())};
            DynamicObject dyn = QueryServiceHelper.queryOne((String)"task_exceptionrecord", (String)"retrycounts", (QFilter[])filters);
            if (dyn != null) {
                count = dyn.getInt("retrycounts");
            }
        }
        return count;
    }

    private static ExceptionDO merge2ExceptionDo(ExceptionDTO eDto, CompensateFieldDTO cDto) {
        if (eDto == null || cDto == null) {
            return null;
        }
        ExceptionDO exceptionDo = eDto.transform2Do();
        if (exceptionDo != null) {
            if (cDto.getRetryTime() != null) {
                exceptionDo.setRetryTime(cDto.getRetryTime());
            }
            if (cDto.getRetryCounts() != null) {
                exceptionDo.setRetryCounts(cDto.getRetryCounts());
            }
            if (cDto.getIsNotified() != null) {
                exceptionDo.setIsNotified(cDto.getIsNotified());
            }
            if (cDto.getNotifyType() != null) {
                exceptionDo.setNotifyType(cDto.getNotifyType());
            }
            if (cDto.getNotifyMember() != null) {
                exceptionDo.setNotifyMember(cDto.getNotifyMember());
            }
            if (cDto.getCompensateStatus() != null) {
                exceptionDo.setCompensateStatus(cDto.getCompensateStatus());
            }
        }
        return exceptionDo;
    }
}

