/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.plugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;

public class ConditionFilterStylePlugin
extends AbstractBillPlugIn {
    private static final String FILTER_GRID = "filtergridap";
    private static final String FILTER = "filter";
    private static final String CONDITION = "condition";
    private static final String FORM_NUMBER = "form_number";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
    }

    public void beforeBindData(EventObject e) {
        this.createBillFilterGrid();
    }

    public void afterBindData(EventObject e) {
        this.fillBillFilterGrid();
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        if ("btnok".equals(key)) {
            Map<String, String> map = this.returnBillFilter();
            this.getView().returnDataToParent(map);
            this.getView().close();
        }
    }

    private void createBillFilterGrid() {
        EntityTypeUtil entityTypeUtil = new EntityTypeUtil();
        FilterGrid filterGrid = (FilterGrid)this.getControl(FILTER_GRID);
        String number = (String)this.getView().getFormShowParameter().getCustomParam(FORM_NUMBER);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)number);
        List filterColumns = entityTypeUtil.getFilterColumns((IDataEntityType)entityType);
        filterGrid.setEntityNumber(entityType.getName());
        filterGrid.setFilterColumns(filterColumns);
    }

    private void fillBillFilterGrid() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String json = (String)parameter.getCustomParam(FILTER);
        if (!StringUtils.isBlank((CharSequence)json)) {
            FilterCondition billFilter = (FilterCondition)SerializationUtils.fromJsonString((String)json, FilterCondition.class);
            FilterGrid filterGrid = (FilterGrid)this.getControl(FILTER_GRID);
            filterGrid.SetValue(billFilter);
        }
    }

    private Map<String, String> returnBillFilter() {
        HashMap<String, String> map = new HashMap<String, String>(4);
        String number = (String)this.getView().getFormShowParameter().getCustomParam(FORM_NUMBER);
        MainEntityType dataType = EntityMetadataCache.getDataEntityType((String)number);
        FilterGrid filterGrid = (FilterGrid)this.getControl(FILTER_GRID);
        FilterCondition fc = filterGrid.getFilterGridState().getFilterCondition();
        FilterBuilder filterBuilder = new FilterBuilder(dataType, fc, false);
        filterBuilder.buildFilter(false);
        String billFilter = filterBuilder.getFilterObject().getFilter();
        if (StringUtils.isNotEmpty((CharSequence)billFilter)) {
            map.put(CONDITION, billFilter);
            map.put(FILTER, SerializationUtils.toJsonString((Object)fc));
        }
        return map;
    }
}

