/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.smartApproval.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.enums.MultiLangEnumBridge;
import kd.ssc.smartApproval.enums.AlgriModelNameEnum;
import kd.ssc.smartApproval.enums.TaskDataUploadStatusEnum;
import kd.ssc.task.http.HttpClientUtil;
import kd.ssc.task.util.SSCBosUtil;

public class TaskDataUploadHelper {
    private static final Log log = LogFactory.getLog(TaskDataUploadHelper.class);
    private static int batchCount = 1000;
    private static final String SELECT_PROP = "taskid,fbilltypeid,forgid,fsscid,fimageok,fcreatorid,fcreatetime,frecordtype,fmoney,ffeetype,fisneedimage,fcreditlevel,fcreditvalue,fuser,funqualifiedtotalnum,fyzjimported,forgpatternid,fispurchase,fissale,fisinventory,fisaccounting,fcreatetime_org,fisbizorg,fgender,fusertype,fcreatetime_user,fstate,withdrawal,breakrule,operation,status,count,errinfo,fruleresult";
    private static final Set<String> PROP_SET = new HashSet(Arrays.asList("fbilltypeid", "forgid", "fsscid", "fimageok", "fcreatorid", "frecordtype", "fmoney", "ffeetype", "fisneedimage", "fcreditlevel", "fcreditvalue", "fuser", "funqualifiedtotalnum", "fyzjimported", "forgpatternid", "fispurchase", "fissale", "fisinventory", "fisaccounting", "fisbizorg", "fgender", "fusertype", "fstate", "fruleresult")){};
    private static final String DATA_UPLOAD_URL = "/record_check/upload";
    private static final String DATA_TRAIN_URL = "/record_check/train";
    private static final String MODEL_INIT_URL = "/record_check/init";
    private static final String CLEAR_DATA_URL = "/record_check/clear";
    private static final String GET_MODEL_URL = "/record_check/display";
    private static final String RET_OK = "0";
    private static final String TRAIN_PROCESSING = "1";
    private static final int RETRIED_COUNT = 1;
    private static final String DATE_FORMAT = "yyyy-MM-dd";

    public static void uploadTaskData(boolean isViewOperator) {
        DynamicObject[] data;
        String urlSetting = TaskDataUploadHelper.getUrlSetting();
        if (StringUtils.isBlank((CharSequence)urlSetting)) {
            ErrorCode code = new ErrorCode("-1", ResManager.loadKDString((String)"\u667a\u80fd\u5ba1\u6838\uff1a\u83b7\u53d6\u5ba1\u6838\u7edf\u4e00\u63a5\u53e3\u4e3a\u7a7a\u3002", (String)"TaskDataUploadHelper_2", (String)"ssc-task-common", (Object[])new Object[0]));
            throw new KDException(code, new Object[0]);
        }
        batchCount = Math.min(10000, TaskDataUploadHelper.getBatchCount());
        if (isViewOperator) {
            ArrayList<Object> params = new ArrayList<Object>(3);
            params.add(1);
            params.add("2");
            params.add(2);
            DB.execute((DBRoute)DBRoute.of((String)"ssc"), (String)"update t_tk_smartapproval_data set fcount = ? where fstatus = ? and fcount = ?", (Object[])params.toArray());
        }
        int uploadCount = 0;
        QFilter statusQf = new QFilter("status", "in", Arrays.asList(TaskDataUploadStatusEnum.NotUpload.getValue(), TaskDataUploadStatusEnum.ErrorRetry.getValue()));
        QFilter countQf = new QFilter("count", "<=", (Object)1);
        while ((data = BusinessDataServiceHelper.load((String)"task_approval_tempdata", (String)SELECT_PROP, (QFilter[])new QFilter[]{statusQf, countQf}, null, (int)(batchCount * 20))) != null && data.length != 0) {
            uploadCount += TaskDataUploadHelper.processForBatch(data, urlSetting);
            SaveServiceHelper.save((DynamicObject[])data);
        }
        log.info("\u667a\u80fd\u5ba1\u6838\uff1a\u6570\u636e\u4e0a\u4f20\u63a5\u53e3\u4e0a\u4f20\u6570\u636e\u91cf\uff1a" + uploadCount);
    }

    private static int processForBatch(DynamicObject[] data, String urlSetting) {
        int beginIndex = 0;
        int uploadCount = 0;
        while (beginIndex < data.length) {
            int endIndex = beginIndex + batchCount;
            if (endIndex > data.length) {
                endIndex = data.length;
            }
            uploadCount += TaskDataUploadHelper.actualUpload(data, beginIndex, endIndex, urlSetting);
            beginIndex = endIndex;
        }
        return uploadCount;
    }

    private static int actualUpload(DynamicObject[] data, int beginIndex, int endIndex, String urlSetting) {
        String jsonBody = TaskDataUploadHelper.taskDataToJsonStr(data, beginIndex, endIndex);
        try {
            JSONObject resultJson;
            String code;
            log.info("\u667a\u80fd\u5ba1\u6838\uff1a\u6570\u636e\u4e0a\u4f20\u5165\u53c2" + jsonBody);
            String ret = TaskDataUploadHelper.executePostWithHeader(urlSetting + DATA_UPLOAD_URL, jsonBody);
            log.info("\u667a\u80fd\u5ba1\u6838\uff1a\u6570\u636e\u4e0a\u4f20\u8fd4\u56de\u7ed3\u679c " + ret);
            boolean uploadSuccess = false;
            if (StringUtils.isNotBlank((CharSequence)ret) && StringUtils.equals((CharSequence)(code = (resultJson = JSONObject.parseObject((String)ret)).getString("code")), (CharSequence)RET_OK)) {
                uploadSuccess = true;
            }
            if (uploadSuccess) {
                for (int i = beginIndex; i < endIndex; ++i) {
                    data[i].set("status", (Object)TaskDataUploadStatusEnum.Uploaded.getValue());
                }
                return endIndex - beginIndex;
            }
            for (int i = beginIndex; i < endIndex; ++i) {
                data[i].set("status", (Object)TaskDataUploadStatusEnum.ErrorRetry.getValue());
                data[i].set("count", (Object)(data[i].getInt("count") + 1));
                data[i].set("errinfo", (Object)"call resp no return data");
            }
            return 0;
        }
        catch (Exception e) {
            log.error("\u667a\u80fd\u5ba1\u6838\uff1a\u6570\u636e\u4e0a\u4f20\u8c03\u7528\u5f02\u5e38", (Throwable)e);
            for (int i = beginIndex; i < endIndex; ++i) {
                data[i].set("status", (Object)TaskDataUploadStatusEnum.ErrorRetry.getValue());
                data[i].set("count", (Object)(data[i].getInt("count") + 1));
                data[i].set("errinfo", (Object)e.getMessage());
            }
            return 0;
        }
    }

    public static void initModel() throws Exception {
        block5: {
            try {
                String urlSetting = TaskDataUploadHelper.getUrlSetting();
                if (StringUtils.isBlank((CharSequence)urlSetting)) {
                    throw new Exception(ResManager.loadKDString((String)"\u667a\u80fd\u5ba1\u6838\uff1a\u83b7\u53d6\u5ba1\u6838\u7edf\u4e00\u63a5\u53e3\u4e3a\u7a7a\u3002", (String)"TaskDataUploadHelper_2", (String)"ssc-task-common", (Object[])new Object[0]));
                }
                String ret = TaskDataUploadHelper.executePostWithHeader(urlSetting + MODEL_INIT_URL, "");
                log.info("\u667a\u80fd\u5ba1\u6838\uff1a\u8c03\u521d\u59cb\u5316\u6a21\u578b\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c " + ret);
                if (StringUtils.isNotBlank((CharSequence)ret)) {
                    JSONObject resultJson = JSONObject.parseObject((String)ret);
                    String code = resultJson.getString("code");
                    if (!StringUtils.equals((CharSequence)code, (CharSequence)RET_OK)) {
                        log.error("\u667a\u80fd\u5ba1\u6838\uff1a\u6a21\u578b\u8bad\u7ec3\u63a5\u53e3\u8c03\u5931\u8d25\uff0c" + resultJson.get((Object)"err"));
                        throw new Exception(ResManager.loadKDString((String)"\u6a21\u578b\u8bad\u7ec3\u63a5\u53e3\u8c03\u5931\u8d25", (String)"TaskDataUploadHelper_3", (String)"ssc-task-common", (Object[])new Object[0]));
                    }
                    break block5;
                }
                ErrorCode code = new ErrorCode("-1", ResManager.loadKDString((String)"\u667a\u80fd\u5ba1\u6838\u6a21\u578b\u521d\u59cb\u5316\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a\u3002", (String)"TaskDataUploadHelper_0", (String)"ssc-task-common", (Object[])new Object[0]));
                throw new KDException(code, new Object[0]);
            }
            catch (Exception e) {
                log.error("\u667a\u80fd\u5ba1\u6838\uff1a\u8c03\u521d\u59cb\u5316\u6a21\u578b\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
                throw e;
            }
        }
    }

    public static void clearData() throws Exception {
        try {
            JSONObject resultJson;
            String code;
            String urlSetting = TaskDataUploadHelper.getUrlSetting();
            if (StringUtils.isBlank((CharSequence)urlSetting)) {
                throw new Exception(ResManager.loadKDString((String)"\u667a\u80fd\u5ba1\u6838\uff1a\u83b7\u53d6\u5ba1\u6838\u7edf\u4e00\u63a5\u53e3\u4e3a\u7a7a\u3002", (String)"TaskDataUploadHelper_2", (String)"ssc-task-common", (Object[])new Object[0]));
            }
            String ret = TaskDataUploadHelper.executePostWithHeader(urlSetting + CLEAR_DATA_URL, "");
            log.info("\u667a\u80fd\u5ba1\u6838\uff1a\u8c03\u6570\u636e\u6e05\u7406\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c " + ret);
            if (StringUtils.isNotBlank((CharSequence)ret) && !StringUtils.equals((CharSequence)(code = (resultJson = JSONObject.parseObject((String)ret)).getString("code")), (CharSequence)RET_OK)) {
                log.error("\u667a\u80fd\u5ba1\u6838\uff1a\u6570\u636e\u6e05\u7406\u63a5\u53e3\u8c03\u5931\u8d25\uff0c" + resultJson.get((Object)"err"));
                throw new Exception(ResManager.loadKDString((String)"\u6570\u636e\u6e05\u7406\u63a5\u53e3\u8c03\u5931\u8d25", (String)"TaskDataUploadHelper_4", (String)"ssc-task-common", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            log.error("\u667a\u80fd\u5ba1\u6838\uff1a\u8c03\u6570\u636e\u6e05\u7406\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            throw e;
        }
    }

    public static void trainTaskData() throws Exception {
        try {
            String urlSetting = TaskDataUploadHelper.getUrlSetting();
            if (StringUtils.isBlank((CharSequence)urlSetting)) {
                throw new Exception(ResManager.loadKDString((String)"\u667a\u80fd\u5ba1\u6838\uff1a\u83b7\u53d6\u5ba1\u6838\u7edf\u4e00\u63a5\u53e3\u4e3a\u7a7a\u3002", (String)"TaskDataUploadHelper_2", (String)"ssc-task-common", (Object[])new Object[0]));
            }
            String ret = TaskDataUploadHelper.executePostWithHeader(urlSetting + DATA_TRAIN_URL, "");
            log.info("\u667a\u80fd\u5ba1\u6838\uff1a\u6a21\u578b\u8bad\u7ec3\u8fd4\u56de\u7ed3\u679c " + ret);
            if (StringUtils.isNotBlank((CharSequence)ret)) {
                JSONObject retJson = JSONObject.parseObject((String)ret);
                String code = retJson.getString("code");
                if (StringUtils.equals((CharSequence)code, (CharSequence)RET_OK)) {
                    JSONArray resultJson = retJson.getJSONArray("result");
                    Object result = retJson.getJSONArray("result").get(0);
                    if (resultJson.isEmpty() || result != null && StringUtils.equals((CharSequence)result.toString(), (CharSequence)"\u65e0\u6570\u636e")) {
                        log.error("\u667a\u80fd\u5ba1\u6838\uff1a\u6a21\u578b\u8bad\u7ec3\u63a5\u53e3\u8c03\u7528\u6210\u529f\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
                        return;
                    }
                    TaskDataUploadHelper.saveTaskAlgriMode(resultJson.getJSONObject(0));
                } else if (StringUtils.equals((CharSequence)code, (CharSequence)TRAIN_PROCESSING)) {
                    TaskDataUploadHelper.saveErrorRecord();
                } else {
                    TaskDataUploadHelper.saveErrorRecord();
                    log.error("\u667a\u80fd\u5ba1\u6838\uff1a\u6a21\u578b\u8bad\u7ec3\u63a5\u53e3\u8c03\u5931\u8d25\uff0c" + retJson.get((Object)"err"));
                }
            }
        }
        catch (Exception e) {
            TaskDataUploadHelper.saveErrorRecord();
            log.error("\u667a\u80fd\u5ba1\u6838\uff1a\u6a21\u578b\u8bad\u7ec3\u63a5\u53e3\u8c03\u7528\u5f02\u5e38", (Throwable)e);
            throw e;
        }
    }

    private static void saveErrorRecord() {
        QFilter thresholdQf = new QFilter("threshold", "=", (Object)-1);
        QFilter lasttraintimeQf = new QFilter("lasttraintime", "=", null);
        boolean exists = QueryServiceHelper.exists((String)"task_algri_mode", (QFilter[])new QFilter[]{thresholdQf, lasttraintimeQf});
        if (!exists) {
            DynamicObject taskAlgriModeUnpass = BusinessDataServiceHelper.newDynamicObject((String)"task_algri_mode");
            taskAlgriModeUnpass.set("threshold", (Object)-1);
            taskAlgriModeUnpass.set("createtime", (Object)new Date());
            taskAlgriModeUnpass.set("name", (Object)AlgriModelNameEnum.UNPASS.getBridge().loadKDString());
            taskAlgriModeUnpass.set("number", (Object)AlgriModelNameEnum.UNPASS.getNumber());
            DynamicObject taskAlgriModeWithdrawal = BusinessDataServiceHelper.newDynamicObject((String)"task_algri_mode");
            taskAlgriModeWithdrawal.set("threshold", (Object)-1);
            taskAlgriModeWithdrawal.set("createtime", (Object)new Date());
            taskAlgriModeWithdrawal.set("name", (Object)AlgriModelNameEnum.WITHDRAWAL.getBridge().loadKDString());
            taskAlgriModeWithdrawal.set("number", (Object)AlgriModelNameEnum.WITHDRAWAL.getNumber());
            DynamicObject taskAlgriModeOperation = BusinessDataServiceHelper.newDynamicObject((String)"task_algri_mode");
            taskAlgriModeOperation.set("threshold", (Object)-1);
            taskAlgriModeOperation.set("createtime", (Object)new Date());
            taskAlgriModeOperation.set("name", (Object)AlgriModelNameEnum.OPERATION.getBridge().loadKDString());
            taskAlgriModeOperation.set("number", (Object)AlgriModelNameEnum.OPERATION.getNumber());
            DynamicObject taskAlgriModeBreakrule = BusinessDataServiceHelper.newDynamicObject((String)"task_algri_mode");
            taskAlgriModeBreakrule.set("threshold", (Object)-1);
            taskAlgriModeBreakrule.set("createtime", (Object)new Date());
            taskAlgriModeBreakrule.set("name", (Object)AlgriModelNameEnum.BREAKRULE.getBridge().loadKDString());
            taskAlgriModeBreakrule.set("number", (Object)AlgriModelNameEnum.BREAKRULE.getNumber());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskAlgriModeUnpass, taskAlgriModeWithdrawal, taskAlgriModeOperation, taskAlgriModeBreakrule});
        }
    }

    public static int getModelTrainResult() throws Exception {
        String urlSetting = TaskDataUploadHelper.getUrlSetting();
        if (StringUtils.isBlank((CharSequence)urlSetting)) {
            throw new Exception(ResManager.loadKDString((String)"\u667a\u80fd\u5ba1\u6838\uff1a\u83b7\u53d6\u5ba1\u6838\u7edf\u4e00\u63a5\u53e3\u4e3a\u7a7a\u3002", (String)"TaskDataUploadHelper_2", (String)"ssc-task-common", (Object[])new Object[0]));
        }
        String ret = TaskDataUploadHelper.executePostWithHeader(urlSetting + GET_MODEL_URL, "");
        log.info("\u667a\u80fd\u5ba1\u6838\uff1a\u6a21\u578b\u8bad\u7ec3\u8fd4\u56de\u7ed3\u679c " + ret);
        if (StringUtils.isNotBlank((CharSequence)ret)) {
            JSONObject retJson = JSONObject.parseObject((String)ret);
            String code = retJson.getString("code");
            if (StringUtils.equals((CharSequence)code, (CharSequence)RET_OK)) {
                JSONArray resultJson = retJson.getJSONArray("result");
                Object result = retJson.getJSONArray("result").get(0);
                if (resultJson.isEmpty() || result != null && StringUtils.equals((CharSequence)result.toString(), (CharSequence)"\u65e0\u6570\u636e")) {
                    log.error("\u667a\u80fd\u5ba1\u6838\uff1a\u83b7\u53d6\u6a21\u578b\u8bad\u7ec3\u7ed3\u679c\u63a5\u53e3\u8c03\u7528\u6210\u529f\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
                    return -1;
                }
                TaskDataUploadHelper.saveTaskAlgriMode(resultJson.getJSONObject(0));
                return 0;
            }
            if (StringUtils.equals((CharSequence)code, (CharSequence)TRAIN_PROCESSING)) {
                return 1;
            }
            log.error("\u667a\u80fd\u5ba1\u6838\uff1a\u83b7\u53d6\u6a21\u578b\u8bad\u7ec3\u7ed3\u679c\u5931\u8d25\uff0c" + retJson.get((Object)"err"));
            return -1;
        }
        return -1;
    }

    public static void saveTaskAlgriMode(JSONObject resultJson) {
        DynamicObject taskAlgriModeUnpass = TaskDataUploadHelper.parseTrainDetailInfo(resultJson, AlgriModelNameEnum.UNPASS);
        DynamicObject taskAlgriModeWithdrawal = TaskDataUploadHelper.parseTrainDetailInfo(resultJson, AlgriModelNameEnum.WITHDRAWAL);
        DynamicObject taskAlgriModeOperation = TaskDataUploadHelper.parseTrainDetailInfo(resultJson, AlgriModelNameEnum.OPERATION);
        DynamicObject taskAlgriModeBreakrule = TaskDataUploadHelper.parseTrainDetailInfo(resultJson, AlgriModelNameEnum.BREAKRULE);
        try (TXHandle h = TX.requiresNew();){
            try {
                QFilter thresholdQf = new QFilter("threshold", "=", (Object)-1);
                QFilter lasttraintimeQf = new QFilter("lasttraintime", "=", null);
                DeleteServiceHelper.delete((String)"task_algri_mode", (QFilter[])new QFilter[]{thresholdQf, lasttraintimeQf});
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskAlgriModeUnpass, taskAlgriModeWithdrawal, taskAlgriModeOperation, taskAlgriModeBreakrule});
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }

    private static DynamicObject parseTrainDetailInfo(JSONObject resultJson, AlgriModelNameEnum model) {
        DynamicObject taskAlgriMode = BusinessDataServiceHelper.newDynamicObject((String)"task_algri_mode");
        taskAlgriMode.set("threshold", (Object)resultJson.getFloat("key"));
        taskAlgriMode.set("trainsize", (Object)resultJson.getInteger("train_data"));
        taskAlgriMode.set("servicename", (Object)resultJson.getString("service_name"));
        taskAlgriMode.set("modelname", (Object)resultJson.getString("model_name"));
        taskAlgriMode.set("usedtimes", (Object)resultJson.getInteger("used_times"));
        taskAlgriMode.set("lasttraintime", (Object)resultJson.getDate("last_train_time"));
        Date date = new Date();
        taskAlgriMode.set("createtime", (Object)date);
        taskAlgriMode.set("modifytime", (Object)date);
        taskAlgriMode.set("number", (Object)model.getNumber());
        switch (model.getNumber()) {
            case "unpass": {
                TaskDataUploadHelper.constructUnpassModel(resultJson, taskAlgriMode);
                break;
            }
            case "withdrawal": {
                TaskDataUploadHelper.constructWithdrawalModel(resultJson, taskAlgriMode);
                break;
            }
            case "operation": {
                TaskDataUploadHelper.constructOperationModel(resultJson, taskAlgriMode);
                break;
            }
            case "breakrule": {
                TaskDataUploadHelper.constructBreakruleModel(resultJson, taskAlgriMode);
            }
        }
        return taskAlgriMode;
    }

    private static void constructBreakruleModel(JSONObject resultJson, DynamicObject taskAlgriMode) {
        JSONObject modelJson = resultJson.getJSONObject(AlgriModelNameEnum.BREAKRULE.getNumber());
        TaskDataUploadHelper.constructDefaultModel(modelJson, taskAlgriMode);
        JSONObject unpassModelJson = resultJson.getJSONObject(AlgriModelNameEnum.UNPASS.getNumber());
        taskAlgriMode.set("accuracy", unpassModelJson.get((Object)"acc"));
        taskAlgriMode.set("name", (Object)AlgriModelNameEnum.BREAKRULE.getBridge().loadKDString());
        taskAlgriMode.set("description", (Object)new MultiLangEnumBridge("\u57fa\u4e8e\u8fc7\u53bb12\u4e2a\u6708\u7684\u5ba1\u6838\u4efb\u52a1\u6570\u636e\u8bad\u7ec3\uff0c\u5982\u679c\u5ba1\u6838\u4efb\u52a1\u9884\u6d4b\u7ed3\u679c\u4e3a\u201c\u901a\u8fc7\u201d\u5219\u4f1a\u6839\u636e\u591a\u9879\u76f8\u5173\u56e0\u7d20\u9884\u6d4b\u5e76\u63a8\u8350\u6982\u7387\u6700\u9ad8\u7684\u201c\u4fe1\u7528\u6263\u5206\u9879\u201d\u9009\u9879\u3002", "TaskDataUploadHelper_7", "ssc-task-formplugin").loadKDString());
    }

    private static void constructOperationModel(JSONObject resultJson, DynamicObject taskAlgriMode) {
        JSONObject modelJson = resultJson.getJSONObject(AlgriModelNameEnum.OPERATION.getNumber());
        TaskDataUploadHelper.constructDefaultModel(modelJson, taskAlgriMode);
        JSONObject unpassModelJson = resultJson.getJSONObject(AlgriModelNameEnum.UNPASS.getNumber());
        taskAlgriMode.set("accuracy", unpassModelJson.get((Object)"acc"));
        taskAlgriMode.set("name", (Object)AlgriModelNameEnum.OPERATION.getBridge().loadKDString());
        taskAlgriMode.set("description", (Object)new MultiLangEnumBridge("\u57fa\u4e8e\u8fc7\u53bb12\u4e2a\u6708\u7684\u5ba1\u6838\u4efb\u52a1\u6570\u636e\u8bad\u7ec3\uff0c\u672c\u7b97\u6cd5\u5c06\u6839\u636e\u9884\u6d4b\u7684\u5ba1\u6838\u7ed3\u679c\uff08\u901a\u8fc7/\u4e0d\u901a\u8fc7\uff09\u548c\u5176\u4ed6\u76f8\u5173\u56e0\u7d20\u63a8\u8350\u6bcf\u6761\u5ba1\u6838\u4efb\u52a1\u9ed8\u8ba4\u7684\u5ba1\u6279\u201c\u64cd\u4f5c\u7c7b\u578b\u201d\u9009\u9879\u3002", "TaskDataUploadHelper_5", "ssc-task-formplugin").loadKDString());
    }

    private static void constructWithdrawalModel(JSONObject resultJson, DynamicObject taskAlgriMode) {
        JSONObject modelJson = resultJson.getJSONObject(AlgriModelNameEnum.WITHDRAWAL.getNumber());
        TaskDataUploadHelper.constructDefaultModel(modelJson, taskAlgriMode);
        JSONObject unpassModelJson = resultJson.getJSONObject(AlgriModelNameEnum.UNPASS.getNumber());
        taskAlgriMode.set("accuracy", unpassModelJson.get((Object)"acc"));
        taskAlgriMode.set("name", (Object)AlgriModelNameEnum.WITHDRAWAL.getBridge().loadKDString());
        taskAlgriMode.set("description", (Object)new MultiLangEnumBridge("\u57fa\u4e8e\u8fc7\u53bb12\u4e2a\u6708\u7684\u5ba1\u6838\u4efb\u52a1\u6570\u636e\u8bad\u7ec3\uff0c\u5982\u679c\u5ba1\u6838\u4efb\u52a1\u9884\u6d4b\u7ed3\u679c\u4e3a\u201c\u4e0d\u901a\u8fc7\u201d\u5219\u4f1a\u6839\u636e\u591a\u9879\u76f8\u5173\u56e0\u7d20\u9884\u6d4b\u5e76\u63a8\u8350\u6982\u7387\u6700\u9ad8\u7684\u201c\u6279\u9000\u539f\u56e0\u201d\u9009\u9879\u3002", "TaskDataUploadHelper_3", "ssc-task-formplugin").loadKDString());
    }

    private static void constructDefaultModel(JSONObject modelJson, DynamicObject taskAlgriMode) {
        taskAlgriMode.set("newrecommend_tag", modelJson.get((Object)"label_sort"));
        TaskDataUploadHelper.addInfluentityRow(modelJson, taskAlgriMode);
    }

    private static void constructUnpassModel(JSONObject resultJson, DynamicObject taskAlgriMode) {
        JSONObject modelJson = resultJson.getJSONObject(AlgriModelNameEnum.UNPASS.getNumber());
        taskAlgriMode.set("accuracy", modelJson.get((Object)"acc"));
        taskAlgriMode.set("recallrate", modelJson.get((Object)"recall"));
        taskAlgriMode.set("auc", modelJson.get((Object)"auc"));
        taskAlgriMode.set("newrecommend_tag", modelJson.get((Object)"importance_value"));
        taskAlgriMode.set("name", (Object)AlgriModelNameEnum.UNPASS.getBridge().loadKDString());
        taskAlgriMode.set("description", (Object)new MultiLangEnumBridge("\u57fa\u4e8e\u8fc7\u53bb12\u4e2a\u6708\u7684\u5ba1\u6838\u4efb\u52a1\u7684\u6570\u636e\u8bad\u7ec3\uff0c\u9884\u6d4b\u5ba1\u6838\u4efb\u52a1\u7684\u901a\u8fc7\u3001\u4e0d\u901a\u8fc7\u4ee5\u53ca\u5bf9\u5e94\u6982\u7387\uff0c\u5e76\u4e14\u7ed9\u4e0e\u5ba1\u6838\u7ed3\u679c\u63a8\u8350\u3002\u540c\u65f6\uff0c\u672c\u7b97\u6cd5\u8fd8\u4f1a\u63a8\u8350\u5e76\u5c55\u793a\u9884\u6d4b\u6bcf\u4e00\u6761\u4efb\u52a1\u7684\u89e3\u6790\u8fc7\u7a0b\u548c\u5386\u53f2\u76f8\u4f3c\u5ba1\u6838\u4efb\u52a1\u4f9b\u5ba1\u6838\u4eba\u5458\u53c2\u8003\u3002", "TaskDataUploadHelper_1", "ssc-task-formplugin").loadKDString());
        TaskDataUploadHelper.addInfluentityRow(modelJson, taskAlgriMode);
    }

    private static String taskDataToJsonStr(DynamicObject[] data, int beginIndex, int endIndex) {
        JSONObject dataJson = new JSONObject();
        JSONArray bodyArray = new JSONArray();
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        for (int i = beginIndex; i < endIndex; ++i) {
            DynamicObject dyo = data[i];
            JSONObject jsonObject = new JSONObject();
            for (String field : PROP_SET) {
                jsonObject.put(field, dyo.get(field));
            }
            jsonObject.put("fid", dyo.get("taskid"));
            String createTime = null;
            String createTimeOrg = null;
            String createTimeUser = null;
            if (dyo.getDate("fcreatetime") != null) {
                createTime = dateFormat.format(dyo.getDate("fcreatetime"));
            }
            if (dyo.getDate("fcreatetime_org") != null) {
                createTimeOrg = dateFormat.format(dyo.getDate("fcreatetime_org"));
            }
            if (dyo.getDate("fcreatetime_user") != null) {
                createTimeUser = dateFormat.format(dyo.getDate("fcreatetime_user"));
            }
            jsonObject.put("fmoney", (Object)Float.valueOf(dyo.get("fmoney").toString()));
            jsonObject.put("fcreditvalue", (Object)Float.valueOf(dyo.get("fcreditvalue").toString()));
            jsonObject.put("fcreatetime", (Object)createTime);
            jsonObject.put("fcreatetime_org", (Object)createTimeOrg);
            jsonObject.put("fcreatetime_user", (Object)createTimeUser);
            String withdrawStr = dyo.getString("withdrawal");
            String breakruleStr = dyo.getString("breakrule");
            List withdraw = JSONObject.parseArray((String)withdrawStr, String.class);
            List breakrule = JSONObject.parseArray((String)breakruleStr, String.class);
            jsonObject.put("fwithdrawal", (Object)withdraw);
            jsonObject.put("fbreakrule", (Object)breakrule);
            String operation = dyo.getString("operation");
            if (StringUtils.isNotBlank((CharSequence)operation)) {
                List<String> operations = Collections.singletonList(operation);
                jsonObject.put("foperation", operations);
            } else {
                jsonObject.put("foperation", Collections.emptyList());
            }
            bodyArray.add((Object)jsonObject);
        }
        dataJson.put("data", (Object)bodyArray);
        return dataJson.toJSONString();
    }

    public static String executePostWithHeader(String url, String body) throws Exception {
        HashMap<String, String> headerMap = new HashMap<String, String>(8);
        headerMap.put("traceId", RequestContext.get().getTraceId());
        headerMap.put("accountId", RequestContext.get().getAccountId());
        headerMap.put("tenantId", RequestContext.get().getTenantId());
        headerMap.put("Content-Type", "application/json;charset=utf8");
        return HttpClientUtil.executePost(url, body, headerMap);
    }

    public static String getSettingInfo(String key) {
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"task_paramcontrol", (String)"paramvalue", (QFilter[])new QFilter[]{new QFilter("paramname", "=", (Object)key)});
        if (dynamicObject == null) {
            return null;
        }
        return dynamicObject.getString("paramvalue");
    }

    public static String getUrlSetting() {
        String url;
        Object params = SSCBosUtil.getSscSettingInfo("smartapprovalurl", false);
        String string = url = params != null ? params.toString() : null;
        if (StringUtils.isEmpty((CharSequence)url)) {
            log.error("\u667a\u80fd\u5ba1\u6838\uff1a\u83b7\u53d6\u5ba1\u6838\u7edf\u4e00\u63a5\u53e3\u4e3a\u7a7a");
            return null;
        }
        return url;
    }

    private static void addInfluentityRow(JSONObject modelJson, DynamicObject taskAlgriMode) {
        DynamicObjectCollection influentity = taskAlgriMode.getDynamicObjectCollection("influentity");
        JSONObject featureJson = modelJson.getJSONObject("feature_importance");
        for (Map.Entry entry : featureJson.entrySet()) {
            DynamicObject influEntityRow = influentity.addNew();
            influEntityRow.set("influencefactor", (Object)entry.getKey().toString());
            influEntityRow.set("factorinflurate", entry.getValue());
        }
    }

    private static int getBatchCount() {
        String value = TaskDataUploadHelper.getSettingInfo("uploadBatchCount");
        int batchCount = 1000;
        if (StringUtils.isBlank((CharSequence)value)) {
            return batchCount;
        }
        try {
            batchCount = Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return batchCount;
    }
}

