/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.smartcs.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.cache.SscDistributeCache;
import kd.ssc.smartcs.enums.ExcpStateEnum;
import kd.ssc.smartcs.factory.AbstractAIMetaFactory;
import kd.ssc.smartcs.factory.AreaFactory;
import kd.ssc.smartcs.factory.LeadingWordsFactory;
import kd.ssc.smartcs.factory.QuestionFactory;
import kd.ssc.smartcs.factory.RobotFactory;
import kd.ssc.smartcs.factory.SkillFactory;
import kd.ssc.smartcs.factory.SubjectFactory;
import kd.ssc.smartcs.parameter.AbstractAIMetaParameter;
import kd.ssc.smartcs.parameter.AreaParameter;
import kd.ssc.smartcs.parameter.LeadingWordsParameter;
import kd.ssc.smartcs.parameter.QuestionParameter;
import kd.ssc.smartcs.parameter.SkillParamter;
import kd.ssc.smartcs.parameter.SubjectParameter;
import kd.ssc.smartcs.product.AbstractAIMetaProduct;
import kd.ssc.smartcs.product.LeadingWordsProduct;
import kd.ssc.smartcs.product.SkillProduct;
import kd.ssc.smartcs.result.AbstractAIMetaResult;
import kd.ssc.smartcs.result.AreaResult;
import kd.ssc.smartcs.result.QuestionResult;
import kd.ssc.smartcs.result.RobotResult;
import kd.ssc.smartcs.result.SkillResult;
import kd.ssc.smartcs.result.SubjectResult;

public class AIMetaDataSynchrnizedUtil {
    private static final Log log = LogFactory.getLog(AIMetaDataSynchrnizedUtil.class);

    public static AreaResult addArea(String name, String number, String description, Map<Long, String> useSsc, Map<String, String> useRole) throws KDException {
        Long skillId = AIMetaDataSynchrnizedUtil.getSkillId();
        if (skillId == null || skillId <= 0L) {
            ErrorCode code = new ErrorCode(ExcpStateEnum.CallTPAPIErr.getValue(), ResManager.loadKDString((String)"\u65b0\u589e\u77e5\u8bc6\u9886\u57df\uff0c\u83b7\u53d6FAQ\u6280\u80fd\u5931\u8d25\u3002", (String)"AIMetaDataSynchrnizedUtil_2", (String)"ssc-task-common", (Object[])new Object[0]));
            throw new KDException(code, new Object[0]);
        }
        AreaFactory factory = new AreaFactory();
        AreaParameter input = AIMetaDataSynchrnizedUtil.constructAddAreaInput(skillId, name, number, description, useSsc, useRole);
        AbstractAIMetaProduct product = ((AbstractAIMetaFactory)factory).makeMeta(input);
        product.add();
        AreaResult result = (AreaResult)product.getResult();
        if (!result.isCallSuccess()) {
            ErrorCode code = new ErrorCode(ExcpStateEnum.CallTPAPIErr.getValue(), result.getMessage());
            throw new KDException(code, new Object[0]);
        }
        return result;
    }

    public static void updateArea(Long id, String name, String number, String description, Map<Long, String> useSsc, Map<String, String> useRole) throws KDException {
        Long skillId = AIMetaDataSynchrnizedUtil.getSkillId();
        if (skillId == null || skillId <= 0L) {
            ErrorCode code = new ErrorCode(ExcpStateEnum.CallTPAPIErr.getValue(), ResManager.loadKDString((String)"\u4fee\u6539\u77e5\u8bc6\u9886\u57df\uff0c\u83b7\u53d6FAQ\u6280\u80fd\u5931\u8d25\u3002", (String)"AIMetaDataSynchrnizedUtil_0", (String)"ssc-task-common", (Object[])new Object[0]));
            throw new KDException(code, new Object[0]);
        }
        AreaFactory factory = new AreaFactory();
        AreaParameter input = AIMetaDataSynchrnizedUtil.constructUpdateAreaInput(id, skillId, name, number, description, useSsc, useRole);
        AIMetaDataSynchrnizedUtil.updateItem(factory, input);
    }

    public static void deleteAreaForBatching(List<Long> ids) throws KDException {
        Long skillId = AIMetaDataSynchrnizedUtil.getSkillId();
        if (skillId == null || skillId <= 0L) {
            ErrorCode code = new ErrorCode(ExcpStateEnum.CallTPAPIErr.getValue(), ResManager.loadKDString((String)"\u5220\u9664\u77e5\u8bc6\u9886\u57df\uff0c\u83b7\u53d6FAQ\u6280\u80fd\u5931\u8d25\u3002", (String)"AIMetaDataSynchrnizedUtil_1", (String)"ssc-task-common", (Object[])new Object[0]));
            throw new KDException(code, new Object[0]);
        }
        AreaFactory factory = new AreaFactory();
        AreaParameter input = AIMetaDataSynchrnizedUtil.constructDeleteAreaInput(skillId, ids);
        AIMetaDataSynchrnizedUtil.deleteItem(factory, input);
    }

    public static SubjectResult addSubject(Long areaId, String name, String number) throws KDException {
        SubjectFactory factory = new SubjectFactory();
        SubjectParameter input = AIMetaDataSynchrnizedUtil.constructAddSubjectInput(areaId, name, number);
        AbstractAIMetaProduct product = ((AbstractAIMetaFactory)factory).makeMeta(input);
        product.add();
        SubjectResult result = (SubjectResult)product.getResult();
        if (!result.isCallSuccess()) {
            ErrorCode code = new ErrorCode(ExcpStateEnum.CallTPAPIErr.getValue(), result.getMessage());
            throw new KDException(code, new Object[0]);
        }
        return result;
    }

    public static void updateSubject(Long id, Long areaId, String name, String number) throws KDException {
        SubjectFactory factory = new SubjectFactory();
        SubjectParameter input = AIMetaDataSynchrnizedUtil.constructUpdateSubjectInput(id, areaId, name, number);
        AIMetaDataSynchrnizedUtil.updateItem(factory, input);
    }

    public static void deleteSubjectForBatching(Long areaId, List<Long> ids) throws KDException {
        SubjectFactory factory = new SubjectFactory();
        SubjectParameter input = AIMetaDataSynchrnizedUtil.constructDeleteSubjectInput(areaId, ids);
        AIMetaDataSynchrnizedUtil.deleteItem(factory, input);
    }

    public static QuestionResult addQuestion(Long areaId, Long subjectId, Long qaId, String keyword, String answer, List<String> questions, boolean enableLinkCard, String linkTitle, String linkAdress, Map<Long, List<String>> attachments) throws KDException {
        QuestionFactory factory = new QuestionFactory();
        QuestionParameter input = AIMetaDataSynchrnizedUtil.constructAddQuestionInput(areaId, subjectId, qaId, keyword, answer, questions, enableLinkCard, linkTitle, linkAdress, attachments);
        AbstractAIMetaProduct product = ((AbstractAIMetaFactory)factory).makeMeta(input);
        product.add();
        QuestionResult result = (QuestionResult)product.getResult();
        if (!result.isCallSuccess()) {
            ErrorCode code = new ErrorCode(ExcpStateEnum.CallTPAPIErr.getValue(), result.getMessage());
            throw new KDException(code, new Object[0]);
        }
        return result;
    }

    public static QuestionResult updateQuestion(Long id, Long areaId, Long subjectId, Long qaId, String keyword, String answer, List<String> questions, boolean enableLinkCard, String linkTitle, String linkAdress, Map<Long, List<String>> attachments) throws KDException {
        ArrayList<Long> ids = new ArrayList<Long>(1);
        ids.add(id);
        AIMetaDataSynchrnizedUtil.deleteQuestionForBatching(areaId, subjectId, ids);
        return AIMetaDataSynchrnizedUtil.addQuestion(areaId, subjectId, qaId, keyword, answer, questions, enableLinkCard, linkTitle, linkAdress, attachments);
    }

    public static void deleteQuestionForBatching(Long areaId, Long subjectId, List<Long> ids) throws KDException {
        QuestionFactory factory = new QuestionFactory();
        QuestionParameter input = AIMetaDataSynchrnizedUtil.constructDeleteQuestionInput(areaId, subjectId, ids);
        AIMetaDataSynchrnizedUtil.deleteItem(factory, input);
    }

    public static void saveAllLeadingWords(List<String> leadingWords) throws KDException {
        Long skillId = AIMetaDataSynchrnizedUtil.getSkillId();
        if (skillId == null || skillId <= 0L) {
            ErrorCode code = new ErrorCode(ExcpStateEnum.CallTPAPIErr.getValue(), ResManager.loadKDString((String)"\u4fdd\u5b58\u6280\u80fd\u5f15\u5bfc\u8bed\uff0c\u83b7\u53d6FAQ\u6280\u80fd\u5931\u8d25\u3002", (String)"AIMetaDataSynchrnizedUtil_3", (String)"ssc-task-common", (Object[])new Object[0]));
            throw new KDException(code, new Object[0]);
        }
        LeadingWordsFactory factory = new LeadingWordsFactory();
        List<Long> leadIds = AIMetaDataSynchrnizedUtil.getAllLeadingWords(factory, skillId);
        AIMetaDataSynchrnizedUtil.deleteAllLeadingWords(factory, skillId, leadIds);
        AIMetaDataSynchrnizedUtil.synAllLeadingWords(factory, skillId, leadingWords);
    }

    private static void synAllLeadingWords(AbstractAIMetaFactory factory, Long skillId, List<String> leadingWords) {
        for (String guide : leadingWords) {
            LeadingWordsParameter input = new LeadingWordsParameter();
            input.setSkillId(skillId);
            input.setName(guide);
            AbstractAIMetaProduct product = factory.makeMeta(input);
            product.add();
        }
    }

    private static void deleteAllLeadingWords(AbstractAIMetaFactory factory, Long skillId, List<Long> leadIds) throws KDException {
        LeadingWordsParameter input = new LeadingWordsParameter();
        input.setSkillId(skillId);
        input.setDeleteIds(leadIds);
        LeadingWordsProduct product = (LeadingWordsProduct)factory.makeMeta(input);
        product.bdelete();
    }

    private static List<Long> getAllLeadingWords(AbstractAIMetaFactory factory, Long skillId) throws KDException {
        LeadingWordsParameter input = new LeadingWordsParameter();
        input.setSkillId(skillId);
        LeadingWordsProduct product = (LeadingWordsProduct)factory.makeMeta(input);
        List<Long> leadingWords = product.getAllLeadingWords();
        AbstractAIMetaResult result = product.getResult();
        if (!result.isCallSuccess()) {
            ErrorCode code = new ErrorCode(ExcpStateEnum.CallTPAPIErr.getValue(), result.getMessage());
            throw new KDException(code, new Object[0]);
        }
        return leadingWords;
    }

    private static Long getSkillId() {
        Long skillId;
        String accountId;
        QFilter a;
        String tenantId = RequestContext.get().getTenantId();
        QFilter t = new QFilter("qxtenantid", "=", (Object)tenantId);
        DynamicObject dyo = QueryServiceHelper.queryOne((String)"som_knowledge_global", (String)"skillid", (QFilter[])new QFilter[]{t, a = new QFilter("accountid", "=", (Object)(accountId = RequestContext.get().getAccountId()))});
        if (dyo != null && (skillId = Long.valueOf(dyo.getLong("skillid"))) != 0L) {
            return skillId;
        }
        log.info("\u65b0\u589e\u6280\u80fd, \u82cd\u7a79\u79df\u6237Id: " + tenantId);
        return AIMetaDataSynchrnizedUtil.addSkill();
    }

    private static Long addSkill() throws KDException {
        SkillFactory factory = new SkillFactory();
        SkillParamter skillInput = new SkillParamter(AIMetaDataSynchrnizedUtil.getAiTenantId());
        SkillProduct product = (SkillProduct)((AbstractAIMetaFactory)factory).makeMeta(skillInput);
        product.add();
        SkillResult result = (SkillResult)product.getResult();
        if (!result.isCallSuccess()) {
            ErrorCode code = new ErrorCode(ExcpStateEnum.CallTPAPIErr.getValue(), result.getMessage());
            throw new KDException(code, new Object[0]);
        }
        Long skillId = result.getId();
        AIMetaDataSynchrnizedUtil.associateSkill2Robot(product, skillId);
        AIMetaDataSynchrnizedUtil.saveSkillId(skillId);
        AIMetaDataSynchrnizedUtil.putSkillId2Cache(skillId);
        return skillId;
    }

    private static Long getAiTenantId() {
        String tenantId = RequestContext.get().getTenantId();
        String key = AIMetaDataSynchrnizedUtil.getTenantKey(tenantId);
        Long aiTenantId = SscDistributeCache.get(key, Long.class);
        if (aiTenantId != null) {
            return aiTenantId;
        }
        QFilter qFilter = new QFilter("qxtenantid", "=", (Object)tenantId);
        QFilter a = new QFilter("accountid", "=", (Object)RequestContext.get().getAccountId());
        DynamicObject[] dyos = BusinessDataServiceHelper.load((String)"som_knowledge_global", (String)"tenantid", (QFilter[])new QFilter[]{qFilter, a});
        if (dyos != null && dyos.length > 0 && (aiTenantId = Long.valueOf(dyos[0].getLong("tenantid"))) != 0L) {
            AIMetaDataSynchrnizedUtil.putTenantId2Cache(aiTenantId);
            return aiTenantId;
        }
        return AIMetaDataSynchrnizedUtil.iniRobot();
    }

    private static Long iniRobot() {
        RobotFactory factory = new RobotFactory();
        AbstractAIMetaProduct product = ((AbstractAIMetaFactory)factory).makeMeta();
        product.add();
        RobotResult result = (RobotResult)product.getResult();
        if (!result.isCallSuccess()) {
            ErrorCode code = new ErrorCode(ExcpStateEnum.CallTPAPIErr.getValue(), String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u673a\u5668\u4eba\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0\uff1a%s\u3002", (String)"AIMetaDataSynchrnizedUtil_5", (String)"ssc-task-common", (Object[])new Object[0]), result.getMessage()));
            throw new KDException(code, new Object[0]);
        }
        Long robotId = result.getId();
        Long tenantId = result.getTenantId();
        AIMetaDataSynchrnizedUtil.saveRobotIdAndTenantId(robotId, tenantId);
        AIMetaDataSynchrnizedUtil.putRobotId2Cache(robotId);
        AIMetaDataSynchrnizedUtil.putTenantId2Cache(tenantId);
        return tenantId;
    }

    private static void saveRobotIdAndTenantId(Long robotId, Long aiTenantId) {
        DynamicObject saveDyo = AIMetaDataSynchrnizedUtil.getSaveDyo(String.join((CharSequence)",", "qxtenantid", "robotid", "tenantid", "accountid"));
        saveDyo.set("robotid", (Object)robotId);
        saveDyo.set("tenantid", (Object)aiTenantId);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{saveDyo});
    }

    private static void saveSkillId(Long skillId) {
        DynamicObject saveDyo = AIMetaDataSynchrnizedUtil.getSaveDyo(String.join((CharSequence)",", "qxtenantid", "skillid", "accountid"));
        saveDyo.set("skillid", (Object)skillId);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{saveDyo});
    }

    private static DynamicObject getSaveDyo(String selectProperties) {
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        QFilter qFilter = new QFilter("qxtenantid", "=", (Object)tenantId);
        QFilter a = new QFilter("accountid", "=", (Object)accountId);
        DynamicObject[] dyos = BusinessDataServiceHelper.load((String)"som_knowledge_global", (String)selectProperties, (QFilter[])new QFilter[]{qFilter, a});
        DynamicObject saveDyo = dyos == null || dyos.length == 0 ? BusinessDataServiceHelper.newDynamicObject((String)"som_knowledge_global") : dyos[0];
        saveDyo.set("qxtenantid", (Object)tenantId);
        saveDyo.set("accountid", (Object)accountId);
        return saveDyo;
    }

    private static void putRobotId2Cache(Long robotId) {
        String tenantId = RequestContext.get().getTenantId();
        SscDistributeCache.put(AIMetaDataSynchrnizedUtil.getRobotKey(tenantId), robotId);
    }

    private static void putTenantId2Cache(Long aiTenantId) {
        String tenantId = RequestContext.get().getTenantId();
        SscDistributeCache.put(AIMetaDataSynchrnizedUtil.getTenantKey(tenantId), aiTenantId);
    }

    private static void putSkillId2Cache(Long skillId) {
        String tenantId = RequestContext.get().getTenantId();
        SscDistributeCache.put(AIMetaDataSynchrnizedUtil.getSkillKey(tenantId), skillId);
    }

    private static String getTenantKey(String tenantId) {
        return tenantId + "tenantId";
    }

    private static String getRobotKey(String tenantId) {
        return tenantId + "robotId";
    }

    private static String getSkillKey(String tenantId) {
        return tenantId + "skillId";
    }

    private static void associateSkill2Robot(SkillProduct product, Long skillId) throws KDException {
        ArrayList<Long> skillIds = new ArrayList<Long>(1);
        skillIds.add(skillId);
        boolean success = product.associate2Robot(skillIds);
        if (!success) {
            AbstractAIMetaResult result = product.getResult();
            ErrorCode code = new ErrorCode(ExcpStateEnum.CallTPAPIErr.getValue(), result.getMessage());
            throw new KDException(code, new Object[0]);
        }
    }

    private static AreaParameter constructAddAreaInput(Long skillId, String name, String number, String description, Map<Long, String> useSsc, Map<String, String> useRole) {
        AreaParameter input = new AreaParameter();
        input.setSkillId(skillId);
        input.setName(name);
        input.setNumber(number);
        input.setDescription(description);
        input.setUseScc(useSsc);
        input.setUseRole(useRole);
        return input;
    }

    private static AreaParameter constructUpdateAreaInput(Long id, Long skillId, String name, String number, String description, Map<Long, String> useSsc, Map<String, String> useRole) {
        AreaParameter input = AIMetaDataSynchrnizedUtil.constructAddAreaInput(skillId, name, number, description, useSsc, useRole);
        input.setId(id);
        return input;
    }

    private static AreaParameter constructDeleteAreaInput(Long skillId, List<Long> ids) {
        AreaParameter input = new AreaParameter();
        input.setSkillId(skillId);
        input.setDeleteIds(ids);
        return input;
    }

    private static SubjectParameter constructAddSubjectInput(Long areaId, String name, String number) {
        SubjectParameter input = new SubjectParameter();
        input.setAreaId(areaId);
        input.setName(name);
        input.setNumber(number);
        return input;
    }

    private static SubjectParameter constructUpdateSubjectInput(Long id, Long areaId, String name, String number) {
        SubjectParameter input = AIMetaDataSynchrnizedUtil.constructAddSubjectInput(areaId, name, number);
        input.setId(id);
        return input;
    }

    private static SubjectParameter constructDeleteSubjectInput(Long areaId, List<Long> ids) {
        SubjectParameter input = new SubjectParameter();
        input.setAreaId(areaId);
        input.setDeleteIds(ids);
        return input;
    }

    private static QuestionParameter constructAddQuestionInput(Long areaId, Long subjectId, Long qaId, String keyword, String answer, List<String> questions, boolean enableLinkCard, String linkTitle, String linkAdress, Map<Long, List<String>> attachments) {
        QuestionParameter input = new QuestionParameter();
        input.setAreaId(areaId);
        input.setSubjectId(subjectId);
        input.setQaId(qaId);
        input.setKeyword(keyword);
        input.setAnswer(answer);
        input.setQuestions(questions);
        input.setEnableLinkCard(enableLinkCard);
        input.setLinkName(linkTitle);
        input.setLinkAddress(linkAdress);
        input.setAttachments(attachments);
        return input;
    }

    private static QuestionParameter constructDeleteQuestionInput(Long areaId, Long subjectId, List<Long> ids) {
        QuestionParameter input = new QuestionParameter();
        input.setAreaId(areaId);
        input.setSubjectId(subjectId);
        input.setDeleteIds(ids);
        return input;
    }

    private static void deleteItem(AbstractAIMetaFactory factory, AbstractAIMetaParameter input) {
        AbstractAIMetaProduct product = factory.makeMeta(input);
        product.bdelete();
        AbstractAIMetaResult result = product.getResult();
        if (!result.isCallSuccess()) {
            ErrorCode code = new ErrorCode(ExcpStateEnum.CallTPAPIErr.getValue(), result.getMessage());
            throw new KDException(code, new Object[0]);
        }
    }

    private static void updateItem(AbstractAIMetaFactory factory, AbstractAIMetaParameter input) {
        AbstractAIMetaProduct product = factory.makeMeta(input);
        product.update();
        AbstractAIMetaResult result = product.getResult();
        if (!result.isCallSuccess()) {
            ErrorCode code = new ErrorCode(ExcpStateEnum.CallTPAPIErr.getValue(), result.getMessage());
            throw new KDException(code, new Object[0]);
        }
    }
}

