/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.create;

import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.ssc.exception.ExceptionUtil;

public class CreateTaskQueue
implements MessageConsumer {
    private static final Log log = LogFactory.getLog(CreateTaskQueue.class);
    private static final int rpTimes = 5;

    public void onMessage(Object message, String messageId, boolean resend, MessageAcker messageAcker) {
        log.error("\u5f71\u50cf\u540c\u6b65eas\uff0cmq\u4f20\u5165\u53c2\u6570: " + message + ", " + messageId + ", " + resend);
        if (message == null || StringUtils.isEmpty((String)message.toString())) {
            log.error("message \u4e3anull,\u4e0d\u7528\u8bc6\u522b");
            messageAcker.ack(messageId);
            return;
        }
        Map task = (Map)message;
        for (int i = 0; i < 5; ++i) {
            try {
                DispatchServiceHelper.invokeBizService((String)"ssc", (String)"task", (String)"ITaskService", (String)"execute", (Object[])new Object[]{task.get("billTypeKey"), task.get("operationKey"), null, task.get("successPkIds")});
                messageAcker.ack(messageId);
                return;
            }
            catch (Exception e) {
                if (i < 4) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e1) {
                        log.error("\u7ebf\u7a0bsleep\u4e2d\u65ad\u5f02\u5e38", (Throwable)e1);
                    }
                    continue;
                }
                List list = (List)task.get("successPkIds");
                list.forEach(result -> {
                    long billid = (Long)result;
                    this.saveErrorMQ(message, e, this.getBillNumber((String)task.get("billTypeKey"), (Long)result));
                });
                continue;
            }
        }
        messageAcker.ack(messageId);
        log.info("\u5df2\u8bf7\u6c425\u6b21\uff0c\u8bf7\u6c42\u5b8c\u6bd5");
    }

    public void saveErrorMQ(Object message, Exception e, String billnumber) {
        QFilter mqParamFilter = new QFilter("mqexceptionmsg", "=", (Object)this.getExcetionMsg(e, billnumber));
        if (!QueryServiceHelper.exists((String)"task_mq_faile", (QFilter[])new QFilter[]{mqParamFilter})) {
            DynamicObject mqErrDyObj = BusinessDataServiceHelper.newDynamicObject((String)"task_mq_faile");
            mqErrDyObj.set("mqregion", (Object)"bos");
            mqErrDyObj.set("mqqueue", (Object)"kd.bos.imageplatform.service.image");
            mqErrDyObj.set("mqexceptionmsg", (Object)this.getExcetionMsg(e, billnumber));
            mqErrDyObj.set("mqexceptionstack_tag", (Object)ExceptionUtil.getStackTrace(e));
            mqErrDyObj.set("mqexceptionhptime", (Object)new Date());
            mqErrDyObj.set("mqparam_tag", (Object)SerializationUtils.toJsonString((Object)message));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mqErrDyObj});
        }
    }

    public String getExcetionMsg(Throwable throwable, String billnumber) {
        String exceptionMsg = throwable.getMessage();
        return String.format(ResManager.loadKDString((String)"%1$s\u5355\u636e\u7f16\u7801\uff1a%2$s", (String)"CreateTaskQueue_0", (String)"ssc-task-common", (Object[])new Object[0]), exceptionMsg, billnumber);
    }

    public String getBillNumber(String billtype, long billid) {
        String numberProp;
        DynamicObject billData = BusinessDataServiceHelper.loadSingle((Object)billid, (String)billtype);
        if (billData == null) {
            return null;
        }
        String billNumber = "";
        DynamicObjectType type = billData.getDynamicObjectType();
        if (type instanceof BillEntityType && (billNumber = billData.getString(numberProp = ((BillEntityType)type).getBillNo())) != null) {
            return billNumber;
        }
        billNumber = this.getBillNumberByDf(billData, billNumber);
        return billNumber;
    }

    public String getBillNumberByDf(DynamicObject billData, String billNumber) {
        if (billData != null) {
            try {
                billNumber = billData.getString("number");
            }
            catch (Exception e) {
                throw new KDException((Throwable)e, new ErrorCode("fi.ssc.createTaskQueue.getBillNumberException", e.getMessage()), new Object[0]);
            }
            if ("".equals(billNumber)) {
                try {
                    billNumber = billData.getString("billno");
                }
                catch (Exception e) {
                    throw new KDException((Throwable)e, new ErrorCode("fi.ssc.createTaskQueue.getBillNoException", e.getMessage()), new Object[0]);
                }
            }
        }
        return billNumber;
    }
}

