/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.partask;

import java.util.ArrayList;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.util.StringUtils;
import kd.ssc.task.partask.ParTaskMessage;
import kd.ssc.task.partask.service.impl.ParTaskNodeServiceImpl;
import kd.ssc.task.partask.util.CreateNewPartask;

public class ParTaskConsumer
implements MessageConsumer {
    private static final Log log = LogFactory.getLog(ParTaskConsumer.class);
    private static final int RP_TIMES = 5;
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("parTask-consumer");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Object message, String messageId, boolean isResend, MessageAcker messageAcker) throws KDException {
        log.info("\u6210\u529f\u8fdb\u5165\u5e76\u884c\u4efb\u52a1\u6d88\u8d39\u8005\u5b9e\u73b0\u7c7b:" + this.getClass().getName() + "\uff0cmq\u4f20\u5165\u53c2\u6570: " + message + ", " + messageId + ", is resend: " + isResend);
        if (message == null || StringUtils.isEmpty((String)message.toString())) {
            log.error("\u6d88\u606f\u961f\u5217\u4e2d message \u4e3a\u7a7a\uff08\u6216\u4e3anull\uff09,\u4e0d\u7528\u6d88\u8d39");
            messageAcker.ack(messageId);
            return;
        }
        if (!(message instanceof ParTaskMessage)) {
            log.error("\u6d88\u606f\u961f\u5217\u4e2d message \u7c7b\u578b\u4e0d\u5339\u914d " + ParTaskMessage.class.getName());
            messageAcker.ack(messageId);
            return;
        }
        ParTaskMessage parTaskMessage = (ParTaskMessage)message;
        String key = parTaskMessage.getBillId() + "-" + parTaskMessage.getNextNodeTypeId() + "-" + parTaskMessage.getInstanceId();
        Object res = cache.eval("if redis.call('SETNX',KEYS[1],'1') == 0 then return 0 else return redis.call('EXPIRE',KEYS[1],60) end", key, new ArrayList());
        if (!"1".equals(res.toString())) {
            log.error("\u5e76\u884c\u4efb\u52a1\u91cd\u590d\u6d88\u8d39\uff0ckey = " + key);
            messageAcker.ack(messageId);
            return;
        }
        try {
            long taskId = 0L;
            taskId = CreateNewPartask.createNewTask(parTaskMessage);
            log.info("\u521b\u5efa\u5e76\u884c\u4efb\u52a1end\uff0c\u4efb\u52a1id:" + taskId);
            if (taskId == 0L) {
                log.error("\u5e76\u884c\u4efb\u52a1\u521b\u5efa\u5931\u8d25,[\u5b9e\u4f8bid:\u8282\u70b9id]:[" + parTaskMessage.getInstanceId() + ":" + parTaskMessage.getNextNodeDefId() + "]");
                new ParTaskNodeServiceImpl().updateTableAfterCreateParTaskFailed(parTaskMessage.getInstanceId(), parTaskMessage.getNextNodeDefId());
            }
        }
        catch (KDException e) {
            String errCode = e.getErrorCode().getCode();
            if (!"-2".equals(errCode)) {
                log.error("[\u5b9e\u4f8bid:\u8282\u70b9id]:[" + parTaskMessage.getInstanceId() + ":" + parTaskMessage.getNextNodeDefId() + "]\u7684\u5e76\u884c\u4efb\u52a1\u521b\u5efa\u8fc7\u7a0b\u4e2d\u4ea7\u751f\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
                new ParTaskNodeServiceImpl().updateTableAfterCreateParTaskFailed(parTaskMessage.getInstanceId(), parTaskMessage.getNextNodeDefId());
                throw e;
            }
        }
        finally {
            messageAcker.ack(messageId);
            log.info("\u5b8c\u6210\u5e76\u884c\u4efb\u52a1\u6d88\u8d39");
        }
    }
}

