/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.partask.service.impl;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ssc.task.partask.enums.FlowInstEnum;
import kd.ssc.task.partask.service.ParTaskFlowInstService;

public class ParTaskFlowInstServiceImpl
implements ParTaskFlowInstService {
    private static final Log log = LogFactory.getLog(ParTaskFlowInstServiceImpl.class);

    @Override
    public void updateInstStatus(long instId, FlowInstEnum flowInstEnum) {
        DynamicObject flowInst = BusinessDataServiceHelper.loadSingle((Object)instId, (String)"task_partaskinst", (String)"ptstatus, ptendtime");
        flowInst.set("ptstatus", (Object)flowInstEnum.getValue());
        if (flowInstEnum != FlowInstEnum.PROCESSING) {
            flowInst.set("ptendtime", (Object)new Date());
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{flowInst});
    }

    @Override
    public Long CreateParTaskIns(Long sscid, Long billtype, String billId, Long flowCode, Long workFlowId) {
        return this.saveIns(sscid, billtype, billId, flowCode, workFlowId);
    }

    @Override
    public Long findParTaskIns(String sscid, Long billtype, String billId) {
        QFilter[] qFilters = new QFilter[]{new QFilter("sscid", "=", (Object)sscid), new QFilter("billtype", "=", (Object)billtype), new QFilter("billid", "=", (Object)billId)};
        List results = QueryServiceHelper.queryPrimaryKeys((String)"task_partaskinst", (QFilter[])qFilters, null, (int)1);
        if (results.isEmpty()) {
            return -1L;
        }
        return (Long)results.get(0);
    }

    @Override
    public boolean isParTaskInsFiled(Long insId) {
        int status = BusinessDataServiceHelper.loadSingle((Object)insId, (String)"task_partaskinst").getInt("ptstatus");
        return FlowInstEnum.FAILED.getValue() == status || FlowInstEnum.REPULSE.getValue() == status;
    }

    @Override
    public Long getFlowIdWithInsId(Long insId) throws KDException {
        if (!QueryServiceHelper.exists((String)"task_partaskinst", (Object)insId)) {
            throw new KDException(ResManager.loadKDString((String)"\u591a\u7ea7\u4efb\u52a1\u5b9e\u4f8b\u4e0d\u5b58\u5728\u3002", (String)"ParTaskFlowInstServiceImpl_0", (String)"ssc-task-common", (Object[])new Object[0]));
        }
        DynamicObject instDo = BusinessDataServiceHelper.loadSingle((Object)insId, (String)"task_partaskinst", (String)"id,flowcode.id");
        return instDo.getLong("flowcode.id");
    }

    private Long saveIns(Long sscid, Long billtype, String billId, Long flowCode, Long workflowId) {
        Object[] result = null;
        try {
            DynamicObject saveIns = BusinessDataServiceHelper.newDynamicObject((String)"task_partaskinst");
            saveIns.set("sscid", (Object)sscid);
            saveIns.set("billtype", (Object)billtype);
            saveIns.set("billid", (Object)billId);
            saveIns.set("flowcode", (Object)flowCode);
            saveIns.set("workflowid", (Object)workflowId);
            String billTypeName = BusinessDataServiceHelper.loadSingle((Object)billtype, (String)"task_taskbill").getString("bindbill.name");
            if (billTypeName == null) {
                billTypeName = "";
            }
            saveIns.set("subject", (Object)(billTypeName + "-" + billId + "SSC" + flowCode));
            saveIns.set("ptstarttime", (Object)new Date());
            saveIns.set("ptstatus", (Object)FlowInstEnum.PROCESSING.getValue());
            result = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{saveIns});
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u5e76\u884c\u4efb\u52a1\u5b9e\u4f8b\u5e76\u5199\u5e93\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            return -1L;
        }
        return (Long)((DynamicObject)result[0]).getPkValue();
    }
}

