/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.partask.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.ssc.cache.SscDistributeCache;
import kd.ssc.task.partask.meta.ParTaskFlowNodeMeta;
import kd.ssc.task.partask.service.ParTaskFlowService;

public class ParTaskFlowServiceImpl
implements ParTaskFlowService {
    private Map<String, ParTaskFlowNodeMeta> defMap;
    private static final String SOURCETYPEID = "ptsourcetype.id";
    private static final String SOURCETYPENAME = "ptsourcetype.name.zh_CN";
    private static final String SOURCENODE = "ptsourcenode";
    private static final String TARGETTYPEID = "pttargettype.id";
    private static final String TARGETTYPENAME = "pttargettype.name.zh_CN";
    private static final String TARGETNODE = "pttargetnode";
    private static Log log = LogFactory.getLog(ParTaskFlowServiceImpl.class);

    @Override
    public Long findParTaskFlowDef(Long sscid, Long billtype) {
        List<Long> ids = this.findAllParTaskFlowDef(sscid, billtype);
        Long defId = -1L;
        if (!ids.isEmpty()) {
            defId = ids.get(0);
        }
        return defId;
    }

    @Override
    public List<Long> findAllParTaskFlowDef(Long sscid, Long billtype) {
        QFilter[] qFilters = new QFilter[]{new QFilter("sscid", "=", (Object)sscid), new QFilter("billtype", "=", (Object)billtype), new QFilter("ispublished", "=", (Object)1)};
        DynamicObjectCollection qryResults = QueryServiceHelper.query((String)"task_partaskflowdef", (String)"id", (QFilter[])qFilters, (String)"version desc");
        ArrayList<Long> results = new ArrayList<Long>(8);
        if (qryResults != null) {
            for (DynamicObject dyo : qryResults) {
                results.add(dyo.getLong("id"));
            }
        }
        return results;
    }

    @Override
    public List<String> getStartNode(Long defId) throws Exception {
        if (this.defMap == null) {
            this.loadDefMapFormDefId(defId);
        }
        return this.getStartNodeFromDefMap(this.defMap);
    }

    @Override
    public List<String> getEndNode(Long defId) throws Exception {
        if (this.defMap == null) {
            this.loadDefMapFormDefId(defId);
        }
        return this.getEndNodeFromDefMap(this.defMap);
    }

    @Override
    public List<String> getParentId(Long defId, String curNodeId) throws Exception {
        if (this.defMap == null) {
            this.loadDefMapFormDefId(defId);
        }
        return this.getParentFromDefMap(this.defMap, curNodeId);
    }

    @Override
    public List<String> getChildId(Long defId, String curNodeId) throws Exception {
        if (this.defMap == null) {
            this.loadDefMapFormDefId(defId);
        }
        return this.getChildFromDefMap(this.defMap, curNodeId);
    }

    @Override
    public Integer getParentNumber(Long defId, String curNodeId) throws Exception {
        if (this.defMap == null) {
            this.loadDefMapFormDefId(defId);
        }
        List<String> parents = this.getParentFromDefMap(this.defMap, curNodeId);
        return parents.size();
    }

    @Override
    public Integer getNodeNumber(Long defId) throws Exception {
        if (this.defMap == null) {
            this.loadDefMapFormDefId(defId);
        }
        return this.defMap.size();
    }

    @Override
    public Boolean isEndNode(Long defId, String curNodeId) throws Exception {
        return this.getChildId(defId, curNodeId).size() == 0;
    }

    @Override
    public Map<String, ParTaskFlowNodeMeta> getSimpleDefMap(DynamicObjectCollection entryCollection) {
        HashMap<String, ParTaskFlowNodeMeta> defMapMeta = new HashMap<String, ParTaskFlowNodeMeta>();
        for (DynamicObject entry : entryCollection) {
            String sourceNodeId = entry.getString(SOURCETYPENAME);
            String targetNodeId = entry.getString(TARGETTYPENAME);
            this.saveEntry2DefMap(defMapMeta, sourceNodeId, targetNodeId);
        }
        return defMapMeta;
    }

    @Override
    public List<String> getStartNodeFromDefMap(Map<String, ParTaskFlowNodeMeta> defMap) {
        ArrayList<String> startNodeList = new ArrayList<String>();
        for (Map.Entry<String, ParTaskFlowNodeMeta> entry : defMap.entrySet()) {
            ParTaskFlowNodeMeta value = entry.getValue();
            if (!value.getParentNodeIdList().isEmpty()) continue;
            startNodeList.add(value.getNodeId());
        }
        return startNodeList;
    }

    @Override
    public List<String> getEndNodeFromDefMap(Map<String, ParTaskFlowNodeMeta> defMap) {
        ArrayList<String> endNodeList = new ArrayList<String>();
        for (Map.Entry<String, ParTaskFlowNodeMeta> entry : defMap.entrySet()) {
            ParTaskFlowNodeMeta value = entry.getValue();
            if (!value.getChildNodeIdList().isEmpty()) continue;
            endNodeList.add(value.getNodeId());
        }
        return endNodeList;
    }

    @Override
    public List<String> getParentFromDefMap(Map<String, ParTaskFlowNodeMeta> defMap, String curNodeId) {
        ParTaskFlowNodeMeta value = defMap.get(curNodeId);
        return value.getParentNodeIdList();
    }

    @Override
    public List<String> getChildFromDefMap(Map<String, ParTaskFlowNodeMeta> defMap, String curNodeId) {
        ParTaskFlowNodeMeta value = defMap.get(curNodeId);
        return value.getChildNodeIdList();
    }

    @Override
    public Integer getParentNumberFromDefMap(Map<String, ParTaskFlowNodeMeta> defMap, String curNodeId) {
        List<String> parents = this.getParentFromDefMap(defMap, curNodeId);
        return parents.size();
    }

    @Override
    public Integer getNodeNumberFromDefMap(Map<String, ParTaskFlowNodeMeta> defMap) {
        return defMap.size();
    }

    @Override
    public Boolean isEndNodeFromDefMap(Map<String, ParTaskFlowNodeMeta> defMap, String curNodeId) {
        return this.getChildFromDefMap(defMap, curNodeId).size() == 0;
    }

    private void loadDefMapFormDefId(Long defId) throws Exception {
        String defIds = String.valueOf(defId);
        if (this.defMap != null && !this.defMap.isEmpty()) {
            log.info("defMapBeforeUpdate:" + Arrays.toString(this.defMap.keySet().toArray()));
        }
        if (SscDistributeCache.get(defIds) != null) {
            String mapJason = SscDistributeCache.get(defIds);
            Map map = (Map)SerializationUtils.fromJsonString((String)mapJason, Map.class);
            this.defMap = this.pareseFromMap(map);
        } else {
            this.defMap = this.getDefMap(defId);
            if (this.defMap != null) {
                SscDistributeCache.put(defIds, SerializationUtils.toJsonString(this.defMap));
            }
        }
        if (this.defMap != null && !this.defMap.isEmpty()) {
            log.info("defMapAfterUpdate:" + Arrays.toString(this.defMap.keySet().toArray()));
        }
    }

    private Map<String, ParTaskFlowNodeMeta> pareseFromMap(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        HashMap<String, ParTaskFlowNodeMeta> defMap = new HashMap<String, ParTaskFlowNodeMeta>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Map value = (Map)entry.getValue();
            if (!value.containsKey("nodeId") || !value.containsKey("parentNodeIdList") || !value.containsKey("childNodeIdList")) continue;
            ParTaskFlowNodeMeta meta = new ParTaskFlowNodeMeta((String)value.get("nodeId"), (List)value.get("parentNodeIdList"), (List)value.get("childNodeIdList"));
            defMap.put(entry.getKey(), meta);
        }
        return defMap;
    }

    private Map<String, ParTaskFlowNodeMeta> getDefMap(Long pkId) throws Exception {
        DynamicObjectCollection entrys = this.loadDefEntrys("task_partaskflowdef", pkId);
        return this.transformDefMapFromEntrys(entrys);
    }

    private DynamicObjectCollection loadDefEntrys(String entityName, Long pkId) throws Exception {
        DynamicObject dyo = null;
        try {
            dyo = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)entityName);
            return dyo.getDynamicObjectCollection("entryentity");
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new Exception(e);
        }
    }

    private Map<String, ParTaskFlowNodeMeta> transformDefMapFromEntrys(DynamicObjectCollection entryCollection) {
        HashMap<String, ParTaskFlowNodeMeta> defMapMeta = new HashMap<String, ParTaskFlowNodeMeta>();
        for (DynamicObject entry : entryCollection) {
            String sourceTypeId = entry.getString(SOURCETYPEID);
            String sourceTypeName = entry.getString(SOURCETYPENAME);
            String source = entry.getString(SOURCENODE);
            String sourceNodeId = sourceTypeName + "_" + source + "_" + sourceTypeId;
            String targetTypeId = entry.getString(TARGETTYPEID);
            String targetTypeName = entry.getString(TARGETTYPENAME);
            String target = entry.getString(TARGETNODE);
            String targetNodeId = targetTypeName + "_" + target + "_" + targetTypeId;
            this.saveEntry2DefMap(defMapMeta, sourceNodeId, targetNodeId);
        }
        return defMapMeta;
    }

    @Override
    public void saveEntry2DefMap(Map<String, ParTaskFlowNodeMeta> defMapMeta, String sourceNodeId, String targetNodeId) {
        this.saveSource2DefMap(defMapMeta, sourceNodeId, targetNodeId);
        this.saveTarget2DefMap(defMapMeta, sourceNodeId, targetNodeId);
    }

    @Override
    public void deleteAllDef(Object sscId, Object billTypeId) {
        QFilter[] qFilters = new QFilter[]{new QFilter("sscid", "=", sscId), new QFilter("billtype", "=", billTypeId)};
        DeleteServiceHelper.delete((String)"task_partaskflowdef", (QFilter[])qFilters);
    }

    private void saveSource2DefMap(Map<String, ParTaskFlowNodeMeta> defMapMeta, String sourceNodeId, String targetNodeId) {
        if (defMapMeta != null) {
            ParTaskFlowNodeMeta data = defMapMeta.get(sourceNodeId);
            if (data == null) {
                data = new ParTaskFlowNodeMeta(sourceNodeId);
                defMapMeta.put(sourceNodeId, data);
            }
            List<String> childNodeIdList = data.getChildNodeIdList();
            if (StringUtils.isNotBlank((CharSequence)targetNodeId) && !targetNodeId.contains("null")) {
                if (!childNodeIdList.contains(targetNodeId)) {
                    childNodeIdList.add(targetNodeId);
                }
                data.setChildNodeIdList(childNodeIdList);
            }
        }
    }

    private void saveTarget2DefMap(Map<String, ParTaskFlowNodeMeta> defMapMeta, String sourceNodeId, String targetNodeId) {
        if (defMapMeta != null && StringUtils.isNotBlank((CharSequence)targetNodeId) && !targetNodeId.contains("null")) {
            List<String> parentNodeIdList;
            ParTaskFlowNodeMeta data = defMapMeta.get(targetNodeId);
            if (data == null) {
                data = new ParTaskFlowNodeMeta(targetNodeId);
                defMapMeta.put(targetNodeId, data);
            }
            if (!(parentNodeIdList = data.getParentNodeIdList()).contains(sourceNodeId)) {
                parentNodeIdList.add(sourceNodeId);
            }
            data.setParentNodeIdList(parentNodeIdList);
        }
    }

    @Override
    public void clearRedisByuDefId(Long defId) {
        String defIds = String.valueOf(defId);
        SscDistributeCache.remove(defIds);
    }
}

