/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.partask.util;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.ssc.config.TaskParamHelper;
import kd.ssc.task.partask.meta.ParTaskFlowNodeMeta;
import kd.ssc.task.partask.service.ParTaskFlowService;
import kd.ssc.task.partask.service.impl.ParTaskFlowServiceImpl;

public class ParTaskFlowVerifyUtil {
    private static ParTaskFlowService parTaskFlowService = new ParTaskFlowServiceImpl();

    public static boolean closedLoopCheck(Map<String, ParTaskFlowNodeMeta> map, String nodeDefId, List<String> visited) {
        List<String> childIdList = StringUtils.isEmpty((String)nodeDefId) ? parTaskFlowService.getStartNodeFromDefMap(map) : parTaskFlowService.getChildFromDefMap(map, nodeDefId);
        if (childIdList.isEmpty()) {
            return StringUtils.isEmpty((String)nodeDefId);
        }
        for (String childDefId : childIdList) {
            if (visited.contains(childDefId)) {
                visited.add(childDefId);
                return true;
            }
            visited.add(childDefId);
            boolean res = ParTaskFlowVerifyUtil.closedLoopCheck(map, childDefId, visited);
            if (res) {
                return true;
            }
            visited.remove(childDefId);
        }
        return false;
    }

    public static boolean isPartaskOnProcessing(Long sscid, Long billtype) {
        String value = TaskParamHelper.getTaskParamByName("isEnableModifyTaskBill");
        boolean enableEditTaskBill = false;
        if ("true".equals(value)) {
            enableEditTaskBill = true;
        }
        if (enableEditTaskBill) {
            boolean inst = ParTaskFlowVerifyUtil.judgeProcessingByInst(sscid, billtype);
            boolean task = ParTaskFlowVerifyUtil.judgeProcessingByTask(sscid, billtype);
            return inst && task;
        }
        return ParTaskFlowVerifyUtil.judgeProcessingByInst(sscid, billtype);
    }

    private static boolean judgeProcessingByTask(Long sscid, Long billtype) {
        return QueryServiceHelper.exists((String)"task_task", (QFilter[])new QFilter[]{new QFilter("sscid", "=", (Object)sscid), new QFilter("billtype", "=", (Object)billtype)});
    }

    private static boolean judgeProcessingByInst(Long sscid, Long billtype) {
        ParTaskFlowServiceImpl taskFlowService = new ParTaskFlowServiceImpl();
        List<Long> defIds = taskFlowService.findAllParTaskFlowDef(sscid, billtype);
        DynamicObjectCollection instStatus = QueryServiceHelper.query((String)"task_partaskinst", (String)"ptstatus", (QFilter[])new QFilter[]{new QFilter("flowcode", "in", defIds)});
        if (instStatus == null || instStatus.isEmpty()) {
            return false;
        }
        for (DynamicObject dyo : instStatus) {
            if (!"0".equals(dyo.getString("ptstatus"))) continue;
            return true;
        }
        return false;
    }
}

